/**
 * @file op_model_mpcore.c
 * MPCORE Event Monitor Driver
 * @remark Copyright 2004 ARM SMP Development Team
 * @remark Copyright 2000-2004 Deepak Saxena <dsaxena@mvista.com>
 * @remark Copyright 2000-2004 MontaVista Software Inc
 * @remark Copyright 2004 Dave Jiang <dave.jiang@intel.com>
 * @remark Copyright 2004 Intel Corporation
 * @remark Copyright 2004 Zwane Mwaikambo <zwane@arm.linux.org.uk>
 * @remark Copyright 2004 Oprofile Authors
 *
 * @remark Read the file COPYING
 *
 * @author Zwane Mwaikambo
 */
#ifndef OP_MODEL_MPCORE_H
#define OP_MODEL_MPCORE_H

struct eventmonitor {
	unsigned long PMCR;
	unsigned char MCEB[8];
	unsigned long MC[8];
};

/*
 * List of userspace counter numbers: note that the structure is important.
 * The code relies on CPUn's counters being CPU0's counters + 3n
 * and on CPU0's counters starting at 0
 */

#define COUNTER_CPU0_PMN0 0
#define COUNTER_CPU0_PMN1 1
#define COUNTER_CPU0_CCNT 2

#define COUNTER_CPU1_PMN0 3
#define COUNTER_CPU1_PMN1 4
#define COUNTER_CPU1_CCNT 5

#define COUNTER_CPU2_PMN0 6
#define COUNTER_CPU2_PMN1 7
#define COUNTER_CPU2_CCNT 8

#define COUNTER_CPU3_PMN0 9
#define COUNTER_CPU3_PMN1 10
#define COUNTER_CPU3_CCNT 11

#define COUNTER_SCU_MN0 12
#define COUNTER_SCU_MN1 13
#define COUNTER_SCU_MN2 14
#define COUNTER_SCU_MN3 15
#define COUNTER_SCU_MN4 16
#define COUNTER_SCU_MN5 17
#define COUNTER_SCU_MN6 18
#define COUNTER_SCU_MN7 19
#define NUM_SCU_COUNTERS 8

#define SCU_COUNTER(number)	((number) + COUNTER_SCU_MN0)

#define MPCORE_NUM_COUNTERS	SCU_COUNTER(NUM_SCU_COUNTERS)


/*
 * Arch dependant variables
 */
#if defined(CONFIG_REALVIEW_EB_ARM11MP) || defined(CONFIG_MACH_REALVIEW_PB11MP)

/* SCU base virtual address */
#define SCU_EVENTMONITORS_VA_BASE __io_address(REALVIEW_EB11MP_SCU_BASE + 0x10)

/* CPU PMU IRQ numbers. For SMP, max cpu number is 4 */
static int arm11_irqs[] = {
	[0]	= IRQ_EB11MP_PMU_CPU0,
	[1]	= IRQ_EB11MP_PMU_CPU1,
	[2]	= IRQ_EB11MP_PMU_CPU2,
	[3]	= IRQ_EB11MP_PMU_CPU3
};

/* SCU PMU IRQ numbers */
static int scu_irqs[NUM_SCU_COUNTERS] = {
	[0]	= IRQ_EB11MP_PMU_SCU0,
	[1]	= IRQ_EB11MP_PMU_SCU1,
	[2]	= IRQ_EB11MP_PMU_SCU2,
	[3]	= IRQ_EB11MP_PMU_SCU3,
	[4]	= IRQ_EB11MP_PMU_SCU4,
	[5]	= IRQ_EB11MP_PMU_SCU5,
	[6]	= IRQ_EB11MP_PMU_SCU6,
	[7]	= IRQ_EB11MP_PMU_SCU7
};

#elif defined(CONFIG_ARCH_NE1)

#define SCU_EVENTMONITORS_VA_BASE   __io_address(NE1_BASE_SCU + 0x10)

static int arm11_irqs[] = {
	[0]	= INT_PMUIRQ_0,
	[1]	= INT_PMUIRQ_1,
	[2]	= INT_PMUIRQ_2,
	[3]	= INT_PMUIRQ_3
};

static int scu_irqs[] = {
	[0]	= INT_PMUIRQ_4,
	[1]	= INT_PMUIRQ_5,
	[2]	= INT_PMUIRQ_6,
	[3]	= INT_PMUIRQ_7,
	[4]	= INT_PMUIRQ_8,
	[5]	= INT_PMUIRQ_9,
	[6]	= INT_PMUIRQ_10,
	[7]	= INT_PMUIRQ_11
};

#else
#error "Please define SCU base and IRQ numbers for MPCore OProfile."
#endif

#endif /* OP_MODEL_MPCORE_H */
