/*
 *  Copyright (C) 1999 ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd
 *  Copyright 2004-2007 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_MXC_SYSTEM_H__
#define __ASM_ARCH_MXC_SYSTEM_H__

#include <linux/io.h>
#include <linux/clk.h>
#include <asm/proc-fns.h>
#include <mach/hardware.h>

static inline void arch_idle(void)
{
	cpu_do_idle();
}

static inline void arch_reset(char mode)
{
#ifdef CONFIG_ARCH_MX3
	/*
	 * Assert system reset signal by Watch Dog timer.
	 */
#define WDOG_WCR	0	/* 16bit watchdog control reg */
#define WCR_SRS_BIT     (1 << 4)
#define WCR_WDE_BIT     (1 << 2)
	u16 reg;
	struct clk *clk;
	void __iomem *wdog_base = IO_ADDRESS(WDOG_BASE_ADDR);

	clk = clk_get(NULL, "wdog_clk");
	clk_enable(clk);

	reg = __raw_readw(wdog_base + WDOG_WCR) & ~WCR_SRS_BIT;
	reg |= WCR_WDE_BIT;
	__raw_writew(reg, wdog_base + WDOG_WCR);
#else
	cpu_reset(0);
#endif
}

#endif /* __ASM_ARCH_MXC_SYSTEM_H__ */
