/*
 * Register description for MX31
 *
 *  Copyright 2003-2007 Sony Corporation.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include "armv6_regproc.h"

static regproc_reg_t mx31_iim[] = {
	/* Silicon Revision (SREV) R 13.2.2.1/13-2 */
	{.name = "SREV",             .type = REG_MMIO_32, .offset = 0x024},
	{NULL}
};

static regproc_reg_t mx31_ccm[] = {
	/* Control Register (CCMR) R/W 0x074B_0B79 3.4.3.1/3-9 */
	{.name = "CCMR",             .type = REG_MMIO_32, .offset = 0x000},
	/* Post Divider Register 0 (PDR0) R/W 0xFF87_0B48 3.4.3.2/3-12 */
	{.name = "PDR0",             .type = REG_MMIO_32, .offset = 0x004},
	/* Post Divider Register 1 (PDR1) R/W 0x49FC_FE7F 3.4.3.3/3-13 */
	{.name = "PDR1",             .type = REG_MMIO_32, .offset = 0x008},
	/* Reset Control and Source Register (RCSR) R/W 0x007F_0000 3.4.3.4/3-15 */
	{.name = "RCSR",             .type = REG_MMIO_32, .offset = 0x00c},
	/* MCU PLL Control Register (MPCTL) R/W 0x0400_1800 3.4.3.5/3-16 */
	{.name = "MPCTL",            .type = REG_MMIO_32, .offset = 0x010},
	/* USB PLL Control Register (UPCTL) R/W 0x0405_1C03 3.4.3.6/3-18 */
	{.name = "UPCTL",            .type = REG_MMIO_32, .offset = 0x014},
	/* Serial PLL Control Register (SPCTL) R/W 0x0404_3001 3.4.3.7/3-20 */
	{.name = "SPCTL",            .type = REG_MMIO_32, .offset = 0x018},
	/* Clock Out Source Register (COSR) R/W 0x0000_0280 3.4.3.8/3-22 */
	{.name = "COSR",             .type = REG_MMIO_32, .offset = 0x01c},
	/* Clock Gating Register 0 (CGR0) R/W 0xFFFF_FFFF 3.4.3.9/3-24 */
	{.name = "CGR0",             .type = REG_MMIO_32, .offset = 0x020},
	/* Clock Gating Register 1 (CGR1) R/W 0xFFFF_FFFF 3.4.3.9/3-24 */
	{.name = "CGR1",             .type = REG_MMIO_32, .offset = 0x024},
	/* Clock Gating Register 2 (CGR2) R/W 0xFFFF_FFFF 3.4.3.9/3-24 */
	{.name = "CGR2",             .type = REG_MMIO_32, .offset = 0x028},
	/* up Interrupt Mask Register (WIMR) R/W 0xFFFF_FFFF 3.4.3.10/3-27 */
	{.name = "WIMR0",            .type = REG_MMIO_32, .offset = 0x02c},
	/* Latch Divergence Counter Register (LDC) R/W 0x0000_0000 3.4.3.11/3-27 */
	{.name = "LDC",              .type = REG_MMIO_32, .offset = 0x030},
	/* DPTC Comparator Value Register 0 (DCVR0) R/W 0x0000_0000 3.4.3.12/3-28 */
	{.name = "DCVR0",            .type = REG_MMIO_32, .offset = 0x034},
	/* DPTC Comparator Value Register 1 (DCVR1) R/W 0x0000_0000 3.4.3.12/3-28 */
	{.name = "DCVR1",            .type = REG_MMIO_32, .offset = 0x038},
	/* DPTC Comparator Value Register 2 (DCVR2) R/W 0x0000_0000 3.4.3.12/3-28 */
	{.name = "DCVR2",            .type = REG_MMIO_32, .offset = 0x03c},
	/* DPTC Comparator Value Register 3 (DCVR3) R/W 0x0000_0000 3.4.3.12/3-28 */
	{.name = "DCVR3",            .type = REG_MMIO_32, .offset = 0x040},
	/* Load Tracking Register 0 (LTR0) R/W 0x0000_0000 3.4.3.13/3-29 */
	{.name = "LTR0",             .type = REG_MMIO_32, .offset = 0x044},
	/* Load Tracking Register 1 (LTR1) R/W 0x0000_4040 3.4.3.14/3-30 */
	{.name = "LTR1",             .type = REG_MMIO_32, .offset = 0x048},
	/* Load Tracking Register 2 (LTR2) R/W 0x0000_0000 3.4.3.15/3-31 */
	{.name = "LTR2",             .type = REG_MMIO_32, .offset = 0x04c},
	/* Load Tracking Register 3 (LTR3) R/W 0x0000_0000 3.4.3.16/3-32 */
	{.name = "LTR3",             .type = REG_MMIO_32, .offset = 0x050},
	/* Load Tracking Buffer Register 0 (LTBR0) R 0x0000_0000 3.4.3.17/3-33 */
	{.name = "LTBR0",            .type = REG_MMIO_32, .offset = 0x054},
	/* Load Tracking Buffer Register 1 (LTBR1) R 0x0000_0000 3.4.3.18/3-34 */
	{.name = "LTBR1",            .type = REG_MMIO_32, .offset = 0x058},
	/* Power Management Control Register 0 (PMCR0) R/W 0x8020_9828 3.4.3.19/3-35 */
	{.name = "PMCR0",            .type = REG_MMIO_32, .offset = 0x05c},
	/* Power Management Control Register 1 (PMCR1) R/W 0x00AA_0000 3.4.3.20/3-38 */
	{.name = "PMCR1",            .type = REG_MMIO_32, .offset = 0x060},
	/* Post Divider Register 2 (PDR2) R/W 0x0000_0285 3.4.3.21/3-39 */
	{.name = "PDR2",             .type = REG_MMIO_32, .offset = 0x064},
	{NULL}
};

static regproc_reg_t mx31_iomux[] = {
	/* Interrupt Observability Register1 (INT_OBS1) R/W 0x0000_0000 4.4.1.1/4-17 */
	{.name = "INT_OBS1",         .type = REG_MMIO_32, .offset = 0x000},
	/* Interrupt Observability Register2 (INT_OBS2) R/W 0x0000_0000 4.4.1.2/4-18 */
	{.name = "INT_OBS2",         .type = REG_MMIO_32, .offset = 0x004},
	/* General Purpose Register R/W 0x0000_0000 4.4.1.3/4-21 */
	{.name = "GPR",              .type = REG_MMIO_32, .offset = 0x008},
	/* Software MUX Control Register 0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL0",      .type = REG_MMIO_32, .offset = 0x000},
	/* Software MUX Control Register 1 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL1",      .type = REG_MMIO_32, .offset = 0x004},
	/* Software MUX Control Register 2 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL2",      .type = REG_MMIO_32, .offset = 0x008},
	/* Software MUX Control Register 00C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_00C",   .type = REG_MMIO_32, .offset = 0x00c},
	/* Software MUX Control Register 010 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_010",   .type = REG_MMIO_32, .offset = 0x010},
	/* Software MUX Control Register 014 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_014",   .type = REG_MMIO_32, .offset = 0x014},
	/* Software MUX Control Register 018 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_018",   .type = REG_MMIO_32, .offset = 0x018},
	/* Software MUX Control Register 01C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_01C",   .type = REG_MMIO_32, .offset = 0x01c},
	/* Software MUX Control Register 020 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_020",   .type = REG_MMIO_32, .offset = 0x020},
	/* Software MUX Control Register 024 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_024",   .type = REG_MMIO_32, .offset = 0x024},
	/* Software MUX Control Register 028 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_028",   .type = REG_MMIO_32, .offset = 0x028},
	/* Software MUX Control Register 02C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_02C",   .type = REG_MMIO_32, .offset = 0x02c},
	/* Software MUX Control Register 030 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_030",   .type = REG_MMIO_32, .offset = 0x030},
	/* Software MUX Control Register 034 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_034",   .type = REG_MMIO_32, .offset = 0x034},
	/* Software MUX Control Register 038 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_038",   .type = REG_MMIO_32, .offset = 0x038},
	/* Software MUX Control Register 03C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_03C",   .type = REG_MMIO_32, .offset = 0x03c},
	/* Software MUX Control Register 040 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_040",   .type = REG_MMIO_32, .offset = 0x040},
	/* Software MUX Control Register 044 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_044",   .type = REG_MMIO_32, .offset = 0x044},
	/* Software MUX Control Register 048 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_048",   .type = REG_MMIO_32, .offset = 0x048},
	/* Software MUX Control Register 04C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_04C",   .type = REG_MMIO_32, .offset = 0x04c},
	/* Software MUX Control Register 050 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_050",   .type = REG_MMIO_32, .offset = 0x050},
	/* Software MUX Control Register 054 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_054",   .type = REG_MMIO_32, .offset = 0x054},
	/* Software MUX Control Register 058 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_058",   .type = REG_MMIO_32, .offset = 0x058},
	/* Software MUX Control Register 05C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_05C",   .type = REG_MMIO_32, .offset = 0x05c},
	/* Software MUX Control Register 060 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_060",   .type = REG_MMIO_32, .offset = 0x060},
	/* Software MUX Control Register 064 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_064",   .type = REG_MMIO_32, .offset = 0x064},
	/* Software MUX Control Register 068 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_068",   .type = REG_MMIO_32, .offset = 0x068},
	/* Software MUX Control Register 06C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_06C",   .type = REG_MMIO_32, .offset = 0x06c},
	/* Software MUX Control Register 070 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_070",   .type = REG_MMIO_32, .offset = 0x070},
	/* Software MUX Control Register 074 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_074",   .type = REG_MMIO_32, .offset = 0x074},
	/* Software MUX Control Register 078 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_078",   .type = REG_MMIO_32, .offset = 0x078},
	/* Software MUX Control Register 07C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_07C",   .type = REG_MMIO_32, .offset = 0x07c},
	/* Software MUX Control Register 080 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_080",   .type = REG_MMIO_32, .offset = 0x080},
	/* Software MUX Control Register 084 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_084",   .type = REG_MMIO_32, .offset = 0x084},
	/* Software MUX Control Register 088 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_088",   .type = REG_MMIO_32, .offset = 0x088},
	/* Software MUX Control Register 08C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_08C",   .type = REG_MMIO_32, .offset = 0x08c},
	/* Software MUX Control Register 090 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_090",   .type = REG_MMIO_32, .offset = 0x090},
	/* Software MUX Control Register 094 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_094",   .type = REG_MMIO_32, .offset = 0x094},
	/* Software MUX Control Register 098 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_098",   .type = REG_MMIO_32, .offset = 0x098},
	/* Software MUX Control Register 09C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_09C",   .type = REG_MMIO_32, .offset = 0x09c},
	/* Software MUX Control Register 0A0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0A0",   .type = REG_MMIO_32, .offset = 0x0a0},
	/* Software MUX Control Register 0A4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0A4",   .type = REG_MMIO_32, .offset = 0x0a4},
	/* Software MUX Control Register 0A8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0A8",   .type = REG_MMIO_32, .offset = 0x0a8},
	/* Software MUX Control Register 0AC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0AC",   .type = REG_MMIO_32, .offset = 0x0ac},
	/* Software MUX Control Register 0B0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0B0",   .type = REG_MMIO_32, .offset = 0x0b0},
	/* Software MUX Control Register 0B4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0B4",   .type = REG_MMIO_32, .offset = 0x0b4},
	/* Software MUX Control Register 0B8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0B8",   .type = REG_MMIO_32, .offset = 0x0b8},
	/* Software MUX Control Register 0BC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0BC",   .type = REG_MMIO_32, .offset = 0x0bc},
	/* Software MUX Control Register 0C0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0C0",   .type = REG_MMIO_32, .offset = 0x0c0},
	/* Software MUX Control Register 0C4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0C4",   .type = REG_MMIO_32, .offset = 0x0c4},
	/* Software MUX Control Register 0C8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0C8",   .type = REG_MMIO_32, .offset = 0x0c8},
	/* Software MUX Control Register 0CC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0CC",   .type = REG_MMIO_32, .offset = 0x0cc},
	/* Software MUX Control Register 0D0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0D0",   .type = REG_MMIO_32, .offset = 0x0d0},
	/* Software MUX Control Register 0D4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0D4",   .type = REG_MMIO_32, .offset = 0x0d4},
	/* Software MUX Control Register 0D8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0D8",   .type = REG_MMIO_32, .offset = 0x0d8},
	/* Software MUX Control Register 0DC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0DC",   .type = REG_MMIO_32, .offset = 0x0dc},
	/* Software MUX Control Register 0E0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0E0",   .type = REG_MMIO_32, .offset = 0x0e0},
	/* Software MUX Control Register 0E4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0E4",   .type = REG_MMIO_32, .offset = 0x0e4},
	/* Software MUX Control Register 0E8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0E8",   .type = REG_MMIO_32, .offset = 0x0e8},
	/* Software MUX Control Register 0EC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0EC",   .type = REG_MMIO_32, .offset = 0x0ec},
	/* Software MUX Control Register 0F0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0F0",   .type = REG_MMIO_32, .offset = 0x0f0},
	/* Software MUX Control Register 0F4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0F4",   .type = REG_MMIO_32, .offset = 0x0f4},
	/* Software MUX Control Register 0F8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0F8",   .type = REG_MMIO_32, .offset = 0x0f8},
	/* Software MUX Control Register 0FC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_0FC",   .type = REG_MMIO_32, .offset = 0x0fc},
	/* Software MUX Control Register 100 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_100",   .type = REG_MMIO_32, .offset = 0x100},
	/* Software MUX Control Register 104 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_104",   .type = REG_MMIO_32, .offset = 0x104},
	/* Software MUX Control Register 108 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_108",   .type = REG_MMIO_32, .offset = 0x108},
	/* Software MUX Control Register 10C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_10C",   .type = REG_MMIO_32, .offset = 0x10c},
	/* Software MUX Control Register 110 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_110",   .type = REG_MMIO_32, .offset = 0x110},
	/* Software MUX Control Register 114 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_114",   .type = REG_MMIO_32, .offset = 0x114},
	/* Software MUX Control Register 118 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_118",   .type = REG_MMIO_32, .offset = 0x118},
	/* Software MUX Control Register 11C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_11C",   .type = REG_MMIO_32, .offset = 0x11c},
	/* Software MUX Control Register 120 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_120",   .type = REG_MMIO_32, .offset = 0x120},
	/* Software MUX Control Register 124 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_124",   .type = REG_MMIO_32, .offset = 0x124},
	/* Software MUX Control Register 128 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_128",   .type = REG_MMIO_32, .offset = 0x128},
	/* Software MUX Control Register 12C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_12C",   .type = REG_MMIO_32, .offset = 0x12c},
	/* Software MUX Control Register 130 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_130",   .type = REG_MMIO_32, .offset = 0x130},
	/* Software MUX Control Register 134 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_134",   .type = REG_MMIO_32, .offset = 0x134},
	/* Software MUX Control Register 138 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_138",   .type = REG_MMIO_32, .offset = 0x138},
	/* Software MUX Control Register 13C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_13C",   .type = REG_MMIO_32, .offset = 0x13c},
	/* Software MUX Control Register 140 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_140",   .type = REG_MMIO_32, .offset = 0x140},
	/* Software MUX Control Register 144 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_144",   .type = REG_MMIO_32, .offset = 0x144},
	/* Software MUX Control Register 148 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_148",   .type = REG_MMIO_32, .offset = 0x148},
	/* Software MUX Control Register 14C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_14C",   .type = REG_MMIO_32, .offset = 0x14c},
	/* Software MUX Control Register 150 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_MUX_CTL_150",   .type = REG_MMIO_32, .offset = 0x150},
	/* Software Pad Control Register 154 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_154",   .type = REG_MMIO_32, .offset = 0x154},
	/* Software Pad Control Register 158 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_158",   .type = REG_MMIO_32, .offset = 0x158},
	/* Software Pad Control Register 15C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_15C",   .type = REG_MMIO_32, .offset = 0x15c},
	/* Software Pad Control Register 160 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_160",   .type = REG_MMIO_32, .offset = 0x160},
	/* Software Pad Control Register 164 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_164",   .type = REG_MMIO_32, .offset = 0x164},
	/* Software Pad Control Register 168 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_168",   .type = REG_MMIO_32, .offset = 0x168},
	/* Software Pad Control Register 16C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_16C",   .type = REG_MMIO_32, .offset = 0x16c},
	/* Software Pad Control Register 170 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_170",   .type = REG_MMIO_32, .offset = 0x170},
	/* Software Pad Control Register 174 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_174",   .type = REG_MMIO_32, .offset = 0x174},
	/* Software Pad Control Register 178 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_178",   .type = REG_MMIO_32, .offset = 0x178},
	/* Software Pad Control Register 17C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_17C",   .type = REG_MMIO_32, .offset = 0x17c},
	/* Software Pad Control Register 180 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_180",   .type = REG_MMIO_32, .offset = 0x180},
	/* Software Pad Control Register 184 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_184",   .type = REG_MMIO_32, .offset = 0x184},
	/* Software Pad Control Register 188 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_188",   .type = REG_MMIO_32, .offset = 0x188},
	/* Software Pad Control Register 18C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_18C",   .type = REG_MMIO_32, .offset = 0x18c},
	/* Software Pad Control Register 190 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_190",   .type = REG_MMIO_32, .offset = 0x190},
	/* Software Pad Control Register 194 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_194",   .type = REG_MMIO_32, .offset = 0x194},
	/* Software Pad Control Register 198 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_198",   .type = REG_MMIO_32, .offset = 0x198},
	/* Software Pad Control Register 19C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_19C",   .type = REG_MMIO_32, .offset = 0x19c},
	/* Software Pad Control Register 1A0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1A0",   .type = REG_MMIO_32, .offset = 0x1a0},
	/* Software Pad Control Register 1A4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1A4",   .type = REG_MMIO_32, .offset = 0x1a4},
	/* Software Pad Control Register 1A8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1A8",   .type = REG_MMIO_32, .offset = 0x1a8},
	/* Software Pad Control Register 1AC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1AC",   .type = REG_MMIO_32, .offset = 0x1ac},
	/* Software Pad Control Register 1B0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1B0",   .type = REG_MMIO_32, .offset = 0x1b0},
	/* Software Pad Control Register 1B4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1B4",   .type = REG_MMIO_32, .offset = 0x1b4},
	/* Software Pad Control Register 1B8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1B8",   .type = REG_MMIO_32, .offset = 0x1b8},
	/* Software Pad Control Register 1BC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1BC",   .type = REG_MMIO_32, .offset = 0x1bc},
	/* Software Pad Control Register 1C0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1C0",   .type = REG_MMIO_32, .offset = 0x1c0},
	/* Software Pad Control Register 1C4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1C4",   .type = REG_MMIO_32, .offset = 0x1c4},
	/* Software Pad Control Register 1C8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1C8",   .type = REG_MMIO_32, .offset = 0x1c8},
	/* Software Pad Control Register 1CC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1CC",   .type = REG_MMIO_32, .offset = 0x1cc},
	/* Software Pad Control Register 1D0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1D0",   .type = REG_MMIO_32, .offset = 0x1d0},
	/* Software Pad Control Register 1D4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1D4",   .type = REG_MMIO_32, .offset = 0x1d4},
	/* Software Pad Control Register 1D8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1D8",   .type = REG_MMIO_32, .offset = 0x1d8},
	/* Software Pad Control Register 1DC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1DC",   .type = REG_MMIO_32, .offset = 0x1dc},
	/* Software Pad Control Register 1E0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1E0",   .type = REG_MMIO_32, .offset = 0x1e0},
	/* Software Pad Control Register 1E4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1E4",   .type = REG_MMIO_32, .offset = 0x1e4},
	/* Software Pad Control Register 1E8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1E8",   .type = REG_MMIO_32, .offset = 0x1e8},
	/* Software Pad Control Register 1EC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1EC",   .type = REG_MMIO_32, .offset = 0x1ec},
	/* Software Pad Control Register 1F0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1F0",   .type = REG_MMIO_32, .offset = 0x1f0},
	/* Software Pad Control Register 1F4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1F4",   .type = REG_MMIO_32, .offset = 0x1f4},
	/* Software Pad Control Register 1F8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1F8",   .type = REG_MMIO_32, .offset = 0x1f8},
	/* Software Pad Control Register 1FC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_1FC",   .type = REG_MMIO_32, .offset = 0x1fc},
	/* Software Pad Control Register 200 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_200",   .type = REG_MMIO_32, .offset = 0x200},
	/* Software Pad Control Register 204 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_204",   .type = REG_MMIO_32, .offset = 0x204},
	/* Software Pad Control Register 208 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_208",   .type = REG_MMIO_32, .offset = 0x208},
	/* Software Pad Control Register 20C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_20C",   .type = REG_MMIO_32, .offset = 0x20c},
	/* Software Pad Control Register 210 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_210",   .type = REG_MMIO_32, .offset = 0x210},
	/* Software Pad Control Register 214 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_214",   .type = REG_MMIO_32, .offset = 0x214},
	/* Software Pad Control Register 218 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_218",   .type = REG_MMIO_32, .offset = 0x218},
	/* Software Pad Control Register 21C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_21C",   .type = REG_MMIO_32, .offset = 0x21c},
	/* Software Pad Control Register 220 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_220",   .type = REG_MMIO_32, .offset = 0x220},
	/* Software Pad Control Register 224 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_224",   .type = REG_MMIO_32, .offset = 0x224},
	/* Software Pad Control Register 228 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_228",   .type = REG_MMIO_32, .offset = 0x228},
	/* Software Pad Control Register 22C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_22C",   .type = REG_MMIO_32, .offset = 0x22c},
	/* Software Pad Control Register 230 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_230",   .type = REG_MMIO_32, .offset = 0x230},
	/* Software Pad Control Register 234 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_234",   .type = REG_MMIO_32, .offset = 0x234},
	/* Software Pad Control Register 238 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_238",   .type = REG_MMIO_32, .offset = 0x238},
	/* Software Pad Control Register 23C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_23C",   .type = REG_MMIO_32, .offset = 0x23c},
	/* Software Pad Control Register 240 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_240",   .type = REG_MMIO_32, .offset = 0x240},
	/* Software Pad Control Register 244 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_244",   .type = REG_MMIO_32, .offset = 0x244},
	/* Software Pad Control Register 248 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_248",   .type = REG_MMIO_32, .offset = 0x248},
	/* Software Pad Control Register 24C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_24C",   .type = REG_MMIO_32, .offset = 0x24c},
	/* Software Pad Control Register 250 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_250",   .type = REG_MMIO_32, .offset = 0x250},
	/* Software Pad Control Register 254 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_254",   .type = REG_MMIO_32, .offset = 0x254},
	/* Software Pad Control Register 258 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_258",   .type = REG_MMIO_32, .offset = 0x258},
	/* Software Pad Control Register 25C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_25C",   .type = REG_MMIO_32, .offset = 0x25c},
	/* Software Pad Control Register 260 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_260",   .type = REG_MMIO_32, .offset = 0x260},
	/* Software Pad Control Register 264 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_264",   .type = REG_MMIO_32, .offset = 0x264},
	/* Software Pad Control Register 268 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_268",   .type = REG_MMIO_32, .offset = 0x268},
	/* Software Pad Control Register 26C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_26C",   .type = REG_MMIO_32, .offset = 0x26c},
	/* Software Pad Control Register 270 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_270",   .type = REG_MMIO_32, .offset = 0x270},
	/* Software Pad Control Register 274 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_274",   .type = REG_MMIO_32, .offset = 0x274},
	/* Software Pad Control Register 278 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_278",   .type = REG_MMIO_32, .offset = 0x278},
	/* Software Pad Control Register 27C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_27C",   .type = REG_MMIO_32, .offset = 0x27c},
	/* Software Pad Control Register 280 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_280",   .type = REG_MMIO_32, .offset = 0x280},
	/* Software Pad Control Register 284 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_284",   .type = REG_MMIO_32, .offset = 0x284},
	/* Software Pad Control Register 288 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_288",   .type = REG_MMIO_32, .offset = 0x288},
	/* Software Pad Control Register 28C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_28C",   .type = REG_MMIO_32, .offset = 0x28c},
	/* Software Pad Control Register 290 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_290",   .type = REG_MMIO_32, .offset = 0x290},
	/* Software Pad Control Register 294 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_294",   .type = REG_MMIO_32, .offset = 0x294},
	/* Software Pad Control Register 298 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_298",   .type = REG_MMIO_32, .offset = 0x298},
	/* Software Pad Control Register 29C R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_29C",   .type = REG_MMIO_32, .offset = 0x29c},
	/* Software Pad Control Register 2A0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2A0",   .type = REG_MMIO_32, .offset = 0x2a0},
	/* Software Pad Control Register 2A4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2A4",   .type = REG_MMIO_32, .offset = 0x2a4},
	/* Software Pad Control Register 2A8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2A8",   .type = REG_MMIO_32, .offset = 0x2a8},
	/* Software Pad Control Register 2AC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2AC",   .type = REG_MMIO_32, .offset = 0x2ac},
	/* Software Pad Control Register 2B0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2B0",   .type = REG_MMIO_32, .offset = 0x2b0},
	/* Software Pad Control Register 2B4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2B4",   .type = REG_MMIO_32, .offset = 0x2b4},
	/* Software Pad Control Register 2B8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2B8",   .type = REG_MMIO_32, .offset = 0x2b8},
	/* Software Pad Control Register 2BC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2BC",   .type = REG_MMIO_32, .offset = 0x2bc},
	/* Software Pad Control Register 2C0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2C0",   .type = REG_MMIO_32, .offset = 0x2c0},
	/* Software Pad Control Register 2C4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2C4",   .type = REG_MMIO_32, .offset = 0x2c4},
	/* Software Pad Control Register 2C8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2C8",   .type = REG_MMIO_32, .offset = 0x2c8},
	/* Software Pad Control Register 2CC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2CC",   .type = REG_MMIO_32, .offset = 0x2cc},
	/* Software Pad Control Register 2D0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2D0",   .type = REG_MMIO_32, .offset = 0x2d0},
	/* Software Pad Control Register 2D4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2D4",   .type = REG_MMIO_32, .offset = 0x2d4},
	/* Software Pad Control Register 2D8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2D8",   .type = REG_MMIO_32, .offset = 0x2d8},
	/* Software Pad Control Register 2DC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2DC",   .type = REG_MMIO_32, .offset = 0x2dc},
	/* Software Pad Control Register 2E0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2E0",   .type = REG_MMIO_32, .offset = 0x2e0},
	/* Software Pad Control Register 2E4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2E4",   .type = REG_MMIO_32, .offset = 0x2e4},
	/* Software Pad Control Register 2E8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2E8",   .type = REG_MMIO_32, .offset = 0x2e8},
	/* Software Pad Control Register 2EC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2EC",   .type = REG_MMIO_32, .offset = 0x2ec},
	/* Software Pad Control Register 2F0 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2F0",   .type = REG_MMIO_32, .offset = 0x2f0},
	/* Software Pad Control Register 2F4 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2F4",   .type = REG_MMIO_32, .offset = 0x2f4},
	/* Software Pad Control Register 2F8 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2F8",   .type = REG_MMIO_32, .offset = 0x2f8},
	/* Software Pad Control Register 2FC R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_2FC",   .type = REG_MMIO_32, .offset = 0x2fc},
	/* Software Pad Control Register 300 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_300",   .type = REG_MMIO_32, .offset = 0x300},
	/* Software Pad Control Register 304 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_304",   .type = REG_MMIO_32, .offset = 0x304},
	/* Software Pad Control Register 308 R/W 0x0000_0000 4.4.1.4/4-23 */
	{.name = "SW_PAD_CTL_308",   .type = REG_MMIO_32, .offset = 0x308},
	{NULL}
};

static regproc_reg_t mx31_gpio1[] = {
	/* GPIO Data R/W 0x0000_0000 5.3.3.1/5-6 */
	{.name = "DR",               .type = REG_MMIO_32, .offset = 0x000},
	/* GPIO Direction R/W 0x0000_0000 5.3.3.2/5-7 */
	{.name = "GDIR",             .type = REG_MMIO_32, .offset = 0x004},
	/* GPIO Pad Status R 0x0000_0000 5.3.3.3/5-8 */
	{.name = "PSR",              .type = REG_MMIO_32, .offset = 0x008},
	/* GPIO Interrupt Configuration Register1 R/W 0x0000_0000 5.3.3.4/5-9 */
	{.name = "ICR1",             .type = REG_MMIO_32, .offset = 0x00c},
	/* GPIO Interrupt Configuration Register2 R/W 0x0000_0000 5.3.3.5/5-10 */
	{.name = "ICR2",             .type = REG_MMIO_32, .offset = 0x010},
	/* GPIO Interrupt Mask Register R/W 0x0000_0000 5.3.3.6/5-10 */
	{.name = "IMR",              .type = REG_MMIO_32, .offset = 0x014},
	/* GPIO Interrupt Status Register R/W 0x0000_0000 5.3.3.7/5-11 */
	{.name = "ISR",              .type = REG_MMIO_32, .offset = 0x018},
	{NULL}
};

static regproc_reg_t mx31_gpio2[] = {
	/* GPIO Data R/W 0x0000_0000 5.3.3.1/5-6 */
	{.name = "DR",               .type = REG_MMIO_32, .offset = 0x000},
	/* GPIO Direction R/W 0x0000_0000 5.3.3.2/5-7 */
	{.name = "GDIR",             .type = REG_MMIO_32, .offset = 0x004},
	/* GPIO Pad Status R 0x0000_0000 5.3.3.3/5-8 */
	{.name = "PSR",              .type = REG_MMIO_32, .offset = 0x008},
	/* GPIO Interrupt Configuration Register1 R/W 0x0000_0000 5.3.3.4/5-9 */
	{.name = "ICR1",             .type = REG_MMIO_32, .offset = 0x00c},
	/* GPIO Interrupt Configuration Register2 R/W 0x0000_0000 5.3.3.5/5-10 */
	{.name = "ICR2",             .type = REG_MMIO_32, .offset = 0x010},
	/* GPIO Interrupt Mask Register R/W 0x0000_0000 5.3.3.6/5-10 */
	{.name = "IMR",              .type = REG_MMIO_32, .offset = 0x014},
	/* GPIO Interrupt Status Register R/W 0x0000_0000 5.3.3.7/5-11 */
	{.name = "ISR",              .type = REG_MMIO_32, .offset = 0x018},
	{NULL}
};

static regproc_reg_t mx31_gpio3[] = {
	/* GPIO Data R/W 0x0000_0000 5.3.3.1/5-6 */
	{.name = "DR",               .type = REG_MMIO_32, .offset = 0x000},
	/* GPIO Direction R/W 0x0000_0000 5.3.3.2/5-7 */
	{.name = "GDIR",             .type = REG_MMIO_32, .offset = 0x004},
	/* GPIO Pad Status R 0x0000_0000 5.3.3.3/5-8 */
	{.name = "PSR",              .type = REG_MMIO_32, .offset = 0x008},
	/* GPIO Interrupt Configuration Register1 R/W 0x0000_0000 5.3.3.4/5-9 */
	{.name = "ICR1",             .type = REG_MMIO_32, .offset = 0x00c},
	/* GPIO Interrupt Configuration Register2 R/W 0x0000_0000 5.3.3.5/5-10 */
	{.name = "ICR2",             .type = REG_MMIO_32, .offset = 0x010},
	/* GPIO Interrupt Mask Register R/W 0x0000_0000 5.3.3.6/5-10 */
	{.name = "IMR",              .type = REG_MMIO_32, .offset = 0x014},
	/* GPIO Interrupt Status Register R/W 0x0000_0000 5.3.3.7/5-11 */
	{.name = "ISR",              .type = REG_MMIO_32, .offset = 0x018},
	{NULL}
};

static regproc_reg_t mx31_l2cc[] = {
	/* 0 L2 Cache ID R 0xD500_0041 14.4.1.1/14-17 */
	{.name = "L2CacheID",        .type = REG_MMIO_32, .offset = 0x000},
	/* 0 L2 Cache Type R 0x1C10_0100 14.4.1.2/14-18 */
	{.name = "L2CacheType",      .type = REG_MMIO_32, .offset = 0x004},
	/* 1 L2 Control R/W 0x0000_0000 14.4.1.3/14-19 */
	{.name = "L2Control",        .type = REG_MMIO_32, .offset = 0x100},
	/* 1 L2 Auxiliary Control Register 1 R/W 0xE402_0FFF 14.4.1.4/14-20 */
	{.name = "L2AuxiliaryControl",.type = REG_MMIO_32, .offset = 0x104},
	/* 7 L2 Cache Sync R 0x0000_0000 14.4.1.5/14-23 */
	{.name = "L2CacheSync",      .type = REG_MMIO_32, .offset = 0x730},
	/* 7 L2 Invalidate By Way - 14.4.1.5/14-23 */
	{.name = "L2InvalidateByWay",.type = REG_MMIO_32, .offset = 0x77c},
	/* 7 L2 Invalidate Line By PA R 0x0000_0000 14.4.1.5/14-23 */
	{.name = "L2InvalidateLineByPA",.type = REG_MMIO_32, .offset = 0x770},
	/* Way R 0x0000_0000 14.4.1.5/14-23 */
	{.name = "L2CleanLinebyIndexWay",.type = REG_MMIO_32, .offset = 0x7b8},
	/* 7 L2 Clean Line by PA R 0x0000_0000 14.4.1.5/14-23 */
	{.name = "L2CleanbyWay",     .type = REG_MMIO_32, .offset = 0x7bc},
	/* Way R 0x0000_0000 14.4.1.5/14-23 */
	{.name = "L2CleanAndInvalidateLineByIndexWay",.type = REG_MMIO_32, .offset = 0x7f8},
	/* 7 L2 Clean and Invalidate by Way - 14.4.1.5/14-23 */
	{.name = "L2CleanAndInvalidateByWay",.type = REG_MMIO_32, .offset = 0x7fc},
	/* 7 L2 Clean and Invalidate Line by PA R 0x0000_0000 14.4.1.5/14-23 */
	{.name = "L2CleanAndInvalidateLineByPA",.type = REG_MMIO_32, .offset = 0x7f0},
	/* 9 L2 Lockdown by Way-D side - 14.4.1.6/14-25 */
	{.name = "L2LockdownByWay_D",.type = REG_MMIO_32, .offset = 0x900},
	/* 9 L2 Lockdown by Way-I side - 14.4.1.6/14-25 */
	{.name = "L2LockdownNyWay_I",.type = REG_MMIO_32, .offset = 0x904},
	/* 15 L2 Test Operation R 0x0000_0000 14.4.1.8/14-27 */
	{.name = "L2TestOperation",  .type = REG_MMIO_32, .offset = 0xf00},
	/* 15 L2 Line Data (word0) - 14.4.1.8/14-27 */
	{.name = "L2LineDataWord0",  .type = REG_MMIO_32, .offset = 0xf10},
	/* 15 L2 Line Data (word1) - 14.4.1.8/14-27 */
	{.name = "L2LineDataWord1",  .type = REG_MMIO_32, .offset = 0xf14},
	/* 15 L2 Line Data (word2) - 14.4.1.8/14-27 */
	{.name = "L2LineDataWord2",  .type = REG_MMIO_32, .offset = 0xf18},
	/* 15 L2 Line Data (word3) - 14.4.1.8/14-27 */
	{.name = "L2LineDataWord3",  .type = REG_MMIO_32, .offset = 0xf1c},
	/* 15 L2 Line Data (word4) - 14.4.1.8/14-27 */
	{.name = "L2LineDataWord4",  .type = REG_MMIO_32, .offset = 0xf20},
	/* 15 L2 Line Data (word5) - 14.4.1.8/14-27 */
	{.name = "L2LineDataWord5",  .type = REG_MMIO_32, .offset = 0xf24},
	/* 15 L2 Line Data (word6) - 14.4.1.8/14-27 */
	{.name = "L2LineDataWord6",  .type = REG_MMIO_32, .offset = 0xf28},
	/* 15 L2 Line Data (word7) - 14.4.1.8/14-27 */
	{.name = "L2LineDataWord7",  .type = REG_MMIO_32, .offset = 0xf2c},
	/* 15 L2 Line Tag {Tag,V,D0,D1,VP} R/W 0x0..._.... 14.4.1.8/14-27 */
	{.name = "L2LineTag",        .type = REG_MMIO_32, .offset = 0xf30},
	/* 15 L2 Debug control register R/W 0x0..._.... 14.4.1.8/14-27 */
	{.name = "L2DebugControl",   .type = REG_MMIO_32, .offset = 0xf40},
	/* L2CC Auxiliary Control Register 2 (L2CCAUXCR) */
	{.name = "L2CCAUXCR",        .type = REG_MMIO_32, .offset = 0x104},
	{NULL}
};

static regproc_reg_t mx31_evtmon[] = {
	/* Event Monitor Control R/W 0x0000_0000 15.3.3.1/15-4 */
	{.name = "EMMC",             .type = REG_MMIO_32, .offset = 0x000},
	/* Counter Status Register R/W 0x0000_0000 15.3.3.2/15-5 */
	{.name = "EMCS",             .type = REG_MMIO_32, .offset = 0x004},
	/* Counter 0 Configuration R/W 0x0000_0000 15.3.3.3/15-6 */
	{.name = "EMCC0",            .type = REG_MMIO_32, .offset = 0x008},
	/* Counter 1 Configuration R/W 0x0000_0000 15.3.3.3/15-6 */
	{.name = "EMCC1",            .type = REG_MMIO_32, .offset = 0x00c},
	/* Counter 2 Configuration R/W 0x0000_0000 15.3.3.3/15-6 */
	{.name = "EMCC2",            .type = REG_MMIO_32, .offset = 0x010},
	/* Counter 3 Configuration R/W 0x0000_0000 15.3.3.3/15-6 */
	{.name = "EMCC3",            .type = REG_MMIO_32, .offset = 0x014},
	/* Counter Register 0 R 0x0000_0000 15.3.3.4/15-8 */
	{.name = "EMC0",             .type = REG_MMIO_32, .offset = 0x020},
	/* Counter Register 1 R 0x0000_0000 15.3.3.4/15-8 */
	{.name = "EMC1",             .type = REG_MMIO_32, .offset = 0x024},
	/* Counter Register 2 R 0x0000_0000 15.3.3.4/15-8 */
	{.name = "EMC2",             .type = REG_MMIO_32, .offset = 0x028},
	/* Counter Register 3 R 0x0000_0000 15.3.3.4/15-8 */
	{.name = "EMC3",             .type = REG_MMIO_32, .offset = 0x02c},
	{NULL}
};

static regproc_reg_t mx31_m31f[] = {
	/* M3IF Control Register R/W 0x0000_0000 17.2.3.1/17-9 */
	{.name = "M3IFCTL",          .type = REG_MMIO_32, .offset = 0x000},
	/* M3IF Snooping Configuration Register 0 R/W 0x0000_0000 17.2.3.2/17-11 */
	{.name = "M3IFSCFG0",        .type = REG_MMIO_32, .offset = 0x028},
	/* M3IF Snooping Configuration Register 1 R/W 0x0000_0000 17.2.3.3/17-13 */
	{.name = "M3IFSCFG1",        .type = REG_MMIO_32, .offset = 0x02c},
	/* M3IF Snooping Configuration Register 2 R/W 0x0000_0000 17.2.3.4/17-14 */
	{.name = "M3IFSCFG2",        .type = REG_MMIO_32, .offset = 0x030},
	/* M3IF Snooping Status Register 0 R/W 0x0000_0000 17.2.3.5/17-14 */
	{.name = "M3IFSSR0",         .type = REG_MMIO_32, .offset = 0x034},
	/* M3IF Snooping Status Register 1 R/W 0x0000_0000 17.2.3.6/17-15 */
	{.name = "M3IFSSR1",         .type = REG_MMIO_32, .offset = 0x038},
	/* M3IF Master Lock WEIM CS0 Register R/W 0x0000_0000 17.2.3.7/17-16 */
	{.name = "M3IFMLWE0",        .type = REG_MMIO_32, .offset = 0x040},
	/* M3IF Master Lock WEIM CS1 Register R/W 0x0000_0000 17.2.3.7/17-16 */
	{.name = "M3IFMLWE1",        .type = REG_MMIO_32, .offset = 0x044},
	/* M3IF Master Lock WEIM CS2 Register R/W 0x0000_0000 17.2.3.7/17-16 */
	{.name = "M3IFMLWE2",        .type = REG_MMIO_32, .offset = 0x048},
	/* M3IF Master Lock WEIM CS3 Register R/W 0x0000_0000 17.2.3.7/17-16 */
	{.name = "M3IFMLWE3",        .type = REG_MMIO_32, .offset = 0x04c},
	/* M3IF Master Lock WEIM CS4 Register R/W 0x0000_0000 17.2.3.7/17-16 */
	{.name = "M3IFMLWE4",        .type = REG_MMIO_32, .offset = 0x050},
	/* M3IF Master Lock WEIM CS5 Register R/W 0x0000_0000 17.2.3.7/17-16 */
	{.name = "M3IFMLWE5",        .type = REG_MMIO_32, .offset = 0x054},
	{NULL}
};

static regproc_reg_t mx31_weim[] = {
	/* Chip Select 0 Upper Control Register R/W 0x0000_0100 18.4.3.1/18-13 */
	{.name = "CSCR0U",           .type = REG_MMIO_32, .offset = 0x000},
	/* Chip Select 0 Lower Control Register R/W 0x0000_0801 18.4.3.2/18-17 */
	{.name = "CSCR0L",           .type = REG_MMIO_32, .offset = 0x004},
	/* Chip Select 0 Addition Control Register R/W 0x0000_8000 18.4.3.3/18-21 */
	{.name = "CSCR0A",           .type = REG_MMIO_32, .offset = 0x008},
	/* Chip Select 1 Upper Control Register R/W 0x0000_0000 18.4.3.1/18-13 */
	{.name = "CSCR1U",           .type = REG_MMIO_32, .offset = 0x010},
	/* Chip Select 1 Lower Control Register R/W 0x0000_0000 18.4.3.2/18-17 */
	{.name = "CSCR1L",           .type = REG_MMIO_32, .offset = 0x014},
	/* Chip Select 1 Addition Control Register R/W 0x0000_0000 18.4.3.3/18-21 */
	{.name = "CSCR1A",           .type = REG_MMIO_32, .offset = 0x018},
	/* Chip Select 2 Upper Control Register R/W 0x0000_0000 18.4.3.1/18-13 */
	{.name = "CSCR2U",           .type = REG_MMIO_32, .offset = 0x020},
	/* Chip Select 2 Lower Control Register R/W 0x0000_0000 18.4.3.2/18-17 */
	{.name = "CSCR2L",           .type = REG_MMIO_32, .offset = 0x024},
	/* Chip Select 2 Addition Control Register R/W 0x0000_0000 18.4.3.3/18-21 */
	{.name = "CSCR2A",           .type = REG_MMIO_32, .offset = 0x028},
	/* Chip Select 3 Upper Control Register R/W 0x0000_0000 18.4.3.1/18-13 */
	{.name = "CSCR3U",           .type = REG_MMIO_32, .offset = 0x030},
	/* Chip Select 3 Lower Control Register R/W 0x0000_0000 18.4.3.2/18-17 */
	{.name = "CSCR3L",           .type = REG_MMIO_32, .offset = 0x034},
	/* Chip Select 3 Addition Control Register R/W 0x0000_0000 18.4.3.3/18-21 */
	{.name = "CSCR3A",           .type = REG_MMIO_32, .offset = 0x038},
	/* Chip Select 4 Upper Control Register R/W 0x0000_0000 18.4.3.1/18-13 */
	{.name = "CSCR4U",           .type = REG_MMIO_32, .offset = 0x040},
	/* Chip Select 4 Lower Control Register R/W 0x0000_0000 18.4.3.2/18-17 */
	{.name = "CSCR4L",           .type = REG_MMIO_32, .offset = 0x044},
	/* Chip Select 4 Addition Control Register R/W 0x0000_0000 18.4.3.3/18-21 */
	{.name = "CSCR4A",           .type = REG_MMIO_32, .offset = 0x048},
	/* Chip Select 5 Upper Control Register R/W 0x0000_0000 18.4.3.1/18-13 */
	{.name = "CSCR5U",           .type = REG_MMIO_32, .offset = 0x050},
	/* Chip Select 5 Lower Control Register R/W 0x0000_0000 18.4.3.2/18-17 */
	{.name = "CSCR5L",           .type = REG_MMIO_32, .offset = 0x054},
	/* Chip Select 5 Addition Control Register R/W 0x0000_0000 18.4.3.3/18-21 */
	{.name = "CSCR5A",           .type = REG_MMIO_32, .offset = 0x058},
	/* WEIM Configuration Register R/W 0x0000_0100 18.4.3.4/18-24 */
	{.name = "WCR",              .type = REG_MMIO_32, .offset = 0x060},
	{NULL}
};

static regproc_reg_t mx31_esdctl[] = {
	/* Enhanced SDRAM Control Register 0 R/W 0x0111_0080 19.3.3.1/19-15 */
	{.name = "ESDCTL0",          .type = REG_MMIO_32, .offset = 0x000},
	/* Enhanced SDRAM Configuration Register 0 R/W 0x0076_EB3A 19.3.3.2/19-20 */
	{.name = "ESDCFG0",          .type = REG_MMIO_32, .offset = 0x004},
	/* Enhanced SDRAM Control Register 1 R/W 0x8112_0080 19.3.3.1/19-15 */
	{.name = "ESDCTL1",          .type = REG_MMIO_32, .offset = 0x008},
	/* Enhanced SDRAM Configuration Register 1 R/W 0x007A_C727 19.3.3.2/19-20 */
	{.name = "ESDCFG1",          .type = REG_MMIO_32, .offset = 0x00c},
	/* Enhanced SDRAM Miscellaneous Register R/W 0x0000_0000 19.3.3.3/19-33 */
	{.name = "ESDMISC",          .type = REG_MMIO_32, .offset = 0x010},
	/* Enhanced MDDR Delay Line 1 Configuration Debug Register R/W 0x001C_0000 19.3.3.4/19-35 */
	{.name = "ESDCDLY1",         .type = REG_MMIO_32, .offset = 0x020},
	/* Enhanced MDDR Delay Line 2 Configuration Debug Register R/W 0x001C_0000 19.3.3.5/19-36 */
	{.name = "ESDCDLY2",         .type = REG_MMIO_32, .offset = 0x024},
	/* Enhanced MDDR Delay Line 3 Configuration Debug Register R/W 0x001C_0000 19.3.3.8/19-39 */
	{.name = "ESDCDLY3",         .type = REG_MMIO_32, .offset = 0x028},
	/* Enhanced MDDR Delay Line 4 Configuration Debug Register R/W 0x001C_0000 19.3.3.9/19-40 */
	{.name = "ESDCDLY4",         .type = REG_MMIO_32, .offset = 0x02c},
	/* Enhanced MDDR Delay Line 5 Configuration Debug Register R/W 0x001C_0000 19.3.3.8/19-39 */
	{.name = "ESDCDLY5",         .type = REG_MMIO_32, .offset = 0x030},
	/* Enhanced MDDR Delay Line Cycle Length Debug Register R N/A 19.3.3.9/19-40 */
	{.name = "ESDCDLYL",         .type = REG_MMIO_32, .offset = 0x034},
	{NULL}
};

static regproc_reg_t mx31_nandfc[] = {
	/* NAND FC Buffer Size Register R 0x0000_0001 20.7.1/20-12 */
	{.name = "NFC_BUFSIZ",       .type = REG_MMIO_16, .offset = 0xe00},
	/* RAM Buffer Address Register R/W 0x0000_0000 20.7.2/20-13 */
	{.name = "RAM_BUFFER_ADDRESS",.type = REG_MMIO_16, .offset = 0xe04},
	/* NAND Flash Address Register R/W 0x0000_0000 20.7.2/20-13 */
	{.name = "NAND_FLASH_ADD",   .type = REG_MMIO_16, .offset = 0xe06},
	/* NAND Flash Command Register R/W 0x0000_0000 20.7.3/20-13 */
	{.name = "NAND_FLASH_CMD",   .type = REG_MMIO_16, .offset = 0xe08},
	/* NANDFC Internal Buffer Lock Control R/W 0x0000_0001 20.7.4/20-14 */
	{.name = "NFC_CONFIGURATION",.type = REG_MMIO_16, .offset = 0xe0a},
	/* Controller Status and Result of Flash Operation R 0x0000_0000 20.7.5/20-14 */
	{.name = "ECC_STATUS_RESULT",.type = REG_MMIO_16, .offset = 0xe0c},
	/* ECC Error Position Main Area Data Error x8/x16 R 0x0000_0000 20.7.6/20-15 */
	{.name = "ECC_RSLT_MAIN_AREA",.type = REG_MMIO_16, .offset = 0xe0e},
	/* ECC Error Position Spare Area Data Error x8/x16 R 0x0000_0000 20.7.7/20-16 */
	{.name = "ECC_RSLT_SPARE_AREA",.type = REG_MMIO_16, .offset = 0xe10},
	/* NAND Flash Write Protection R/W 0x0000_0002 20.7.9/20-18 */
	{.name = "NF_WR_PROT",       .type = REG_MMIO_16, .offset = 0xe12},
	/* Start R/W 0x0000_0000 20.7.10/20-18 */
	{.name = "UNLOCK_START_BLK_ADD",.type = REG_MMIO_16, .offset = 0xe14},
	/* Address to Unlock in Write Protection Mode-End R/W 0x0000_0000 20.7.11/20-19 */
	{.name = "UNLOCK_END_BLK_ADD",.type = REG_MMIO_16, .offset = 0xe16},
	/* NAND Flash Write Protection Status R/W 0x0000_0002 20.7.12/20-19 */
	{.name = "NAND_FLASH_WR_PR_ST",.type = REG_MMIO_16, .offset = 0xe18},
	/* NAND Flash Operation Configuration1 R/W 0x0000_0008 20.7.13/20-20 */
	{.name = "NAND_FLASH_CONFIG1",.type = REG_MMIO_16, .offset = 0xe1a},
	/* NAND Flash Operation Configuration 2 R/W 0x0000_0000 20.7.14/20-21 */
	{.name = "NAND_FLASH_CONFIG2",.type = REG_MMIO_16, .offset = 0xe1c},
	{NULL}
};

static regproc_reg_t mx31_pcmcia[] = {
	/* PCMCIA input Pins Register Read Only 0x0000_00.. 21.4.1.1/21-9 */
	{.name = "PIPR",             .type = REG_MMIO_32, .offset = 0x000},
	/* PCMCIA Status Changed Register Read/Write 0x0000_0000 21.4.1.2/21-11 */
	{.name = "PSCR",             .type = REG_MMIO_32, .offset = 0x004},
	/* PCMCIA Enable Register Read/Write 0x0000_1018 21.4.1.3/21-12 */
	{.name = "PER",              .type = REG_MMIO_32, .offset = 0x008},
	/* PCMCIA Base Register 0 Read/Write 0x0000_0000 21.4.1.4/21-14 */
	{.name = "PBR0",             .type = REG_MMIO_32, .offset = 0x00c},
	/* PCMCIA Base Register 1 Read/Write 0x0000_0000 21.4.1.4/21-14 */
	{.name = "PBR1",             .type = REG_MMIO_32, .offset = 0x010},
	/* PCMCIA Base Register 2 Read/Write 0x0000_0000 21.4.1.4/21-14 */
	{.name = "PBR2",             .type = REG_MMIO_32, .offset = 0x014},
	/* PCMCIA Base Register 3 Read/Write 0x0000_0000 21.4.1.4/21-14 */
	{.name = "PBR3",             .type = REG_MMIO_32, .offset = 0x018},
	/* PCMCIA Base Register 4 Read/Write 0x0000_0000 21.4.1.4/21-14 */
	{.name = "PBR4",             .type = REG_MMIO_32, .offset = 0x01c},
	/* PCMCIA Option Register 0 Read/Write 0x0000_0000 21.4.1.5/21-15 */
	{.name = "POR0",             .type = REG_MMIO_32, .offset = 0x028},
	/* PCMCIA Option Register 1 Read/Write 0x0000_0000 21.4.1.5/21-15 */
	{.name = "POR1",             .type = REG_MMIO_32, .offset = 0x02c},
	/* PCMCIA Option Register 2 Read/Write 0x0000_0000 21.4.1.5/21-15 */
	{.name = "POR2",             .type = REG_MMIO_32, .offset = 0x030},
	/* PCMCIA Option Register 3 Read/Write 0x0000_0000 21.4.1.5/21-15 */
	{.name = "POR3",             .type = REG_MMIO_32, .offset = 0x034},
	/* PCMCIA Option Register 4 Read/Write 0x0000_0000 21.4.1.5/21-15 */
	{.name = "POR4",             .type = REG_MMIO_32, .offset = 0x038},
	/* PCMCIA Offset Register 0 Read/Write 0x0000_0000 21.4.1.6/21-19 */
	{.name = "POFR0",            .type = REG_MMIO_32, .offset = 0x044},
	/* PCMCIA Offset Register 1 Read/Write 0x0000_0000 21.4.1.6/21-19 */
	{.name = "POFR1",            .type = REG_MMIO_32, .offset = 0x048},
	/* PCMCIA Offset Register 2 Read/Write 0x0000_0000 21.4.1.6/21-19 */
	{.name = "POFR2",            .type = REG_MMIO_32, .offset = 0x04c},
	/* PCMCIA Offset Register 3 Read/Write 0x0000_0000 21.4.1.6/21-19 */
	{.name = "POFR3",            .type = REG_MMIO_32, .offset = 0x050},
	/* PCMCIA Offset Register 4 Read/Write 0x0000_0000 21.4.1.6/21-19 */
	{.name = "POFR4",            .type = REG_MMIO_32, .offset = 0x054},
	/* PCMCIA General Control Register Read/Write 0x0000_0008 21.4.1.7/21-20 */
	{.name = "PGCR",             .type = REG_MMIO_32, .offset = 0x060},
	/* PCMCIA General Status Register Read/Write 0x0000_0000 21.4.1.8/21-21 */
	{.name = "PGSR",             .type = REG_MMIO_32, .offset = 0x064},
	{NULL}
};

static regproc_reg_t mx31_owire[] = {
	/* Control register 0x0000 R/W 22.4.3.1/22-4 */
	{.name = "CONTROL",          .type = REG_MMIO_16, .offset = 0x000},
	/* Time divider register 0x0000 R/W 22.4.3.2/22-5 */
	{.name = "TIME_DIVIDER",     .type = REG_MMIO_16, .offset = 0x002},
	/* Reset register 0x0000 R/W 22.4.3.3/22-8 */
	{.name = "RESET",            .type = REG_MMIO_16, .offset = 0x004},
	{NULL}
};

static regproc_reg_t mx31_ata[] = {
	/* Transceiver timing parameter. Controls toff R/W 0x01 23.3.3.2.1/23-20 */
	{.name = "TIME_OFF",         .type = REG_MMIO_8,  .offset = 0x000},
	/* Transceiver timing parameter. Controls ton R/W 0x01 23.3.3.2.2/23-20 */
	{.name = "TIME_ON",          .type = REG_MMIO_8,  .offset = 0x001},
	/* PIO timing parameter. Controls t1 R/W 0x01 23.3.3.2.3/23-21 */
	{.name = "TIME_1",           .type = REG_MMIO_8,  .offset = 0x002},
	/* PIO timing parameter. Controls t2 during write cycles R/W 0x01 23.3.3.2.4/23-21 */
	{.name = "TIME_2W",          .type = REG_MMIO_8,  .offset = 0x003},
	/* PIO timing parameter. Controls t2 during read cycles R/W 0x01 23.3.3.2.5/23-21 */
	{.name = "TIME_2R",          .type = REG_MMIO_8,  .offset = 0x004},
	/* PIO timing parameter. Controls tA R/W 0x01 23.3.3.2.6/23-21 */
	{.name = "TIME_AX",          .type = REG_MMIO_8,  .offset = 0x005},
	/* PIO timing parameter. Controls trd R/W 0x01 23.3.3.2.7/23-22 */
	{.name = "TIME_PIO_RDX",     .type = REG_MMIO_8,  .offset = 0x00f},
	/* PIO timing parameter. Controls t4 R/W 0x01 23.3.3.2.8/23-22 */
	{.name = "TIME_4",           .type = REG_MMIO_8,  .offset = 0x007},
	/* PIO timing parameter. Controls t9 R/W 0x01 23.3.3.2.9/23-22 */
	{.name = "TIME_9",           .type = REG_MMIO_8,  .offset = 0x008},
	/* MDMA timing parameter. Controls tm R/W 0x01 23.3.3.2.10/23-22 */
	{.name = "TIME_M",           .type = REG_MMIO_8,  .offset = 0x009},
	/* MDMA timing parameter. Controls tn and tj R/W 0x01 23.3.3.2.11/23-23 */
	{.name = "TIME_JN",          .type = REG_MMIO_8,  .offset = 0x00a},
	/* MDMA timing parameter. Controls td R/W 0x01 23.3.3.2.12/23-23 */
	{.name = "TIME_D",           .type = REG_MMIO_8,  .offset = 0x00b},
	/* MDMA timing parameter. Controls tk R/W 0x01 23.3.3.2.13/23-23 */
	{.name = "TIME_K",           .type = REG_MMIO_8,  .offset = 0x00c},
	/* UDMA timing parameter. Controls tack R/W 0x01 23.3.3.2.14/23-23 */
	{.name = "TIME_ACK",         .type = REG_MMIO_8,  .offset = 0x00d},
	/* UDMA timing parameter. Controls tenv. R/W 0x01 23.3.3.2.15/23-24 */
	{.name = "TIME_ENV",         .type = REG_MMIO_8,  .offset = 0x00e},
	/* UDMA timing parameter. Controls trp. R/W 0x01 23.3.3.2.16/23-24 */
	{.name = "TIME_PIO_RPX",     .type = REG_MMIO_8,  .offset = 0x00f},
	/* UDMA timing parameter. Controls tzah. R/W 0x01 23.3.3.2.17/23-24 */
	{.name = "TIME_ZAH",         .type = REG_MMIO_8,  .offset = 0x010},
	/* UDMA timing parameter. Controls tmli. R/W 0x01 23.3.3.2.18/23-24 */
	{.name = "TIME_MLIX",        .type = REG_MMIO_8,  .offset = 0x011},
	/* UDMA timing parameter. Controls tdvh. R/W 0x01 23.3.3.2.19/23-25 */
	{.name = "TIME_DVH",         .type = REG_MMIO_8,  .offset = 0x012},
	/* UDMA timing parameter. Controls tdzfs. R/W 0x01 23.3.3.2.20/23-25 */
	{.name = "TIME_DZFS",        .type = REG_MMIO_8,  .offset = 0x013},
	/* UDMA timing parameter. Controls tdvs. R/W 0x01 23.3.3.2.21/23-25 */
	{.name = "TIME_DVS",         .type = REG_MMIO_8,  .offset = 0x014},
	/* UDMA timing parameter. Controls tcvh. R/W 0x01 23.3.3.2.22/23-25 */
	{.name = "TIME_CVH",         .type = REG_MMIO_8,  .offset = 0x015},
	/* UDMA timing parameter. Controls tss R/W 0x01 23.3.3.2.23/23-26 */
	{.name = "TIME_SS",          .type = REG_MMIO_8,  .offset = 0x016},
	/* UDMA timing parameter. Controls tcyc and t2cyc. R/W 0x01 23.3.3.2.24/23-26 */
	{.name = "TIME_CYC",         .type = REG_MMIO_8,  .offset = 0x017},
	/* 16-bit wide data port to/from FIFO. R/W - 23.3.3.3.1/23-26 */
	{.name = "FIFO_DATA_16",     .type = REG_MMIO_16, .offset = 0x01c},
	/* 32-bit wide data port to/from FIFO. R/W - 23.3.3.3.2/23-27 */
	{.name = "FIFO_DATA_32",     .type = REG_MMIO_32, .offset = 0x018},
	/* Fifo Filling In Halfwords  R 0x00 23.3.3.3.3/23-27 */
	{.name = "FIFO_FILL",        .type = REG_MMIO_8,  .offset = 0x020},
	/* Ata Interface Control Register R/W 0x00 23.3.3.5.1/23-29 */
	{.name = "ATA_CONTROL",      .type = REG_MMIO_8,  .offset = 0x024},
	/* Interrupt Pending Register R 0x1 - 23.3.3.5.1/23-29 */
	{.name = "INTERRUPT_PENDING",.type = REG_MMIO_8,  .offset = 0x028},
	/* Interrupt Enable Register R/W 0x0 - 23.3.3.5.2/23-30 */
	{.name = "INTERRUPT_ENABLE", .type = REG_MMIO_8,  .offset = 0x02c},
	/* Interrupt Clear Register W - 23.3.3.5.3/23-31 */
	{.name = "INTERRUPT_CLEAR",  .type = REG_MMIO_8,  .offset = 0x030},
	/* Fifo Alarm Threshold R/W 0x00 23.3.3.7/23-32 */
	{.name = "FIFO_ALARM",       .type = REG_MMIO_8,  .offset = 0x034},
	/* Drive Features Register R/W 23.3.3.7/23-32 */
	{.name = "DRIVE_DATA",       .type = REG_MMIO_16, .offset = 0x0a0},
	/* Drive Sector Count Register R/W 23.3.3.7/23-32 */
	{.name = "DRIVE_SECTOR_COUNT",.type = REG_MMIO_16, .offset = 0x0a8},
	/* Drive Cylinder Low Register R/W - 23.3.3.7/23-32 */
	{.name = "DRIVE_SECTOR_NUM", .type = REG_MMIO_16, .offset = 0x0ac},
	/* Drive Cylinder High Register R/W - 23.3.3.7/23-32 */
	{.name = "DRIVE_CYL_HIGH",   .type = REG_MMIO_16, .offset = 0x0b4},
	/* Drive Device Head Register R/W - 23.3.3.7/23-32 */
	{.name = "DRIVE_DEV_HEAD",   .type = REG_MMIO_16, .offset = 0x0b8},
	/* Drive Status Register(R)/Drive Command Register(W) R/W - 23.3.3.7/23-32 */
	{.name = "DRIVE_STATUS_CMD", .type = REG_MMIO_16, .offset = 0x0bc},
	/* Drive Alternate Status Register(R)/Drive Control Register(W) R/W - 23.3.3.7/23-32 */
	{.name = "DRIVE_ALT_STATUS_CONTROL",.type = REG_MMIO_16, .offset = 0x0d8},
	{NULL}
};

static regproc_reg_t mx31_cspi1[] = {
	/* Receive Data Register (RXDATA) R 0x0000_0000 24.3.3.1/24-6 */
	{.name = "RXDATA1",          .type = REG_MMIO_32, .offset = 0x000},
	/* Transmit Data Register (TXDATA) W 0x0000_0000 24.3.3.2/24-7 */
	{.name = "TXDATA1",          .type = REG_MMIO_32, .offset = 0x004},
	/* Control Register (CONREG) R/W 0x0000_0000 24.3.3.3/24-8 */
	{.name = "CONREG1",          .type = REG_MMIO_32, .offset = 0x008},
	/* Interrupt Control Register (INTREG) R/W 0x0000_0000 24.3.3.4/24-11 */
	{.name = "INTREG1",          .type = REG_MMIO_32, .offset = 0x00c},
	/* DMA Control Register (DMAREG) R/W 0x0000_0000 24.3.3.5/24-13 */
	{.name = "DMAREG1",          .type = REG_MMIO_32, .offset = 0x010},
	/* Status Register (STATREG) R/W 0x0000_0003 24.3.3.6/24-14 */
	{.name = "STATREG1",         .type = REG_MMIO_32, .offset = 0x014},
	/* Sample Period Control Register (PERIODREG) R/W 0x0000_0000 24.3.3.7/24-15 */
	{.name = "PERIODREG1",       .type = REG_MMIO_32, .offset = 0x018},
	{NULL}
};

static regproc_reg_t mx31_cspi2[] = {
	/* Receive Data Register (RXDATA) R 0x0000_0000 24.3.3.1/24-6 */
	{.name = "RXDATA2",          .type = REG_MMIO_32, .offset = 0x000},
	/* Transmit Data Register (TXDATA) W 0x0000_0000 24.3.3.2/24-7 */
	{.name = "TXDATA2",          .type = REG_MMIO_32, .offset = 0x004},
	/* Control Register (CONREG) R/W 0x0000_0000 24.3.3.3/24-8 */
	{.name = "CONREG2",          .type = REG_MMIO_32, .offset = 0x008},
	/* Interrupt Control Register (INTREG) R/W 0x0000_0000 24.3.3.4/24-11 */
	{.name = "INTREG2",          .type = REG_MMIO_32, .offset = 0x00c},
	/* DMA Control Register (DMAREG) R/W 0x0000_0000 24.3.3.5/24-13 */
	{.name = "DMAREG2",          .type = REG_MMIO_32, .offset = 0x010},
	/* Status Register (STATREG) R/W 0x0000_0003 24.3.3.6/24-14 */
	{.name = "STATREG2",         .type = REG_MMIO_32, .offset = 0x014},
	/* Sample Period Control Register (PERIODREG) R/W 0x0000_0000 24.3.3.7/24-15 */
	{.name = "PERIODREG2",       .type = REG_MMIO_32, .offset = 0x018},
	{NULL}
};

static regproc_reg_t mx31_cspi3[] = {
	/* Receive Data Register (RXDATA) R 0x0000_0000 24.3.3.1/24-6 */
	{.name = "RXDATA3",          .type = REG_MMIO_32, .offset = 0x000},
	/* Transmit Data Register (TXDATA) W 0x0000_0000 24.3.3.2/24-7 */
	{.name = "TXDATA3",          .type = REG_MMIO_32, .offset = 0x004},
	/* Control Register (CONREG) R/W 0x0000_0000 24.3.3.3/24-8 */
	{.name = "CONREG3",          .type = REG_MMIO_32, .offset = 0x008},
	/* Interrupt Control Register (INTREG) R/W 0x0000_0000 24.3.3.4/24-11 */
	{.name = "INTREG3",          .type = REG_MMIO_32, .offset = 0x00c},
	/* DMA Control Register (DMAREG) R/W 0x0000_0000 24.3.3.5/24-13 */
	{.name = "DMAREG3",          .type = REG_MMIO_32, .offset = 0x010},
	/* Status Register (STATREG) R/W 0x0000_0003 24.3.3.6/24-14 */
	{.name = "STATREG3",         .type = REG_MMIO_32, .offset = 0x014},
	/* Sample Period Control Register (PERIODREG) R/W 0x0000_0000 24.3.3.7/24-15 */
	{.name = "PERIODREG3",       .type = REG_MMIO_32, .offset = 0x018},
	{NULL}
};

static regproc_reg_t mx31_fir[] = {
	/* FIR Transmit Control Register 0x0000_0000 R/W 25.3.3.1/25-9 */
	{.name = "FIRITCR",          .type = REG_MMIO_32, .offset = 0x000},
	/* FIR Transmit Count Register 0x0000_0000 R/W 25.3.3.2/25-11 */
	{.name = "FIRITCTR",         .type = REG_MMIO_32, .offset = 0x004},
	/* FIR Receive Control Register 0x0000_0000 R/W 25.3.3.3/25-12 */
	{.name = "FIRIRCR",          .type = REG_MMIO_32, .offset = 0x008},
	/* FIR Transmit Status Register 0x0000_0000 R/Write one to clear 25.3.3.4/25-14 */
	{.name = "FIRITSR",          .type = REG_MMIO_32, .offset = 0x00c},
	/* FIR Receive Status Register 0x0000_0000 R/Write one to clear 25.3.3.5/25-15 */
	{.name = "FIRIRSR",          .type = REG_MMIO_32, .offset = 0x010},
	/* Transmitter FIFO - W 25.4.2/25-18 */
	{.name = "TXFIFO",           .type = REG_MMIO_32, .offset = 0x014},
	/* Receiver FIFO - R 25.4.4/25-20 */
	{.name = "RXFIFO",           .type = REG_MMIO_32, .offset = 0x018},
	/* FIR Control Register 0x0000_0000 R/W 25.3.3.6/25-16 */
	{.name = "FIRICR",           .type = REG_MMIO_32, .offset = 0x01c},
	{NULL}
};

static regproc_reg_t mx31_i2c1[] = {
	/* I2C Address Register R/W 0x0000 26.3.3.1/26-6 */
	{.name = "IADR1",            .type = REG_MMIO_16, .offset = 0x000},
	/* I2C Frequency Divider Register R/W 0x0000 26.3.3.2/26-7 */
	{.name = "IFDR1",            .type = REG_MMIO_16, .offset = 0x004},
	/* I2C Control Register R/W 0x0000 26.3.3.3/26-8 */
	{.name = "I2CR1",            .type = REG_MMIO_16, .offset = 0x008},
	/* I2C Status Register R/W 0x0081 26.3.3.4/26-10 */
	{.name = "I2SR1",            .type = REG_MMIO_16, .offset = 0x00c},
	/* I2C Data I/O Register R/W 0x0000 26.3.3.5/26-11 */
	{.name = "I2DR1",            .type = REG_MMIO_16, .offset = 0x010},
	{NULL}
};

static regproc_reg_t mx31_i2c2[] = {
	/* I2C Address Register R/W 0x0000 26.3.3.1/26-6 */
	{.name = "IADR2",            .type = REG_MMIO_16, .offset = 0x000},
	/* I2C Frequency Divider Register R/W 0x0000 26.3.3.2/26-7 */
	{.name = "IFDR2",            .type = REG_MMIO_16, .offset = 0x004},
	/* I2C Control Register R/W 0x0000 26.3.3.3/26-8 */
	{.name = "I2CR2",            .type = REG_MMIO_16, .offset = 0x008},
	/* I2C Status Register R/W 0x0081 26.3.3.4/26-10 */
	{.name = "I2SR2",            .type = REG_MMIO_16, .offset = 0x00c},
	/* I2C Data I/O Register R/W 0x0000 26.3.3.5/26-11 */
	{.name = "I2DR2",            .type = REG_MMIO_16, .offset = 0x010},
	{NULL}
};

static regproc_reg_t mx31_i2c3[] = {
	/* I2C Address Register R/W 0x0000 26.3.3.1/26-6 */
	{.name = "IADR3",            .type = REG_MMIO_16, .offset = 0x000},
	/* I2C Frequency Divider Register R/W 0x0000 26.3.3.2/26-7 */
	{.name = "IFDR3",            .type = REG_MMIO_16, .offset = 0x004},
	/* I2C Control Register R/W 0x0000 26.3.3.3/26-8 */
	{.name = "I2CR3",            .type = REG_MMIO_16, .offset = 0x008},
	/* I2C Status Register R/W 0x0081 26.3.3.4/26-10 */
	{.name = "I2SR3",            .type = REG_MMIO_16, .offset = 0x00c},
	/* I2C Data I/O Register R/W 0x0000 26.3.3.5/26-11 */
	{.name = "I2DR3",            .type = REG_MMIO_16, .offset = 0x010},
	{NULL}
};

static regproc_reg_t mx31_kpp[] = {
	/* Keypad Control Register R/W 0x0000 27.3.3.1/27-5 */
	{.name = "KPCR",             .type = REG_MMIO_16, .offset = 0x000},
	/* Keypad Status Register R/W 0x0000 27.3.3.2/27-6 */
	{.name = "KPSR",             .type = REG_MMIO_16, .offset = 0x002},
	/* Keypad Data Direction Register R/W 0x0000 27.3.3.3/27-7 */
	{.name = "KDDR",             .type = REG_MMIO_16, .offset = 0x004},
	/* Keypad Data Register R/W - 27.3.3.4/27-8 */
	{.name = "KPDR",             .type = REG_MMIO_16, .offset = 0x006},
	{NULL}
};

static regproc_reg_t mx31_mshc1[] = {
	/* SMSC Timeout Register 1 R/W 0x00 28.2.3.2.1/28-6 */
	{.name = "TIMEOUT1",         .type = REG_MMIO_8,  .offset = 0x000},
	/* Gasket Interrupt Status/ Clear Register 1 R/W 0 28.2.3.2.2/28-7 */
	{.name = "INTERRUPT_STATUS1",.type = REG_MMIO_8,  .offset = 0x014},
	/* Gasket Interrupt Enable Register 1 R/W - 28.2.3.2.3/28-8 */
	{.name = "INTERRUPT_ENABLE1",.type = REG_MMIO_8,  .offset = 0x01c},
	{NULL}
};

static regproc_reg_t mx31_mshc2[] = {
	/* SMSC Timeout Register 2 R/W 0x00 28.2.3.2.1/28-6 */
	{.name = "TIMEOUT2",         .type = REG_MMIO_8,  .offset = 0x000},
	/* Gasket Interrupt Status/ Clear Register 2 R/W 0 28.2.3.2.2/28-7 */
	{.name = "INTERRUPT_STATUS2",.type = REG_MMIO_8,  .offset = 0x014},
	/* Gasket Interrupt Enable Register 2 R/W - 28.2.3.2.3/28-8 */
	{.name = "INTERRUPT_ENABLE2",.type = REG_MMIO_8,  .offset = 0x01c},
	{NULL}
};

static regproc_reg_t mx31_sdhc1[] = {
	/* SDHC Clock Control R/W 0x0000_0000 29.3.3.1/29-8 */
	{.name = "STR_STP_CLK",      .type = REG_MMIO_32, .offset = 0x000},
	/* SDHC Status R 0x3000_0000 29.3.3.2/29-10 */
	{.name = "STATUS",           .type = REG_MMIO_32, .offset = 0x004},
	/* SDHC Card Clock Rate R/W 0x0000_0008 29.3.3.3/29-14 */
	{.name = "CLK_RATE",         .type = REG_MMIO_32, .offset = 0x008},
	/* SDHC Command Data Control R/W 0x0000_0000 29.3.3.4/29-15 */
	{.name = "CMD_DAT_CONT",     .type = REG_MMIO_32, .offset = 0x00c},
	/* SDHC Response Time-out R/W 0x0000_0040 29.3.3.5/29-17 */
	{.name = "RES_TO",           .type = REG_MMIO_32, .offset = 0x010},
	/* SDHC Read Time-out R/W 0x0000_FFFF 29.3.3.6/29-18 */
	{.name = "READ_TO",          .type = REG_MMIO_32, .offset = 0x014},
	/* SDHC Block Length R/W 0x0000_0000 29.3.3.7/29-19 */
	{.name = "BLK_LEN",          .type = REG_MMIO_32, .offset = 0x018},
	/* SDHC Number of Block R/W 0x0000_0000 29.3.3.8/29-20 */
	{.name = "NOB",              .type = REG_MMIO_32, .offset = 0x01c},
	/* SDHC Revision Number R 0x0000_0400 29.3.3.9/29-21 */
	{.name = "REV_NO",           .type = REG_MMIO_32, .offset = 0x020},
	/* SDHC Interrupt Control R/W 0x0000_0000 29.3.3.10/29-22 */
	{.name = "INT_CNTR",         .type = REG_MMIO_32, .offset = 0x024},
	/* SDHC Command Number R/W 0x0000_0000 29.3.3.11/29-26 */
	{.name = "CMD",              .type = REG_MMIO_32, .offset = 0x028},
	/* SDHC Command Argument R/W 0x0000_0000 29.3.3.12/29-27 */
	{.name = "ARG",              .type = REG_MMIO_32, .offset = 0x02c},
	/* SDHC Command Response FIFO Access R 0x0000_0000 29.3.3.13/29-28 */
	{.name = "RES_FIFO",         .type = REG_MMIO_32, .offset = 0x034},
	/* SDHC Data Buffer Access R/W 0x0000_0000 29.3.3.14/29-29 */
	{.name = "BUFFER_ACCESS",    .type = REG_MMIO_32, .offset = 0x038},
	{NULL}
};

static regproc_reg_t mx31_sdhc2[] = {
	/* SDHC Clock Control R/W 0x0000_0000 29.3.3.1/29-8 */
	{.name = "STR_STP_CLK",      .type = REG_MMIO_32, .offset = 0x000},
	/* SDHC Status R 0x3000_0000 29.3.3.2/29-10 */
	{.name = "STATUS",           .type = REG_MMIO_32, .offset = 0x004},
	/* SDHC Card Clock Rate R/W 0x0000_0008 29.3.3.3/29-14 */
	{.name = "CLK_RATE",         .type = REG_MMIO_32, .offset = 0x008},
	/* SDHC Command Data Control R/W 0x0000_0000 29.3.3.4/29-15 */
	{.name = "CMD_DAT_CONT",     .type = REG_MMIO_32, .offset = 0x00c},
	/* SDHC Response Time-out R/W 0x0000_0040 29.3.3.5/29-17 */
	{.name = "RES_TO",           .type = REG_MMIO_32, .offset = 0x010},
	/* SDHC Read Time-out R/W 0x0000_FFFF 29.3.3.6/29-18 */
	{.name = "READ_TO",          .type = REG_MMIO_32, .offset = 0x014},
	/* SDHC Block Length R/W 0x0000_0000 29.3.3.7/29-19 */
	{.name = "BLK_LEN",          .type = REG_MMIO_32, .offset = 0x018},
	/* SDHC Number of Block R/W 0x0000_0000 29.3.3.8/29-20 */
	{.name = "NOB",              .type = REG_MMIO_32, .offset = 0x01c},
	/* SDHC Revision Number R 0x0000_0400 29.3.3.9/29-21 */
	{.name = "REV_NO",           .type = REG_MMIO_32, .offset = 0x020},
	/* SDHC Interrupt Control R/W 0x0000_0000 29.3.3.10/29-22 */
	{.name = "INT_CNTR",         .type = REG_MMIO_32, .offset = 0x024},
	/* SDHC Command Number R/W 0x0000_0000 29.3.3.11/29-26 */
	{.name = "CMD",              .type = REG_MMIO_32, .offset = 0x028},
	/* SDHC Command Argument R/W 0x0000_0000 29.3.3.12/29-27 */
	{.name = "ARG",              .type = REG_MMIO_32, .offset = 0x02c},
	/* SDHC Command Response FIFO Access R 0x0000_0000 29.3.3.13/29-28 */
	{.name = "RES_FIFO",         .type = REG_MMIO_32, .offset = 0x034},
	/* SDHC Data Buffer Access R/W 0x0000_0000 29.3.3.14/29-29 */
	{.name = "BUFFER_ACCESS",    .type = REG_MMIO_32, .offset = 0x038},
	{NULL}
};

static regproc_reg_t mx31_sim[] = {
	/* SIM Port1 Control register R/W 0x0000_0000 30.3.3.1/30-12 */
	{.name = "PORT1_CNTL",       .type = REG_MMIO_32, .offset = 0x000},
	/* SIM Setup register R/W 0x0000_0000 30.3.3.2/30-13 */
	{.name = "SETUP",            .type = REG_MMIO_32, .offset = 0x004},
	/* SIM Port 1 Detect register R/W 0x0000_000. 30.3.3.3/30-14 */
	{.name = "PORT1_DETECT",     .type = REG_MMIO_32, .offset = 0x008},
	/* SIM Port1 Transmit Buffer register R/W 0x0000_0000 30.3.3.4/30-15 */
	{.name = "PORT1_XMT_BUF",    .type = REG_MMIO_32, .offset = 0x00c},
	/* SIM Port 1 Receive Buffer register R 0x0000_0000 30.3.3.5/30-16 */
	{.name = "PORT1_RCV_BUF",    .type = REG_MMIO_32, .offset = 0x010},
	/* SIM Port0 Control register R/W 0x0000_0000 30.3.3.6/30-17 */
	{.name = "PORT0_CNTL",       .type = REG_MMIO_32, .offset = 0x014},
	/* SIM Control register R/W 0x0000_0006 30.3.3.7/30-18 */
	{.name = "CNTL",             .type = REG_MMIO_32, .offset = 0x018},
	/* SIM Clock Select register R/W 0x0000_0000 30.3.3.8/30-20 */
	{.name = "CLOCK_SELECT",     .type = REG_MMIO_32, .offset = 0x01c},
	/* SIM Receive Threshold register R/W 0x0000_0001 30.3.3.9/30-21 */
	{.name = "RCV_THRESHOLD",    .type = REG_MMIO_32, .offset = 0x020},
	/* SIM Enable register R/W 0x0000_0000 30.3.3.10/30-22 */
	{.name = "ENABLE",           .type = REG_MMIO_32, .offset = 0x024},
	/* SIM Transmit Status register R/W 0x0000_00B8 30.3.3.11/30-23 */
	{.name = "XMT_STATUS",       .type = REG_MMIO_32, .offset = 0x028},
	/* SIM Receive Status register R/W 0x0000_0000 30.3.3.12/30-25 */
	{.name = "RCV_STATUS",       .type = REG_MMIO_32, .offset = 0x02c},
	/* SIM Interrupt Mask register R/W 0x0000_1FFF 30.3.3.13/30-27 */
	{.name = "INT_MASK",         .type = REG_MMIO_32, .offset = 0x030},
	/* SIM Port0 Transmit Buffer register R/W 0x0000_0000 30.3.3.14/30-29 */
	{.name = "PORT0_XMT_BUF",    .type = REG_MMIO_32, .offset = 0x034},
	/* SIM Port0 Receive Buffer register R 0x0000_0000 30.3.3.15/30-30 */
	{.name = "PORT0_RCV_BUF",    .type = REG_MMIO_32, .offset = 0x038},
	/* SIM Port0 Detect register R/W 0x0000_000. 30.3.3.16/30-31 */
	{.name = "PORT0_DETECT",     .type = REG_MMIO_32, .offset = 0x03c},
	/* SIM Data Format register R/W 0x0000_0000 30.3.3.17/30-32 */
	{.name = "DATA_FORMAT",      .type = REG_MMIO_32, .offset = 0x040},
	/* SIM Transmit Threshold register R/W 0x0000_0000 30.3.3.18/30-33 */
	{.name = "XMT_THRESHOLD",    .type = REG_MMIO_32, .offset = 0x044},
	/* SIM Transmit Guard Control register R/W 0x0000_0000 30.3.3.19/30-34 */
	{.name = "GUARD_CNTL",       .type = REG_MMIO_32, .offset = 0x048},
	/* SIM Open Drain Configuration Control register R/W 0x0000_0000 30.3.3.20/30-35 */
	{.name = "OD_CONFIG",        .type = REG_MMIO_32, .offset = 0x04c},
	/* SIM Reset Control register R/W 0x0000_0000 30.3.3.21/30-36 */
	{.name = "RESET_CNTL",       .type = REG_MMIO_32, .offset = 0x050},
	/* SIM Character Wait Time register R/W 0x0000_FFFF 30.3.3.22/30-37 */
	{.name = "CHAR_WAIT",        .type = REG_MMIO_32, .offset = 0x054},
	/* SIM General Purpose Counter register R/W 0x0000_FFFF 30.3.3.23/30-38 */
	{.name = "GPCNT",            .type = REG_MMIO_32, .offset = 0x058},
	/* SIM Divisor register R/W 0x0000_00BF 30.3.3.24/30-39 */
	{.name = "DIVISOR",          .type = REG_MMIO_32, .offset = 0x05c},
	/* SIM Block Wait Time register R/W 0x0000_FFFF 30.3.3.25/30-39 */
	{.name = "BWT",              .type = REG_MMIO_32, .offset = 0x060},
	/* SIM Block Guard Time register R/W 0x0000_0000 30.3.3.26/30-40 */
	{.name = "BGT",              .type = REG_MMIO_32, .offset = 0x064},
	/* SIM Block Wait Time register HIGH R/W 0x0000_FFFF 30.3.3.27/30-41 */
	{.name = "BWT_H",            .type = REG_MMIO_32, .offset = 0x068},
	{NULL}
};

static regproc_reg_t mx31_uart1[] = {
	/* UART Control Register 1 R/W 0x0000_0000 31.3.3.3/31-15 */
	{.name = "UCR1_1",           .type = REG_MMIO_32, .offset = 0x080},
	/* UART Control Register 2 R/W 0x0000_0001 31.3.3.4/31-17 */
	{.name = "UCR2_1",           .type = REG_MMIO_32, .offset = 0x084},
	/* UART Control Register 3 R/W 0x0000_0700 31.3.3.5/31-19 */
	{.name = "UCR3_1",           .type = REG_MMIO_32, .offset = 0x088},
	/* UART Control Register 4 R/W 0x0000_8000 31.3.3.6/31-22 */
	{.name = "UCR4_1",           .type = REG_MMIO_32, .offset = 0x08c},
	/* UART FIFO Control Register R/W 0x0000_0801 31.3.3.7/31-23 */
	{.name = "UFCR1",            .type = REG_MMIO_32, .offset = 0x090},
	/* UART Status Register 1 R/W 0x0000_2040 31.3.3.8/31-25 */
	{.name = "USR1_1",           .type = REG_MMIO_32, .offset = 0x094},
	/* UART Status Register 2 R/W 0x0000_4028 31.3.3.9/31-27 */
	{.name = "USR2_1",           .type = REG_MMIO_32, .offset = 0x098},
	/* UART Escape Character Register R/W 0x0000_002B 31.3.3.10/31-29 */
	{.name = "UESC1",            .type = REG_MMIO_32, .offset = 0x09c},
	/* UART Escape Timer Register R/W 0x0000_0000 31.3.3.11/31-30 */
	{.name = "UTIM1",            .type = REG_MMIO_32, .offset = 0x0a0},
	/* UART BRM Incremental Register R/W 0x0000_0000 31.3.3.12/31-31 */
	{.name = "UBIR1",            .type = REG_MMIO_32, .offset = 0x0a4},
	/* UART BRM Modulator Register R/W 0x0000_0000 31.3.3.13/31-32 */
	{.name = "UBMR1",            .type = REG_MMIO_32, .offset = 0x0a8},
	/* UART Baud Rate Count Register R 0x0000_0004 31.3.3.14/31-33 */
	{.name = "UBRC1",            .type = REG_MMIO_32, .offset = 0x0ac},
	/* UART One Millisecond Register R/W 0x0000_0000 31.3.3.15/31-34 */
	{.name = "ONEMS1",           .type = REG_MMIO_32, .offset = 0x0b0},
	/* UART Test Register R/W 0x0000_0060 31.3.3.16/31-35 */
	{.name = "UTS1",             .type = REG_MMIO_32, .offset = 0x0b4},
	{NULL}
};

static regproc_reg_t mx31_uart2[] = {
	/* UART Control Register 1 R/W 0x0000_0000 31.3.3.3/31-15 */
	{.name = "UCR1_2",           .type = REG_MMIO_32, .offset = 0x080},
	/* UART Control Register 2 R/W 0x0000_0001 31.3.3.4/31-17 */
	{.name = "UCR2_2",           .type = REG_MMIO_32, .offset = 0x084},
	/* UART Control Register 3 R/W 0x0000_0700 31.3.3.5/31-19 */
	{.name = "UCR3_2",           .type = REG_MMIO_32, .offset = 0x088},
	/* UART Control Register 4 R/W 0x0000_8000 31.3.3.6/31-22 */
	{.name = "UCR4_2",           .type = REG_MMIO_32, .offset = 0x08c},
	/* UART FIFO Control Register R/W 0x0000_0801 31.3.3.7/31-23 */
	{.name = "UFCR2",            .type = REG_MMIO_32, .offset = 0x090},
	/* UART Status Register 1 R/W 0x0000_2040 31.3.3.8/31-25 */
	{.name = "USR1_2",           .type = REG_MMIO_32, .offset = 0x094},
	/* UART Status Register 2 R/W 0x0000_4028 31.3.3.9/31-27 */
	{.name = "USR2_2",           .type = REG_MMIO_32, .offset = 0x098},
	/* UART Escape Character Register R/W 0x0000_002B 31.3.3.10/31-29 */
	{.name = "UESC2",            .type = REG_MMIO_32, .offset = 0x09c},
	/* UART Escape Timer Register R/W 0x0000_0000 31.3.3.11/31-30 */
	{.name = "UTIM2",            .type = REG_MMIO_32, .offset = 0x0a0},
	/* UART BRM Incremental Register R/W 0x0000_0000 31.3.3.12/31-31 */
	{.name = "UBIR2",            .type = REG_MMIO_32, .offset = 0x0a4},
	/* UART BRM Modulator Register R/W 0x0000_0000 31.3.3.13/31-32 */
	{.name = "UBMR2",            .type = REG_MMIO_32, .offset = 0x0a8},
	/* UART Baud Rate Count Register R 0x0000_0004 31.3.3.14/31-33 */
	{.name = "UBRC2",            .type = REG_MMIO_32, .offset = 0x0ac},
	/* UART One Millisecond Register R/W 0x0000_0000 31.3.3.15/31-34 */
	{.name = "ONEMS2",           .type = REG_MMIO_32, .offset = 0x0b0},
	/* UART Test Register R/W 0x0000_0060 31.3.3.16/31-35 */
	{.name = "UTS2",             .type = REG_MMIO_32, .offset = 0x0b4},
	{NULL}
};

static regproc_reg_t mx31_uart3[] = {
	/* UART Control Register 1 R/W 0x0000_0000 31.3.3.3/31-15 */
	{.name = "UCR1_3",           .type = REG_MMIO_32, .offset = 0x080},
	/* UART Control Register 2 R/W 0x0000_0001 31.3.3.4/31-17 */
	{.name = "UCR2_3",           .type = REG_MMIO_32, .offset = 0x084},
	/* UART Control Register 3 R/W 0x0000_0700 31.3.3.5/31-19 */
	{.name = "UCR3_3",           .type = REG_MMIO_32, .offset = 0x088},
	/* UART Control Register 4 R/W 0x0000_8000 31.3.3.6/31-22 */
	{.name = "UCR4_3",           .type = REG_MMIO_32, .offset = 0x08c},
	/* UART FIFO Control Register R/W 0x0000_0801 31.3.3.7/31-23 */
	{.name = "UFCR3",            .type = REG_MMIO_32, .offset = 0x090},
	/* UART Status Register 1 R/W 0x0000_2040 31.3.3.8/31-25 */
	{.name = "USR1_3",           .type = REG_MMIO_32, .offset = 0x094},
	/* UART Status Register 2 R/W 0x0000_4028 31.3.3.9/31-27 */
	{.name = "USR2_3",           .type = REG_MMIO_32, .offset = 0x098},
	/* UART Escape Character Register R/W 0x0000_002B 31.3.3.10/31-29 */
	{.name = "UESC3",            .type = REG_MMIO_32, .offset = 0x09c},
	/* UART Escape Timer Register R/W 0x0000_0000 31.3.3.11/31-30 */
	{.name = "UTIM3",            .type = REG_MMIO_32, .offset = 0x0a0},
	/* UART BRM Incremental Register R/W 0x0000_0000 31.3.3.12/31-31 */
	{.name = "UBIR3",            .type = REG_MMIO_32, .offset = 0x0a4},
	/* UART BRM Modulator Register R/W 0x0000_0000 31.3.3.13/31-32 */
	{.name = "UBMR3",            .type = REG_MMIO_32, .offset = 0x0a8},
	/* UART Baud Rate Count Register R 0x0000_0004 31.3.3.14/31-33 */
	{.name = "UBRC3",            .type = REG_MMIO_32, .offset = 0x0ac},
	/* UART One Millisecond Register R/W 0x0000_0000 31.3.3.15/31-34 */
	{.name = "ONEMS3",           .type = REG_MMIO_32, .offset = 0x0b0},
	/* UART Test Register R/W 0x0000_0060 31.3.3.16/31-35 */
	{.name = "UTS3",             .type = REG_MMIO_32, .offset = 0x0b4},
	{NULL}
};

static regproc_reg_t mx31_uart4[] = {
	/* UART Control Register 1 R/W 0x0000_0000 31.3.3.3/31-15 */
	{.name = "UCR1_4",           .type = REG_MMIO_32, .offset = 0x080},
	/* UART Control Register 2 R/W 0x0000_0001 31.3.3.4/31-17 */
	{.name = "UCR2_4",           .type = REG_MMIO_32, .offset = 0x084},
	/* UART Control Register 3 R/W 0x0000_0700 31.3.3.5/31-19 */
	{.name = "UCR3_4",           .type = REG_MMIO_32, .offset = 0x088},
	/* UART Control Register 4 R/W 0x0000_8000 31.3.3.6/31-22 */
	{.name = "UCR4_4",           .type = REG_MMIO_32, .offset = 0x08c},
	/* UART FIFO Control Register R/W 0x0000_0801 31.3.3.7/31-23 */
	{.name = "UFCR4",            .type = REG_MMIO_32, .offset = 0x090},
	/* UART Status Register 1 R/W 0x0000_2040 31.3.3.8/31-25 */
	{.name = "USR1_4",           .type = REG_MMIO_32, .offset = 0x094},
	/* UART Status Register 2 R/W 0x0000_4028 31.3.3.9/31-27 */
	{.name = "USR2_4",           .type = REG_MMIO_32, .offset = 0x098},
	/* UART Escape Character Register R/W 0x0000_002B 31.3.3.10/31-29 */
	{.name = "UESC4",            .type = REG_MMIO_32, .offset = 0x09c},
	/* UART Escape Timer Register R/W 0x0000_0000 31.3.3.11/31-30 */
	{.name = "UTIM4",            .type = REG_MMIO_32, .offset = 0x0a0},
	/* UART BRM Incremental Register R/W 0x0000_0000 31.3.3.12/31-31 */
	{.name = "UBIR4",            .type = REG_MMIO_32, .offset = 0x0a4},
	/* UART BRM Modulator Register R/W 0x0000_0000 31.3.3.13/31-32 */
	{.name = "UBMR4",            .type = REG_MMIO_32, .offset = 0x0a8},
	/* UART Baud Rate Count Register R 0x0000_0004 31.3.3.14/31-33 */
	{.name = "UBRC4",            .type = REG_MMIO_32, .offset = 0x0ac},
	/* UART One Millisecond Register R/W 0x0000_0000 31.3.3.15/31-34 */
	{.name = "ONEMS4",           .type = REG_MMIO_32, .offset = 0x0b0},
	/* UART Test Register R/W 0x0000_0060 31.3.3.16/31-35 */
	{.name = "UTS4",             .type = REG_MMIO_32, .offset = 0x0b4},
	{NULL}
};

static regproc_reg_t mx31_uart5[] = {
	/* UART Control Register 1 R/W 0x0000_0000 31.3.3.3/31-15 */
	{.name = "UCR1_5",           .type = REG_MMIO_32, .offset = 0x080},
	/* UART Control Register 2 R/W 0x0000_0001 31.3.3.4/31-17 */
	{.name = "UCR2_5",           .type = REG_MMIO_32, .offset = 0x084},
	/* UART Control Register 3 R/W 0x0000_0700 31.3.3.5/31-19 */
	{.name = "UCR3_5",           .type = REG_MMIO_32, .offset = 0x088},
	/* UART Control Register 4 R/W 0x0000_8000 31.3.3.6/31-22 */
	{.name = "UCR4_5",           .type = REG_MMIO_32, .offset = 0x08c},
	/* UART FIFO Control Register R/W 0x0000_0801 31.3.3.7/31-23 */
	{.name = "UFCR5",            .type = REG_MMIO_32, .offset = 0x090},
	/* UART Status Register 1 R/W 0x0000_2040 31.3.3.8/31-25 */
	{.name = "USR1_5",           .type = REG_MMIO_32, .offset = 0x094},
	/* UART Status Register 2 R/W 0x0000_4028 31.3.3.9/31-27 */
	{.name = "USR2_5",           .type = REG_MMIO_32, .offset = 0x098},
	/* UART Escape Character Register R/W 0x0000_002B 31.3.3.10/31-29 */
	{.name = "UESC5",            .type = REG_MMIO_32, .offset = 0x09c},
	/* UART Escape Timer Register R/W 0x0000_0000 31.3.3.11/31-30 */
	{.name = "UTIM5",            .type = REG_MMIO_32, .offset = 0x0a0},
	/* UART BRM Incremental Register R/W 0x0000_0000 31.3.3.12/31-31 */
	{.name = "UBIR5",            .type = REG_MMIO_32, .offset = 0x0a4},
	/* UART BRM Modulator Register R/W 0x0000_0000 31.3.3.13/31-32 */
	{.name = "UBMR5",            .type = REG_MMIO_32, .offset = 0x0a8},
	/* UART Baud Rate Count Register R 0x0000_0004 31.3.3.14/31-33 */
	{.name = "UBRC5",            .type = REG_MMIO_32, .offset = 0x0ac},
	/* UART One Millisecond Register R/W 0x0000_0000 31.3.3.15/31-34 */
	{.name = "ONEMS5",           .type = REG_MMIO_32, .offset = 0x0b0},
	/* UART Test Register R/W 0x0000_0060 31.3.3.16/31-35 */
	{.name = "UTS5",             .type = REG_MMIO_32, .offset = 0x0b4},
	{NULL}
};

static regproc_reg_t mx31_usbotg[] = {
	/* OTG ID (UOG_ID) R 0x0000_0000 */
	{.name = "ID",               .type = REG_MMIO_32, .offset = 0x000},
	/* OTG Hardware General (UOG_HWGENERAL) R 0x0000_0000 */
	{.name = "HWGENERAL",        .type = REG_MMIO_32, .offset = 0x004},
	/* OTG Host Hardware Parameters (UOG_HWHOST) R 0x0000_0000 */
	{.name = "HWHOST",           .type = REG_MMIO_32, .offset = 0x008},
	/* OTG TX Buffer Hardware Parameters (UOG_HWTXBUF) R 0x0000_0000 */
	{.name = "HWTXBUF",          .type = REG_MMIO_32, .offset = 0x010},
	/* OTG RX Buffer Hardware Parameters (UOG_HWRXBUF) R 0x0000_0000 */
	{.name = "HWRXBUF",          .type = REG_MMIO_32, .offset = 0x014},
	/* OTG Capability Register Length (UOG_CAPLENGTH) R 0x40 */
	{.name = "CAPLENGTH",        .type = REG_MMIO_8,  .offset = 0x100},
	/* OTG Host Interface Version (UOG_HCIVERSION) R 0x0000 */
	{.name = "HCIVERSION",       .type = REG_MMIO_16, .offset = 0x102},
	/* OTG Host Control Structural Parameters (UOG_HCSPARAMS) R 0x0000_0000 */
	{.name = "HCSPARAMS",        .type = REG_MMIO_32, .offset = 0x104},
	/* OTG Control Capability Parameters (UOG_HCCPARAMS) R 0x0000_0000 */
	{.name = "HCCPARAMS",        .type = REG_MMIO_32, .offset = 0x108},
	/* OTG Device Interface Version (UOG_DCIVERSION) R 0x0000 */
	{.name = "DCIVERSION",       .type = REG_MMIO_16, .offset = 0x120},
	/* OTG Device Controller Capability Parameters (UOG_DCCPARAMS) R 0x0000_0000 */
	{.name = "DCCPARAMS",        .type = REG_MMIO_32, .offset = 0x124},
	/* OTG USB Command Register (UOG_USBCMD) RW 0x0000_0000 */
	{.name = "USBCMD",           .type = REG_MMIO_32, .offset = 0x140},
	/* OTG USB Status Register (UOG_USBSTS) RW 0x0000_0000 */
	{.name = "USBSTS",           .type = REG_MMIO_32, .offset = 0x144},
	/* OTG Interrupt Enable Register (UOG_USBINTR) RW 0x0000_0000 */
	{.name = "USBINTR",          .type = REG_MMIO_32, .offset = 0x148},
	/* OTG USB Frame Index (UOG_FRINDEX) RW - */
	{.name = "FRINDEX",          .type = REG_MMIO_32, .offset = 0x14c},
	/* OTG Host Controller Frame List Base Address (UOG_PERIODICLISTBASE) RW (32-bit only) 0x0000_0000 */
	{.name = "PERIODICLISTBASE", .type = REG_MMIO_32, .offset = 0x154},
	/* OTG Host Controller Next Asynch. Address (UOG_ASYNCLISTADDR) RW (32-bit only) 0x0000_0000 */
	{.name = "ASYNCLISTADDR",    .type = REG_MMIO_32, .offset = 0x158},
	/* OTG Host Controller Embedded TT Asynch. Buffer Status (UOG_BURSTSIZE) RW (32-bit only) 0x0000_0000 */
	{.name = "BURSTSIZE",        .type = REG_MMIO_32, .offset = 0x160},
	/* OTG TX FIFO Fill Tuning (UOG_TXFILLTUNING) RW (32-bit only) 0x0000_0000 */
	{.name = "TXFILLTUNING",     .type = REG_MMIO_32, .offset = 0x164},
	/* OTG ULPI Viewport (ULPIVIEW) RW 0x0000_0000 */
	{.name = "ULPI",             .type = REG_MMIO_32, .offset = 0x170},
	/* OTG Port Status and Control (UOG_PORTSC1) RW 0x0000_0000 */
	{.name = "PORTSCx",          .type = REG_MMIO_32, .offset = 0x184},
	/* Status and control (UOG_OTGSC) RW 0x0000_0000 */
	{.name = "OTGSC",            .type = REG_MMIO_32, .offset = 0x1a4},
	/* OTG USB Device Mode (UOG_USBMODE) RW 0x0000_0000 */
	{.name = "USBMODE",          .type = REG_MMIO_32, .offset = 0x1a8},
	/* OTG Endpoint Setup Status (UOG_ENDPTSETUPSTAT) RW 0x0000_0000 */
	{.name = "ENPTSETUPSTAT",    .type = REG_MMIO_32, .offset = 0x1ac},
	/* OTG Endpoint Initialization (UOG_ENDPTPRIME) RW 0x0000_0000 */
	{.name = "ENDPTPRIME",       .type = REG_MMIO_32, .offset = 0x1b0},
	/* (UOG_ENDPTFLUSH) RW 0x0000_0000 */
	{.name = "ENDPTFLUSH",       .type = REG_MMIO_32, .offset = 0x1b4},
	/* OTG Endpoint Status (UOG_ENDPTSTAT) R 0x0000_0000 */
	{.name = "ENDPTSTAT",        .type = REG_MMIO_32, .offset = 0x1b8},
	/* OTG Endpoint Complete (UOG_ENDPTCOMPLETE) RW 0x0000_0000 */
	{.name = "ENDPTCOMPLETE",    .type = REG_MMIO_32, .offset = 0x1bc},
	/* OTG Endpoint Control0 (ENDPTCTRL0) RW 0x0000_0000 */
	{.name = "ENDPTCTRL0",       .type = REG_MMIO_32, .offset = 0x1c0},
	/* OTG Endpoint Control1 (ENDPTCTRL1) RW 0x0000_0000 */
	{.name = "ENDPTCTRL1",       .type = REG_MMIO_32, .offset = 0x1c4},
	/* OTG Endpoint Control2 (ENDPTCTRL2) RW 0x0000_0000 */
	{.name = "ENDPTCTRL2",       .type = REG_MMIO_32, .offset = 0x1c8},
	/* OTG Endpoint Control3 (ENDPTCTRL3) RW 0x0000_0000 */
	{.name = "ENDPTCTRL3",       .type = REG_MMIO_32, .offset = 0x1cc},
	/* OTG Endpoint Control4 (ENDPTCTRL4) RW 0x0000_0000 */
	{.name = "ENDPTCTRL4",       .type = REG_MMIO_32, .offset = 0x1d0},
	/* OTG Endpoint Control5 (ENDPTCTRL5) RW 0x0000_0000 */
	{.name = "ENDPTCTRL5",       .type = REG_MMIO_32, .offset = 0x1d4},
	/* OTG Endpoint Control6 (ENDPTCTRL6) RW 0x0000_0000 */
	{.name = "ENDPTCTRL6",       .type = REG_MMIO_32, .offset = 0x1d8},
	/* OTG Endpoint Control7 (ENDPTCTRL7) RW 0x0000_0000 */
	{.name = "ENDPTCTRL7",       .type = REG_MMIO_32, .offset = 0x1dc},
	/* OTG Endpoint Control8 (ENDPTCTRL8) RW 0x0000_0000 */
	{.name = "ENDPTCTRL8",       .type = REG_MMIO_32, .offset = 0x1e0},
	/* OTG Endpoint Control9 (ENDPTCTRL9) RW 0x0000_0000 */
	{.name = "ENDPTCTRL9",       .type = REG_MMIO_32, .offset = 0x1e4},
	/* OTG Endpoint Control10 (ENDPTCTRL10) RW 0x0000_0000 */
	{.name = "ENDPTCTRL10",      .type = REG_MMIO_32, .offset = 0x1e8},
	/* OTG Endpoint Control11 (ENDPTCTRL11) RW 0x0000_0000 */
	{.name = "ENDPTCTRL11",      .type = REG_MMIO_32, .offset = 0x1ec},
	/* OTG Endpoint Control12 (ENDPTCTRL12) RW 0x0000_0000 */
	{.name = "ENDPTCTRL12",      .type = REG_MMIO_32, .offset = 0x1f0},
	/* OTG Endpoint Control13 (ENDPTCTRL13) RW 0x0000_0000 */
	{.name = "ENDPTCTRL13",      .type = REG_MMIO_32, .offset = 0x1f4},
	/* OTG Endpoint Control14 (ENDPTCTRL14) RW 0x0000_0000 */
	{.name = "ENDPTCTRL14",      .type = REG_MMIO_32, .offset = 0x1f8},
	/* OTG Endpoint Control15 (ENDPTCTRL15) RW 0x0000_0000 */
	{.name = "ENDPTCTRL15",      .type = REG_MMIO_32, .offset = 0x1fc},
	/* ULPI Viewport */
	{.name = "ULPIVIEW",         .type = REG_MMIO_32, .offset = 0x570},
	/* USB Control Register */
	{.name = "USB_CTRL",         .type = REG_MMIO_32, .offset = 0x600},
	/* USB OTG Mirror Register */
	{.name = "USB_OTG_MIRROR",   .type = REG_MMIO_8,  .offset = 0x604},
	{NULL}
};

static regproc_reg_t mx31_usbhost1[] = {
	/* Host 1 ID */
	{.name = "UH1_ID",           .type = REG_MMIO_32, .offset = 0x200},
	/* Hardware General */
	{.name = "UH1_HWGENERAL",    .type = REG_MMIO_32, .offset = 0x204},
	/* Host Hardware Parameters */
	{.name = "UH1_HWHOST",       .type = REG_MMIO_32, .offset = 0x208},
	/* TX Buffer Hardware Parameters */
	{.name = "UH1_HWTXBUF",      .type = REG_MMIO_32, .offset = 0x210},
	/* RX Buffer Hardware Parameters */
	{.name = "UH1_HWRXBUF",      .type = REG_MMIO_32, .offset = 0x214},
	/* Capability Register Length */
	{.name = "UH1_CAPLENGTH",    .type = REG_MMIO_8,  .offset = 0x300},
	/* Host Interface Version */
	{.name = "UH1_HCIVERSION",   .type = REG_MMIO_16, .offset = 0x302},
	/* Host Control Structural Parameters */
	{.name = "UH1_HCSPARAMS",    .type = REG_MMIO_32, .offset = 0x304},
	/* Control Capability Parameters */
	{.name = "UH1_HCCPARAMS",    .type = REG_MMIO_32, .offset = 0x308},
	/* USB Command Register */
	{.name = "UH1_USBCMD",       .type = REG_MMIO_32, .offset = 0x340},
	/* USB Status Register */
	{.name = "UH1_USBSTS",       .type = REG_MMIO_32, .offset = 0x344},
	/* Interrupt Enable Register */
	{.name = "UH1_USBINTR",      .type = REG_MMIO_32, .offset = 0x348},
	/* USB Frame Index */
	{.name = "UH1_FRINDEX",      .type = REG_MMIO_32, .offset = 0x34c},
	/* Host Controller Frame List BaseAddress */
	{.name = "UH1_PERIODICLISTBASE",.type = REG_MMIO_32, .offset = 0x354},
	/* Host Controller Next Asynch. Address */
	{.name = "UH1_ASYNCLISTADDR",.type = REG_MMIO_32, .offset = 0x358},
	/* Host Controller Embedded TTAsynch. Buffer Status */
	{.name = "UH1_BURSTSIZE",    .type = REG_MMIO_32, .offset = 0x360},
	/* TX FIFO Fill Tuning */
	{.name = "UH1_TXFILLTUNING", .type = REG_MMIO_32, .offset = 0x364},
	/* Port Status and Control */
	{.name = "UH1_PORTSC1",      .type = REG_MMIO_32, .offset = 0x384},
	/* USB Device Mode */
	{.name = "UH1_USBMODE",      .type = REG_MMIO_32, .offset = 0x3a8},
	{NULL}
};

static regproc_reg_t mx31_usbhost2[] = {
	/* Host 2 ID */
	{.name = "UH2_ID",           .type = REG_MMIO_32, .offset = 0x400},
	/* Hardware General */
	{.name = "UH2_HWGENERAL",    .type = REG_MMIO_32, .offset = 0x404},
	/* Host Hardware Parameters */
	{.name = "UH2_HWHOST",       .type = REG_MMIO_32, .offset = 0x408},
	/* TX Buffer Hardware Parameters */
	{.name = "UH2_HWTXBUF",      .type = REG_MMIO_32, .offset = 0x410},
	/* RX Buffer Hardware Parameters */
	{.name = "UH2_HWRXBUF",      .type = REG_MMIO_32, .offset = 0x414},
	/* Capability Register Length */
	{.name = "UH2_CAPLENGTH",    .type = REG_MMIO_8,  .offset = 0x500},
	/* Host Interface Version */
	{.name = "UH2_HCIVERSION",   .type = REG_MMIO_16, .offset = 0x502},
	/* Host Control Structural Parameters */
	{.name = "UH2_HCSPARAMS",    .type = REG_MMIO_32, .offset = 0x504},
	/* Control Capability Parameters */
	{.name = "UH2_HCCPARAMS",    .type = REG_MMIO_32, .offset = 0x508},
	/* USB Command Register */
	{.name = "UH2_USBCMD",       .type = REG_MMIO_32, .offset = 0x540},
	/* USB Status Register */
	{.name = "UH2_USBSTS",       .type = REG_MMIO_32, .offset = 0x544},
	/* Interrupt Enable Register */
	{.name = "UH2_USBINTR",      .type = REG_MMIO_32, .offset = 0x548},
	/* USB Frame Index */
	{.name = "UH2_FRINDEX",      .type = REG_MMIO_32, .offset = 0x54c},
	/* Host Controller Frame List BaseAddress */
	{.name = "UH2_PERIODICLISTBASE",.type = REG_MMIO_32, .offset = 0x554},
	/* Host Controller Next Asynch. Address */
	{.name = "UH2_ASYNCLISTADDR",.type = REG_MMIO_32, .offset = 0x558},
	/* Host Controller Embedded TTAsynch. Buffer Status */
	{.name = "UH2_BURSTSIZE",    .type = REG_MMIO_32, .offset = 0x560},
	/* TX FIFO Fill Tuning */
	{.name = "UH2_TXFILLTUNING", .type = REG_MMIO_32, .offset = 0x564},
	/* Port Status and Control */
	{.name = "UH2_PORTSC1",      .type = REG_MMIO_32, .offset = 0x584},
	/* USB Device Mode */
	{.name = "UH2_USBMODE",      .type = REG_MMIO_32, .offset = 0x5a8},
	{NULL}
};

static regproc_reg_t mx31_epit1[] = {
	/* EPIT Control Register R/W 0x0000_0000 33.5.2.1/33-7 */
	{.name = "EPITCR1",          .type = REG_MMIO_32, .offset = 0x000},
	/* EPIT Status Register R/W 0x0000_0000 33.5.2.2/33-10 */
	{.name = "EPITSR1",          .type = REG_MMIO_32, .offset = 0x004},
	/* EPIT Load Register R/W 0xFFFF_FFFF 33.5.2.3/33-10 */
	{.name = "EPITLR1",          .type = REG_MMIO_32, .offset = 0x008},
	/* EPIT Compare Register R/W 0x0000_0000 33.5.2.4/33-11 */
	{.name = "EPITCMPR1",        .type = REG_MMIO_32, .offset = 0x00c},
	/* EPIT Counter Register R 0x0000_0000 33.5.2.5/33-12 */
	{.name = "EPITCNT1",         .type = REG_MMIO_32, .offset = 0x010},
	{NULL}
};

static regproc_reg_t mx31_epit2[] = {
	/* EPIT Control Register R/W 0x0000_0000 33.5.2.1/33-7 */
	{.name = "EPITCR2",          .type = REG_MMIO_32, .offset = 0x000},
	/* EPIT Status Register R/W 0x0000_0000 33.5.2.2/33-10 */
	{.name = "EPITSR2",          .type = REG_MMIO_32, .offset = 0x004},
	/* EPIT Load Register R/W 0xFFFF_FFFF 33.5.2.3/33-10 */
	{.name = "EPITLR2",          .type = REG_MMIO_32, .offset = 0x008},
	/* EPIT Compare Register R/W 0x0000_0000 33.5.2.4/33-11 */
	{.name = "EPITCMPR2",        .type = REG_MMIO_32, .offset = 0x00c},
	/* EPIT Counter Register R 0x0000_0000 33.5.2.5/33-12 */
	{.name = "EPITCNT2",         .type = REG_MMIO_32, .offset = 0x010},
	{NULL}
};

static regproc_reg_t mx31_gpt[] = {
	/* GPT Control Register (GPTCR) R/W 0x0000_0000 34.3.3.1/34-10 */
	{.name = "GPTCR",            .type = REG_MMIO_32, .offset = 0x000},
	/* GPT Prescaler Register (GPTPR) R/W 0x0000_0000 34.3.3.2/34-14 */
	{.name = "GPTPR",            .type = REG_MMIO_32, .offset = 0x004},
	/* GPT Status Register (GPTSR) R/W 0x0000_0000 34.3.3.3/34-14 */
	{.name = "GPTSR",            .type = REG_MMIO_32, .offset = 0x008},
	/* GPT Interrupt Register (GPTIR) R/W 0x0000_0000 34.3.3.4/34-15 */
	{.name = "GPTIR",            .type = REG_MMIO_32, .offset = 0x00c},
	/* GPT Output Compare Register 1 (GPTOCR1) R/W 0xFFFF_FFFF 34.3.3.5/34-16 */
	{.name = "GPTOCR1",          .type = REG_MMIO_32, .offset = 0x010},
	/* GPT Output Compare Register 2 (GPTOCR2) R/W 0xFFFF_FFFF 34.3.3.6/34-17 */
	{.name = "GPTOCR2",          .type = REG_MMIO_32, .offset = 0x014},
	/* GPT Output Compare Register 3 (GPTOCR3) R/W 0xFFFF_FFFF 34.3.3.7/34-18 */
	{.name = "GPTOCR3",          .type = REG_MMIO_32, .offset = 0x018},
	/* GPT Input Capture Register 1 (GPTICR1) R 0x0000_0000 34.3.3.8/34-18 */
	{.name = "GPTICR1",          .type = REG_MMIO_32, .offset = 0x01c},
	/* GPT Counter Register (GPTCNT) R 0x0000_0000 34.3.3.10/34-20 */
	{.name = "GPTCNT",           .type = REG_MMIO_32, .offset = 0x024},
	{NULL}
};

static regproc_reg_t mx31_pwm[] = {
	/* PWM Control Register (PWMCR) R/W 0x0000_0000 35.3.2.1/35-7 */
	{.name = "PWMCR",            .type = REG_MMIO_32, .offset = 0x000},
	/* PWM Status Register (PWMSR) R/W 0x0000_0008 35.3.2.2/35-9 */
	{.name = "PWMSR",            .type = REG_MMIO_32, .offset = 0x004},
	/* PWM Interrupt Register (PWMIR) R/W 0x0000_0000 35.3.2.3/35-11 */
	{.name = "PWMIR",            .type = REG_MMIO_32, .offset = 0x008},
	/* PWM Sample Register (PWMSAR) R/W 0x0000_0000 35.3.2.4/35-11 */
	{.name = "PWMSAR",           .type = REG_MMIO_32, .offset = 0x00c},
	/* PWM Period Register (PWMPR) R/W 0x0000_FFFE 35.3.2.5/35-12 */
	{.name = "PWMPR",            .type = REG_MMIO_32, .offset = 0x010},
	/* PWM Counter Register (PWMCNR) R 0x0000_0000 35.3.2.6/35-13 */
	{.name = "PWMCNR",           .type = REG_MMIO_32, .offset = 0x014},
	{NULL}
};

static regproc_reg_t mx31_rtc[] = {
	/* RTC Hours and Minutes Counter Register (HOURMIN) R/W 0x0000_.... 36.3.3.1/36-6 */
	{.name = "HOURMIN",          .type = REG_MMIO_32, .offset = 0x000},
	/* RTC Seconds Counter Register (SECONDS) R/W 0x0000_00.. 36.3.3.2/36-7 */
	{.name = "SECONDS",          .type = REG_MMIO_32, .offset = 0x004},
	/* RTC Hours and Minutes Alarm Register (ALRM_HM) R/W 0x0000_0000 36.3.3.3/36-7 */
	{.name = "ALRM_HM",          .type = REG_MMIO_32, .offset = 0x008},
	/* RTC Seconds Alarm Register (ALRM_SEC) R/W 0x0000_0000 36.3.3.4/36-8 */
	{.name = "ALRM_SEC",         .type = REG_MMIO_32, .offset = 0x00c},
	/* RTC Control Register (RCCTL) R/W 0x0000_0080 36.3.3.5/36-9 */
	{.name = "RTCCTL",           .type = REG_MMIO_32, .offset = 0x010},
	/* RTC Interrupt Status Register (RTCISR) R/W 0x0000_0000 36.3.3.6/36-10 */
	{.name = "RTCISR",           .type = REG_MMIO_32, .offset = 0x014},
	/* RTC Interrupt Enable Register (RTCIENR) R/W 0x0000_0000 36.3.3.7/36-12 */
	{.name = "RTCIENR",          .type = REG_MMIO_32, .offset = 0x018},
	/* Stopwatch Minutes Register (STPWCH) R/W 0x0000_0000 36.3.3.8/36-14 */
	{.name = "STPWCH",           .type = REG_MMIO_32, .offset = 0x01c},
	/* RTC Days Counter Register (DAYR) R/W 0x0000_.... 36.3.3.9/36-15 */
	{.name = "DAYR",             .type = REG_MMIO_32, .offset = 0x020},
	/* RTC Days Alarm Register (DAYALARM) R/W 0x0000_0000 36.3.3.10/36-16 */
	{.name = "DAYALARM",         .type = REG_MMIO_32, .offset = 0x024},
	{NULL}
};

static regproc_reg_t mx31_wdog[] = {
	/* Watchdog Control Register R/W 0x0030 37.4.1/37-5 */
	{.name = "WCR",              .type = REG_MMIO_16, .offset = 0x000},
	/* Watchdog Status Register R/W 0x0010 37.4.2/37-6 */
	{.name = "WSR",              .type = REG_MMIO_16, .offset = 0x002},
	/* Watchdog Reset Status Register R 0x00.. 37.5.6/37-10 */
	{.name = "WRSR",             .type = REG_MMIO_16, .offset = 0x004},
	{NULL}
};

static regproc_reg_t mx31_aips_a[] = {
	/* Master Privilege Register 1 R/W Undefined 38.3.3.1/38-24 */
	{.name = "MPR_1",            .type = REG_MMIO_32, .offset = 0x000},
	/* Master Privilege Register 2 R/W Undefined 38.3.3.1/38-24 */
	{.name = "MPR_2",            .type = REG_MMIO_32, .offset = 0x004},
	/* Peripheral Access Control Register 1 R/W 0x5444_4444 38.3.3.2/38-26 */
	{.name = "PACR_1",           .type = REG_MMIO_32, .offset = 0x020},
	/* Peripheral Access Control Register 2 R/W 0x4444_4444 38.3.3.2/38-26 */
	{.name = "PACR_2",           .type = REG_MMIO_32, .offset = 0x024},
	/* Peripheral Access Control Register 3 R/W 0x4444_4444 38.3.3.2/38-26 */
	{.name = "PACR_3",           .type = REG_MMIO_32, .offset = 0x028},
	/* Peripheral Access Control Register 4 R/W 0x4444_4444 38.3.3.2/38-26 */
	{.name = "PACR_4",           .type = REG_MMIO_32, .offset = 0x02c},
	/* Off-Platform Peripheral Access Control Register 1 R/W 0x5444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_1",          .type = REG_MMIO_32, .offset = 0x040},
	/* Off-Platform Peripheral Access Control Register 2 R/W 0x4444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_2",          .type = REG_MMIO_32, .offset = 0x044},
	/* Off-Platform Peripheral Access Control Register 3 R/W 0x4444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_3",          .type = REG_MMIO_32, .offset = 0x048},
	/* Off-Platform Peripheral Access Control Register 4 R/W 0x4444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_4",          .type = REG_MMIO_32, .offset = 0x04c},
	/* Off-Platform Peripheral Access Control Register 5 R/W 0x4444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_5",          .type = REG_MMIO_32, .offset = 0x050},
	{NULL}
};

static regproc_reg_t mx31_aips_b[] = {
	/* Master Privilege Register 1 R/W Undefined 38.3.3.1/38-24 */
	{.name = "MPR_1",            .type = REG_MMIO_32, .offset = 0x000},
	/* Master Privilege Register 2 R/W Undefined 38.3.3.1/38-24 */
	{.name = "MPR_2",            .type = REG_MMIO_32, .offset = 0x004},
	/* Peripheral Access Control Register 1 R/W 0x5444_4444 38.3.3.2/38-26 */
	{.name = "PACR_1",           .type = REG_MMIO_32, .offset = 0x020},
	/* Peripheral Access Control Register 2 R/W 0x4444_4444 38.3.3.2/38-26 */
	{.name = "PACR_2",           .type = REG_MMIO_32, .offset = 0x024},
	/* Peripheral Access Control Register 3 R/W 0x4444_4444 38.3.3.2/38-26 */
	{.name = "PACR_3",           .type = REG_MMIO_32, .offset = 0x028},
	/* Peripheral Access Control Register 4 R/W 0x4444_4444 38.3.3.2/38-26 */
	{.name = "PACR_4",           .type = REG_MMIO_32, .offset = 0x02c},
	/* Off-Platform Peripheral Access Control Register 1 R/W 0x5444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_1",          .type = REG_MMIO_32, .offset = 0x040},
	/* Off-Platform Peripheral Access Control Register 2 R/W 0x4444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_2",          .type = REG_MMIO_32, .offset = 0x044},
	/* Off-Platform Peripheral Access Control Register 3 R/W 0x4444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_3",          .type = REG_MMIO_32, .offset = 0x048},
	/* Off-Platform Peripheral Access Control Register 4 R/W 0x4444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_4",          .type = REG_MMIO_32, .offset = 0x04c},
	/* Off-Platform Peripheral Access Control Register 5 R/W 0x4444_4444 38.3.3.3/38-29 */
	{.name = "OPACR_5",          .type = REG_MMIO_32, .offset = 0x050},
	{NULL}
};

static regproc_reg_t mx31_max[] = {
	/* Master Priority Register for Slave port 0 R/W 0x0054_3210 39.3.3.1/39-14 */
	{.name = "MPR0",             .type = REG_MMIO_32, .offset = 0x000},
	/* General Purpose Control Register for Slave port 0 R/W 0x0000_0000 39.3.3.2/39-15 */
	{.name = "SGPCR0",           .type = REG_MMIO_32, .offset = 0x010},
	/* Master Priority Register for Slave port 1 R/W 0x0054_3210 39.3.3.1/39-14 */
	{.name = "MPR1",             .type = REG_MMIO_32, .offset = 0x100},
	/* General Purpose Control Register for Slave port 1 R/W 0x0000_0000 39.3.3.2/39-15 */
	{.name = "SGPCR1",           .type = REG_MMIO_32, .offset = 0x110},
	/* Master Priority Register for Slave port 2 R/W 0x0054_3210 39.3.3.1/39-14 */
	{.name = "MPR2",             .type = REG_MMIO_32, .offset = 0x200},
	/* General Purpose Control Register for Slave port 2 R/W 0x0000_0000 39.3.3.2/39-15 */
	{.name = "SGPCR2",           .type = REG_MMIO_32, .offset = 0x210},
	/* Master Priority Register for Slave port 3 R/W 0x0054_3210 39.3.3.1/39-14 */
	{.name = "MPR3",             .type = REG_MMIO_32, .offset = 0x300},
	/* General Purpose Control Register for Slave port 3 R/W 0x0000_0000 39.3.3.2/39-15 */
	{.name = "SGPCR3",           .type = REG_MMIO_32, .offset = 0x310},
	/* Master Priority Register for Slave port 4 R/W 0x0054_3210 39.3.3.1/39-14 */
	{.name = "MPR4",             .type = REG_MMIO_32, .offset = 0x400},
	/* General Purpose Control Register for Slave port 4 R/W 0x0000_0000 39.3.3.2/39-15 */
	{.name = "SGPCR4",           .type = REG_MMIO_32, .offset = 0x410},
	/* General Purpose Control Register for Master port 0 R/W 0x0000_0000 39.3.3.3/39-17 */
	{.name = "MGPCR0",           .type = REG_MMIO_32, .offset = 0x800},
	/* General Purpose Control Register for Master port 1 R/W 0x0000_0000 39.3.3.3/39-17 */
	{.name = "MGPCR1",           .type = REG_MMIO_32, .offset = 0x900},
	/* General Purpose Control Register for Master port 2 R/W 0x0000_0000 39.3.3.3/39-17 */
	{.name = "MGPCR2",           .type = REG_MMIO_32, .offset = 0xa00},
	/* General Purpose Control Register for Master port 3 R/W 0x0000_0000 39.3.3.3/39-17 */
	{.name = "MGPCR3",           .type = REG_MMIO_32, .offset = 0xb00},
	/* General Purpose Control Register for Master port 4 R/W 0x0000_0000 39.3.3.3/39-17 */
	{.name = "MGPCR4",           .type = REG_MMIO_32, .offset = 0xc00},
	/* General Purpose Control Register for Master port 5 R/W 0x0000_0000 39.3.3.3/39-17 */
	{.name = "MGPCR5",           .type = REG_MMIO_32, .offset = 0xd00},
	{NULL}
};

static regproc_reg_t mx31_sdma_ap[] = {
	/* AP (MCU) Channel 0 Pointer R/W 0x0000_0000 40.10.3.1/40-43 */
	{.name = "MC0PTR",           .type = REG_MMIO_32, .offset = 0x000},
	/* Channel Interrupts R/W 0x0000_0000 40.10.3.2/40-44 */
	{.name = "INTR",             .type = REG_MMIO_32, .offset = 0x004},
	/* Channel Stop/Channel Status R 0x0000_0000 40.10.3.3/40-44 */
	{.name = "STOP_STAT",        .type = REG_MMIO_32, .offset = 0x008},
	/* Channel Start R/W 0x0000_0000 40.10.3.4/40-45 */
	{.name = "HSTART",           .type = REG_MMIO_32, .offset = 0x00c},
	/* Channel Event Override R/W 0x0000_0000 40.10.3.5/40-46 */
	{.name = "EVTOVR",           .type = REG_MMIO_32, .offset = 0x010},
	/* Channel DSP(BP) Override R/W 0xFFFF_FFFF 40.10.3.6/40-46 */
	{.name = "DSPOVR",           .type = REG_MMIO_32, .offset = 0x014},
	/* Channel AP Override R/W 0x0000_0000 40.10.3.7/40-47 */
	{.name = "HOSTOVR",          .type = REG_MMIO_32, .offset = 0x018},
	/* Channel Event Pending R 0x0000_0000 40.10.3.8/40-48 */
	{.name = "EVTPEND",          .type = REG_MMIO_32, .offset = 0x01c},
	/* Reset Register R 0x0000_0000 40.10.3.9/40-48 */
	{.name = "RESET",            .type = REG_MMIO_32, .offset = 0x024},
	/* DMA Request Error Register R 40.10.3.10/40-49 */
	{.name = "EVTERR",           .type = REG_MMIO_32, .offset = 0x028},
	/* Channel AP Interrupt Mask R/W 40.10.3.11/40-50 */
	{.name = "INTRMASK",         .type = REG_MMIO_32, .offset = 0x02c},
	/* Schedule Status R 0x0000_0000 40.10.3.12/40-51 */
	{.name = "PSW",              .type = REG_MMIO_32, .offset = 0x030},
	/* DMA Request Error Register R 0x0000_0000 40.10.3.13/40-52 */
	{.name = "EVTERRDBG",        .type = REG_MMIO_32, .offset = 0x034},
	/* Configuration Register R/W 0x0000_0003 40.10.3.14/40-53 */
	{.name = "CONFIG",           .type = REG_MMIO_32, .offset = 0x038},
	/* OnCE Enable R/W 0x0000_0000 40.10.3.15/40-54 */
	{.name = "ONCE_ENB",         .type = REG_MMIO_32, .offset = 0x040},
	/* OnCE Data Register R/W 0x0000_0000 40.10.3.16/40-54 */
	{.name = "ONCE_DATA",        .type = REG_MMIO_32, .offset = 0x044},
	/* OnCE Instruction Register R/W 0x0000_0000 40.10.3.17/40-55 */
	{.name = "ONCE_INSTR",       .type = REG_MMIO_32, .offset = 0x048},
	/* OnCE Status Register R 0x0000_E000 40.10.3.18/40-56 */
	{.name = "ONCE_STAT",        .type = REG_MMIO_32, .offset = 0x04c},
	/* OnCE Command Register R/W 0x0000_0000 40.10.3.19/40-58 */
	{.name = "ONCE_CMD",         .type = REG_MMIO_32, .offset = 0x050},
	/* DMA Requests R 0x0000_0000 40.10.3.22/40-60 */
	{.name = "EVT_MIRROR",       .type = REG_MMIO_32, .offset = 0x054},
	/* Illegal Instruction Trap Address R/W 0x0000_0001 40.10.3.20/40-59 */
	{.name = "ILLINSTADDR",      .type = REG_MMIO_32, .offset = 0x058},
	/* Channel 0 Boot Address R/W 0x0000_0050 40.10.3.21/40-59 */
	{.name = "CHN0ADDR",         .type = REG_MMIO_32, .offset = 0x05c},
	/* Cross-Trigger Events Configuration Register 1 R/W 0x0000_0000 40.10.3.23/40-61 */
	{.name = "XTRIG_CONF1",      .type = REG_MMIO_32, .offset = 0x070},
	/* Cross-Trigger Events Configuration Register 2 R/W 0x0000_0000 40.10.3.23/40-61 */
	{.name = "XTRIG_CONF2",      .type = REG_MMIO_32, .offset = 0x074},
	/* Channel Priority Register 0 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI0",          .type = REG_MMIO_32, .offset = 0x100},
	/* Channel Priority Register 1 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI1",          .type = REG_MMIO_32, .offset = 0x104},
	/* Channel Priority Register 2 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI2",          .type = REG_MMIO_32, .offset = 0x108},
	/* Channel Priority Register 3 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI3",          .type = REG_MMIO_32, .offset = 0x10c},
	/* Channel Priority Register 4 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI4",          .type = REG_MMIO_32, .offset = 0x110},
	/* Channel Priority Register 5 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI5",          .type = REG_MMIO_32, .offset = 0x114},
	/* Channel Priority Register 6 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI6",          .type = REG_MMIO_32, .offset = 0x118},
	/* Channel Priority Register 7 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI7",          .type = REG_MMIO_32, .offset = 0x11c},
	/* Channel Priority Register 8 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI8",          .type = REG_MMIO_32, .offset = 0x120},
	/* Channel Priority Register 9 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI9",          .type = REG_MMIO_32, .offset = 0x124},
	/* Channel Priority Register 10 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI10",         .type = REG_MMIO_32, .offset = 0x128},
	/* Channel Priority Register 11 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI11",         .type = REG_MMIO_32, .offset = 0x12c},
	/* Channel Priority Register 12 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI12",         .type = REG_MMIO_32, .offset = 0x130},
	/* Channel Priority Register 13 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI13",         .type = REG_MMIO_32, .offset = 0x134},
	/* Channel Priority Register 14 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI14",         .type = REG_MMIO_32, .offset = 0x138},
	/* Channel Priority Register 15 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI15",         .type = REG_MMIO_32, .offset = 0x13c},
	/* Channel Priority Register 16 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI16",         .type = REG_MMIO_32, .offset = 0x140},
	/* Channel Priority Register 17 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI17",         .type = REG_MMIO_32, .offset = 0x144},
	/* Channel Priority Register 18 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI18",         .type = REG_MMIO_32, .offset = 0x148},
	/* Channel Priority Register 19 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI19",         .type = REG_MMIO_32, .offset = 0x14c},
	/* Channel Priority Register 20 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI20",         .type = REG_MMIO_32, .offset = 0x150},
	/* Channel Priority Register 21 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI21",         .type = REG_MMIO_32, .offset = 0x154},
	/* Channel Priority Register 22 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI22",         .type = REG_MMIO_32, .offset = 0x158},
	/* Channel Priority Register 23 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI23",         .type = REG_MMIO_32, .offset = 0x15c},
	/* Channel Priority Register 24 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI24",         .type = REG_MMIO_32, .offset = 0x160},
	/* Channel Priority Register 25 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI25",         .type = REG_MMIO_32, .offset = 0x164},
	/* Channel Priority Register 26 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI26",         .type = REG_MMIO_32, .offset = 0x168},
	/* Channel Priority Register 27 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI27",         .type = REG_MMIO_32, .offset = 0x16c},
	/* Channel Priority Register 28 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI28",         .type = REG_MMIO_32, .offset = 0x170},
	/* Channel Priority Register 29 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI29",         .type = REG_MMIO_32, .offset = 0x174},
	/* Channel Priority Register 30 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI30",         .type = REG_MMIO_32, .offset = 0x178},
	/* Channel Priority Register 31 R/W 0x0000_0000 40.10.3.24/40-64 */
	{.name = "CHNPRI31",         .type = REG_MMIO_32, .offset = 0x17c},
	/* Channel Enable RAM 0 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL0",         .type = REG_MMIO_32, .offset = 0x080},
	/* Channel Enable RAM 1 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL1",         .type = REG_MMIO_32, .offset = 0x084},
	/* Channel Enable RAM 2 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL2",         .type = REG_MMIO_32, .offset = 0x088},
	/* Channel Enable RAM 3 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL3",         .type = REG_MMIO_32, .offset = 0x08c},
	/* Channel Enable RAM 4 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL4",         .type = REG_MMIO_32, .offset = 0x090},
	/* Channel Enable RAM 5 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL5",         .type = REG_MMIO_32, .offset = 0x094},
	/* Channel Enable RAM 6 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL6",         .type = REG_MMIO_32, .offset = 0x098},
	/* Channel Enable RAM 7 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL7",         .type = REG_MMIO_32, .offset = 0x09c},
	/* Channel Enable RAM 8 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL8",         .type = REG_MMIO_32, .offset = 0x0a0},
	/* Channel Enable RAM 9 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL9",         .type = REG_MMIO_32, .offset = 0x0a4},
	/* Channel Enable RAM 10 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL10",        .type = REG_MMIO_32, .offset = 0x0a8},
	/* Channel Enable RAM 11 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL11",        .type = REG_MMIO_32, .offset = 0x0ac},
	/* Channel Enable RAM 12 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL12",        .type = REG_MMIO_32, .offset = 0x0b0},
	/* Channel Enable RAM 13 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL13",        .type = REG_MMIO_32, .offset = 0x0b4},
	/* Channel Enable RAM 14 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL14",        .type = REG_MMIO_32, .offset = 0x0b8},
	/* Channel Enable RAM 15 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL15",        .type = REG_MMIO_32, .offset = 0x0bc},
	/* Channel Enable RAM 16 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL16",        .type = REG_MMIO_32, .offset = 0x0c0},
	/* Channel Enable RAM 17 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL17",        .type = REG_MMIO_32, .offset = 0x0c4},
	/* Channel Enable RAM 18 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL18",        .type = REG_MMIO_32, .offset = 0x0c8},
	/* Channel Enable RAM 19 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL19",        .type = REG_MMIO_32, .offset = 0x0cc},
	/* Channel Enable RAM 20 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL20",        .type = REG_MMIO_32, .offset = 0x0d0},
	/* Channel Enable RAM 21 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL21",        .type = REG_MMIO_32, .offset = 0x0d4},
	/* Channel Enable RAM 22 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL22",        .type = REG_MMIO_32, .offset = 0x0d8},
	/* Channel Enable RAM 23 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL23",        .type = REG_MMIO_32, .offset = 0x0dc},
	/* Channel Enable RAM 24 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL24",        .type = REG_MMIO_32, .offset = 0x0e0},
	/* Channel Enable RAM 25 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL25",        .type = REG_MMIO_32, .offset = 0x0e4},
	/* Channel Enable RAM 26 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL26",        .type = REG_MMIO_32, .offset = 0x0e8},
	/* Channel Enable RAM 27 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL27",        .type = REG_MMIO_32, .offset = 0x0ec},
	/* Channel Enable RAM 28 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL28",        .type = REG_MMIO_32, .offset = 0x0f0},
	/* Channel Enable RAM 29 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL29",        .type = REG_MMIO_32, .offset = 0x0f4},
	/* Channel Enable RAM 30 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL30",        .type = REG_MMIO_32, .offset = 0x0f8},
	/* Channel Enable RAM 31 R/W - 40.10.3.25/40-65 */
	{.name = "CHNENBL31",        .type = REG_MMIO_32, .offset = 0x0fc},
	{NULL}
};

static regproc_reg_t mx31_spba[] = {
	/* Peripheral Right Register SPBA_SDHC1 R/W 0x0000_0007 41.5.1/41-10 */
	{.name = "SPBA_SDHC1",       .type = REG_MMIO_32, .offset = 0x004},
	/* Peripheral Right Register SPBA_SDHC2 R/W 0x0000_0007 41.5.1/41-10 */
	{.name = "SPBA_SDHC2",       .type = REG_MMIO_32, .offset = 0x008},
	/* Peripheral Right Register SPBA_UART3 R/W 0x0000_0007 41.5.1/41-10 */
	{.name = "SPBA_UART3",       .type = REG_MMIO_32, .offset = 0x00c},
	/* Peripheral Right Register SPBA_CSPI2 R/W 0x0000_0007 41.5.1/41-10 */
	{.name = "SPBA_CSPI2",       .type = REG_MMIO_32, .offset = 0x010},
	/* Peripheral Right Register SPBA_SSI2 R/W 0x0000_0007 41.5.1/41-10 */
	{.name = "SPBA_SSI2",        .type = REG_MMIO_32, .offset = 0x014},
	/* Peripheral Right Register SPBA_SIM R/W 0x0000_0007 41.5.1/41-10 */
	{.name = "SPBA_SIM",         .type = REG_MMIO_32, .offset = 0x018},
	/* Peripheral Right Register SPBA_IIM R/W 0x0000_0007 41.5.1/41-10 */
	{.name = "SPBA_IIM",         .type = REG_MMIO_32, .offset = 0x01c},
	/* Peripheral Right Register SPBA_ATA R/W 0x0000_0007 41.5.1/41-10 */
	{.name = "SPBA_ATA",         .type = REG_MMIO_32, .offset = 0x020},
	{NULL}
};

static regproc_reg_t mx31_audmux[] = {
	/* Port Timing Control Register 1 (PTCR1) R/W 0xAD40_0800 42.3.2.1/42-30 */
	{.name = "PTCR1",            .type = REG_MMIO_32, .offset = 0x000},
	/* Port Data Control Register 1 (PDCR1) R/W 0x0000_A000 42.3.2.2/42-32 */
	{.name = "PDCR1",            .type = REG_MMIO_32, .offset = 0x004},
	/* Port Timing Control Register 2 (PTCR2) R/W 0xA500_0800 42.3.2.3/42-34 */
	{.name = "PTCR2",            .type = REG_MMIO_32, .offset = 0x008},
	/* Port Data Control Register 2 (PDCR2) R/W 0x0000_8000 42.3.2.4/42-36 */
	{.name = "PDCR2",            .type = REG_MMIO_32, .offset = 0x00c},
	/* Port Timing Control Register 3 (PTCR3) R/W 0x9CC0_0800 42.3.2.5/42-37 */
	{.name = "PTCR3",            .type = REG_MMIO_32, .offset = 0x010},
	/* Port Data Control Register 3 (PDCR3) R/W 0x0000_6000 42.3.2.6/42-39 */
	{.name = "PDCR3",            .type = REG_MMIO_32, .offset = 0x014},
	/* Port Timing Control Register 4 (PTCR4) R/W 0x0000_0800 42.3.2.7/42-41 */
	{.name = "PTCR4",            .type = REG_MMIO_32, .offset = 0x018},
	/* Port Data Control Register 4 (PDCR4) R/W 0x0000_4000 42.3.2.8/42-43 */
	{.name = "PDCR4",            .type = REG_MMIO_32, .offset = 0x01c},
	/* Port Timing Control Register 5 (PTCR5) R/W 0x0000_0800 42.3.2.9/42-44 */
	{.name = "PTCR5",            .type = REG_MMIO_32, .offset = 0x020},
	/* Port Data Control Register 5 (PDCR5) R/W 0x0000_2000 42.3.2.10/42-46 */
	{.name = "PDCR5",            .type = REG_MMIO_32, .offset = 0x024},
	/* Port Timing Control Register 6 (PTCR6) R/W 0x0000_0800 42.3.2.11/42-48 */
	{.name = "PTCR6",            .type = REG_MMIO_32, .offset = 0x028},
	/* Port Data Control Register 6 (PDCR6) R/W 0x0000_0000 42.3.2.12/42-50 */
	{.name = "PDCR6",            .type = REG_MMIO_32, .offset = 0x02c},
	/* Port Timing Control Register 7 (PTCR7) R/W 0x0000_0800 42.3.2.13/42-51 */
	{.name = "PTCR7",            .type = REG_MMIO_32, .offset = 0x030},
	/* Port Data Control Register 7 (PDCR7) R/W 0x0000_C000 42.3.2.14/42-53 */
	{.name = "PDCR7",            .type = REG_MMIO_32, .offset = 0x034},
	/* CE Bus Network Mode Control Register (CNMCR) R/W 0x0003_1010 42.3.2.15/42-55 */
	{.name = "CNMCR",            .type = REG_MMIO_32, .offset = 0x038},
	{NULL}
};

static regproc_reg_t mx31_ssi1[] = {
	/* SSI Transmit Data Register R/W 0x0000_0000 45.3.3.1/45-24 */
	{.name = "STX0_1",           .type = REG_MMIO_32, .offset = 0x000},
	/* SSI Transmit Data Register 1 R/W 0x0000_0000 45.3.3.1/45-24 */
	{.name = "STX1_1",           .type = REG_MMIO_32, .offset = 0x004},
	/* SSI Receive Data Register 0 R 0x0000_0000 45.3.3.4/45-28 */
	{.name = "SRX0_1",           .type = REG_MMIO_32, .offset = 0x008},
	/* SSI Receive Data Register 1 R 0x0000_0000 45.3.3.4/45-28 */
	{.name = "SRX1_1",           .type = REG_MMIO_32, .offset = 0x00c},
	/* SSI Control Register R/W 0x0000_0000 45.3.3.7/45-31 */
	{.name = "SCR1",             .type = REG_MMIO_32, .offset = 0x010},
	/* SSI Interrupt Status Register R 0x0000_3003 45.3.3.8/45-33 */
	{.name = "SISR1",            .type = REG_MMIO_32, .offset = 0x014},
	/* SSI Interrupt Enable Register R/W 0x0000_3003 45.3.3.9/45-37 */
	{.name = "SIER",             .type = REG_MMIO_32, .offset = 0x018},
	/* SSI Transmit Configuration Register R/W 0x0000_0200 45.3.3.10/45-39 */
	{.name = "STCR1",            .type = REG_MMIO_32, .offset = 0x01c},
	/* SSI Receive Configuration Register R/W 0x0000_0200 45.3.3.11/45-40 */
	{.name = "SRCR1",            .type = REG_MMIO_32, .offset = 0x020},
	/* SSI Transmit Clock Control Register R/W 0x0004_0000 45.3.3.12/45-42 */
	{.name = "STCCR1",           .type = REG_MMIO_32, .offset = 0x024},
	/* SSI Receive Clock Control Register R/W 0x0004_0000 45.3.3.12/45-42 */
	{.name = "SRCCR1",           .type = REG_MMIO_32, .offset = 0x028},
	/* SSI FIFO Control/Status Register R/W 0x0081_0081 45.3.3.13/45-45 */
	{.name = "SFCSR1",           .type = REG_MMIO_32, .offset = 0x02c},
	/* SSI AC97 Control Register R/W 0x0000_0000 45.3.3.14/45-48 */
	{.name = "SACNT1",           .type = REG_MMIO_32, .offset = 0x038},
	/* SSI AC97 Command Address Register R/W 0x0000_0000 45.3.3.15/45-49 */
	{.name = "SACADD1",          .type = REG_MMIO_32, .offset = 0x03c},
	/* SSI AC97 Command Data Register R/W 0x0000_0000 45.3.3.16/45-50 */
	{.name = "SACDAT1",          .type = REG_MMIO_32, .offset = 0x040},
	/* SSI AC97 Tag Register R/W 0x0000_0000 45.3.3.17/45-50 */
	{.name = "SATAG1",           .type = REG_MMIO_32, .offset = 0x044},
	/* SSI Transmit Time Slot Mask Register R/W 0x0000_0000 45.3.3.18/45-51 */
	{.name = "STMSK1",           .type = REG_MMIO_32, .offset = 0x048},
	/* SSI Receive Time Slot Mask Register R/W 0x0000_0000 45.3.3.19/45-52 */
	{.name = "SRMSK1",           .type = REG_MMIO_32, .offset = 0x04c},
	{NULL}
};

static regproc_reg_t mx31_ssi2[] = {
	/* SSI Transmit Data Register R/W 0x0000_0000 45.3.3.1/45-24 */
	{.name = "STX0_2",           .type = REG_MMIO_32, .offset = 0x000},
	/* SSI Transmit Data Register 1 R/W 0x0000_0000 45.3.3.1/45-24 */
	{.name = "STX1_2",           .type = REG_MMIO_32, .offset = 0x004},
	/* SSI Receive Data Register 0 R 0x0000_0000 45.3.3.4/45-28 */
	{.name = "SRX0_2",           .type = REG_MMIO_32, .offset = 0x008},
	/* SSI Receive Data Register 1 R 0x0000_0000 45.3.3.4/45-28 */
	{.name = "SRX1_2",           .type = REG_MMIO_32, .offset = 0x00c},
	/* SSI Control Register R/W 0x0000_0000 45.3.3.7/45-31 */
	{.name = "SCR2",             .type = REG_MMIO_32, .offset = 0x010},
	/* SSI Interrupt Status Register R 0x0000_3003 45.3.3.8/45-33 */
	{.name = "SISR2",            .type = REG_MMIO_32, .offset = 0x014},
	/* SSI Interrupt Enable Register R/W 0x0000_3003 45.3.3.9/45-37 */
	{.name = "SIER2",            .type = REG_MMIO_32, .offset = 0x018},
	/* SSI Transmit Configuration Register R/W 0x0000_0200 45.3.3.10/45-39 */
	{.name = "STCR2",            .type = REG_MMIO_32, .offset = 0x01c},
	/* SSI Receive Configuration Register R/W 0x0000_0200 45.3.3.11/45-40 */
	{.name = "SRCR2",            .type = REG_MMIO_32, .offset = 0x020},
	/* SSI Transmit Clock Control Register R/W 0x0004_0000 45.3.3.12/45-42 */
	{.name = "STCCR2",           .type = REG_MMIO_32, .offset = 0x024},
	/* SSI Receive Clock Control Register R/W 0x0004_0000 45.3.3.12/45-42 */
	{.name = "SRCCR2",           .type = REG_MMIO_32, .offset = 0x028},
	/* SSI FIFO Control/Status Register R/W 0x0081_0081 45.3.3.13/45-45 */
	{.name = "SFCSR2",           .type = REG_MMIO_32, .offset = 0x02c},
	/* SSI AC97 Control Register R/W 0x0000_0000 45.3.3.14/45-48 */
	{.name = "SACNT2",           .type = REG_MMIO_32, .offset = 0x038},
	/* SSI AC97 Command Address Register R/W 0x0000_0000 45.3.3.15/45-49 */
	{.name = "SACADD2",          .type = REG_MMIO_32, .offset = 0x03c},
	/* SSI AC97 Command Data Register R/W 0x0000_0000 45.3.3.16/45-50 */
	{.name = "SACDAT2",          .type = REG_MMIO_32, .offset = 0x040},
	/* SSI AC97 Tag Register R/W 0x0000_0000 45.3.3.17/45-50 */
	{.name = "SATAG2",           .type = REG_MMIO_32, .offset = 0x044},
	/* SSI Transmit Time Slot Mask Register R/W 0x0000_0000 45.3.3.18/45-51 */
	{.name = "STMSK2",           .type = REG_MMIO_32, .offset = 0x048},
	/* SSI Receive Time Slot Mask Register R/W 0x0000_0000 45.3.3.19/45-52 */
	{.name = "SRMSK2",           .type = REG_MMIO_32, .offset = 0x04c},
	{NULL}
};

static regproc_reg_t mx31_avic[] = {
	/* Interrupt Control Register R/W 0x0000_0000 9.2.3.1/9-9 */
	{.name = "INTCNTL",          .type = REG_MMIO_32, .offset = 0x000},
	/* Normal Interrupt Mask Register R/W 0x0000_001F 9.2.3.2/9-11 */
	{.name = "NIMASK",           .type = REG_MMIO_32, .offset = 0x004},
	/* Interrupt Enable Number Register R/W 0x0000_0000 9.2.3.3/9-12 */
	{.name = "INTENNUM",         .type = REG_MMIO_32, .offset = 0x008},
	/* Interrupt Disable Number Register R/W 0x0000_0000 9.2.3.4/9-13 */
	{.name = "INTDISNUM",        .type = REG_MMIO_32, .offset = 0x00c},
	/* Interrupt Enable Register High R/W 0x0000_0000 9.2.3.5/9-14 */
	{.name = "INTENABLEH",       .type = REG_MMIO_32, .offset = 0x010},
	/* Interrupt Enable Register Low R/W 0x0000_0000 9.2.3.5/9-14 */
	{.name = "INTENABLEL",       .type = REG_MMIO_32, .offset = 0x014},
	/* Interrupt Type Register High R/W 0x0000_0000 9.2.3.6/9-15 */
	{.name = "INTTYPEH",         .type = REG_MMIO_32, .offset = 0x018},
	/* Interrupt Type Register Low R/W 0x0000_0000 9.2.3.6/9-15 */
	{.name = "INTTYPEL",         .type = REG_MMIO_32, .offset = 0x01c},
	/* Normal Interrupt Priority Level Register 7 R/W 0x0000_0000 9.2.3.7/9-16 */
	{.name = "NIPRIORITY7",      .type = REG_MMIO_32, .offset = 0x020},
	/* Normal Interrupt Priority Level Register 6 R/W 0x0000_0000 9.2.3.7/9-16 */
	{.name = "NIPRIORITY6",      .type = REG_MMIO_32, .offset = 0x024},
	/* Normal Interrupt Priority Level Register 5 R/W 0x0000_0000 9.2.3.7/9-16 */
	{.name = "NIPRIORITY5",      .type = REG_MMIO_32, .offset = 0x028},
	/* Normal Interrupt Priority Level Register 4 R/W 0x0000_0000 9.2.3.7/9-16 */
	{.name = "NIPRIORITY4",      .type = REG_MMIO_32, .offset = 0x02c},
	/* Normal Interrupt Priority Level Register 3 R/W 0x0000_0000 9.2.3.7/9-16 */
	{.name = "NIPRIORITY3",      .type = REG_MMIO_32, .offset = 0x030},
	/* Normal Interrupt Priority Level Register 2 R/W 0x0000_0000 9.2.3.7/9-16 */
	{.name = "NIPRIORITY2",      .type = REG_MMIO_32, .offset = 0x034},
	/* Normal Interrupt Priority Level Register 1 R/W 0x0000_0000 9.2.3.7/9-16 */
	{.name = "NIPRIORITY1",      .type = REG_MMIO_32, .offset = 0x038},
	/* Normal Interrupt Priority Level Register 0 R/W 0x0000_0000 9.2.3.7/9-16 */
	{.name = "NIPRIORITY0",      .type = REG_MMIO_32, .offset = 0x03c},
	/* Normal Interrupt Vector and Status Register R 0xFFFF_FFFF 9.2.3.8/9-24 */
	{.name = "NIVECSR",          .type = REG_MMIO_32, .offset = 0x040},
	/* Fast Interrupt Vector and Status Register R 0xFFFF_FFFF 9.2.3.9/9-25 */
	{.name = "FIVECSR",          .type = REG_MMIO_32, .offset = 0x044},
	/* Interrupt Source Register High R 0x0000_0000 9.2.3.10/9-26 */
	{.name = "INTSRCH",          .type = REG_MMIO_32, .offset = 0x048},
	/* Interrupt Source Register Low R 0x0000_0000 9.2.3.10/9-26 */
	{.name = "INTSRCL",          .type = REG_MMIO_32, .offset = 0x04c},
	/* Interrupt Force Register High R/W 0x0000_0000 9.2.3.11/9-27 */
	{.name = "INTFRCH",          .type = REG_MMIO_32, .offset = 0x050},
	/* Interrupt Force Register Low R/W 0x0000_0000 9.2.3.11/9-27 */
	{.name = "INTFRCL",          .type = REG_MMIO_32, .offset = 0x054},
	/* Normal Interrupt Pending Register High R 0x0000_0000 9.2.3.12/9-28 */
	{.name = "NIPNDH",           .type = REG_MMIO_32, .offset = 0x058},
	/* Normal Interrupt Pending Register High R 0x0000_0000 9.2.3.12/9-28 */
	{.name = "NIPNDL",           .type = REG_MMIO_32, .offset = 0x05c},
	/* Fast Interrupt Pending Register High R 0x0000_0000 9.2.3.13/9-29 */
	{.name = "FIPNDH",           .type = REG_MMIO_32, .offset = 0x060},
	/* Fast Interrupt Pending Register Low R 0x0000_0000 9.2.3.13/9-29 */
	{.name = "FIPNDL",           .type = REG_MMIO_32, .offset = 0x064},
	/* Vector Register 0 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR0",          .type = REG_MMIO_32, .offset = 0x100},
	/* Vector Register 1 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR1",          .type = REG_MMIO_32, .offset = 0x104},
	/* Vector Register 2 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR2",          .type = REG_MMIO_32, .offset = 0x108},
	/* Vector Register 3 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR3",          .type = REG_MMIO_32, .offset = 0x10c},
	/* Vector Register 4 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR4",          .type = REG_MMIO_32, .offset = 0x110},
	/* Vector Register 5 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR5",          .type = REG_MMIO_32, .offset = 0x114},
	/* Vector Register 6 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR6",          .type = REG_MMIO_32, .offset = 0x118},
	/* Vector Register 7 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR7",          .type = REG_MMIO_32, .offset = 0x11c},
	/* Vector Register 8 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR8",          .type = REG_MMIO_32, .offset = 0x120},
	/* Vector Register 9 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR9",          .type = REG_MMIO_32, .offset = 0x124},
	/* Vector Register 10 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR10",         .type = REG_MMIO_32, .offset = 0x128},
	/* Vector Register 11 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR11",         .type = REG_MMIO_32, .offset = 0x12c},
	/* Vector Register 12 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR12",         .type = REG_MMIO_32, .offset = 0x130},
	/* Vector Register 13 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR13",         .type = REG_MMIO_32, .offset = 0x134},
	/* Vector Register 14 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR14",         .type = REG_MMIO_32, .offset = 0x138},
	/* Vector Register 15 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR15",         .type = REG_MMIO_32, .offset = 0x13c},
	/* Vector Register 16 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR16",         .type = REG_MMIO_32, .offset = 0x140},
	/* Vector Register 17 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR17",         .type = REG_MMIO_32, .offset = 0x144},
	/* Vector Register 18 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR18",         .type = REG_MMIO_32, .offset = 0x148},
	/* Vector Register 19 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR19",         .type = REG_MMIO_32, .offset = 0x14c},
	/* Vector Register 20 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR20",         .type = REG_MMIO_32, .offset = 0x150},
	/* Vector Register 21 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR21",         .type = REG_MMIO_32, .offset = 0x154},
	/* Vector Register 22 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR22",         .type = REG_MMIO_32, .offset = 0x158},
	/* Vector Register 23 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR23",         .type = REG_MMIO_32, .offset = 0x15c},
	/* Vector Register 24 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR24",         .type = REG_MMIO_32, .offset = 0x160},
	/* Vector Register 25 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR25",         .type = REG_MMIO_32, .offset = 0x164},
	/* Vector Register 26 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR26",         .type = REG_MMIO_32, .offset = 0x168},
	/* Vector Register 27 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR27",         .type = REG_MMIO_32, .offset = 0x16c},
	/* Vector Register 28 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR28",         .type = REG_MMIO_32, .offset = 0x170},
	/* Vector Register 29 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR29",         .type = REG_MMIO_32, .offset = 0x174},
	/* Vector Register 30 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR30",         .type = REG_MMIO_32, .offset = 0x178},
	/* Vector Register 31 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR31",         .type = REG_MMIO_32, .offset = 0x17c},
	/* Vector Register 32 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR32",         .type = REG_MMIO_32, .offset = 0x180},
	/* Vector Register 33 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR33",         .type = REG_MMIO_32, .offset = 0x184},
	/* Vector Register 34 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR34",         .type = REG_MMIO_32, .offset = 0x188},
	/* Vector Register 35 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR35",         .type = REG_MMIO_32, .offset = 0x18c},
	/* Vector Register 36 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR36",         .type = REG_MMIO_32, .offset = 0x190},
	/* Vector Register 37 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR37",         .type = REG_MMIO_32, .offset = 0x194},
	/* Vector Register 38 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR38",         .type = REG_MMIO_32, .offset = 0x198},
	/* Vector Register 39 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR39",         .type = REG_MMIO_32, .offset = 0x19c},
	/* Vector Register 40 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR40",         .type = REG_MMIO_32, .offset = 0x1a0},
	/* Vector Register 41 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR41",         .type = REG_MMIO_32, .offset = 0x1a4},
	/* Vector Register 42 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR42",         .type = REG_MMIO_32, .offset = 0x1a8},
	/* Vector Register 43 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR43",         .type = REG_MMIO_32, .offset = 0x1ac},
	/* Vector Register 44 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR44",         .type = REG_MMIO_32, .offset = 0x1b0},
	/* Vector Register 45 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR45",         .type = REG_MMIO_32, .offset = 0x1b4},
	/* Vector Register 46 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR46",         .type = REG_MMIO_32, .offset = 0x1b8},
	/* Vector Register 47 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR47",         .type = REG_MMIO_32, .offset = 0x1bc},
	/* Vector Register 48 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR48",         .type = REG_MMIO_32, .offset = 0x1c0},
	/* Vector Register 49 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR49",         .type = REG_MMIO_32, .offset = 0x1c4},
	/* Vector Register 50 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR50",         .type = REG_MMIO_32, .offset = 0x1c8},
	/* Vector Register 51 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR51",         .type = REG_MMIO_32, .offset = 0x1cc},
	/* Vector Register 52 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR52",         .type = REG_MMIO_32, .offset = 0x1d0},
	/* Vector Register 53 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR53",         .type = REG_MMIO_32, .offset = 0x1d4},
	/* Vector Register 54 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR54",         .type = REG_MMIO_32, .offset = 0x1d8},
	/* Vector Register 55 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR55",         .type = REG_MMIO_32, .offset = 0x1dc},
	/* Vector Register 56 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR56",         .type = REG_MMIO_32, .offset = 0x1e0},
	/* Vector Register 57 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR57",         .type = REG_MMIO_32, .offset = 0x1e4},
	/* Vector Register 58 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR58",         .type = REG_MMIO_32, .offset = 0x1e8},
	/* Vector Register 59 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR59",         .type = REG_MMIO_32, .offset = 0x1ec},
	/* Vector Register 60 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR60",         .type = REG_MMIO_32, .offset = 0x1f0},
	/* Vector Register 61 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR61",         .type = REG_MMIO_32, .offset = 0x1f4},
	/* Vector Register 62 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR62",         .type = REG_MMIO_32, .offset = 0x1f8},
	/* Vector Register 63 R/W 0x0000_0000 9.2.3.14/9-31  */
	{.name = "VECTOR63",         .type = REG_MMIO_32, .offset = 0x1fc},
	{NULL}
};

static regproc_module_t mx31_reg_proc_modules[] =
{
	CPU_COPROCESSOR_MODULES
	{.name = "IIM",  	.regs = mx31_iim,	.base = IO_ADDRESS(0x5001c000)},
	{.name = "CCM",  	.regs = mx31_ccm,	.base = IO_ADDRESS(0x53f80000)},
	{.name = "IOMUX",	.regs = mx31_iomux,	.base = IO_ADDRESS(0x43fac000)},
	{.name = "GPIO1",	.regs = mx31_gpio1,	.base = IO_ADDRESS(0x53fcc000)},
	{.name = "GPIO2",	.regs = mx31_gpio2,	.base = IO_ADDRESS(0x53fd0000)},
	{.name = "GPIO3",	.regs = mx31_gpio3,	.base = IO_ADDRESS(0x53fa4000)},
	{.name = "L2CC", 	.regs = mx31_l2cc,	.base = IO_ADDRESS(0x30000000)},
	{.name = "EVTMON",	.regs = mx31_evtmon,	.base = IO_ADDRESS(0x43f08000)},
	{.name = "M31F", 	.regs = mx31_m31f,	.base = IO_ADDRESS(0xb8003000)},
	{.name = "WEIM", 	.regs = mx31_weim,	.base = IO_ADDRESS(0xb8002000)},
	{.name = "ESDCTL",	.regs = mx31_esdctl,	.base = IO_ADDRESS(0xb8001000)},
	{.name = "NANDFC",	.regs = mx31_nandfc,	.base = IO_ADDRESS(0xb8000000)},
	{.name = "PCMCIA",	.regs = mx31_pcmcia,	.base = IO_ADDRESS(0xb8004000)},
	{.name = "OWIRE",	.regs = mx31_owire,	.base = IO_ADDRESS(0x43f9c000)},
	{.name = "ATA",  	.regs = mx31_ata,	.base = IO_ADDRESS(0x43f8c000)},
	{.name = "CSPI1",	.regs = mx31_cspi1,	.base = IO_ADDRESS(0x43fa4000)},
	{.name = "CSPI2",	.regs = mx31_cspi2,	.base = IO_ADDRESS(0x50010000)},
	{.name = "CSPI3",	.regs = mx31_cspi3,	.base = IO_ADDRESS(0x53f84000)},
	{.name = "FIR",  	.regs = mx31_fir,	.base = IO_ADDRESS(0x53f8c000)},
	{.name = "I2C1", 	.regs = mx31_i2c1,	.base = IO_ADDRESS(0x43f80000)},
	{.name = "I2C2", 	.regs = mx31_i2c2,	.base = IO_ADDRESS(0x43f98000)},
	{.name = "I2C3", 	.regs = mx31_i2c3,	.base = IO_ADDRESS(0x43f84000)},
	{.name = "KPP",  	.regs = mx31_kpp,	.base = IO_ADDRESS(0x43fa8000)},
	{.name = "MSHC1",	.regs = mx31_mshc1,	.base = IO_ADDRESS(0x50024000)},
	{.name = "MSHC2",	.regs = mx31_mshc2,	.base = IO_ADDRESS(0x50028000)},
	{.name = "SDHC1",	.regs = mx31_sdhc1,	.base = IO_ADDRESS(0x50004000)},
	{.name = "SDHC2",	.regs = mx31_sdhc2,	.base = IO_ADDRESS(0x50008000)},
	{.name = "SIM",  	.regs = mx31_sim,	.base = IO_ADDRESS(0x50018000)},
	{.name = "UART1",	.regs = mx31_uart1,	.base = IO_ADDRESS(0x43f90000)},
	{.name = "UART2",	.regs = mx31_uart2,	.base = IO_ADDRESS(0x43f94000)},
	{.name = "UART3",	.regs = mx31_uart3,	.base = IO_ADDRESS(0x5000c000)},
	{.name = "UART4",	.regs = mx31_uart4,	.base = IO_ADDRESS(0x43fb0000)},
	{.name = "UART5",	.regs = mx31_uart5,	.base = IO_ADDRESS(0x43fb4000)},
	{.name = "USBOTG",	.regs = mx31_usbotg,	.base = IO_ADDRESS(0x43f88000)},
	{.name = "USBHOST1",	.regs = mx31_usbhost1,	.base = IO_ADDRESS(0x43f88000)},
	{.name = "USBHOST2",	.regs = mx31_usbhost2,	.base = IO_ADDRESS(0x43f88000)},
	{.name = "EPIT1",	.regs = mx31_epit1,	.base = IO_ADDRESS(0x53f94000)},
	{.name = "EPIT2",	.regs = mx31_epit2,	.base = IO_ADDRESS(0x53f98000)},
	{.name = "GPT",  	.regs = mx31_gpt,	.base = IO_ADDRESS(0x53f90000)},
	{.name = "PWM",  	.regs = mx31_pwm,	.base = IO_ADDRESS(0x53fe0000)},
	{.name = "RTC",  	.regs = mx31_rtc,	.base = IO_ADDRESS(0x53fd8000)},
	{.name = "WDOG", 	.regs = mx31_wdog,	.base = IO_ADDRESS(0x53fdc000)},
	{.name = "AIPS_A",	.regs = mx31_aips_a,	.base = IO_ADDRESS(0x43f00000)},
	{.name = "AIPS_B",	.regs = mx31_aips_b,	.base = IO_ADDRESS(0x53f00000)},
	{.name = "MAX",  	.regs = mx31_max,	.base = IO_ADDRESS(0x43f04000)},
	{.name = "SDMA_AP",	.regs = mx31_sdma_ap,	.base = IO_ADDRESS(0x53fd4000)},
	{.name = "SPBA", 	.regs = mx31_spba,	.base = IO_ADDRESS(0x5003c000)},
	{.name = "AUDMUX",	.regs = mx31_audmux,	.base = IO_ADDRESS(0x53fc4000)},
	{.name = "SSI1", 	.regs = mx31_ssi1,	.base = IO_ADDRESS(0x43fa0000)},
	{.name = "SSI2", 	.regs = mx31_ssi2,	.base = IO_ADDRESS(0x50014000)},
	{.name = "AVIC", 	.regs = mx31_avic,	.base = IO_ADDRESS(0x68000000)},
	{NULL}
};
