/*
 * linux/block/k3d_priv.h
 * Copyright 2007 Sony Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/* k3d is based on linux/fs/xvfat/rdchk.c */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/list.h>
#include <linux/smp_lock.h>
#include <linux/slab.h>
#include <linux/blkdev.h>
#include <linux/freezer.h>
#include <linux/k3d.h>
#include <linux/delay.h>

#define K3D_S_CHANGE     0
#define K3D_S_INSERT     1
#define K3D_S_NOTCHECKED 4

#define K3D_S_CHANGE_BIT     (1 << (K3D_S_CHANGE))
#define K3D_S_INSERT_BIT     (1 << (K3D_S_INSERT))
#define K3D_S_NOTCHECKED_BIT (1 << (K3D_S_NOTCHECKED))

#define k3di_state(k3di, type)		((k3di)->state      & (1<<(type)))
#define k3di_capability(k3di, type)	((k3di)->capability & (1<<(type)))

struct k3d_info {
	struct list_head  dev_list;
	struct list_head  chk_list;
 	struct gendisk    *disk;
	atomic_t          ref_count;
	unsigned long     state, prev_state;
	unsigned long     capability, prev_cap;
	unsigned int      state_change_count;
	unsigned int      interval;
	unsigned int      interval_count;
	char              name[BDEVNAME_SIZE];
	struct blkdev_io_error *bioe;
	int               flag;
	atomic_t          flag_wait_unregister;
	atomic_t          flag_delay_inv;
};

#define K3D_F_DELAY_INV  1

struct k3d_info *find_k3dinfo_by_name(const char* name);

int get_k3dinfo_change(struct k3d_info *k3di);
int get_k3dinfo_insert(struct k3d_info *k3di);
int set_k3dinfo_interval(struct k3d_info *k3di, unsigned int val);

/* for debug */
#undef K3D_DEBUG
#undef K3D_DEBUG2
#undef K3D_DEBUG0

#ifdef K3D_DEBUG
#define k3d_printk(x...)	printk(x)
#else
#define k3d_printk(x...)	do{}while(0)
#endif

#ifdef K3D_DEBUG2
#define k3d_printk2(x...)	printk(x)
#else
#define k3d_printk2(x...)	do{}while(0)
#endif

#ifdef K3D_DEBUG0
#define k3d_printk0(x...)	printk(x)
#else
#define k3d_printk0(x...)	do{}while(0)
#endif

#ifdef CONFIG_PROC_FS
#include <linux/proc_fs.h>
int __init k3d_proc_init(void);
void k3d_proc_exit(void);
void k3d_proc_notify(struct k3d_info *k3di);
#else  /* !CONFIG_PROC_FS */
inline void k3d_proc_notify(struct k3d_info *k3di)
{
	k3d_printk("%s: dev=%s  chg_cap=%ld ins_cap=%ld chg=%d ins=%ld\n",
		     __FUNCTION__, k3di->name,
		     k3di_capability(k3di, K3D_S_CHANGE),
		     k3di_capability(k3di, K3D_S_INSERT),
		     k3di_state(k3di, K3D_S_CHANGE),
		     k3di_state(k3di, K3D_S_INSERT));
}
#endif /* !CONFIG_PROC_FS */

