/*******************************************************************************

  smac_hw.h
  smac hardware informations

  Copyright 2008,2009 Sony Corporation

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

*******************************************************************************/

#ifndef __SMAC_HW_H__
#define __SMAC_HW_H__

/* SMAC register size */
#define SMAC_REG_SIZE		0x00002000

/* Descriptor */
#define SMAC_TX_DESC_SIZE	(SMAC_MAX_TXD * sizeof(struct smac_desc))	/* SMAC Tx descriptor size: Max 256x16byte */
#define SMAC_RX_DESC_SIZE	(SMAC_MAX_RXD * sizeof(struct smac_desc))	/* SMAC Rx descriptor size: Max 256x16byte */
#define SMAC_DESC_SIZE		(SMAC_TX_DESC_SIZE + SMAC_RX_DESC_SIZE)	/* SMAC descriptor size */
#define SMAC_TX_DESC_OFFSET	0x00000000
#define SMAC_RX_DESC_OFFSET	SMAC_TX_DESC_SIZE

/* ethernet frame size at VLAN */
#define MAXIMUM_ETHERNET_VLAN_SIZE (1518 + VLAN_HLEN)

/* Supported Rx Buffer Sizes */
#define SMAC_RXBUFFER_128	  128	 /* Used for packet split */
#define SMAC_RXBUFFER_256	  256	 /* Used for packet split */
#define SMAC_RXBUFFER_512	  512
#define SMAC_RXBUFFER_1024	 1024
#define SMAC_RXBUFFER_2048	 2048
#define SMAC_RXBUFFER_4096	 4096
#define SMAC_RXBUFFER_8192	 8192
#define SMAC_RXBUFFER_16384	16384

/* ------------------------------ */
/* SMAC Register Map */
#define SMAC_INTR_STAT			(0x0000)
#define SMAC_INTR_ENABLE		(0x0004)
#define SMAC_INTR_DISABLE		(0x0008)
#define SMAC_INTR_CLEAR			(0x000c)
#define SMAC_INTR_TEST			(0x0010)
#define SMAC_INTR_RFC			(1 << 29)
#define SMAC_INTR_RDTA			(1 << 27)
#define SMAC_INTR_RDT			(1 << 26)
#define SMAC_INTR_RDL			(1 << 25)
#define SMAC_INTR_SWRD			(1 << 18)
#define SMAC_INTR_PSUD			(1 << 17)
#define SMAC_INTR_RU			(1 << 7)
#define SMAC_INTR_RI			(1 << 6)
#define SMAC_INTR_TU			(1 << 2)
#define SMAC_INTR_TI			(1 << 0)
#define SMAC_INTR_ALL			(0x7C01ABFF)

#define SMAC_OPERATION			(0x0100)
#define SMAC_OP_RSF			(1 << 25) /* Recieve Store and Forward */
/* Threshold for flow control
   000 : Full - 1KB
   001 : Full - 2KB
   010 : Full - 3KB
   011 : Full - 4KB
   100 : Full - 5KB
   101 : Full - 6KB
   110 : Full - 7KB */
#define SMAC_OP_RF_MSB(val)		((((val) - 1) & 0x4) >> 2)
#define SMAC_OP_RF_LSB(val)		(((val) - 1) & 0x3)
 /* Threshold for activating (bit23,10-9) */
#define SMAC_OP_RFA			((SMAC_OP_RF_MSB(CONFIG_SMAC_RX_FIFO_ACTIVE) << 23) \
						| (SMAC_OP_RF_LSB(CONFIG_SMAC_RX_FIFO_ACTIVE) << 9))
/* Threshold for deactivating (bit22,12-11) */
#define SMAC_OP_RFD			((SMAC_OP_RF_MSB(CONFIG_SMAC_RX_FIFO_DEACTIVE) << 22) \
						| (SMAC_OP_RF_LSB(CONFIG_SMAC_RX_FIFO_DEACTIVE) << 11))

#define SMAC_OP_TSF			(1 << 21) /* Transmit Store and Forward */
#define SMAC_OP_EFC			(1 << 8) /* Enable HW Flow Control */
#define SMAC_OP_RTC_64BYTE		(0 << 3)
#define SMAC_OP_RTC_32BYTE		(1 << 3)

#define SMAC_TX_DB_BASE			(0x010c)
#define SMAC_TX_DB_LENGTH_MINUS1	(0x0110)
#define SMAC_TX_DB_HEAD			(0x0114)
#define SMAC_TX_DB_TAIL			(0x0118)
#define SMAC_RX_DB_BASE			(0x011c)
#define SMAC_RX_DB_LENGTH_MINUS1	(0x0120)
#define SMAC_RX_DB_HEAD			(0x0124)
#define SMAC_RX_DB_TAIL			(0x0128)

#define SMAC_BUS_MODE			(0x012c)
#define SMAC_BM_RMW_ENA			(1 << 16)
#define SMAC_BM_BLE_BIG			(1 << 7)
#define SMAC_BM_BLE_LITTLE		(0 << 7)
#define SMAC_BM_PBL			(16 << 8) /* Programmable Burst Length */
#define SMAC_BM_SWR			(1 << 0) /* sw reset */

#define SMAC_BUS_ARB			(0x0130)
#define SMAC_RX_MAX_FRM_LENGTH		(0x0134)
#define SMAC_RX_FRAME_BYTE_LIMIT	(0x013c)
#define SMAC_RX_FRAME_COUNT_LIMIT	(0x0140)
#define SMAC_RX_MINSIZE_LIMIT		(0x0144)
#define SMAC_RX_DELAY_TIMER		(0x0148)
#define SMAC_RX_ABSOLUTE_TIMER		(0x014c)
#define SMAC_RX_DESC_LIMIT		(0x0150)
#define SMAC_RXFIFO_FRM_CNT		(0x0154)

#define SMAC_PHY_POLLING		(0x0440)
#define SMAC_PP_M_PA			0xF800
#define SMAC_PP_S_PA			11
#define SMAC_PP_M_GR			0x07C0
#define SMAC_PP_S_GR			6
#define SMAC_PP_PE			(1 << 5)

#define SMAC_PHY_POLLED_DATA		(0x0444)
#define SMAC_TX_DESC_ADDR		(0x0530)
#define SMAC_RX_DESC_ADDR		(0x0534)
#define SMAC_TX_DESC0			(0x0538)
#define SMAC_TX_DESC1			(0x053c)
#define SMAC_TX_DESC2			(0x0540)
#define SMAC_TX_DESC3			(0x0544)
#define SMAC_RX_DESC0			(0x0548)
#define SMAC_RX_DESC1			(0x054c)
#define SMAC_RX_DESC2			(0x0550)
#define SMAC_RX_DESC3			(0x0554)

#define SMAC_STATE_TX_RD		(0x0D00)
#define SMAC_STATE_TX_GD		(0x0D04)
#define SMAC_STATE_TX_GB		(0x0D08)
#define SMAC_STATE_TX_WR		(0x0D0C)
#define SMAC_STATE_TX_WB		(0x0D10)
#define SMAC_STATE_RX_RD		(0x0D20)
#define SMAC_STATE_RX_GD		(0x0D24)
#define SMAC_STATE_RX_WR		(0x0D2C)
#define SMAC_STATE_RX_WB		(0x0D30)
#define SMAC_STATE_SWR			(0x0D40)
#define SMAC_STATE_RA			(0x0D60)
#define SMAC_STATE_RA_PL		(0x0D64)

#define SMAC_HW_VERSION			(0x0F00)
#define SMAC_HV_S_MAV			24
#define SMAC_HV_M_MAV			0xff000000
#define SMAC_HV_S_MIV0			16
#define SMAC_HV_M_MIV0			0x00ff0000
#define SMAC_HV_S_MIV1			8
#define SMAC_HV_M_MIV1			0x0000ff00
#define SMAC_HV_S_MIV2			0
#define SMAC_HV_M_MIV2			0x000000ff

#define SMAC_REVISE			(0x0F04)
#define SMAC_REVISE_SRV			(1 << 0)

#define SMAC_MAC_CONFIG			(0x1000)
#define SMAC_MC_WD			(1 << 23)
#define SMAC_MC_JD			(1 << 22)
#define SMAC_MC_JE			(1 << 20)	 /* jumbo frame enable */
#define SMAC_MC_M_IFG			(7 << 17)
#define SMAC_MC_IFG_64BIT		(4 << 17)
#define SMAC_MC_PS_MII			(1 << 15)	 /* MII */
#define SMAC_MC_FES_100			(1 << 14)	 /* 100Mbps */
#define SMAC_MC_DM_FULL			(1 << 11)	 /* full duplex */
#define SMAC_MC_RCS			(1 << 10)	 /* to enable Rx checksum offload */
#define SMAC_MC_TE			(1 << 3)
#define SMAC_MC_RE			(1 << 2)
#define SMAC_MC_DFS_ENA			(0 << 7)	/* enable FCS stripping */
#define SMAC_MC_DFS_DIS			(1 << 7)

#define SMAC_MAC_FRAME_FILTER		(0x1004)
#define SMAC_MFF_PM			(1 << 4)	/* enable pass all multicast */
#define SMAC_MFF_PR			(1 << 0)	/* enable promiscuous mode */

#define SMAC_HASH_TABLE_HIGH		(0x1008)
#define SMAC_HASH_TABLE_LOW		(0x100c)

#define SMAC_PHY_ADDR			(0x1010)
#define SMAC_PA_M_PA			0xf800
#define SMAC_PA_S_PA			11
#define SMAC_PA_M_GR			0x07c0
#define SMAC_PA_S_GR			6
#define SMAC_PA_M_MCR			0x001c
#define SMAC_PA_S_MCR			2
#define SMAC_PA_M_GW			0x0002
#define SMAC_PA_READ			0x0000
#define SMAC_PA_WRITE			0x0002
#define SMAC_PA_M_GB			0x0001
#define SMAC_PA_KICK			0x0001
#define SMAC_PA_BUSY			0x0001
#define SMAC_PA_FREE			0x0000

#define SMAC_PHY_DATA			(0x1014)

#define SMAC_CONTROL_FRM		(0x1018)
#define SMAC_CF_PT			(CONFIG_SMAC_FC_PAUSE_TIME << 16) /* Pause Time */
/* Pause Low Threshold
   00:   4 slot times
   01:  28 slot times
   10: 144 slot times
   11: 256 slot times */
#define SMAC_CF_PLT			(1 << 4) /* Pause Low Threshold */

#define SMAC_CF_UP			(1 << 3) /* Unicast Pause Frame Detect */
#define SMAC_CF_RFE			(1 << 2) /* Receive Flow Control Enable */
#define SMAC_CF_TFE			(1 << 1) /* Transmit Flow Control Enable */
#define SMAC_CF_FCB			(1 << 0) /* Flow Control Busy/Backpressure Active */

#define SMAC_VLAN_TAG			(0x101c)
#define SMAC_MAC_VERSION		(0x1020)
#define SMAC_WAKE_UP_FILTER		(0x1028)
#define SMAC_POWER_MANAGEMENT		(0x102c)
#define SMAC_POWER_MANAGEMENT		(0x102c)
#define SMAC_MAC_INTR_STAT		(0x1038)
#define SMAC_MAC_INTR_MASK		(0x103C)

#define SMAC_MAC_ADDR_HIGH(n)		(0x1040 + n * 8)
#define SMAC_MAC_ADDR_LOW(n)		(0x1044 + n * 8)
#define SMAC_MAC_ADDR_0_HIGH		SMAC_MAC_ADDR_HIGH(0)
#define SMAC_MAC_ADDR_0_LOW		SMAC_MAC_ADDR_LOW(0)
#define SMAC_MAC_AE			0x80000000

#define SMAC_RGMII_STAT			(0x10D8)

#define SMAC_MMC_CONTROL		(0x1100)
#define SMAC_MMC_CR			(1 << 0)
#define SMAC_MMC_CSR			(1 << 1)
#define SMAC_MMC_RR			(1 << 2)
#define SMAC_MMC_CF			(1 << 3)

#define SMAC_MMC_INTR_RX		(0x1104)
#define SMAC_MMC_INTR_TX		(0x1108)
#define SMAC_MMC_INTR_MASK_RX		(0x110C)
#define SMAC_MMC_INTR_MASK_TX		(0x1110)

#define SMAC_TXOCTETCOUNT_GB		(0x1114)
#define SMAC_TXFRAMECOUNT_GB		(0x1118)
#define SMAC_TXBROADCASTFRAMES_G	(0x111C)
#define SMAC_TXMULTICASTFRAMES_G	(0x1120)
#define SMAC_TX64OCTETS_GB		(0x1124)
#define SMAC_TX65TO127OCTETS_GB		(0x1128)
#define SMAC_TX128TO255OCTETS_GB	(0x112C)
#define SMAC_TX256TO511OCTETS_GB	(0x1130)
#define SMAC_TX512TO1023OCTETS_GB	(0x1134)
#define SMAC_TX1024TOMAXOCTETS_GB	(0x1138)
#define SMAC_TXUNICASTFRAMES_GB		(0x113C)
#define SMAC_TXMULTICASTFRAMES_GB	(0x1140)
#define SMAC_TXBROADCASTFRAMES_GB	(0x1144)
#define SMAC_TXUNDERFLOWERROR		(0x1148)
#define SMAC_TXSINGLECOL_G		(0x114C)
#define SMAC_TXMULTICOL_G		(0x1150)
#define SMAC_TXDEFERRED			(0x1154)
#define SMAC_TXLATECOL			(0x1158)
#define SMAC_TXEXESSCOL			(0x115C)
#define SMAC_TXCARRIERERROR		(0x1160)
#define SMAC_TXOCTETCOUNT_G		(0x1164)
#define SMAC_TXFRAMECOUNT_G		(0x1168)
#define SMAC_TXEXCESSDEF		(0x116C)
#define SMAC_TXPAUSEFRAMES		(0x1170)
#define SMAC_TXVLANFRAMES_G		(0x1174)
#define SMAC_RXFRAMECOUNT_GB		(0x1180)
#define SMAC_RXOCTETCOUNT_GB		(0x1184)
#define SMAC_RXOCTETCOUNT_G		(0x1188)
#define SMAC_RXBROADCASTFRAMES_G	(0x118C)
#define SMAC_RXMULTICASTFRAMES_G	(0x1190)
#define SMAC_RXCRCERROR			(0x1194)
#define SMAC_RXALIGNMENTERROR		(0x1198)
#define SMAC_RXRUNTERROR		(0x119C)
#define SMAC_RXJABBERERROR		(0x11A0)
#define SMAC_RXUNDERSIZE_G		(0x11A4)
#define SMAC_RXOVERSIZE_G		(0x11A8)
#define SMAC_RX64OCTETS_GB		(0x11AC)
#define SMAC_RX65TO127OCTETS_GB		(0x11B0)
#define SMAC_RX128TO255OCTETS_GB	(0x11B4)
#define SMAC_RX256TO511OCTETS_GB	(0x11B8)
#define SMAC_RX512TO1023OCTETS_GB	(0x11BC)
#define SMAC_RX1024TOMAXOCTETS_GB	(0x11C0)
#define SMAC_RXUNICASTFRAMES_G		(0x11C4)
#define SMAC_RXLENGTHERROR		(0x11C8)
#define SMAC_RXOUTOFRANGETYPE		(0x11CC)
#define SMAC_RXPAUSEFRAMES		(0x11D0)
#define SMAC_RXFIFOOVERFLOW		(0x11D4)
#define SMAC_RXVLANFRAMES_GB		(0x11D8)
#define SMAC_RXWATCHDOGERROR		(0x11DC)
#define SMAC_RXIPV4_GD_FRMS		(0x1210)
#define SMAC_RXIPV4_HDRERR_FRMS		(0x1214)
#define SMAC_RXIPV4_NOPAY_FRMS		(0x1218)
#define SMAC_RXIPV4_FRAG_FRMS		(0x121C)
#define SMAC_RXIPV4_UDSBL_FRMS		(0x1220)
#define SMAC_RXIPV6_GD_FRMS		(0x1224)
#define SMAC_RXIPV6_HDRERR_FRMS		(0x1228)
#define SMAC_RXIPV6_NOPAY_FRMS		(0x122C)
#define SMAC_RXUDP_GD_FRMS		(0x1230)
#define SMAC_RXUDP_ERR_FRMS		(0x1234)
#define SMAC_RXTCP_GD_FRMS		(0x1238)
#define SMAC_RXTCP_ERR_FRMS		(0x123C)
#define SMAC_RXICMP_GD_FRMS		(0x1240)
#define SMAC_RXICMP_ERR_FRMS		(0x1244)
#define SMAC_RXIPV4_GD_OCTETS		(0x1250)
#define SMAC_RXIPV4_HDRERR_OCTETS	(0x1254)
#define SMAC_RXIPV4_NOPAY_OCTETS	(0x1258)
#define SMAC_RXIPV4_FRAG_OCTETS		(0x125C)
#define SMAC_RXIPV4_UDSEL_OCTETS	(0x1260)
#define SMAC_RXIPV6_GD_OCTETS		(0x1264)
#define SMAC_RXIPV6_HDRERR_OCTETS	(0x1268)
#define SMAC_RXIPV6_NOPAY_OCTETS	(0x126C)
#define SMAC_RXUDP_GD_OCTETS		(0x1270)
#define SMAC_RXUDP_ERR_OCTETS		(0x1274)
#define SMAC_RXTCP_GD_OCTETS		(0x1278)
#define SMAC_RXTCP_ERR_OCTETS		(0x127C)
#define SMAC_RXICMP_GD_OCTETS		(0x1280)
#define SMAC_RXICMP_ERR_OCTETS		(0x1284)


/* ------------------------------ */
/* descriptor */
struct smac_desc {
	volatile uint32_t desc0;
	uint32_t desc1;
	uint32_t desc2;
	uint32_t desc3;
};

/* TX descriptor */
#define SMAC_STDD_M_WB		(1 << 31)
#define SMAC_STDD_M_IC		(1 << 28)
#define SMAC_STDD_M_ICS		(1 << 25)
#define SMAC_STDD_M_TCS		(1 << 24)
#define SMAC_STDD_M_PHCS	(1 << 23)
#define SMAC_STDD_M_LS		(1 << 27)
#define SMAC_STDD_M_FS		(1 << 26)
#define SMAC_STDD_M_DFCS_ENA	(1 << 22)
#define SMAC_STDD_M_DFCS_DIS	(0 << 22)
#define SMAC_STDD_M_DPAD_ENA	(1 << 21)
#define SMAC_STDD_M_DPAD_DIS	(0 << 21)
#define SMAC_STDD_M_LSE		(1 << 19)
#define SMAC_STDD_M_BUF_LEN2	0x3fff0000
#define SMAC_STDD_S_BUF_LEN2	16
#define SMAC_STDD_M_BUF_LEN1	0x000000ff
#define SMAC_STDD_S_BUF_LEN1	0

/* RX descriptor */
/* RDES0 */
#define SMAC_SRD_M_WB		(1 << 31)
#define SMAC_SRD_M_SHF		(1 << 30)
#define SMAC_SRD_M_FRAME_LEN	0x3fff0000
#define SMAC_SRD_S_FRAME_LEN	16
#define SMAC_SRD_M_ES		(1 << 15)
#define SMAC_SRD_M_TCS		(1 << 14)
#define SMAC_SRD_M_SAF		(1 << 13)
#define SMAC_SRD_M_LE		(1 << 12)
#define SMAC_SRD_M_OE		(1 << 11)
#define SMAC_SRD_M_VL		(1 << 10)
#define SMAC_SRD_M_FS		(1 << 9)
#define SMAC_SRD_M_LS		(1 << 8)
#define SMAC_SRD_M_ICSE		(1 << 7)
#define SMAC_SRD_M_LC		(1 << 6)
#define SMAC_SRD_M_ICS		(1 << 5)
#define SMAC_SRD_M_RWT		(1 << 4)
#define SMAC_SRD_M_RE		(1 << 3)
#define SMAC_SRD_M_DE		(1 << 2)
#define SMAC_SRD_M_CE		(1 << 1)
#define SMAC_SRD_M_TCSE		(1 << 0)
/* RDES1 */
#define SMAC_SRD1_M_FT		(1 << 31)
#define SMAC_SRD1_M_DT		(1 << 15)
#define SMAC_SRD1_M_ADT		(1 << 14)
#define SMAC_SRD1_M_FCL		(1 << 13)
#define SMAC_SRD1_M_FBL		(1 << 12)
#define SMAC_SRD1_M_SHP		(1 << 11)

#endif	/* __SMAC_HW_H__ */

