/*
 * smac_local.h
 * smac private data
 *
 * Copyright 2008,2009 Sony Corporation
 *
 * This code is based on drivers/net/e1000/e1000.h
 */
/*******************************************************************************

  Intel PRO/1000 Linux driver
  Copyright(c) 1999 - 2006 Intel Corporation.

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

  The full GNU General Public License is included in this distribution in
  the file called "COPYING".

  Contact Information:
  Linux NICS <linux.nics@intel.com>
  e1000-devel Mailing List <e1000-devel@lists.sourceforge.net>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/

#ifndef __SMAC_LOCAL_H__
#define __SMAC_LOCAL_H__

/*------------------------------------------------------------------------------
  Include Files
  ------------------------------------------------------------------------------*/
#include <linux/version.h>
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,19))
#include <linux/config.h>
#endif
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/list.h>
#include <linux/sched.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/vmalloc.h>
#include <linux/interrupt.h>
#include <linux/string.h>
#include <linux/pagemap.h>
#include <linux/bitops.h>
#include <linux/capability.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <linux/list.h>
#include <linux/reboot.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/time.h>
#include <linux/swab.h>
#include <linux/stddef.h>
#include <linux/types.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/poll.h>
#include <linux/highmem.h>
#include <linux/dma-mapping.h>
#include <net/pkt_sched.h>
#include <linux/ipv6.h>
#include <net/ipv6.h>
#include <net/ip.h>
#include <linux/mii.h>
#include <linux/phy.h>
#ifdef SIOCETHTOOL
#include <linux/ethtool.h>
#endif
#ifdef NETIF_F_HW_VLAN_TX
#include <linux/if_vlan.h>
#endif
#include <linux/platform_device.h>
#include <linux/semaphore.h>
#include <linux/smac_platform.h>

#include <asm/byteorder.h>
#include <asm/io.h>
#include <asm/irq.h>

#include "smac_hw.h"		/* smac hw register map */
#include "smac_io.h"


/*------------------------------------------------------------------------------
  Debug Print
  ------------------------------------------------------------------------------*/
#define PFX "smac: "

#ifdef CONFIG_SMAC_TRACE_FUNCTION
#define SMAC_DEBUG_FUNC() printk(KERN_DEBUG PFX "%s()\n", __func__)
#else
#define SMAC_DEBUG_FUNC()
#endif

#ifdef CONFIG_SMAC_DBG
#define SMAC_ASSERT(expr) \
	if (!(expr)) { \
		printk(KERN_DEBUG PFX "assertion failed! %s,%s,%s,line=%d\n", \
		       #expr, __FILE__, __func__, __LINE__); \
	}
#define SMAC_DEBUG_OUT(fmt, args...) \
	printk(KERN_DEBUG PFX "debug: " "%s(): " fmt, __func__, ## args)
#else
#define SMAC_ASSERT(expr) do {} while (0)
#define SMAC_DEBUG_OUT(fmt, args...)
#endif

#define SMAC_ERR_OUT(fmt, args...) \
	printk(KERN_ERR PFX "error: " "%s(): " fmt, __func__, ## args)

#define SMAC_DPRINTK(nlevel, klevel, fmt, args...) \
	(void)((NETIF_MSG_##nlevel & adapter->msg_enable) && \
	printk(KERN_##klevel PFX "%s: %s: " fmt, adapter->netdev->name, \
	       __FUNCTION__ , ## args))


/*------------------------------------------------------------------------------
  Macros
  ------------------------------------------------------------------------------*/
/* Kernel dependent */
#ifndef CHECKSUM_PARTIAL
#define CHECKSUM_PARTIAL CHECKSUM_HW
#define CHECKSUM_COMPLETE CHECKSUM_HW
#endif

#ifndef htons
#define htons cpu_to_be16
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,18))
#ifndef netdev_alloc_skb
#define netdev_alloc_skb(a,b) dev_alloc_skb(b)
#endif
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,22))
#define tcp_hdr(skb) (skb->h.th)
#define tcp_hdrlen(skb) (skb->h.th->doff << 2)
#define udp_hdr(skb) (skb->h.uh)
#define skb_transport_offset(skb) (skb->h.raw - skb->data)
#define skb_transport_header(skb) (skb->h.raw)
#define ipv6_hdr(skb) (skb->nh.ipv6h)
#define ip_hdr(skb) (skb->nh.iph)
#define skb_network_offset(skb) (skb->nh.raw - skb->data)
#define skb_network_header(skb) (skb->nh.raw)
#define skb_tail_pointer(skb) skb->tail
#define skb_copy_to_linear_data_offset(skb, offset, from, len) \
                                 memcpy(skb->data + offset, from, len)
#define skb_network_header_len(skb) (skb->h.raw - skb->nh.raw)
#define skb_mac_header(skb) skb->mac.raw

#ifndef alloc_etherdev_mq
#define alloc_etherdev_mq(_a, _b) alloc_etherdev(_a)
#endif

#ifndef ETH_FCS_LEN
#define ETH_FCS_LEN 4
#endif
#endif /* < 2.6.22 */

/* platform dependent */
#if defined(CONFIG_SMAC_FORCE_DESCRIPTOR_ENDIAN_BIG)
#define SMAC_CPU_DESC_BE
#define smac_cpu_to_desc(x)	cpu_to_be32(x)
#define smac_desc_to_cpu(x)	be32_to_cpu(x)
#elif defined(CONFIG_SMAC_FORCE_DESCRIPTOR_ENDIAN_LITTLE)
#define SMAC_CPU_DESC_LE
#define smac_cpu_to_desc(x)	cpu_to_le32(x)
#define smac_desc_to_cpu(x)	le32_to_cpu(x)
#elif defined(CONFIG_CPU_BIG_ENDIAN)
#define SMAC_CPU_DESC_BE
#define smac_cpu_to_desc(x)	(x)
#define smac_desc_to_cpu(x)	(x)
#else
#define SMAC_CPU_DESC_LE
#define smac_cpu_to_desc(x)	(x)
#define smac_desc_to_cpu(x)	(x)
#endif

/* advertised speed & duplex */
#define SMAC_ADVERTISE_10_HALF		0x0001
#define SMAC_ADVERTISE_10_FULL		0x0002
#define SMAC_ADVERTISE_100_HALF		0x0004
#define SMAC_ADVERTISE_100_FULL		0x0008
#define SMAC_ADVERTISE_1000_HALF	0x0010
#define SMAC_ADVERTISE_1000_FULL	0x0020

/* TX flags */
#define SMAC_TX_FLAGS_CSUM		0x00000001	/* IP checksum only */
#define SMAC_TX_FLAGS_TSO		0x00000004
#define SMAC_TX_FLAGS_TCSUM		0x00000010	/* TCP/UDP checksum + pseudo IP header checksum */

/* tx/rx descriptor defines */
#define SMAC_MAX_TXD		CONFIG_SMAC_NR_TX_DESCRIPTORS
#define SMAC_MAX_RXD		CONFIG_SMAC_NR_RX_DESCRIPTORS
#define SMAC_DEFAULT_TXD	SMAC_MAX_TXD
#define SMAC_DEFAULT_RXD	SMAC_MAX_RXD
#define SMAC_TX_WEIGHT		(SMAC_MAX_TXD/4)
#define SMAC_TX_WAKE_THRESHOLD	(SMAC_MAX_TXD/8)
#define SMAC_DESC_WEIGHT	(SMAC_MAX_RXD/4)
#define SMAC_RX_BUFFER_WRITE	(SMAC_MAX_RXD/16)
/* # of cleaning descriptors */
#define SMAC_MAX_INTR 10

/* duplex */
#define SMAC_HALF_DUPLEX	1
#define SMAC_FULL_DUPLEX	2

/* frame size */
#define ETHERNET_FCS_SIZE		4
#ifdef CONFIG_SMAC_ENABLE_JUMBOFRAME
#define MAX_JUMBO_FRAME_SIZE		(4092 + VLAN_HLEN - ETHERNET_FCS_SIZE)
#else
#define MAX_JUMBO_FRAME_SIZE		(1518 + VLAN_HLEN - ETHERNET_FCS_SIZE)
#endif
#define ENET_HEADER_SIZE		14
#define MAXIMUM_ETHERNET_FRAME_SIZE	MAX_JUMBO_FRAME_SIZE	/* With FCS */
#define MINIMUM_ETHERNET_FRAME_SIZE	64	/* With FCS */
#define MAXIMUM_ETHERNET_PACKET_SIZE	(MAXIMUM_ETHERNET_FRAME_SIZE - ETHERNET_FCS_SIZE)
#define MINIMUM_ETHERNET_PACKET_SIZE	(MINIMUM_ETHERNET_FRAME_SIZE - ETHERNET_FCS_SIZE)
#define CRC_LENGTH			ETHERNET_FCS_SIZE
#define SMAC_MULTICAST_ADDR_NUM		16

/* InterruptThrottleNumber latency */
#define SMAC_LOWEST_LATENCY	CONFIG_SMAC_LOWEST_LATENCY
#define SMAC_LOW_LATENCY	(SMAC_LOWEST_LATENCY * 4)
#define SMAC_BULK_LATENCY	(SMAC_LOW_LATENCY * 5)
/* parameter of InterruptThrottleNum */
#define SMAC_ITNR_OFF			0
#define SMAC_ITNR_DYNAMIC		1
#define SMAC_ITNR_DYNAMIC_CONSERVATIVE	3

/* only works for sizes that are powers of 2 */
#define SMAC_ROUNDUP(i, size) ((i) = (((i) + (size) - 1) & ~((size) - 1)))


/*------------------------------------------------------------------------------
  Enums
  ------------------------------------------------------------------------------*/
typedef enum {
#undef FALSE
	FALSE = 0,
#undef TRUE
	TRUE = 1
} boolean_t;

/* speed & duplex settings */
typedef enum {
	smac_10_half = 0,
	smac_10_full = 1,
	smac_100_half = 2,
	smac_100_full = 3
} smac_speed_duplex_type;

/* flow control settings */
typedef enum {
	SMAC_FC_NONE = 0,
	SMAC_FC_RX_PAUSE = 1,
	SMAC_FC_TX_PAUSE = 2,
	SMAC_FC_FULL = 3
} smac_fc_type;

/* InterruptThrottleNum latency range  */
typedef enum {
	lowest_latency_range = 0,	/* 15 usec/interrupt */
	low_latency_range = 1,		/* 50 usec/interrupt */
	bulk_latency_range = 2,		/* 250 usec/interrupt */
} smac_latency_range_type;

/* for smac_adapter.flags */
enum smac_state_t {
	__SMAC_TESTING,
	__SMAC_RESETTING,
#ifdef SMAC_USE_PHY_POLLING
	__SMAC_DOWN
#endif
};


/*------------------------------------------------------------------------------
  Structs
  ------------------------------------------------------------------------------*/
/* struct for sk_buff */
struct smac_buffer {
	struct sk_buff *skb;		/* skb base address (virtual) */
	dma_addr_t dma;			/* skb base address (physical) */
	unsigned long time_stamp;	/* jiffies */
	uint16_t length;		/* length of skb */
	uint16_t next_to_watch;		/* index of descriptor (set up skb infomation) */
};

/* struct for tx/rx descriptor */
/* descriptor is controled as ring buffer */
/* tx(rx) have SMAC_MAX_TXD(SMAC_MAX_RXD) buffer_info */
/* tx descriptor ring */
struct smac_tx_ring {
	void *desc;				/* descriptor base address (virtual) */
	dma_addr_t dma;				/* descriptor base address (physical) */
	unsigned int size;			/* descriptor size (byte) */
	unsigned int count;			/* number of descriptor */
	unsigned int next_to_use;		/* index of descriptor (next use) */
	unsigned int next_to_clean;		/* index of descriptor (next clean up) */
	struct smac_buffer *buffer_info;	/* skb information */

	spinlock_t tx_lock;			/* spinlock for tx */
};

/* rx descriptor ring */
struct smac_rx_ring {
	void *desc;
	dma_addr_t dma;
	unsigned int size;
	unsigned int count;
	unsigned int next_to_use;
	unsigned int next_to_clean;
	struct smac_buffer *buffer_info;
};

/* descriptor operation macro */
#define SMAC_DESC_UNUSED(R) \
    ((((R)->next_to_clean > (R)->next_to_use) ? 0 : (R)->count) + (R)->next_to_clean - (R)->next_to_use - 1)

#define SMAC_GET_DESC(R, i, type)    (&(((struct type *)((R).desc))[i]))
#define SMAC_RX_DESC(R, i)	  SMAC_GET_DESC(R, i, smac_desc)
#define SMAC_TX_DESC(R, i)	  SMAC_GET_DESC(R, i, smac_desc)


/* Statistics counters collected by the MAC */
struct smac_hw_stats {
#ifdef CONFIG_SMAC_DBG	/* SMAC H/W register for debug */
	uint64_t intr_stat;
	uint64_t intr_enable;
	uint64_t operation;
	uint64_t tx_db_base;
	uint64_t tx_db_length_minus1;
	uint64_t tx_db_head;
	uint64_t tx_db_tail;
	uint64_t rx_db_base;
	uint64_t rx_db_length_minus1;
	uint64_t rx_db_head;
	uint64_t rx_db_tail;
	uint64_t bus_mode;
	uint64_t rx_max_frm_length;
	uint64_t rx_frame_byte_limit;
	uint64_t rx_frame_count_limit;
	uint64_t rx_minsize_limit;
	uint64_t rx_delay_timer;
	uint64_t rx_absolute_timer;
	uint64_t rx_desc_limit;
	uint64_t rxfifo_frm_cnt;
	uint64_t phy_polling;
	uint64_t phy_polled_data;
	uint64_t tx_desc_addr;
	uint64_t rx_desc_addr;
	uint64_t tx_desc0;
	uint64_t tx_desc1;
	uint64_t tx_desc2;
	uint64_t tx_desc3;
	uint64_t rx_desc0;
	uint64_t rx_desc1;
	uint64_t rx_desc2;
	uint64_t rx_desc3;
	uint64_t state_tx_rd;
	uint64_t state_tx_gd;
	uint64_t state_tx_gb;
	uint64_t state_tx_wr;
	uint64_t state_tx_wb;
	uint64_t state_rx_rd;
	uint64_t state_rx_gd;
	uint64_t state_rx_wr;
	uint64_t state_rx_wb;
	uint64_t state_swr;
	uint64_t state_ra;
	uint64_t state_ra_pl;
	uint64_t hw_version;
	uint64_t mac_config;
	uint64_t mac_frame_filter;
	uint64_t hash_table_high;
	uint64_t hash_table_low;
	uint64_t phy_addr;
	uint64_t phy_data;
	uint64_t control_frm;
	uint64_t vlan_tag;
	uint64_t mac_version;
	uint64_t wake_up_filter;
	uint64_t power_management;
	uint64_t mac_intr_stat;
	uint64_t mac_intr_mask;
	uint64_t mac_addr_0_high;
	uint64_t mac_addr_0_low;
	uint64_t rgmii_stat;
	uint64_t mmc_control;
	uint64_t mmc_intr_rx;
	uint64_t mmc_intr_tx;
	uint64_t mmc_intr_mask_rx;
	uint64_t mmc_intr_mask_tx;
#endif

	/* SMAC H/W statistics */
	uint64_t txoctetcount_gb;
	uint64_t txframecount_gb;
	uint64_t txbroadcastframes_g;
	uint64_t txmulticastframes_g;
	uint64_t tx64octets_gb;
	uint64_t tx65to127octets_gb;
	uint64_t tx128to255octets_gb;
	uint64_t tx256to511octets_gb;
	uint64_t tx512to1023octets_gb;
	uint64_t tx1024tomaxoctets_gb;
	uint64_t txunicastframes_gb;
	uint64_t txmulticastframes_gb;
	uint64_t txbroadcastframes_gb;
	uint64_t txunderflowerror;
	uint64_t txsinglecol_g;
	uint64_t txmulticol_g;
	uint64_t txdeferred;
	uint64_t txlatecol;
	uint64_t txexesscol;
	uint64_t txcarriererror;
	uint64_t txoctetcount_g;
	uint64_t txframecount_g;
	uint64_t txexcessdef;
	uint64_t txpauseframes;
	uint64_t txvlanframes_g;
	uint64_t rxframecount_gb;
	uint64_t rxoctetcount_gb;
	uint64_t rxoctetcount_g;
	uint64_t rxbroadcastframes_g;
	uint64_t rxmulticastframes_g;
	uint64_t rxcrcerror;
	uint64_t rxalignmenterror;
	uint64_t rxrunterror;
	uint64_t rxjabbererror;
	uint64_t rxundersize_g;
	uint64_t rxoversize_g;
	uint64_t rx64octets_gb;
	uint64_t rx65to127octets_gb;
	uint64_t rx128to255octets_gb;
	uint64_t rx256to511octets_gb;
	uint64_t rx512to1023octets_gb;
	uint64_t rx1024tomaxoctets_gb;
	uint64_t rxunicastframes_g;
	uint64_t rxlengtherror;
	uint64_t rxoutofrangetype;
	uint64_t rxpauseframes;
	uint64_t rxfifooverflow;
	uint64_t rxvlanframes_gb;
	uint64_t rxwatchdogerror;
	uint64_t rxipv4_gd_frms;
	uint64_t rxipv4_hdrerr_frms;
	uint64_t rxipv4_nopay_frms;
	uint64_t rxipv4_frag_frms;
	uint64_t rxipv4_udsbl_frms;
	uint64_t rxipv6_gd_frms;
	uint64_t rxipv6_hdrerr_frms;
	uint64_t rxipv6_nopay_frms;
	uint64_t rxudp_gd_frms;
	uint64_t rxudp_err_frms;
	uint64_t rxtcp_gd_frms;
	uint64_t rxtcp_err_frms;
	uint64_t rxicmp_gd_frms;
	uint64_t rxicmp_err_frms;
	uint64_t rxipv4_gd_octets;
	uint64_t rxipv4_hdrerr_octets;
	uint64_t rxipv4_nopay_octets;
	uint64_t rxipv4_frag_octets;
	uint64_t rxipv4_udsel_octets;
	uint64_t rxipv6_gd_octets;
	uint64_t rxipv6_hdrerr_octets;
	uint64_t rxipv6_nopay_octets;
	uint64_t rxudp_gd_octets;
	uint64_t rxudp_err_octets;
	uint64_t rxtcp_gd_octets;
	uint64_t rxtcp_err_octets;
	uint64_t rxicmp_gd_octets;
	uint64_t rxicmp_err_octets;
};


/* private data structure */
struct smac_adapter {
	struct timer_list watchdog_timer;	/* timer for check link status */
	uint32_t rx_buffer_len;			/* length of rx buffer */
	uint16_t link_speed;			/* transfer speed */
	uint16_t link_duplex;			/* duplex */
	unsigned char irq;			/* IRQ No. */
	spinlock_t stats_lock;			/* spinlock for net_stats */
	spinlock_t phy_lock;			/* spinlock for PHY access */

	/* tx */
	struct smac_tx_ring *tx_ring;		/* tx descriptor */
	unsigned int restart_queue;		/* # of call netif_wake_queue() */
	unsigned long tx_queue_len;		/* length of tx buffer */
	uint32_t tx_timeout_count;		/* # of reset tx */
	uint8_t tx_timeout_factor;		/* not used? */

	/* rx */
	struct smac_rx_ring *rx_ring;		/* rx descriptor */
#ifdef CONFIG_SMAC_ENABLE_NAPI
	struct napi_struct napi;
#endif
	boolean_t rx_csum;			/* checksum offload enable/disable */

	/* statistics */
	/* SMAC hw statistics */
	struct smac_hw_stats stats;		/* SMAC H/W register's value */
	/* SMAC driver statistics */
	unsigned int total_tx_bytes;		/* transfered bytes */
	unsigned int total_tx_packets;		/* transfered packets */
	unsigned int total_tx_dropped;		/* dropped tx packets */
	unsigned int total_rx_bytes;		/* received bytes */
	unsigned int total_rx_packets;		/* received packets */
	unsigned int total_rx_dropped;		/* dropped rx packets */
	struct work_struct reset_task;		/* work queue for reset */
	uint32_t hw_csum_err;			/* # of checksum error */
	uint32_t hw_csum_good;			/* # of checksum good */
	uint32_t alloc_rx_buff_failed;		/* # of failed allocate rx buffer */

	/* Receive Interrupt Delay */
	uint32_t rx_int_delay;			/* Receive Interrupt Delay */
	uint32_t rx_abs_int_delay;		/* Receive Absolute Interrupt Delay */

	/* Interrupt Throttle Number */
	uint32_t itnr;				/* value of setting SMAC_RX_FRAME_COUNT_LIMIT */
	uint32_t itnr_setting;			/* InterruptThrottleNum parameter */
	smac_latency_range_type current_itnr;	/* current latency range */

	/* SMAC H/W */
	uint8_t *hw_addr;			/* SMAC register base virtual address */
	unsigned long hw_addr_phys;		/* SMAC register base physical address */
	uint8_t *tx_desc_addr;			/* tx descriptor base virtual address */
	uint8_t *rx_desc_addr;			/* rx descriptor base virtual address */
	dma_addr_t tx_desc_addr_phys;		/* tx descriptor base physical address */
	dma_addr_t rx_desc_addr_phys;		/* rx descriptor base physical address */

	uint8_t mac_addr[6];			/* MAC address */

	/* auto-nego */
	uint8_t forced_speed_duplex;		/* force speed and duplex */
	boolean_t autoneg;			/* auto-nego enable/disable */
	uint16_t autoneg_advertised;		/* auto-neg advertised */

	/* flow control */
	smac_fc_type fc;			/* flow control */
	boolean_t fc_set_done;			/* done flow control setting */
	boolean_t fc_autoneg;			/* flow control auto-nego enable/disable */

	/* struct netdev */
	struct net_device *netdev;
	struct net_device_stats net_stats;	/* this driver's status */

	/* platform device */
	struct platform_device *pdev;

	/* platform data */
	struct smac_platform_data *platform_data;

	uint32_t flags;				/* status flag: assign smac_state_t bit */
	int msg_enable;				/* network interface message level */

	struct mii_if_info mii;			/* MII lib hooks/info */
};


/*------------------------------------------------------------------------------
  Function Prototype
  ------------------------------------------------------------------------------*/
void smac_reinit_locked(struct smac_adapter *adapter);
int smac_up(struct smac_adapter *adapter);
void smac_down(struct smac_adapter *adapter);
void smac_reset(struct smac_adapter *adapter);
void smac_update_stats(struct smac_adapter *adapter);

/* hardwear initialization */
int smac_map_base_address(struct smac_adapter *adapter);
void smac_unmap_base_address(struct smac_adapter *adapter);

/* MAC address accessor */
void smac_read_mac_addr(struct smac_adapter *adapter);
void smac_write_mac_addr(struct smac_adapter *adapter);

/* hardware accessor */
uint32_t smac_readreg(struct smac_adapter *adapter,unsigned long adr);
void smac_writereg(struct smac_adapter *adapter,unsigned long adr, uint32_t data);
int smac_mdio_read(struct net_device *dev, int phy_id, int location);
void smac_mdio_write(struct net_device *dev, int phy_id, int location, int val);
uint16_t smac_readphy(struct smac_adapter *adapter, uint16_t reg);
void smac_writephy(struct smac_adapter *adapter, uint16_t reg, uint16_t data);
uint32_t smac_read_desc(void* desc);
void smac_write_desc(uint32_t val, void* desc);
void smac_update_hw_stats(struct smac_adapter *adapter);

/* link configuration */
boolean_t smac_setup_link(struct smac_adapter *adapter);
boolean_t smac_config_fc_after_link_up(struct smac_adapter *adapter);
void smac_force_mac_fc(struct smac_adapter *adapter);

/* module param */
void __devinit smac_check_options(struct smac_adapter *adapter);
#ifdef CONFIG_SMAC_DBG
void __devinit smac_print_options(struct smac_adapter *adapter);
#else
#define smac_print_options(a)
#endif


#endif /* __SMAC_LOCAL_H__ */
