/*
 * File Name       : drivers/video/emxx/emxx_lcdhw_pmwlcd.c
 * Function        : PMWLCD Driver (H/W Control)
 * Release Version : Ver 1.18
 * Release Date    : 2013.02.14
 *
 * File Name       : drivers/video/emxx/emxx_lcdhw.c
 * Function        : LCD Driver (H/W Control)
 * Release Version : Ver 1.30
 * Release Date    : 2011.01.24
 *
 * Copyright (C) 2010, 2011 Renesas Electronics Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */


/********************************************************
 *  Definitions                                         *
 *******************************************************/
#define _DEBUG_LCDHW  0x00 /* 00008421(bit) */
			   /* 0x01: debug function in
			    * 0x02: debug function out
			    * 0x04: debug IMC
			    * 0x08: debug frame change
			    * 0x10: debug INTERLACE TB/BT
			    * 0x40: debug FBIOBLANK
			    * 0x80: debug PMWLCD
			    */


#define DEV_NAME "emxx_lcdhw_pmwlcd"

//#define DEBUG_PMWLCD_DUMMY

/********************************************************
 *  Macros                                              *
 *******************************************************/
#define printk_err(fmt, arg...) \
	do {                     \
		printk(KERN_ERR DEV_NAME "(%d): %s: " fmt, __LINE__, __func__, ## arg); \
	} while (0)

#define printk_wrn(fmt, arg...) \
	do {                     \
		printk(KERN_WARNING DEV_NAME "(%d): %s: " fmt, __LINE__, __func__, ## arg); \
	} while (0)

#define printk_info(fmt, arg...) \
	do {                      \
		printk(KERN_INFO DEV_NAME "(%d): %s: " fmt, __LINE__, __func__, ## arg); \
	} while (0)

#if _DEBUG_LCDHW
#define printk_dbg(level, fmt, arg...) \
	do {                            \
		if (level > 0) \
			printk(KERN_DEBUG DEV_NAME "(%d): %s: " fmt, \
			__LINE__, __func__, ## arg); \
	} while (0)
#else
#define printk_dbg(level, fmt, arg...) \
	;
#endif


/********************************************************
 *  Include Files                                       *
 *******************************************************/
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/version.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/delay.h>
#include <linux/platform_device.h>
#include <linux/io.h>
#include <linux/delay.h>
#include <linux/fb.h>
#include <linux/dmapool.h>

#include <asm/system.h>

#include <mach/irqs.h>
#include <mach/spi.h>
#ifdef CONFIG_MACH_EMEV
#include <mach/smu.h>
#endif
#include <mach/pmu.h>
#include <mach/hardware.h>
#include <mach/emxx_mem.h>

#include <mach/gpio.h>

#include <mach/imc.h>
#include <mach/emxx_imc.h>
#include "../../imc/emxx_imc.h"

#include <mach/pwm.h>

#include "lcdc.h"
#include "emxx_common.h"
#include "emxx_lcd_common.h"
#include "emxx_lcdhw.h"
#include "emxx_lcd.h"
#include "emxx_mod_pmwlcd.h"


/********************************************************
 *  IMC request structure                               *
 *******************************************************/
struct vsync_param {
	/* for struct emxx_imc_update_vsync */
	unsigned long			imc_cpubufsel;
	struct imc_wb_param		param_wb;
	unsigned long			imc_mirror;
	struct imc_alphasel_param	param_alphasel;
	unsigned long			imc_l0_scanmode;
	unsigned long			imc_l1a_scanmode;
	unsigned long			imc_l1b_scanmode;
	unsigned long			imc_l1c_scanmode;
	unsigned long			imc_l2a_scanmode;
	unsigned long			imc_l2b_scanmode;
	unsigned long			imc_bg_scanmode;
};

struct emxx_imc_param {
	struct emxx_imc_preset		imc_preset;
	struct emxx_imc_update_vsync	imc_vsync;
	struct emxx_imc_update_reserve	imc_reserve;

	/* for struct emxx_imc_preset */
	unsigned long			imc_control;
	unsigned long			imc_datareq;
	struct imc_gamma_param		param_gamma;
	struct imc_yuv_param		param_yuv;
	struct imc_burst_param		param_burst;

	/* for struct emxx_imc_update_vsync */
	struct vsync_param		param_vsync;

	/* for struct emxx_imc_update_reserve */
	struct l01_param		param_l0;
	struct l01_param		param_l1a;
	struct l01_param		param_l1b;
	struct l01_param		param_l1c;
	struct l2_param			param_l2a;
	struct l2_param			param_l2b;
	struct bg_param			param_bg;

	imc_callback_func_refresh	callback_refresh;
	imc_callback_func_wb		callback_wb;
};

       struct emxx_imc_info           imc_info;
static struct emxx_imc_param          *imc_param;
static struct emxx_imc_preset         *imc_preset;
static struct emxx_imc_update_vsync   *imc_vsync;
static struct emxx_imc_update_reserve *imc_reserve;

       struct l01_param			fb_layer;
       struct l2_param			v4l2_layer;
       struct emxx_imc_update_vsync	ImcNxtVsync;
       struct vsync_param		ImcNxtVsync_Param;


/********************************************************
 * IMC register initialize                              *
 *******************************************************/
#define IMC_CONTROL_INIT		0x00000000
#define IMC_REFRESH_INIT		0x00000000
#define IMC_DATAREQ_INIT		0x00000100

#define IMC_CPUBUFSEL_INIT		0x00000000

#define IMC_GAMMA_EN_INIT		0x00000000
#define IMC_GAMMA_ADR_INIT		0x00000000

#define IMC_WB_AREAADR_P_INIT		0x00000000
#define IMC_WB_HOFFSET_INIT		0x00000000
#define IMC_WB_FORMAT_INIT		0x00000000
#define IMC_WB_SIZE_INIT		0x00000000
#define IMC_WB_AREAADR_Q_INIT		0x00000000
#define IMC_WB_BUFSEL_INIT		0x00000000
#define IMC_WB_MPOSITION_INIT		0x00000000
#define IMC_WB_MSIZE_INIT		0x00000000
#define IMC_BACKCOLOR_INIT		0x00000000
#define IMC_WB_BYTELANE_INIT		0x0000C600
//#define IMC_WB_SCANMODE_INIT		0x00000001
#define IMC_WB_SCANMODE_INIT		0x00000000	/* ★Progressive */

#define IMC_MIRROR_INIT			0x00000000

#define IMC_YGAINOFFSET_INIT		0x00000080
#define IMC_UGAINOFFSET_INIT		0x00000080
#define IMC_VGAINOFFSET_INIT		0x00000080
#define IMC_YUV2RGB_INIT		0x00000000
#define IMC_COEF_R0_INIT		0x00000000
#define IMC_COEF_R1_INIT		0x00000000
#define IMC_COEF_R2_INIT		0x00000000
#define IMC_COEF_R3_INIT		0x00000000
#define IMC_COEF_G0_INIT		0x00000000
#define IMC_COEF_G1_INIT		0x00000000
#define IMC_COEF_G2_INIT		0x00000000
#define IMC_COEF_G3_INIT		0x00000000
#define IMC_COEF_B0_INIT		0x00000000
#define IMC_COEF_B1_INIT		0x00000000
#define IMC_COEF_B2_INIT		0x00000000
#define IMC_COEF_B3_INIT		0x00000000

#define IMC_ALPHASEL0_INIT		0x00000000
#define IMC_ALPHASEL1_INIT		0x00000000

#define IMC_BURST_EN_INIT		0x00000101
#define IMC_THRESHOLD_INIT		0x00001010

#define IMC_L0_CONTROL_INIT		0x00000000
#define IMC_L0_FORMAT_INIT		0x00000000
#define IMC_L0_BUFSEL_INIT		0x00000000
#define IMC_L0_BYTELANE_INIT		0x0000E400
#define IMC_L0_KEYENABLE_INIT		0x00000000
#define IMC_L0_KEYCOLOR_INIT		0x00000000
#define IMC_L0_ALPHA_INIT		0x00000000
#define IMC_L0_RESIZE_INIT		0x00000000
#define IMC_L0_MIRROR_INIT		0x00000000
#define IMC_L0_OFFSET_INIT		0x00000000
#define IMC_L0_FRAMEADR_P_INIT		0x00000000
#define IMC_L0_FRAMEADR_Q_INIT		0x00000000
#define IMC_L0_POSITION_INIT		0x00000000
#define IMC_L0_SIZE_INIT		0x00000000
#define IMC_L0_MPOSITION_INIT		0x00000000
#define IMC_L0_MSIZE_INIT		0x00000000
//#define IMC_L0_SCANMODE_INIT		0x00000001
#define IMC_L0_SCANMODE_INIT		0x00000000	/* ★Progressive */

#define IMC_L1A_CONTROL_INIT		0x00000000
#define IMC_L1A_FORMAT_INIT		0x00000000
#define IMC_L1A_BUFSEL_INIT		0x00000000
#define IMC_L1A_BYTELANE_INIT		0x0000E400
#define IMC_L1A_KEYENABLE_INIT		0x00000000
#define IMC_L1A_KEYCOLOR_INIT		0x00000000
#define IMC_L1A_ALPHA_INIT		0x00000000
#define IMC_L1A_RESIZE_INIT		0x00000000
#define IMC_L1A_MIRROR_INIT		0x00000000
#define IMC_L1A_OFFSET_INIT		0x00000000
#define IMC_L1A_FRAMEADR_P_INIT		0x00000000
#define IMC_L1A_FRAMEADR_Q_INIT		0x00000000
#define IMC_L1A_POSITION_INIT		0x00000000
#define IMC_L1A_SIZE_INIT		0x00000000
#define IMC_L1A_MPOSITION_INIT		0x00000000
#define IMC_L1A_MSIZE_INIT		0x00000000
//#define IMC_L1A_SCANMODE_INIT		0x00000001
#define IMC_L1A_SCANMODE_INIT		0x00000000	/* ★Progressive */

#define IMC_L1B_CONTROL_INIT		0x00000000
#define IMC_L1B_FORMAT_INIT		0x00000000
#define IMC_L1B_BUFSEL_INIT		0x00000000
#define IMC_L1B_BYTELANE_INIT		0x0000E400
#define IMC_L1B_KEYENABLE_INIT		0x00000000
#define IMC_L1B_KEYCOLOR_INIT		0x00000000
#define IMC_L1B_ALPHA_INIT		0x00000000
#define IMC_L1B_RESIZE_INIT		0x00000000
#define IMC_L1B_MIRROR_INIT		0x00000000
#define IMC_L1B_OFFSET_INIT		0x00000000
#define IMC_L1B_FRAMEADR_P_INIT		0x00000000
#define IMC_L1B_FRAMEADR_Q_INIT		0x00000000
#define IMC_L1B_POSITION_INIT		0x00000000
#define IMC_L1B_SIZE_INIT		0x00000000
#define IMC_L1B_MPOSITION_INIT		0x00000000
#define IMC_L1B_MSIZE_INIT		0x00000000
//#define IMC_L1B_SCANMODE_INIT		0x00000001
#define IMC_L1B_SCANMODE_INIT		0x00000000	/* ★Progressive */

#define IMC_L1C_CONTROL_INIT		0x00000000
#define IMC_L1C_FORMAT_INIT		0x00000000
#define IMC_L1C_BUFSEL_INIT		0x00000000
#define IMC_L1C_BYTELANE_INIT		0x0000E400
#define IMC_L1C_KEYENABLE_INIT		0x00000000
#define IMC_L1C_KEYCOLOR_INIT		0x00000000
#define IMC_L1C_ALPHA_INIT		0x00000000
#define IMC_L1C_RESIZE_INIT		0x00000000
#define IMC_L1C_MIRROR_INIT		0x00000000
#define IMC_L1C_OFFSET_INIT		0x00000000
#define IMC_L1C_FRAMEADR_P_INIT		0x00000000
#define IMC_L1C_FRAMEADR_Q_INIT		0x00000000
#define IMC_L1C_POSITION_INIT		0x00000000
#define IMC_L1C_SIZE_INIT		0x00000000
#define IMC_L1C_MPOSITION_INIT		0x00000000
#define IMC_L1C_MSIZE_INIT		0x00000000
//#define IMC_L1C_SCANMODE_INIT		0x00000001
#define IMC_L1C_SCANMODE_INIT		0x00000000	/* ★Progressive */

#define IMC_L2A_CONTROL_INIT		0x00000000
#define IMC_L2A_FORMAT_INIT		0x00000000
#define IMC_L2A_BUFSEL_INIT		0x00000000
#define IMC_L2A_BYTELANE_INIT		0x0000E4E4
#define IMC_L2A_RESIZE_INIT		0x00000000
#define IMC_L2A_MIRROR_INIT		0x00000000
#define IMC_L2A_OFFSET_INIT		0x00000000
#define IMC_L2A_FRAMEADR_YP_INIT	0x00000000
#define IMC_L2A_FRAMEADR_UP_INIT	0x00000000
#define IMC_L2A_FRAMEADR_VP_INIT	0x00000000
#define IMC_L2A_FRAMEADR_YQ_INIT	0x00000000
#define IMC_L2A_FRAMEADR_UQ_INIT	0x00000000
#define IMC_L2A_FRAMEADR_VQ_INIT	0x00000000
#define IMC_L2A_POSITION_INIT		0x00000000
#define IMC_L2A_SIZE_INIT		0x00000000
#define IMC_L2A_MPOSITION_INIT		0x00000000
#define IMC_L2A_MSIZE_INIT		0x00000000
//#define IMC_L2A_SCANMODE_INIT		0x00000001
#define IMC_L2A_SCANMODE_INIT		0x00000000	/* ★Progressive */

#define IMC_L2B_CONTROL_INIT		0x00000000
#define IMC_L2B_FORMAT_INIT		0x00000000
#define IMC_L2B_BUFSEL_INIT		0x00000000
#define IMC_L2B_BYTELANE_INIT		0x0000E4E4
#define IMC_L2B_RESIZE_INIT		0x00000000
#define IMC_L2B_MIRROR_INIT		0x00000000
#define IMC_L2B_OFFSET_INIT		0x00000000
#define IMC_L2B_FRAMEADR_YP_INIT	0x00000000
#define IMC_L2B_FRAMEADR_UP_INIT	0x00000000
#define IMC_L2B_FRAMEADR_VP_INIT	0x00000000
#define IMC_L2B_FRAMEADR_YQ_INIT	0x00000000
#define IMC_L2B_FRAMEADR_UQ_INIT	0x00000000
#define IMC_L2B_FRAMEADR_VQ_INIT	0x00000000
#define IMC_L2B_POSITION_INIT		0x00000000
#define IMC_L2B_SIZE_INIT		0x00000000
#define IMC_L2B_MPOSITION_INIT		0x00000000
#define IMC_L2B_MSIZE_INIT		0x00000000
//#define IMC_L2B_SCANMODE_INIT		0x00000001
#define IMC_L2B_SCANMODE_INIT		0x00000000	/* ★Progressive */

#define IMC_BG_FORMAT_INIT		0x00000000
#define IMC_BG_BUFSEL_INIT		0x00000000
#define IMC_BG_BYTELANE_INIT		0x0000E400
#define IMC_BG_RESIZE_INIT		0x00000000
#define IMC_BG_MIRROR_INIT		0x00000000
#define IMC_BG_OFFSET_INIT		0x00000000
#define IMC_BG_FRAMEADR_P_INIT		0x00000000
#define IMC_BG_FRAMEADR_Q_INIT		0x00000000
#define IMC_BG_MPOSITION_INIT		0x00000000
#define IMC_BG_MSIZE_INIT		0x00000000
//#define IMC_BG_SCANMODE_INIT		0x00000001
#define IMC_BG_SCANMODE_INIT		0x00000000	/* ★Progressive */


/********************************************************
 * LCDC register initialize                             *
 *******************************************************/
#if 0
/* Control for LCDC      : YUV output */
#define LCD_CONTROL_INIT	(LCD_OUT_SEL_YUV | LCD_PI_SEL_INTERLACE)
#else
/* Control for LCDC      : RGB output */
//#define LCD_CONTROL_INIT	(LCD_PI_SEL_INTERLACE)
#define LCD_CONTROL_INIT	(LCD_PI_SEL_PROGRESSIVE)	/* ★Progressive */
#endif

/* Input Format select   : RGB888 input  */
#define LCD_IFORMAT_INIT	LCD_IFORMAT_RGB888

#define LCD_QOS_INIT		0x00000180
#define LCD_DATAREQ_INIT	0x00000001
/* Access Bus Select             : Local Bus         */
#define LCD_BUSSEL_UPDATE	LCD_BUSSEL_LOCAL
/* Access Bus Select             : Black Only        */
#define LCD_BUSSEL_INIT		LCD_BUSSEL_BLACK
#ifdef CONFIG_EMXX_LCD_FRAMECACHE
/* AREA Address for Frame Buffer :                       */
#define LCD_AREAADR_ODD_INIT	FRAMEBUF_START
#define LCD_AREAADR_EVEN_INIT	(FRAMEBUF_START + FRAMEBUF_LENGTH / 2)
#else /* CONFIG_EMXX_LCD_FRAMECACHE */
/* AREA Address for Frame Buffer :                       */
#define LCD_AREAADR_ODD_INIT	0x00000000
#define LCD_AREAADR_EVEN_INIT	0x00000000
#endif /* CONFIG_EMXX_LCD_FRAMECACHE */
#define LCD_BACKCOL_INIT \
 (0x00 << LCD_BGRED_SFT | 0x00 << LCD_BGGREEN_SFT | 0x00 << LCD_BGBLUE_SFT)

#define LCD_COEF_Y0_INIT	0x002F	/*!<   47 */
#define LCD_COEF_Y1_INIT	0x009D	/*!<  157 */
#define LCD_COEF_Y2_INIT	0x0010	/*!<   16 */
#define LCD_COEF_Y3_INIT	0x0010	/*!<   16 */
#define LCD_COEF_U0_INIT	0x07E6	/*!<  -26 */
#define LCD_COEF_U1_INIT	0x07A9	/*!<  -87 */
#define LCD_COEF_U2_INIT	0x0070	/*!<  112 */
#define LCD_COEF_U3_INIT	0x0080	/*!<  128 */
#define LCD_COEF_V0_INIT	0x0070	/*!<  112 */
#define LCD_COEF_V1_INIT	0x079A	/*!< -102 */
#define LCD_COEF_V2_INIT	0x07F6	/*!<  -10 */
#define LCD_COEF_V3_INIT	0x0080	/*!<  128 */
#define LCD_BYTELANE_INIT	0x008D


/********************************************************
 * LCD Module initialize command                        *
 *******************************************************/
#define LCDM_SPI_ADDR_MODULEID	0xFF	/*!< Module-ID */
#define LCDM_SPI_ADDR_USERFUNC	0xFE	/*!< ユーザ調整機能 */
#define LCDM_SPI_ADDR_DEVFUNC	0xFD	/*!< Device別制御機能 */

#define LCDM_SPI_CMD_WRITE	0x00	/*!< Write Access */
#define LCDM_SPI_CMD_READ	0x01	/*!< Read Access */

/* SPIパラメタフォーマット定義 */
typedef union lcdm_spi_param_t {
	/* 1byte固定 */
	unsigned char	byteif;
	
	/* Module-ID */
	struct module_t {
		unsigned int	moduleid	:4;	/*!< [0-3] Module-ID */
		unsigned int	devinfo		:4;	/*!< [4-7] Device-Info */
		#define LCDM_PARAM_MODULEID_MAX		(1<<4)
	} module;
	
	/* ユーザ調整機能 */
	struct userfunc_t {
		unsigned int	flip_v		:1;	/*!< [0-0] 上下反転表示 0:正転 1:反転 */
		unsigned int	flip_h		:1;	/*!< [1-1] 左右反転表示 0:正転 1:反転 */
		unsigned int	framerate	:2;	/*!< [2-3] フレーム周波数 0:60Hz 1:50Hz */
		unsigned int	reserved	:3;	/*!< [4-6] (reserved) */
		unsigned int	on		:1;	/*!< [7-7] 常に1 */
	} userfunc;
	
	/* SPI通信フォーマット定義: Device別制御機能(Device-Info = 0) */
	struct devfunc0_t {
		unsigned char	reserved;		/*!< [0-7] (reserved) */
	} devfunc0;
	/* SPI通信フォーマット定義: Device別制御機能(Device-Info = 1) */
	struct devfunc1_t {
		unsigned int	dimension	:1;	/*!< [0-0] 0:2D 1:3D */
		unsigned int	sidebyside	:1;	/*!< [1-1] 0:OFF 1:ON */
		unsigned int	reserved	:6;	/*!< [2-7] (reserved) */
	} devfunc1;
}lcdm_spi_param_t;

/**
 * GPIOを使って操作するパネルインタフェース
 */
#define LCDM_GIO_VFON		GPIO_P114	/*!< [IN]  L:電源OFF状態 H:電源ON状態  */
#define LCDM_GIO_DOWN		GPIO_P121	/*!< [OUT] L:電源ON制御  H:電源OFF制御 */

#define LCDM_GIODATA_DOWN_PWRON		0	/*!< 電源ON制御  */
#define LCDM_GIODATA_DOWN_PWROFF	1	/*!< 電源OFF制御 */

#define LCDM_GIODATA_VFON_PWRON		1	/*!< 電源ON状態  */
#define LCDM_GIODATA_VFON_PWROFF	0	/*!< 電源OFF状態 */

/**
 * SPI通信用バッファインデックス
 */
#define LCDM_SPI_INDEX_DATA	0	/*!< 転送データ位置:コマンド */
#define LCDM_SPI_INDEX_ADDR	1	/*!< 転送データ位置:アドレス */
#if 0
#define LCDM_SPI_TRANSIZE	5	/*!< SPI転送サイズ */
#else
#define LCDM_SPI_TRANSIZE	2	/*!< SPI転送サイズ */
#endif
#define LCDM_SPI_DIR_READ	1	/*!< SPI転送方向読み込み */
#define LCDM_SPI_DIR_WRITE	2	/*!< SPI転送方向書き込み */

typedef enum {
	PMWLLCD_REG_PA3_01	= 0x00,
	PMWLLCD_REG_PA3_02,
	PMWLLCD_REG_PA3_03,
	PMWLLCD_REG_PA3_04,
	PMWLLCD_REG_PA3_05,
	PMWLLCD_REG_PA3_11,
	PMWLLCD_REG_PA3_12,
	PMWLLCD_REG_PA3_13,
	PMWLLCD_REG_PA3_14,
	PMWLLCD_REG_PA3_15,
	PMWLLCD_REG_PA3_16,
	PMWLLCD_REG_PA3_17,
	PMWLLCD_REG_PA3_18,
	PMWLLCD_REG_PA3_19,
	PMWLLCD_REG_PA3_1A,
	PMWLLCD_REG_PA3_1B,
	PMWLLCD_REG_PA3_1C,
	PMWLLCD_REG_PA3_21,
	PMWLLCD_REG_PA3_22,
	PMWLLCD_REG_PA3_23,
	PMWLLCD_REG_PA3_24,
	PMWLLCD_REG_PA3_25,
	PMWLLCD_REG_PA3_26,
	PMWLLCD_REG_PA3_27,
	PMWLLCD_REG_PA3_28,
	PMWLLCD_REG_PA3_29,
	PMWLLCD_REG_PA3_2A,
	PMWLLCD_REG_PA3_2B,
	PMWLLCD_REG_PA3_2C,
	PMWLLCD_REG_PA3_2D,
	PMWLLCD_REG_PA3_31,
	PMWLLCD_REG_PA3_32,
	PMWLLCD_REG_PA3_33,
	PMWLLCD_REG_PA3_34,
	PMWLLCD_REG_PA3_35,
	PMWLLCD_REG_PA3_36,
	PMWLLCD_REG_PA3_37,
	PMWLLCD_REG_PA3_38,
	PMWLLCD_REG_PA3_39,
	PMWLLCD_REG_PA3_3A,
	PMWLLCD_REG_PA3_3B,
	PMWLLCD_REG_PA3_3C,
	PMWLLCD_REG_PA2_01,
	PMWLLCD_REG_PA2_02,
	PMWLLCD_REG_PA2_03,
	PMWLLCD_REG_PA2_04,
	PMWLLCD_REG_PA2_05,
	PMWLLCD_REG_P00_01,
	PMWLLCD_REG_P00_02,
	PMWLLCD_REG_P00_03,
	PMWLLCD_REG_P00_04,
	PMWLLCD_REG_P00_05,
	PMWLLCD_REG_P00_0C,
	PMWLLCD_REG_P00_0D,
	PMWLLCD_REG_P00_0E,
	PMWLLCD_REG_P00_0F,
	PMWLLCD_REG_P00_17,
	PMWLLCD_REG_P00_18,
	PMWLLCD_REG_P00_19,
	PMWLLCD_REG_P00_1A,
	PMWLLCD_REG_P00_1C,
	PMWLLCD_REG_P00_1D,
	PMWLLCD_REG_P00_2B,
	PMWLLCD_REG_P00_44,
	PMWLLCD_REG_P00_45,
	PMWLLCD_REG_P00_51,
	PMWLLCD_REG_P00_53,
	PMWLLCD_REG_P00_55,
	PMWLLCD_REG_P00_59,
	PMWLLCD_REG_P00_5A,
	PMWLLCD_REG_P00_5B,
	PMWLLCD_REG_P00_5C,
	PMWLLCD_REG_P00_5D,
	PMWLLCD_REG_P00_5E,
	PMWLLCD_REG_P00_8A,
	PMWLLCD_REG_P00_8B,
	PMWLLCD_REG_P00_8C,
	PMWLLCD_REG_PFF_81,
	PMWLLCD_REG_PFF_82,
	PMWLLCD_REG_PC5_81,
	PMWLLCD_REG_PCA_B1,
	PMWLCD_REG_NUM,
} pmwlcd_reg_t;

typedef struct {
	pmwlcd_reg_t  reg;
	unsigned char data ;
} lcdreg_val;

static const lcdreg_val lcdset_val[] =
{
	{ PMWLLCD_REG_PA3_01, 0x09 },
	{ PMWLLCD_REG_PA3_02, 0xb8 },
	{ PMWLLCD_REG_PA3_03, 0x10 },
	{ PMWLLCD_REG_PA3_04, 0x25 },
	{ PMWLLCD_REG_PA3_05, 0x02 },
	{ PMWLLCD_REG_PA3_11, 0x15 },
	{ PMWLLCD_REG_PA3_12, 0x00 },
	{ PMWLLCD_REG_PA3_13, 0x00 },
	{ PMWLLCD_REG_PA3_14, 0x00 },
	{ PMWLLCD_REG_PA3_15, 0x00 },
	{ PMWLLCD_REG_PA3_16, 0x00 },
	{ PMWLLCD_REG_PA3_17, 0x00 },
	{ PMWLLCD_REG_PA3_18, 0x00 },
	{ PMWLLCD_REG_PA3_19, 0x00 },
	{ PMWLLCD_REG_PA3_1A, 0x00 },
	{ PMWLLCD_REG_PA3_1B, 0x00 },
	{ PMWLLCD_REG_PA3_1C, 0x00 },
	{ PMWLLCD_REG_PA3_21, 0x86 },
	{ PMWLLCD_REG_PA3_22, 0xff },
	{ PMWLLCD_REG_PA3_23, 0x59 },
	{ PMWLLCD_REG_PA3_24, 0x31 },
	{ PMWLLCD_REG_PA3_25, 0x18 },
	{ PMWLLCD_REG_PA3_26, 0x08 },
	{ PMWLLCD_REG_PA3_27, 0xe0 },
	{ PMWLLCD_REG_PA3_28, 0x00 },
	{ PMWLLCD_REG_PA3_29, 0x48 },
	{ PMWLLCD_REG_PA3_2A, 0x72 },
	{ PMWLLCD_REG_PA3_2B, 0xc0 },
	{ PMWLLCD_REG_PA3_2C, 0x55 },
	{ PMWLLCD_REG_PA3_2D, 0x86 },
	{ PMWLLCD_REG_PA3_31, 0xf3 },
	{ PMWLLCD_REG_PA3_32, 0x08 },
	{ PMWLLCD_REG_PA3_33, 0x20 },
	{ PMWLLCD_REG_PA3_34, 0x40 },
	{ PMWLLCD_REG_PA3_35, 0xff },
	{ PMWLLCD_REG_PA3_36, 0x00 },
	{ PMWLLCD_REG_PA3_37, 0xc0 },
	{ PMWLLCD_REG_PA3_38, 0x30 },
	{ PMWLLCD_REG_PA3_39, 0x00 },
	{ PMWLLCD_REG_PA3_3A, 0xff },
	{ PMWLLCD_REG_PA3_3B, 0x00 },
	{ PMWLLCD_REG_PA3_3C, 0xff },

	{ PMWLLCD_REG_PA2_01, 0x00 },
	{ PMWLLCD_REG_PA2_02, 0x00 },
	{ PMWLLCD_REG_PA2_03, 0x00 },
	{ PMWLLCD_REG_PA2_04, 0x00 },
	{ PMWLLCD_REG_PA2_05, 0x00 },

	{ PMWLLCD_REG_P00_03, 0x01 },
	{ PMWLLCD_REG_P00_04, 0x40 },
	{ PMWLLCD_REG_P00_05, 0x14 },
	{ PMWLLCD_REG_P00_0C, 0x00 },
	{ PMWLLCD_REG_P00_0D, 0x40 },
	{ PMWLLCD_REG_P00_0E, 0x40 },
	{ PMWLLCD_REG_P00_0F, 0x40 },
	{ PMWLLCD_REG_P00_17, 0x00 },
	{ PMWLLCD_REG_P00_18, 0x00 },
	{ PMWLLCD_REG_P00_19, 0x95 },
	{ PMWLLCD_REG_P00_1A, 0x51 },
	{ PMWLLCD_REG_P00_1C, 0x00 },
	{ PMWLLCD_REG_P00_1D, 0x06 },
	{ PMWLLCD_REG_P00_2B, 0x01 },
	{ PMWLLCD_REG_P00_44, 0x00 },
	{ PMWLLCD_REG_P00_45, 0x50 },
	{ PMWLLCD_REG_P00_51, 0x00 },
	{ PMWLLCD_REG_P00_53, 0x24 },
	{ PMWLLCD_REG_P00_55, 0x14 },
	{ PMWLLCD_REG_P00_59, 0x00 },
	{ PMWLLCD_REG_P00_5A, 0x00 },
	{ PMWLLCD_REG_P00_5B, 0x00 },
	{ PMWLLCD_REG_P00_5C, 0x00 },
	{ PMWLLCD_REG_P00_5D, 0x01 },
	{ PMWLLCD_REG_P00_5E, 0x00 },
	{ PMWLLCD_REG_P00_8A, 0x00 },
	{ PMWLLCD_REG_P00_8B, 0x3f },
	{ PMWLLCD_REG_P00_8C, 0x00 },

	{ PMWLLCD_REG_PFF_81, 0x58 },
	{ PMWLLCD_REG_PFF_82, 0x01 },

	{ PMWLLCD_REG_PC5_81, 0x94 },

	{ PMWLLCD_REG_PCA_B1, 0x02 },
};
#define LCD_SET_SIZE		(sizeof(lcdset_val)/sizeof(lcdreg_val))

static const lcdreg_val lcd_reset[] =
{ 
	{ PMWLLCD_REG_P00_02, 0x00 },
};
#define LCD_RESET_SIZE		(sizeof(lcd_reset)/sizeof(lcdreg_val))

static const lcdreg_val lcd_stb[] =
{
	{ PMWLLCD_REG_P00_01, 0x00 },
	{ PMWLLCD_REG_P00_01, 0x01 }
};
#define LCD_STB_SIZE		(sizeof(lcd_stb)/sizeof(lcdreg_val))

#define LCD_REG_SET_NUM	13

static const lcdreg_val lcdset_reg[LCDM_PARAM_BRIGHTNESS_NUM][LCD_REG_SET_NUM] =
{
	{	/* Very Low */
		{ PMWLLCD_REG_P00_51, 0x36 },
		{ PMWLLCD_REG_PA3_21, 0x86 },
		{ PMWLLCD_REG_PA3_22, 0xFF },
		{ PMWLLCD_REG_PA3_2B, 0xC0 },
		{ PMWLLCD_REG_PA3_2C, 0x55 },
		{ PMWLLCD_REG_PA3_01, 0x09 },
		{ PMWLLCD_REG_PA3_29, 0x48 },
		{ PMWLLCD_REG_PA3_2A, 0x72 },
		{ PMWLLCD_REG_PA3_2D, 0x86 },
		{ PMWLLCD_REG_PA3_11, 0x00 },
		{ PMWLLCD_REG_PA3_12, 0x10 },
		{ PMWLLCD_REG_PA3_13, 0x10 },
		{ PMWLLCD_REG_PA3_14, 0x10 }
	},
	{	/* Low */
		{ PMWLLCD_REG_P00_51, 0x3F },
		{ PMWLLCD_REG_PA3_21, 0x86 },
		{ PMWLLCD_REG_PA3_22, 0xFF },
		{ PMWLLCD_REG_PA3_2B, 0xC0 },
		{ PMWLLCD_REG_PA3_2C, 0x55 },
		{ PMWLLCD_REG_PA3_01, 0x09 },
		{ PMWLLCD_REG_PA3_29, 0x48 },
		{ PMWLLCD_REG_PA3_2A, 0x72 },
		{ PMWLLCD_REG_PA3_2D, 0x86 },
		{ PMWLLCD_REG_PA3_11, 0x15 },
		{ PMWLLCD_REG_PA3_12, 0x00 },
		{ PMWLLCD_REG_PA3_13, 0x00 },
		{ PMWLLCD_REG_PA3_14, 0x00 }
	},
	{	/* Mid */
		{ PMWLLCD_REG_P00_51, 0x7F },
		{ PMWLLCD_REG_PA3_21, 0x86 },
		{ PMWLLCD_REG_PA3_22, 0xFF },
		{ PMWLLCD_REG_PA3_2B, 0xC0 },
		{ PMWLLCD_REG_PA3_2C, 0x55 },
		{ PMWLLCD_REG_PA3_01, 0x09 },
		{ PMWLLCD_REG_PA3_29, 0x48 },
		{ PMWLLCD_REG_PA3_2A, 0x72 },
		{ PMWLLCD_REG_PA3_2D, 0x86 },
		{ PMWLLCD_REG_PA3_11, 0x15 },
		{ PMWLLCD_REG_PA3_12, 0x00 },
		{ PMWLLCD_REG_PA3_13, 0x00 },
		{ PMWLLCD_REG_PA3_14, 0x00 }
	},
	{	/* High */
		{ PMWLLCD_REG_P00_51, 0xFF },
		{ PMWLLCD_REG_PA3_21, 0x86 },
		{ PMWLLCD_REG_PA3_22, 0xFF },
		{ PMWLLCD_REG_PA3_2B, 0xC0 },
		{ PMWLLCD_REG_PA3_2C, 0x55 },
		{ PMWLLCD_REG_PA3_01, 0x09 },
		{ PMWLLCD_REG_PA3_29, 0x48 },
		{ PMWLLCD_REG_PA3_2A, 0x72 },
		{ PMWLLCD_REG_PA3_2D, 0x86 },
		{ PMWLLCD_REG_PA3_11, 0x15 },
		{ PMWLLCD_REG_PA3_12, 0x00 },
		{ PMWLLCD_REG_PA3_13, 0x00 },
		{ PMWLLCD_REG_PA3_14, 0x00 }
	}
};

static uint8_t s_sha_page	= 0x00;
static uint8_t s_sha_pa3_01	= 0x09;
static uint8_t s_sha_pa3_02	= 0x76;
static uint8_t s_sha_pa3_03	= 0x10;
static uint8_t s_sha_pa3_04	= 0x25;
static uint8_t s_sha_pa3_05	= 0x02;
static uint8_t s_sha_pa3_11	= 0x15;
static uint8_t s_sha_pa3_12	= 0x00;
static uint8_t s_sha_pa3_13	= 0x00;
static uint8_t s_sha_pa3_14	= 0x00;
static uint8_t s_sha_pa3_15	= 0x00;
static uint8_t s_sha_pa3_16	= 0x00;
static uint8_t s_sha_pa3_17	= 0x00;
static uint8_t s_sha_pa3_18	= 0x00;
static uint8_t s_sha_pa3_19	= 0x00;
static uint8_t s_sha_pa3_1a	= 0x00;
static uint8_t s_sha_pa3_1b	= 0x00;
static uint8_t s_sha_pa3_1c	= 0x00;
static uint8_t s_sha_pa3_21	= 0x80;
static uint8_t s_sha_pa3_22	= 0xff;
static uint8_t s_sha_pa3_23	= 0x80;
static uint8_t s_sha_pa3_24	= 0x31;
static uint8_t s_sha_pa3_25	= 0x18;
static uint8_t s_sha_pa3_26	= 0x48;
static uint8_t s_sha_pa3_27	= 0xe0;
static uint8_t s_sha_pa3_28	= 0x80;
static uint8_t s_sha_pa3_29	= 0x68;
static uint8_t s_sha_pa3_2a	= 0xf2;
static uint8_t s_sha_pa3_2b	= 0xc0;
static uint8_t s_sha_pa3_2c	= 0x55;
static uint8_t s_sha_pa3_2d	= 0x80;
static uint8_t s_sha_pa3_31	= 0x93;
static uint8_t s_sha_pa3_32	= 0x04;
static uint8_t s_sha_pa3_33	= 0x20;
static uint8_t s_sha_pa3_34	= 0x40;
static uint8_t s_sha_pa3_35	= 0xff;
static uint8_t s_sha_pa3_36	= 0x00;
static uint8_t s_sha_pa3_37	= 0x80;
static uint8_t s_sha_pa3_38	= 0x31;
static uint8_t s_sha_pa3_39	= 0x00;
static uint8_t s_sha_pa3_3a	= 0xff;
static uint8_t s_sha_pa3_3b	= 0x00;
static uint8_t s_sha_pa3_3c	= 0xff;
static uint8_t s_sha_pa2_01	= 0x00;
static uint8_t s_sha_pa2_02	= 0x00;
static uint8_t s_sha_pa2_03	= 0x00;
static uint8_t s_sha_pa2_04	= 0x00;
static uint8_t s_sha_pa2_05	= 0x00;
static uint8_t s_sha_p00_01	= 0x00;
static uint8_t s_sha_p00_02	= 0x10;
static uint8_t s_sha_p00_03	= 0x00;
static uint8_t s_sha_p00_04	= 0x40;
static uint8_t s_sha_p00_05	= 0x14;
static uint8_t s_sha_p00_0c	= 0x00;
static uint8_t s_sha_p00_0d	= 0x40;
static uint8_t s_sha_p00_0e	= 0x40;
static uint8_t s_sha_p00_0f	= 0x40;
static uint8_t s_sha_p00_17	= 0x00;
static uint8_t s_sha_p00_18	= 0x00;
static uint8_t s_sha_p00_19	= 0x15;
static uint8_t s_sha_p00_1a	= 0x51;
static uint8_t s_sha_p00_1c	= 0x00;
static uint8_t s_sha_p00_1d	= 0x06;
static uint8_t s_sha_p00_2b	= 0x01;
static uint8_t s_sha_p00_44	= 0x00;
static uint8_t s_sha_p00_45	= 0x50;
static uint8_t s_sha_p00_51	= 0x00;
static uint8_t s_sha_p00_53	= 0x00;
static uint8_t s_sha_p00_55	= 0x14;
static uint8_t s_sha_p00_59	= 0x00;
static uint8_t s_sha_p00_5a	= 0x00;
static uint8_t s_sha_p00_5b	= 0x00;
static uint8_t s_sha_p00_5c	= 0x00;
static uint8_t s_sha_p00_5d	= 0x01;
static uint8_t s_sha_p00_5e	= 0x00;
static uint8_t s_sha_p00_8a	= 0x00;
static uint8_t s_sha_p00_8b	= 0x3f;
static uint8_t s_sha_p00_8c	= 0x00;
static uint8_t s_sha_pff_81	= 0x00;
static uint8_t s_sha_pff_82	= 0x00;
static uint8_t s_sha_pc5_81	= 0x14;
static uint8_t s_sha_pca_b1	= 0x03;

static uint8_t s_set_page_1st = 0;	/* 0: not 1st, 1: 1st */

typedef struct {
	uint8_t *data;		/* shadowのアドレス   */
	uint8_t page_addr;	/* ページのアドレス   */
	uint8_t reg_addr;	/* レジスタのアドレス */
	uint8_t refresh;	/* refresh実施フラグ  */
} emxx_spi_info_t;

#define PMWLCD_PAGE_ADDR	0xFD
#define PMWLCD_PAGE_00		0x00
#define PMWLCD_PAGE_A3		0xA3
#define PMWLCD_PAGE_A2		0xA2
#define PMWLCD_PAGE_FF		0xFF
#define PMWLCD_PAGE_C5		0xC5
#define PMWLCD_PAGE_CA		0xCA
#define PMWLCD_REFRESH_START	PMWLLCD_REG_PA3_01
#define PMWLCD_REFRESH_END		PMWLLCD_REG_PCA_B1

#define PMWLCD_REFRESH_ON   1
#define PMWLCD_REFRESH_OFF  0

static emxx_spi_info_t s_emxx_reg_info[PMWLCD_REG_NUM] = {
                          /* uint8_t *data, uint8_t page_addr, uint8_t reg_addr, uint8_t refresh    */
    [PMWLLCD_REG_PA3_01] = { &s_sha_pa3_01, PMWLCD_PAGE_A3,    0x01,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_02] = { &s_sha_pa3_02, PMWLCD_PAGE_A3,    0x02,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_03] = { &s_sha_pa3_03, PMWLCD_PAGE_A3,    0x03,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_04] = { &s_sha_pa3_04, PMWLCD_PAGE_A3,    0x04,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_05] = { &s_sha_pa3_05, PMWLCD_PAGE_A3,    0x05,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_11] = { &s_sha_pa3_11, PMWLCD_PAGE_A3,    0x11,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_12] = { &s_sha_pa3_12, PMWLCD_PAGE_A3,    0x12,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_13] = { &s_sha_pa3_13, PMWLCD_PAGE_A3,    0x13,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_14] = { &s_sha_pa3_14, PMWLCD_PAGE_A3,    0x14,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_15] = { &s_sha_pa3_15, PMWLCD_PAGE_A3,    0x15,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_16] = { &s_sha_pa3_16, PMWLCD_PAGE_A3,    0x16,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_17] = { &s_sha_pa3_17, PMWLCD_PAGE_A3,    0x17,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_18] = { &s_sha_pa3_18, PMWLCD_PAGE_A3,    0x18,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_19] = { &s_sha_pa3_19, PMWLCD_PAGE_A3,    0x19,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_1A] = { &s_sha_pa3_1a, PMWLCD_PAGE_A3,    0x1A,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_1B] = { &s_sha_pa3_1b, PMWLCD_PAGE_A3,    0x1B,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_1C] = { &s_sha_pa3_1c, PMWLCD_PAGE_A3,    0x1C,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_21] = { &s_sha_pa3_21, PMWLCD_PAGE_A3,    0x21,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_22] = { &s_sha_pa3_22, PMWLCD_PAGE_A3,    0x22,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_23] = { &s_sha_pa3_23, PMWLCD_PAGE_A3,    0x23,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_24] = { &s_sha_pa3_24, PMWLCD_PAGE_A3,    0x24,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_25] = { &s_sha_pa3_25, PMWLCD_PAGE_A3,    0x25,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_26] = { &s_sha_pa3_26, PMWLCD_PAGE_A3,    0x26,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_27] = { &s_sha_pa3_27, PMWLCD_PAGE_A3,    0x27,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_28] = { &s_sha_pa3_28, PMWLCD_PAGE_A3,    0x28,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_29] = { &s_sha_pa3_29, PMWLCD_PAGE_A3,    0x29,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_2A] = { &s_sha_pa3_2a, PMWLCD_PAGE_A3,    0x2A,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_2B] = { &s_sha_pa3_2b, PMWLCD_PAGE_A3,    0x2B,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_2C] = { &s_sha_pa3_2c, PMWLCD_PAGE_A3,    0x2C,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_2D] = { &s_sha_pa3_2d, PMWLCD_PAGE_A3,    0x2D,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_31] = { &s_sha_pa3_31, PMWLCD_PAGE_A3,    0x31,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_32] = { &s_sha_pa3_32, PMWLCD_PAGE_A3,    0x32,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_33] = { &s_sha_pa3_33, PMWLCD_PAGE_A3,    0x33,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_34] = { &s_sha_pa3_34, PMWLCD_PAGE_A3,    0x34,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_35] = { &s_sha_pa3_35, PMWLCD_PAGE_A3,    0x35,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_36] = { &s_sha_pa3_36, PMWLCD_PAGE_A3,    0x36,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_37] = { &s_sha_pa3_37, PMWLCD_PAGE_A3,    0x37,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_38] = { &s_sha_pa3_38, PMWLCD_PAGE_A3,    0x38,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_39] = { &s_sha_pa3_39, PMWLCD_PAGE_A3,    0x39,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_3A] = { &s_sha_pa3_3a, PMWLCD_PAGE_A3,    0x3A,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_3B] = { &s_sha_pa3_3b, PMWLCD_PAGE_A3,    0x3B,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA3_3C] = { &s_sha_pa3_3c, PMWLCD_PAGE_A3,    0x3C,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA2_01] = { &s_sha_pa2_01, PMWLCD_PAGE_A2,    0x01,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA2_02] = { &s_sha_pa2_02, PMWLCD_PAGE_A2,    0x02,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA2_03] = { &s_sha_pa2_03, PMWLCD_PAGE_A2,    0x03,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA2_04] = { &s_sha_pa2_04, PMWLCD_PAGE_A2,    0x04,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PA2_05] = { &s_sha_pa2_05, PMWLCD_PAGE_A2,    0x05,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_01] = { &s_sha_p00_01, PMWLCD_PAGE_00,    0x01,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_02] = { &s_sha_p00_02, PMWLCD_PAGE_00,    0x02,             PMWLCD_REFRESH_OFF },
    [PMWLLCD_REG_P00_03] = { &s_sha_p00_03, PMWLCD_PAGE_00,    0x03,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_04] = { &s_sha_p00_04, PMWLCD_PAGE_00,    0x04,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_05] = { &s_sha_p00_05, PMWLCD_PAGE_00,    0x05,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_0C] = { &s_sha_p00_0c, PMWLCD_PAGE_00,    0x0C,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_0D] = { &s_sha_p00_0d, PMWLCD_PAGE_00,    0x0D,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_0E] = { &s_sha_p00_0e, PMWLCD_PAGE_00,    0x0E,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_0F] = { &s_sha_p00_0f, PMWLCD_PAGE_00,    0x0F,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_17] = { &s_sha_p00_17, PMWLCD_PAGE_00,    0x17,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_18] = { &s_sha_p00_18, PMWLCD_PAGE_00,    0x18,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_19] = { &s_sha_p00_19, PMWLCD_PAGE_00,    0x19,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_1A] = { &s_sha_p00_1a, PMWLCD_PAGE_00,    0x1A,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_1C] = { &s_sha_p00_1c, PMWLCD_PAGE_00,    0x1C,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_1D] = { &s_sha_p00_1d, PMWLCD_PAGE_00,    0x1D,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_2B] = { &s_sha_p00_2b, PMWLCD_PAGE_00,    0x2B,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_44] = { &s_sha_p00_44, PMWLCD_PAGE_00,    0x44,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_45] = { &s_sha_p00_45, PMWLCD_PAGE_00,    0x45,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_51] = { &s_sha_p00_51, PMWLCD_PAGE_00,    0x51,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_53] = { &s_sha_p00_53, PMWLCD_PAGE_00,    0x53,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_55] = { &s_sha_p00_55, PMWLCD_PAGE_00,    0x55,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_59] = { &s_sha_p00_59, PMWLCD_PAGE_00,    0x59,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_5A] = { &s_sha_p00_5a, PMWLCD_PAGE_00,    0x5A,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_5B] = { &s_sha_p00_5b, PMWLCD_PAGE_00,    0x5B,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_5C] = { &s_sha_p00_5c, PMWLCD_PAGE_00,    0x5C,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_5D] = { &s_sha_p00_5d, PMWLCD_PAGE_00,    0x5D,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_5E] = { &s_sha_p00_5e, PMWLCD_PAGE_00,    0x5E,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_8A] = { &s_sha_p00_8a, PMWLCD_PAGE_00,    0x8A,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_8B] = { &s_sha_p00_8b, PMWLCD_PAGE_00,    0x8B,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_P00_8C] = { &s_sha_p00_8c, PMWLCD_PAGE_00,    0x8C,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PFF_81] = { &s_sha_pff_81, PMWLCD_PAGE_FF,    0x81,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PFF_82] = { &s_sha_pff_82, PMWLCD_PAGE_FF,    0x82,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PC5_81] = { &s_sha_pc5_81, PMWLCD_PAGE_C5,    0x81,             PMWLCD_REFRESH_ON  },
    [PMWLLCD_REG_PCA_B1] = { &s_sha_pca_b1, PMWLCD_PAGE_CA,    0xB1,             PMWLCD_REFRESH_ON  },
};

#define	PMWLCD_SW_RESX_WAIT_MSEC		(10)	/* wait time after SW_RESX */
#define	PMWLCD_SW_STB_WAIT_MSEC			(10)	/* wait time after SW_STB */
#define	PMWLCD_PON_WAIT_MSEC			(200)	/* wait time after power on */
#define	PMWLCD_PON_RETRY_WAIT_MSEC		(10)	/* wait time before retry power on */
#define	PMWLCD_PON_RETRY_MAX			(10)	/* power on retry count max */
#define	PMWLCD_LCDOUT_WAIT_MSEC			(10)	/* wait time after lcdout */
#define	PMWLCD_PON_SEQ_RETRY_WAIT_MSEC	(200)	/* wait time before retry power on sequence */
#define	PMWLCD_PON_SEQ_RETRY_MAX		(3)		/* power on sequence retry count max */

/********************************************************
 *  Variables                                           *
 *******************************************************/
       int init_is_first   = 1;
#ifdef CONFIG_EMXX_LCD_FRAMECACHE
       int direct_path     = 0;
       int direct_reserved = 0;
#endif /* CONFIG_EMXX_LCD_FRAMECACHE */
       enum EMXX_FB_OUTPUT_MODE lcdc_output_mode = EMXX_FB_OUTPUT_MODE_LCD;
       int lcd_field = FIELD_NONE;
       int refresh_reserved = 0;

/**
 * lcdhw初期化完了フラグ
 * init_lcdhw()呼び出し成功後に1となる
 */
static enum LCDHW_STATUS st_lcdhw_status = LCDHW_STATUS_NOT_INITIALIZED;

/**
 * 電源操作シーケンス排他制御用(mutex)
 */
static DEFINE_MUTEX(s_lcd_pwr_mtx);

/**
 * SPI通信シーケンス排他制御用(mutex)
 */
static DEFINE_MUTEX(s_lcd_spi_mtx);

/********************************************************
 *  Prototype declarations of local function            *
 *******************************************************/
/*
 * LCD Driver (H/W)
 */

/* ------------------ LCD initialize function ------------------------------ */
static inline void   change_pinsel_hdmi(void);
static inline void   change_pinsel_pmwlcd(void);
static inline void   unreset_lcdc(void);
static inline void   unreset_usi3(void);
static void          lcd_hw_init(void);
static void          lcd_hw_start_black(int moduleid);
static void          lcd_controller_hw_init(void);
static inline void   lcd_controller_hw_init_lcdsize(void);

/* ------------------ LCD module initialize function ----------------------- */
static void          lcd_module_hw_unreset(void);
static void          lcd_module_hw_reset(void);
static void          lcd_module_hw_request_gpio(void);
static void          lcd_module_hw_free_gpio(void);
static int           lcd_module_hw_power_on(void);
static int           lcd_module_hw_power_on_pmwlcd(void);
static int           lcd_module_hw_power_off(void);
static int           lcd_module_hw_power_off_pmwlcd(void);
static int           lcd_module_hw_spi_read(unsigned char addr, unsigned char *data);
static int           lcd_module_hw_spi_write(unsigned char addr, unsigned char data);
static int           lcd_module_hw_spi_xfer(unsigned char *wbuf, unsigned char *rbuf,
						unsigned char *dirs, unsigned int count);
static int           lcd_module_hw_disp_on(void);
static int           lcd_module_hw_detect_module(lcdm_param_module_t *param);
static int			 lcd_hw_spi_register_set(pmwlcd_reg_t addr, unsigned char data);

/* ------------------ IMC initialize function ------------------------------ */
static int           imc_hw_init(void);

static void         *imc_hw_init_preset_gamma(
 struct imc_gamma_param *param_gamma);
static void         *imc_hw_init_preset_yuv(struct imc_yuv_param *param_yuv);
static void         *imc_hw_init_preset_burst(
 struct imc_burst_param *param_burst);
static void         *imc_hw_init_vsync_wb(struct imc_wb_param *param_wb);
static void         *imc_hw_init_vsync_alphasel(struct imc_alphasel_param *
						param_alphasel);
static void         *imc_hw_init_reserve_l0(struct l01_param *param_l0);
static void         *imc_hw_init_reserve_l1a(struct l01_param *param_l1a);
static void         *imc_hw_init_reserve_l1b(struct l01_param *param_l1b);
static void         *imc_hw_init_reserve_l1c(struct l01_param *param_l1c);
static void         *imc_hw_init_reserve_l2a(struct l2_param *param_l2a);
static void         *imc_hw_init_reserve_l2b(struct l2_param *param_l2b);
static void         *imc_hw_init_reserve_bg(struct bg_param *param_bg);



/* ------------------ inline function -------------------------------------- */
inline void chk_errno(int errno, char **cnum)
{
	switch (errno) {
	case ENODEV:
		*cnum = "ENODEV";
		break;
	case EINVAL:
		*cnum = "EINVAL";
		break;
	case EPERM:
		*cnum = "EPERM";
		break;
	case EIO:
		*cnum = "EIO";
		break;
	case EAGAIN:
		*cnum = "EAGAIN";
		break;
	default:
		*cnum = "****";
		break;
	}
}

/**
 * ビットオーダー変更
 */
static inline int reverse_bit(int data, int len)
{
	int i, reversed;
	
	reversed = 0;
	for (i = 0; i < len; i++) {
		reversed <<= 1;
		reversed |= ((data & (1 << i)) ? 1 : 0);
	}
	return reversed;
}


/* ------------------ LCD control function --------------------------------- */
/******************************************************************************
* MODULE   : change_output
* FUNCTION : change LCDC output
* RETURN   : 0 : success
* NOTE     : none
******************************************************************************/
int change_output(enum EMXX_FB_OUTPUT_MODE old_mode,
 enum EMXX_FB_OUTPUT_MODE new_mode)
{
	unsigned long imc_wb_scanmode = 0;
	unsigned long imc_wb_bytelane = IMC_WB_BYTELANE_INIT;

	unsigned int harea = 0, hpulse = 0, hfrontp = 0, hbackp = 0;
	unsigned int varea = 0, vpulse = 0, vfrontp = 0, vbackp = 0;

	lcdm_input_timing_t input_timing;

	//########## LCDHW排他開始 ##########
	lcdhw_power_mutex_lock();

	lcd_hw_backlight_off();
	lcd_module_hw_standby();
	lcd_module_hw_power_off();
	lcd_hw_stop();
	lcd_module_hw_reset();

	refresh_reserved = 0;

	lcdc_output_mode = new_mode;
	switch (lcdc_output_mode) {
	default:
	case EMXX_FB_OUTPUT_MODE_LCD:
		lcdm_param_get_timing(&input_timing);
		harea	= input_timing.harea;
		hpulse	= input_timing.hpulse;
		hfrontp	= input_timing.hfrontp;
		hbackp	= input_timing.hbackp;
		varea	= input_timing.varea * 2;
		vpulse	= input_timing.vpulse;
		vfrontp	= input_timing.vfrontp;
		vbackp	= input_timing.vbackp;
		imc_wb_scanmode  = IMC_WB_SCANMODE_INTERLACED;
		imc_wb_bytelane  = IMC_WB_BYTELANE_ABGR;
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_1080I:
		harea	= HAREA_1080I;
		hpulse	= HPULSE_1080I;
		hfrontp	= HFRONTP_1080I;
		hbackp	= HBACKP_1080I;
		varea	= VAREA_1080I;
		vpulse	= VPULSE_1080I;
		vfrontp	= VFRONTP_1080I;
		vbackp	= VBACKP_1080I;
		imc_wb_scanmode  = IMC_WB_SCANMODE_INTERLACED;
		imc_wb_bytelane  = IMC_WB_BYTELANE_ARGB;
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_720P:
		harea	= HAREA_720P;
		hpulse	= HPULSE_720P;
		hfrontp	= HFRONTP_720P;
		hbackp	= HBACKP_720P;
		varea	= VAREA_720P;
		vpulse	= VPULSE_720P;
		vfrontp	= VFRONTP_720P;
		vbackp	= VBACKP_720P;
		imc_wb_scanmode  = IMC_WB_SCANMODE_PROGRESSIVE;
		imc_wb_bytelane  = IMC_WB_BYTELANE_ARGB;
		break;
	}

	switch (lcdc_output_mode) {
	default:
	case EMXX_FB_OUTPUT_MODE_LCD:
		/* PMWLCD */
		change_pinsel_pmwlcd();
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_1080I:
	case EMXX_FB_OUTPUT_MODE_HDMI_720P:
		/* HDMI */
		change_pinsel_hdmi();
		unreset_usi3();
		break;
	}

#ifdef CONFIG_EMXX_LCD_FRAMECACHE
	direct_path = 0;
	direct_reserved = 0;
#endif /* CONFIG_EMXX_LCD_FRAMECACHE */
	lcd_controller_hw_init();

	lcd_module_hw_unreset();
	lcd_module_hw_power_on();

	lcd_controller_hw_init_lcdsize();

	ImcNxtVsync.wb->hoffset  = harea * BITS_PER_PIXEL / 8;
	ImcNxtVsync.wb->size     = (harea << IMC_WB_HSIZE_SFT) |
				   (varea << IMC_WB_VSIZE_SFT);
	ImcNxtVsync.wb->scanmode = imc_wb_scanmode;
	ImcNxtVsync.wb->bytelane = imc_wb_bytelane;

	if (imc_hw_set_update_vsync(&ImcNxtVsync))
		printk_wrn("IMC update_vsync() failed.\n");

	if (blank_state.lcd_output == 1) {
		lcd_hw_start();
		lcd_module_hw_wakeup();
	}
	if (blank_state.lcd_backlight == 1)
		lcd_hw_backlight_on();

	//########## LCDHW排他終了 ##########
	lcdhw_power_mutex_unlock();

	return 0;
}


/******************************************************************************
* MODULE   : change_frame
* FUNCTION : change LCD display page
* RETURN   : 0 : success
* NOTE     : none
******************************************************************************/
int change_frame(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

#ifdef CONFIG_EMXX_LCD_FRAMECACHE
	direct_path = 0;
	direct_reserved = 0;
#endif /* CONFIG_EMXX_LCD_FRAMECACHE */
	if ((lcdc_output_mode == EMXX_FB_OUTPUT_MODE_LCD) ||
	     (blank_state.lcd_backlight != 0))
		writel(LCD_BUSSEL_UPDATE,  LCDCMmioV + LCD_BUSSEL);

	return 0;
}


/******************************************************************************
* MODULE   : init_lcdhw
* FUNCTION : LCD(H/W) initialized
* RETURN   : 0     : success
*            other : fail
* NOTE     : none
******************************************************************************/
int init_lcdhw(void)
{
	int result = 0;
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	//########## LCDHW排他開始 ##########
	lcdhw_power_mutex_lock();

	/* initialize check */
	if (LCDHW_STATUS_INITIALIZED == st_lcdhw_status) {
		printk_info("already initialized.\n");
		result = 0;
		goto ERR_UNLOCK;
	}

#ifdef CONFIG_EMXX_LCD_FRAMECACHE
	save_ckrqmode = readl(SMU_CKRQ_MODE);
#endif /* CONFIG_EMXX_LCD_FRAMECACHE */

	/* initialize static parameters */
	imc_param   = NULL;
	imc_preset  = NULL;
	imc_vsync   = NULL;
	imc_reserve = NULL;

	/* LCDC initialize              */
	lcd_hw_init();

	/* UnReset IMC */
	imc_hw_unreset(IMC_CH0);

	/* install LCDC irq handler     */
	if (request_irq(INT_LCD, lcd_irq_handler, 0, DEV_NAME, NULL)) {
		printk_err("fail in request_irq(INT_LCD)\n");
		result = LCD_INIT_ERROR__LCD_IRQ_NOT_REQUEST;
		goto ERR_UNLOCK;
	}

	/* GPIO request */
	lcd_module_hw_request_gpio();

	/* LCDC register initialize     */
	lcd_controller_hw_init();

	/* LCD Module unreset           */
	lcd_module_hw_unreset();

	/* LCD Module power on          */
	result = lcd_module_hw_power_on();
	if (result) {
		printk_err("fail in LCD module initialize\n");
		result = LCD_INIT_ERROR__LCDM_INIT;
		goto ERR_FREE_GPIO;
	}

	/* lcd display size set         */
	lcd_controller_hw_init_lcdsize();

	/* IMC initialize               */
	if (imc_hw_init()) {
		printk_err("fail in IMC initialize\n");
		result = LCD_INIT_ERROR__IMC_INIT;
		goto ERR_FREE_GPIO;
	}

	/* LCDC start                   */
	lcd_hw_start();

	/* LCD Module wake up           */
	lcd_module_hw_wakeup();

	/* BackLight on                 */
	lcd_hw_backlight_on();

	/* init_lcdhw success           */
	st_lcdhw_status = LCDHW_STATUS_INITIALIZED;

	//########## LCDHW排他終了 ##########
	lcdhw_power_mutex_unlock();

	/* Clear LCD Initialize Error */
	lcdm_event_set_value(LCDM_EVENT_INITERR, LCDM_OFF);

	return 0;

ERR_FREE_GPIO:
	lcd_module_hw_free_gpio();
//ERR_FREE_IRQ:
	free_irq(INT_LCD, NULL);
ERR_UNLOCK:
	//########## LCDHW排他終了 ##########
	lcdhw_power_mutex_unlock();

	if (0 != result) {
		/* Set LCD Initialize Error */
		lcdm_event_set_value(LCDM_EVENT_INITERR, LCDM_ON);
	}

	return result;
}


/******************************************************************************
* MODULE   : exit_lcdhw
* FUNCTION : LCD(H/W) initialized
* RETURN   : none
* NOTE     : none
******************************************************************************/
void exit_lcdhw(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	//########## LCDHW排他開始 ##########
	lcdhw_power_mutex_lock();

	lcd_hw_backlight_off();
	lcd_module_hw_standby();
	lcd_module_hw_power_off();
	lcd_hw_stop();
	lcd_module_hw_reset();

	lcd_module_hw_free_gpio();

	free_irq(INT_LCD, NULL);

	lcd_hw_reset();

	st_lcdhw_status = LCDHW_STATUS_NOT_INITIALIZED;

	//########## LCDHW排他終了 ##########
	lcdhw_power_mutex_unlock();
}


/*******************************************************************************
 * @brief	lcdhw初期化完了フラグ取得
 *
 * @param	なし
 *
 * @retval	LCDHW_STATUS_NOT_INITIALIZED	lcdhw初期化未実施
 * @retval	LCDHW_STATUS_INITIALIZED	lcdhw初期化完了
 *******************************************************************************/
enum LCDHW_STATUS get_lcdhw_status(void)
{
	return st_lcdhw_status;
}

/* ------------------ LCDHW exclusion control function --------------------- */
/*******************************************************************************
 * @brief	lcdhw電源操作排他ロック取得
 *
 * @param	なし
 *
 * @return	なし
 *******************************************************************************/
void lcdhw_power_mutex_lock(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), ">>>>>\n");
	mutex_lock(&s_lcd_pwr_mtx);
}


/*******************************************************************************
 * @brief	lcdhw電源操作排他ロック解放
 *
 * @param	なし
 *
 * @return	なし
 *******************************************************************************/
void lcdhw_power_mutex_unlock(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "<<<<<\n");
	mutex_unlock(&s_lcd_pwr_mtx);
}


/* ------------------ LCD H/W control function ----------------------------- */
/********************************************************
 *  save/restore Function Definitions                   *
 *******************************************************/
/******************************************************************************
* MODULE   : lcd_hw_save_reg
* FUNCTION : save LCD(H/W) register data
* RETURN   : 0     : success
* NOTE     : none
******************************************************************************/
void lcd_hw_save_reg(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
}


/******************************************************************************
* MODULE   : lcd_hw_restore_reg
* FUNCTION : restore LCD(H/W) register data
* RETURN   : 0     : success
* NOTE     : none
******************************************************************************/
void lcd_hw_restore_reg(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	/* restore LCD framebuffer address */
	lcd_controller_hw_init();

	/* init LCD size */
	lcd_controller_hw_init_lcdsize();
}


/******************************************************************************
* MODULE   : lcd_hw_start
* FUNCTION : start LCD(H/W)
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_hw_start(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	printk_dbg((_DEBUG_LCDHW & 0x40), "<start LCDOUT>\n");

	/* enable auto frequency control */
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
	if ((system_rev & EMXX_REV_MASK) < EMXX_REV_ES2) {
#endif
	/* unmask LCD (bit0=0) */
	LCD_FIFO_REQ_UNMASK;
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
	}
#endif

	writel(LCD_LCDOUT_START, LCDCMmioV + LCD_LCDOUT);
}


/*******************************************************************************
 * @brief	固定黒画像出力開始
 *
 * @oaram[in]	moduleid	出力解像度を決めるModule-ID
 *
 * @return	なし
 *******************************************************************************/
static void lcd_hw_start_black(int moduleid)
{
	lcdm_param_module_t	param_module;

	// 指定したModule-IDを一旦保存する
	// 以降のレジスタ初期化は保存したModule-IDの解像度で行われる
	memset(&param_module, 0, sizeof(param_module));
	param_module.moduleid = moduleid;
	lcdm_param_set_module(&param_module);
	
	// 出力を一旦停止する
	lcd_hw_stop();
	
	// LCDCレジスタを初期化する
	lcd_controller_hw_init_lcdsize();
	
	// 黒画像設定
	writel(LCD_BUSSEL_BLACK, LCDCMmioV + LCD_BUSSEL);
	
	// 出力開始
	lcd_hw_start();
}


/******************************************************************************
* MODULE   : lcd_hw_stop
* FUNCTION : stop LCD(H/W)
* RETURN   : 0     : success
* NOTE     : none
******************************************************************************/
void lcd_hw_stop(void)
{
	unsigned long ulRegVal32;
	int wait_max = 40;
	int wait_cnt = 0;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	printk_dbg((_DEBUG_LCDHW & 0x40), "<stop LCDOUT>\n");
	writel(LCD_LCDOUT_STOP, LCDCMmioV + LCD_LCDOUT);

	/* wait for LCD disp off (max 40ms) */
	do {
		ulRegVal32 = lcd_hw_chk_int_rawstatus();
		if (ulRegVal32 & LCD_LCDSTOP_BIT) {
			printk_dbg((_DEBUG_LCDHW & 0x01), "wait(%dms)\n",
			 wait_cnt);
			wait_cnt = wait_max;
		} else {
			if (wait_cnt < wait_max)
				mdelay(1);
		}
		wait_cnt++;
	} while (wait_cnt <= wait_max);

	/* wait for IMC stopped */
	imc_hw_wait_stop(IMC_CH0);

	/* disable auto frequency control */
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
	if ((system_rev & EMXX_REV_MASK) < EMXX_REV_ES2) {
#endif
	/* mask LCD (bit0=1) */
	LCD_FIFO_REQ_MASK;
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
	}
#endif

	refresh_reserved = 0;
	lcd_field = FIELD_NONE;
}


/******************************************************************************
* MODULE   : lcd_hw_reset
* FUNCTION : LCD(H/W) reset
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_hw_reset(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	printk_dbg((_DEBUG_LCDHW & 0x40), "<reset and close clockgate>\n");

	/* Reset LCD */
	emxx_clkctrl_off(EMXX_CLKCTRL_LCD);
	emxx_clkctrl_off(EMXX_CLKCTRL_LCDC);
	emxx_clkctrl_off(EMXX_CLKCTRL_LCDPCLK);
	emxx_reset_device(EMXX_RST_LCD_A | EMXX_RST_LCD);
	emxx_close_clockgate(EMXX_CLK_LCD_C | EMXX_CLK_LCD_L | EMXX_CLK_LCD_P |
	 EMXX_CLK_LCD);
}


/******************************************************************************
* MODULE   : lcd_hw_unreset
* FUNCTION : LCD(H/W) unreset
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_hw_unreset(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	printk_dbg((_DEBUG_LCDHW & 0x40), "<open clockgate and unreset>\n");

	/* UnReset LCD */
	emxx_open_clockgate(EMXX_CLK_LCD_C | EMXX_CLK_LCD_L | EMXX_CLK_LCD_P |
	 EMXX_CLK_LCD);
	emxx_clkctrl_off(EMXX_CLKCTRL_LCD);
	emxx_clkctrl_off(EMXX_CLKCTRL_LCDC);
	emxx_clkctrl_off(EMXX_CLKCTRL_LCDPCLK);
	emxx_unreset_device(EMXX_RST_LCD_A | EMXX_RST_LCD);
	emxx_clkctrl_on(EMXX_CLKCTRL_LCD);
	emxx_clkctrl_on(EMXX_CLKCTRL_LCDC);
	emxx_clkctrl_on(EMXX_CLKCTRL_LCDPCLK);
}


/*******************************************************************************
 * @brief	タイミング関連情報更新
 *
 * @oaram	なし
 *
 * @return	なし
 *******************************************************************************/
void lcd_hw_update_timing(void)
{
	unsigned long status = 0;

	// 現在の表示状態を保持
	status = lcd_hw_chk_status();
	if (status & LCD_STATUS_ON) {
		lcd_hw_stop();
	}

	// LCDCタイミング関連情報更新
	lcd_controller_hw_init_lcdsize();

	// 表示状態を元に戻す
	if (status & LCD_STATUS_ON) {
		lcd_hw_start();
	}
}


/*******************************************************************************
 * @brief	サイズ関連情報更新
 *
 * @oaram	なし
 *
 * @return	なし
 *******************************************************************************/
void lcd_hw_update_size(void)
{
	unsigned long imc_wb_scanmode = 0;
	unsigned long imc_wb_bytelane = IMC_WB_BYTELANE_INIT;
	unsigned int harea = 0, varea = 0;
	unsigned long status = 0;
	lcdm_input_timing_t input_timing;

	// 現在のサイズを取得
	switch (lcdc_output_mode) {
	default:
	case EMXX_FB_OUTPUT_MODE_LCD:
		lcdm_param_get_timing(&input_timing);
		harea	= input_timing.harea;
		varea	= input_timing.varea * 2;
		imc_wb_scanmode  = IMC_WB_SCANMODE_INTERLACED;
		imc_wb_bytelane  = IMC_WB_BYTELANE_ABGR;
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_1080I:
		harea	= HAREA_1080I;
		varea	= VAREA_1080I;
		imc_wb_scanmode  = IMC_WB_SCANMODE_INTERLACED;
		imc_wb_bytelane  = IMC_WB_BYTELANE_ARGB;
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_720P:
		harea	= HAREA_720P;
		varea	= VAREA_720P;
		imc_wb_scanmode  = IMC_WB_SCANMODE_PROGRESSIVE;
		imc_wb_bytelane  = IMC_WB_BYTELANE_ARGB;
		break;
	}

	// 現在の表示状態を保持
	status = lcd_hw_chk_status();
	if (status & LCD_STATUS_ON) {
		lcd_hw_stop();
	}

	// LCDCサイズ反映
	lcd_controller_hw_init_lcdsize();

	// IMCサイズ反映
	ImcNxtVsync.wb->hoffset  = harea * BITS_PER_PIXEL / 8;
	ImcNxtVsync.wb->size     = (harea << IMC_WB_HSIZE_SFT) |
				   (varea << IMC_WB_VSIZE_SFT);
	ImcNxtVsync.wb->scanmode = imc_wb_scanmode;
	ImcNxtVsync.wb->bytelane = imc_wb_bytelane;

	if (imc_hw_set_update_vsync(&ImcNxtVsync)) {
		printk_wrn("IMC update_vsync() failed - 2.\n");
	}

	// 表示状態を元に戻す
	if (status & LCD_STATUS_ON) {
		lcd_hw_start();
	}
}


/******************************************************************************
* MODULE   : lcd_hw_backlight_off
* FUNCTION : LCD(H/W) backlight control(off)
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_hw_backlight_off(void)
{
#if 0
	if (lcdc_output_mode == EMXX_FB_OUTPUT_MODE_LCD) {
		printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
		printk_dbg((_DEBUG_LCDHW & 0x40), "<backlight Off>\n");
#ifdef CONFIG_EMXX_PWC
		/* LED1_EN:OFF LED1_RAMP:OFF LED2_EN:OFF LED2_RAMP:OFF */
		pwc_write(DA9052_LEDCONT_REG, 0x00, 0x0f);
		/* BOOST_EN:OFF LED1_IN_EN:OFF LED2_IN_EN:OFF */
		pwc_write(DA9052_BOOST_REG, 0x00, 0x07);
#endif

	}
#endif
	// バックライト輝度を0にする
	lcd_hw_backlight_adjust(0);

	return;
}


/******************************************************************************
* MODULE   : lcd_hw_backlight_on
* FUNCTION : LCD(H/W) backlight control(on)
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_hw_backlight_on(void)
{
#if 0
	unsigned int brightness = 0;
	
	if (lcdc_output_mode == EMXX_FB_OUTPUT_MODE_LCD) {
		printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
		printk_dbg((_DEBUG_LCDHW & 0x40), "<backlight On>\n");
//		mdelay(110);
#ifdef CONFIG_EMXX_PWC
		/* BOOST_EN:ON LED1_IN_EN:ON LED2_IN_EN:ON */
		pwc_write(DA9052_BOOST_REG, 0x07, 0x07);
		 /* LED1_EN:ON LED1_RAMP:ON LED2_EN:ON LED2_RAMP:ON */
		pwc_write(DA9052_LEDCONT_REG, 0x0f, 0x0f);
#endif

		// 現在保持されているバックライト輝度取得
		lcdm_param_get_brightness(&brightness);
		
		// バックライト輝度設定
		lcd_hw_backlight_adjust(brightness);
	}
#endif
	return;
}


#if (_DEBUG_LCDHW & 0x80)
static unsigned int s_dbg_wk_counter = 0;
static unsigned long s_dbg_wk_jiffies = 0;
void pwm_callback_count(void *data, int intsts, int intrawsts)
{
	s_dbg_wk_counter++;
	if (50*1000 == s_dbg_wk_counter) {
		unsigned long diff_jiffies = ((jiffies - s_dbg_wk_jiffies) * 1000 / HZ);
		printk_dbg((_DEBUG_LCDHW & 0x80), 
			"PWM: 50k clock counted. it takes %lu msec\n", diff_jiffies);
		s_dbg_wk_jiffies = jiffies;
		s_dbg_wk_counter = 0;
	}
}
#endif

//2MHzを元に算出した3クロック分の時間: 1クロック500nsなので2us空けておく
#define PWM_DELAY4RESTART_US	(2)
/*******************************************************************************
 * @brief	LCDM-バックライト輝度調整
 *
 * @oaram[in]	brightness	バックライト輝度
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_hw_backlight_adjust(unsigned int brightness)
{
#if 1
	int result = 0;
	int loop_cnt = 0;
	
	if(brightness <= LCDM_PARAM_BRIGHTNESS_MAX) {
		// reg設定
		for(loop_cnt = 0; loop_cnt < LCD_REG_SET_NUM; loop_cnt++) {
			result = lcd_hw_spi_register_set(lcdset_reg[brightness][loop_cnt].reg, lcdset_reg[brightness][loop_cnt].data);
			if(result != 0) {
				printk_err("error: result=%d, reg=0x%02X, data=0x%02X\n", result, lcdset_reg[brightness][loop_cnt].reg, lcdset_reg[brightness][loop_cnt].data);
			}
		}
	}
	return result;
#else
	struct emxx_pwm_ch_config_t pwm_ch_config;
	struct emxx_pwm_cmpcnt_t    pwm_cmpcnt;
#if (_DEBUG_LCDHW & 0x80)
	struct emxx_pwm_cb_info_t   pwm_cb_info;
	pwm_cb_info.cb_count      = pwm_callback_count;
	pwm_cb_info.cb_count_data = NULL;
	pwm_cb_info.cb_loop       = NULL;
	pwm_cb_info.cb_loop_data  = NULL;
#endif
	
	// 一度PWMを停止する
	emxx_pwm_stop(EMXX_PWM_CH0);
	
	// 停止後の再開は3クロック以上空ける必要あり
	udelay(PWM_DELAY4RESTART_US);
	
	// PWM動作モード設定
	pwm_ch_config.use_cmp = PWM_BIT_CMP0;	// CMP0のみ使用
	pwm_ch_config.mode = PWM_CODE_MODE_OR;	// OR(CMP0のみ)
	if (LCDM_PARAM_BRIGHTNESS_OFF == brightness) {
		pwm_ch_config.inverse = 1;	// 出力結果反転する
	} else {
		pwm_ch_config.inverse = 0;	// 出力結果反転しない
	}
#if (_DEBUG_LCDHW & 0x80)
	pwm_ch_config.interrupt_count = PWM_BIT_CMP0;
#else
	pwm_ch_config.interrupt_count = 0;	// カウント終了割り込み無効
#endif
	pwm_ch_config.interrupt_loop  = 0;	// ループ終了割り込み無効
	emxx_pwm_set_channel_config(EMXX_PWM_CH0, &pwm_ch_config);
	
	// PWM動作カウンタ等設定
	// クロックにはPLL3(229.376MHz)を115分周した1.995MHzを使用している
	// 50KHzを40クロックとしてHIGH区間のクロック数を設定する
	pwm_cmpcnt.cmp         = EMXX_PWM_COMPARE0;
	pwm_cmpcnt.delay       = 0;
	pwm_cmpcnt.lead_edge   = 0;
	if (LCDM_PARAM_BRIGHTNESS_OFF == brightness) {
		pwm_cmpcnt.trail_edge = LCDM_PARAM_BRIGHTNESS_MAX;
	} else {
		pwm_cmpcnt.trail_edge = brightness;
	}
	pwm_cmpcnt.total_cycle = LCDM_PARAM_BRIGHTNESS_MAX;
	pwm_cmpcnt.loop_count  = 0;	// 自動停止無効
#if (_DEBUG_LCDHW & 0x80)
	pwm_cmpcnt.cb_info     = &pwm_cb_info;
#else
	pwm_cmpcnt.cb_info     = NULL;	// コールバック関数不要
#endif
	
	emxx_pwm_set_compare_counter(EMXX_PWM_CH0, &pwm_cmpcnt);
	
	// PWM出力開始
#if (_DEBUG_LCDHW & 0x80)
	s_dbg_wk_jiffies = jiffies;
#endif
	emxx_pwm_start(EMXX_PWM_CH0);
#endif
}

/*******************************************************************************
 * @brief	LCDM-SPI書き込み制御関数
 *
 * @oaram[in]	無し
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_hw_spi_write_control(uint8_t page, uint8_t addr, uint8_t data)
{
	int result = 0;

	if ((s_sha_page != page) || (s_set_page_1st != 0)) {
		result = lcd_module_hw_spi_write(PMWLCD_PAGE_ADDR, page);

		if (result != 0) {
			printk_err("error: result=%d, page=0x%02X\n", result, page);
			return result;
		}

		s_sha_page = page;
		s_set_page_1st = 0;
	}

	result = lcd_module_hw_spi_write(addr, data);

	if (result != 0) {
		printk_err("error: result=%d, addr=0x%02X, data=0x%02X\n", result, addr, data);
	}

	return result;
}

/*******************************************************************************
 * @brief	LCDM-SPI制御関数
 *
 * @oaram[in]	無し
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_hw_spi_refresh(void)
{
	emxx_spi_info_t *info = 0;
	int result = 0;
	int i = 0;
	int is_underrun;

	is_underrun = emxx_lcd_check_underrun();

	if (is_underrun != 0) {
		for (i = 0; i < LCD_RESET_SIZE; i++) {
			result = lcd_hw_spi_register_set(lcd_reset[i].reg, lcd_reset[i].data);
			if (result != 0) {
				printk_err("error: result=%d, reg=0x%02X, data=0x%02X\n", result, lcd_reset[i].reg, lcd_reset[i].data);
				return result;
			}
		}
		mdelay(PMWLCD_SW_RESX_WAIT_MSEC);
		printk_info("SW_RESX\n");
	}

	for (i = 0 ; i < LCD_SET_SIZE ; i++)
	{
		info = &s_emxx_reg_info[lcdset_val[i].reg];

		if ((info == NULL) || (info->data == NULL)) {
			printk_err("error: reg=0x%x\n", lcdset_val[i].reg);
		} else {
			if (info->refresh == PMWLCD_REFRESH_ON) {
				result = lcd_hw_spi_write_control(info->page_addr, info->reg_addr, *(info->data));

				if (result != 0) {
					printk_err("error: result=%d, page=0x%x, addr=0x%x, data=0x%x\n", result, info->page_addr, info->reg_addr, *(info->data));
				}
			}
		}
	}

	info = &s_emxx_reg_info[lcd_stb[1].reg];

	if ((info == NULL) || (info->data == NULL)) {
		printk_err("error: reg=0x%x\n", lcd_stb[1].reg);
	} else {
		if (info->refresh == PMWLCD_REFRESH_ON) {
			result = lcd_hw_spi_write_control(info->page_addr, info->reg_addr, *(info->data));

			if (result != 0) {
				printk_err("error: result=%d, page=0x%x, addr=0x%x, data=0x%x\n", result, info->page_addr, info->reg_addr, *(info->data));
			} else {
				mdelay(PMWLCD_SW_STB_WAIT_MSEC);
			}
		}
	}

	return result;
}

/*******************************************************************************
 * @brief	LCDM-SPIレジスタ書き込み制御
 *
 * @oaram[in]	addr	shadowテーブル位置
 * @oaram[in]	data	SPI書き込みデータ
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
static int lcd_hw_spi_register_set(pmwlcd_reg_t addr, unsigned char data)
{
	emxx_spi_info_t *info = 0;
	int result = 0;
	
	info = &s_emxx_reg_info[addr];
	
	if(info != NULL) {
		if (info->data != NULL) {
			/* Shadow Ram更新 */
			*(info->data) = data;
			
			result = lcd_hw_spi_write_control(info->page_addr, info->reg_addr, data);
		}
		else {
			/* 戻り値エラー設定 */
			result = -EINVAL;
			/* エラーログ表示 */
			printk_err("error: result=%d, info->data=0x%X\n", result, (unsigned int)info->data);
		}
	}
	else {
		/* 戻り値エラー設定 */
		result = -EINVAL;
		/* エラーログ表示 */
		printk_err("error: result=%d, info=0x%X\n", result, (unsigned int)info);
	}
	
	return result;
}

/*******************************************************************************
 * @brief	DEBUG-レジスタ	読み出し制御
 *
 * @oaram[in]	page	SPI書き込みページ
 * @oaram[in]	addr	SPI書き込みアドレス
 * @oaram[in]	data	SPI書き込みデータ
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_hw_debug_spi_reg_get(unsigned char page, unsigned char addr, unsigned char *data)
{
	emxx_spi_info_t *info = 0;
	int count  = 0;
	int status = 0;
	
	/* 対応テーブル検索 */
	for(count = PMWLCD_REFRESH_START; count <= PMWLCD_REFRESH_END; count++) {
		if ( (s_emxx_reg_info[count].page_addr == page) && (s_emxx_reg_info[count].reg_addr == addr) ) {
			info = &s_emxx_reg_info[count];
			status = 0;
			break;
		}
		else {
			status = 1;
		}
	}
	
	if (status == 0) {
		/* Shadowデータ取得 */
		*(data) = *(info->data);
	}
	return status;
}

/*******************************************************************************
 * @brief	DEBUG-レジスタ書き込み制御
 *
 * @oaram[in]	page	SPI書き込みページ
 * @oaram[in]	addr	SPI書き込みアドレス
 * @oaram[in]	data	SPI書き込みデータ
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_hw_debug_spi_reg_set(unsigned char page, unsigned char addr, unsigned char data)
{
	emxx_spi_info_t *info = 0;
	int result = 0;
	int count  = 0;
	int status = 0;
	
	/* 対応テーブル検索 */
	for(count = PMWLCD_REFRESH_START; count <= PMWLCD_REFRESH_END; count++) {
		if ((s_emxx_reg_info[count].page_addr == page) && (s_emxx_reg_info[count].reg_addr == addr)) {
			info = &s_emxx_reg_info[count];
			status = 0;
			break;
		}
		else {
			status = 1;
		}
	}
	
	if(status == 0) {
		/* Shadow Ram更新 */
		*(info->data) = data;
		
		result = lcd_hw_spi_write_control(page, addr, data);
	}
	else {
		result = -EINVAL;
	}
	
	return result;
}

/* ------------------ LCDC rgister check function -------------------------- */
/*****************************************************************************
* MODULE   : lcd_hw_chk_status
* FUNCTION : check LCDC status
* RETURN   :  0 : success
*            -1 : failed
* NOTE     : none
*****************************************************************************/
unsigned long lcd_hw_chk_status(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	/* check lcd status */
	return (unsigned long)readl(LCDCMmioV + LCD_STATUS);
}


/*****************************************************************************
* MODULE   : lcd_hw_chk_int_status
* FUNCTION : check LCDC bussel
* RETURN   : none
* NOTE     : none
******************************************************************************/
unsigned long lcd_hw_chk_bussel(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	/*  check bussel */
	return (unsigned long)readl(LCDCMmioV + LCD_BUSSEL);
}


/*****************************************************************************
* MODULE   : lcd_hw_chk_int_status
* FUNCTION : check LCDC interrupt status
* RETURN   : none
* NOTE     : none
******************************************************************************/
unsigned long lcd_hw_chk_int_status(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	/*  check Interuppt Status */
	return (unsigned long)readl(LCDCMmioV + LCD_INTSTATUS);
}


/*****************************************************************************
* MODULE   : lcd_hw_chk_int_rawstatus
* FUNCTION : check LCDC interrupt RAW status
* RETURN   : none
* NOTE     : none
******************************************************************************/
unsigned long lcd_hw_chk_int_rawstatus(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	/*  check Interuppt RAW Status */
	return (unsigned long)readl(LCDCMmioV + LCD_INTRAWSTATUS);
}


/* ------------------ LCDC interruput control function --------------------- */
/*****************************************************************************
* MODULE   : lcd_hw_int_enable
* FUNCTION : enable LCDC VSYNC interrupt
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_hw_int_enable(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	/*  Interuppt Enable Set */
	writel(LCD_UNDERRUN_BIT, LCDCMmioV + LCD_INTENSET);
	if (lcdc_output_mode == EMXX_FB_OUTPUT_MODE_HDMI_1080I)
		writel(LCD_LCDVS_BIT | LCD_FIELD_BIT, LCDCMmioV + LCD_INTENSET);
}


/*****************************************************************************
* MODULE   : lcd_hw_int_disable
* FUNCTION : disable LCDC interrupts
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_hw_int_disable(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	/* Interrupt Enable Clear */
	writel(LCD_INT_ALL_BIT, LCDCMmioV + LCD_INTENCLR);
}


/*****************************************************************************
* MODULE   : lcd_hw_int_factor_clr
* FUNCTION : disable LCDC interrupts
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_hw_int_factor_clr(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	/* Interrupt Status Clear */
	writel(LCD_INT_ALL_BIT, LCDCMmioV + LCD_INTFFCLR);
}


/* ------------------ LCD initialize function ------------------------------ */
static inline void change_pinsel_hdmi(void)
{
	/********************************/
	/* port / terminal switching    */
	/********************************/
	printk_dbg(_DEBUG_LCDHW,
	 "SMU_LCDLCLKDIV = 0x%08x\n", readl(SMU_LCDLCLKDIV));
	/* 229.376Mhz / 10 = 22.938Mhz */
	writel(0x00000009, SMU_LCDLCLKDIV);

#ifdef CONFIG_MACH_EMEV
	printk_dbg(_DEBUG_LCDHW,
	 "SMU_USIB0SCLKDIV = 0x%08x\n", readl(SMU_USIB0SCLKDIV));
	/* OSC0 11.2896Mhz / 256 = 44.1Khz */
	writel(0x02FF000F, SMU_USIB0SCLKDIV);

	/* IIC0 IIC1 */
	writel((readl(CHG_PINSEL_G032) & 0xFFFFF0FF), CHG_PINSEL_G032);

	/* LCD3 PXCLKB CLK_I HS VS DE */
	writel((readl(CHG_PINSEL_G000) & 0xFF0FFFFF), CHG_PINSEL_G000);

	/* USI3 */
	writel((readl(CHG_PINSEL_G096) & 0xFF87FFFF), CHG_PINSEL_G096);

	/* CHG mask release  GIO_006 */
	writel(((readl(CHG_PULL13) & 0xFFF0FFFF) | 0x00040000), CHG_PULL13);
	/* CHG mask release  GIO_020, schmitt */
	writel(((readl(CHG_PULL0) & 0xFFFFF0FF) | 0x00000C00),  CHG_PULL0);

	/* select YUV */
	writel(0x00000401, CHG_PINSEL_LCD3);
	/* select USI3 */
	writel((readl(CHG_PINSEL_USI) & 0xFFFFFFCF), CHG_PINSEL_USI);

	/* LCD pin drive 12mA */
	writel(0x03FFF000, CHG_DRIVE0);
#endif
}


/*******************************************************************************
 * @brief	PMWLCD用ピン出力設定(YUV出力)
 *
 * @oaram[in]	moduleid	出力解像度を決めるModule-ID
 *
 * @return	なし
 *******************************************************************************/
static inline void change_pinsel_pmwlcd(void)
{
	// 32.768kHzベースのPLL4を458.752MHzで使用する
	printk_dbg(_DEBUG_LCDHW, "(before)SMU_PLL4CTRL0 = 0x%08x\n", readl(SMU_PLL4CTRL0));
	writel(0x0000006F, SMU_PLL4CTRL0);	/* 32768 x 125 x (111+1) = 458.752MHz */
	printk_dbg(_DEBUG_LCDHW, "(before)SMU_PLL4CTRL0 = 0x%08x\n", readl(SMU_PLL4CTRL0));

	// PLL4有効
	printk_dbg(_DEBUG_LCDHW, "(before)SMU_PLL4CTRL1 = 0x%08x\n", readl(SMU_PLL4CTRL1));
	writel(0x000000FE, SMU_PLL4CTRL1);
	printk_dbg(_DEBUG_LCDHW, "(before)SMU_PLL4CTRL1 = 0x%08x\n", readl(SMU_PLL4CTRL1));

	// LCD_LCLKを27MHzに一番近い値に設定する
	// PLL4を使用すると、27MHzに一番近い値は26.985MHz
	printk_dbg(_DEBUG_LCDHW, "(before)SMU_LCDLCLKDIV = 0x%08x\n", readl(SMU_LCDLCLKDIV));
	writel(0x00000110, SMU_LCDLCLKDIV);	/* 458.752MHz / (16+1) = 26.985MHz */
	printk_dbg(_DEBUG_LCDHW, "(after )SMU_LCDLCLKDIV = 0x%08x\n", readl(SMU_LCDLCLKDIV));

	// LCDクロック立ち下がり同期にする
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_DELAY_LCD33 = 0x%08x\n", readl(CHG_DELAY_LCD33));
	writel(readl(CHG_DELAY_LCD33) & ~0x10000000, CHG_DELAY_LCD33);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_DELAY_LCD33 = 0x%08x\n", readl(CHG_DELAY_LCD33));

#if 0
	// PWCLKを2MHzに近い値に設定する(PWM周期50kHzで最小幅が500nsのため)
	// PLL3を使用すると、2MHzを超えない一番近い値は1.995MHz
	printk_dbg(_DEBUG_LCDHW, "(before)SMU_PWMPWCLKDIV = 0x%08x\n", readl(SMU_PWMPWCLKDIV));
	writel(0x00000072, SMU_PWMPWCLKDIV);	/* 229.376Mhz / (114+1) = 1.995MHz */
	printk_dbg(_DEBUG_LCDHW, "(after )SMU_PWMPWCLKDIV = 0x%08x\n", readl(SMU_PWMPWCLKDIV));
#endif

	// 以下のピンで使用する機能を選択する
	// GIO 018, 020 - 023 -> YUV3_CLK_O, CLK_I, HS, VS, DE
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PINSEL_G000 = 0x%08x\n", readl(CHG_PINSEL_G000));
	writel((readl(CHG_PINSEL_G000) & ~0x00E40000), CHG_PINSEL_G000);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PINSEL_G000 = 0x%08x\n", readl(CHG_PINSEL_G000));

#if 0
	// 以下のピンで使用する機能を選択する
	// GIO 040 - 043 -> YUV3_D0 - D1, D8 - D9
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PINSEL_G032 = 0x%08x\n", readl(CHG_PINSEL_G032));
	writel((readl(CHG_PINSEL_G032) & ~0x00000F00), CHG_PINSEL_G032);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PINSEL_G032 = 0x%08x\n", readl(CHG_PINSEL_G032));
#else
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PINSEL_G032 = 0x%08x\n", readl(CHG_PINSEL_G032));
	writel((readl(CHG_PINSEL_G032) & ~0x00000fff), CHG_PINSEL_G032);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PINSEL_G032 = 0x%08x\n", readl(CHG_PINSEL_G032));
#endif

#if 0
	// 以下のピンで使用する機能を選択する
	// GIO 093 -> GIO (O_EROM_ACCESS)
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PINSEL_G064 = 0x%08x\n", readl(CHG_PINSEL_G064));
	writel((readl(CHG_PINSEL_G064) | 0x20000000), CHG_PINSEL_G064);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PINSEL_G064 = 0x%08x\n", readl(CHG_PINSEL_G064));
#endif

#if 0
	// 以下のピンで使用する機能を選択する
	// GIO 109 - 112 -> USI2_CLK, DI, DO, CS0 (SPI)
	// GIO 114       -> GIO (VFON)
	// GIO 120       -> PWM0
	// GIO 121       -> GIO (DOWN)
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PINSEL_G096 = 0x%08x\n", readl(CHG_PINSEL_G096));
	writel(((readl(CHG_PINSEL_G096) & ~0x0101E000) | 0x02040000), CHG_PINSEL_G096);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PINSEL_G096 = 0x%08x\n", readl(CHG_PINSEL_G096));
#else
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PINSEL_G096 = 0x%08x\n", readl(CHG_PINSEL_G096));
	#define VAL_CHG_PINSEL_G096 ( 0x0305a000 )
	writel(((readl(CHG_PINSEL_G096) & ~VAL_CHG_PINSEL_G096) | 0x03040000), CHG_PINSEL_G096 );
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PINSEL_G096 = 0x%08x\n", readl(CHG_PINSEL_G096));
#endif

#if 0
	// LCDインタフェースで使用するピンのModeを選択する(YUVなので、Mode1になる)
	// CHG_PINSEL_LCD3[11:10] : Mode1(YUV D0 - 15)
	// CHG_PINSEL_LCD3[1:0]   : Mode1(YUV CLK_O, CLK_I, HS, VS, DE)
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PINSEL_LCD3 = 0x%08x\n", readl(CHG_PINSEL_LCD3));
	writel(0x00000401, CHG_PINSEL_LCD3);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PINSEL_LCD3 = 0x%08x\n", readl(CHG_PINSEL_LCD3));
#else
	#define VAL_PINSEL_LCD3 ( 0x00000000 )
	writel(VAL_PINSEL_LCD3, CHG_PINSEL_LCD3);
#endif

#if 0
	// USIインタフェースで使用するピンのModeを選択する(USI2, PWM0はMode0になる)
	// CHG_PINSEL_USI[9:8] : Mode0(PWM0)
	// CHG_PINSEL_USI[1:0] : Mode0(USI2)
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PINSEL_USI = 0x%08x\n", readl(CHG_PINSEL_USI));
	writel(0x00000000, CHG_PINSEL_USI);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PINSEL_USI = 0x%08x\n", readl(CHG_PINSEL_USI));
#else
	#define VAL_CHG_PINSEL_USI  ( 0x00000003 )  /* mode 0 */
	writel( (readl(CHG_PINSEL_USI) & ~(VAL_CHG_PINSEL_USI)), CHG_PINSEL_USI );
#endif

#if 0
	// GIO 018, 020 - 023 のpull設定を行う
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PULL0 = 0x%08x\n", readl(CHG_PULL0));
	writel(((readl(CHG_PULL0) & ~0x00FFFF0F) | 0x00000400),  CHG_PULL0);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PULL0 = 0x%08x\n", readl(CHG_PULL0));
#endif

#if 0
	// GIO 040 - 041 のpull設定を行う
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PULL2 = 0x%08x\n", readl(CHG_PULL2));
	writel(((readl(CHG_PULL2) & ~0xFF000000) | 0x00000000),  CHG_PULL2);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PULL2 = 0x%08x\n", readl(CHG_PULL2));
#endif

#if 0
	// GIO 042 - 043 のpull設定を行う
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PULL3 = 0x%08x\n", readl(CHG_PULL3));
	writel(((readl(CHG_PULL3) & ~0x000000FF) | 0x00000000),  CHG_PULL3);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PULL3 = 0x%08x\n", readl(CHG_PULL3));
#endif

#if 0
	// GIO 093 (O_EROM_ACCESS) の出力をpull down (0) にする
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PULL10 = 0x%08x\n", readl(CHG_PULL10));
	writel(((readl(CHG_PULL10) & ~0x000000F0) | 0x00000030),  CHG_PULL10);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PULL10 = 0x%08x\n", readl(CHG_PULL10));

	// GIO 109 - 112, 114 のpull設定を行う
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PULL15 = 0x%08x\n", readl(CHG_PULL15));
	writel(((readl(CHG_PULL15) & ~0x00F0FFFF) | 0x00404444),  CHG_PULL15);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PULL15 = 0x%08x\n", readl(CHG_PULL15));

	// GIO 120 - 121 のpull設定を行う
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PULL16 = 0x%08x\n", readl(CHG_PULL16));
	writel(((readl(CHG_PULL16) & ~0x0FF00000) | 0x04400000),  CHG_PULL16);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PULL16 = 0x%08x\n", readl(CHG_PULL16));
#else
	// GIO 114 のpull設定を行う
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PULL15 = 0x%08x\n", readl(CHG_PULL15));
	writel(((readl(CHG_PULL15) & ~0x00F00000) | 0x00700000),  CHG_PULL15);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PULL15 = 0x%08x\n", readl(CHG_PULL15));
	
	// GIO 120 - 121 のpull設定を行う
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_PULL16 = 0x%08x\n", readl(CHG_PULL16));
	writel(((readl(CHG_PULL16) & ~0x0FF00000) | 0x04400000),  CHG_PULL16);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_PULL16 = 0x%08x\n", readl(CHG_PULL16));

	// GIO 114 のinput設定を行う
	gpio_direction_input(GPIO_P114);
	
	/* GIO 121 の出力＆Low設定 */
	gpio_direction_output(GPIO_P121, 1);
	/* GIO 120 の出力＆Low設定 */
	gpio_direction_output(GPIO_P120, 0);
#endif

	// LCD 1.8 / 3.3 V 供給の設定
	// 3.3 V に設定する
	printk_dbg(_DEBUG_LCDHW, "(before)CHG_LCD_ENABLE = 0x%08x\n", readl(CHG_LCD_ENABLE));
	writel(0x00000001, CHG_LCD_ENABLE);
	printk_dbg(_DEBUG_LCDHW, "(after )CHG_LCD_ENABLE = 0x%08x\n", readl(CHG_LCD_ENABLE));
}


static inline void unreset_lcdc(void)
{
	/********************************/
	/* clock supply                 */
	/********************************/
	emxx_open_clockgate(EMXX_CLK_LCD_C | EMXX_CLK_LCD_L | EMXX_CLK_LCD_P | EMXX_CLK_LCD);

	/********************************/
	/* clock auto control -> OFF    */
	/********************************/
	emxx_clkctrl_off(EMXX_CLKCTRL_LCD);
	emxx_clkctrl_off(EMXX_CLKCTRL_LCDC);
	emxx_clkctrl_off(EMXX_CLKCTRL_LCDPCLK);

	/********************************/
	/* LCDC unreset                 */
	/********************************/
	emxx_unreset_device(EMXX_RST_LCD_A | EMXX_RST_LCD);

	/********************************/
	/* clock auto control -> ON     */
	/********************************/
	emxx_clkctrl_on(EMXX_CLKCTRL_LCD);
	emxx_clkctrl_on(EMXX_CLKCTRL_LCDC);
	emxx_clkctrl_on(EMXX_CLKCTRL_LCDPCLK);
}


static inline void unreset_usi3(void)
{
	/********************************/
	/* clock supply                 */
	/********************************/
	emxx_open_clockgate(EMXX_CLK_USIB_S3_H | EMXX_CLK_USIB_S3_S | EMXX_CLK_USIB_S3_P);

	/********************************/
	/* clock auto control -> OFF    */
	/********************************/
	emxx_clkctrl_off(EMXX_CLKCTRL_USIBS3);
	emxx_clkctrl_off(EMXX_CLKCTRL_USIBS3PCLK);
	emxx_clkctrl_off(EMXX_CLKCTRL_USIBS3SCLK);

	/********************************/
	/* LCDC unreset                 */
	/********************************/
	emxx_unreset_device(EMXX_RST_USIB_S3_A | EMXX_RST_USIB_S3_S);

	/********************************/
	/* clock auto control -> ON     */
	/********************************/
	emxx_clkctrl_on(EMXX_CLKCTRL_USIBS3);
	emxx_clkctrl_on(EMXX_CLKCTRL_USIBS3PCLK);
	emxx_clkctrl_on(EMXX_CLKCTRL_USIBS3SCLK);
}


/*****************************************************************************
* MODULE   : lcd_hw_init
* FUNCTION : LCD(H/W) initialized
* RETURN   : none
* NOTE     : none
******************************************************************************/
static void lcd_hw_init(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	switch (lcdc_output_mode) {
	default:
	case EMXX_FB_OUTPUT_MODE_LCD:
		/* PMWLCD */
		change_pinsel_pmwlcd();
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_1080I:
	case EMXX_FB_OUTPUT_MODE_HDMI_720P:
		/* HDMI */
		change_pinsel_hdmi();
		break;
	}

	unreset_lcdc();

	if ((lcdc_output_mode == EMXX_FB_OUTPUT_MODE_HDMI_1080I) ||
	    (lcdc_output_mode == EMXX_FB_OUTPUT_MODE_HDMI_720P))
		unreset_usi3();
}


/******************************************************************************
* MODULE   : lcd_controller_hw_init
* FUNCTION : LCD(H/W) initialized
* RETURN   : none
* NOTE     : none
******************************************************************************/
static void lcd_controller_hw_init(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	lcd_hw_int_factor_clr();
	lcd_hw_int_disable();
	lcd_hw_int_enable();
	switch (lcdc_output_mode) {
	default:
	case EMXX_FB_OUTPUT_MODE_LCD:
		/* Control for LCDC  */
		writel(LCD_CONTROL_INIT, LCDCMmioV + LCD_CONTROL);
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_1080I:
		/* Control for LCDC  */
		writel(LCD_LCLK_33V_PCLK |
		       LCD_OUT_SEL_YUV |
		       LCD_PI_SEL_INTERLACE |
		       LCD_OFORMAT_RGB888 |
		       LCD_CLKPOL_RISING |
		       LCD_HPOL_NEGATIVE |
		       LCD_VPOL_NEGATIVE |
		       LCD_ENPOL_HIGH,
		       LCDCMmioV + LCD_CONTROL);
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_720P:
		/* Control for LCDC  */
		writel(LCD_LCLK_33V_PCLK |
		       LCD_OUT_SEL_YUV |
		       LCD_PI_SEL_PROGRESSIVE |
		       LCD_OFORMAT_RGB888 |
		       LCD_CLKPOL_RISING |
		       LCD_HPOL_NEGATIVE |
		       LCD_VPOL_NEGATIVE |
		       LCD_ENPOL_HIGH,
		       LCDCMmioV + LCD_CONTROL);
		break;
	}

	lcd_field = FIELD_NONE;

	/* QoS for LCDC      */
	writel(LCD_QOS_INIT,     LCDCMmioV + LCD_QOS);
	/* Data Request Timing for LCDC */
	writel(LCD_DATAREQ_INIT, LCDCMmioV + LCD_DATAREQ);
#ifdef CONFIG_EMXX_LCD_FRAMECACHE
	/* AREA Address for Frame Buffer       */
	writel(LCD_AREAADR_ODD_INIT, LCDCMmioV + LCD_AREAADR_ODD);
	writel(LCD_AREAADR_EVEN_INIT, LCDCMmioV + LCD_AREAADR_EVEN);
#endif /* CONFIG_EMXX_LCD_FRAMECACHE */
	/* Input Format      */
	writel(LCD_IFORMAT_INIT, LCDCMmioV + LCD_IFORMAT);
	/* Background color  */
	writel(LCD_BACKCOL_INIT, LCDCMmioV + LCD_BACKCOLOR);
#ifdef CONFIG_EMXX_LCD_FRAMECACHE
	if (direct_path) {
		/* Access Bus Select(Pwoer Management) */
		writel(LCD_BUSSEL_DIRECT, LCDCMmioV + LCD_BUSSEL);
	} else {
#endif /* CONFIG_EMXX_LCD_FRAMECACHE */
		/* Access Bus Select(Pwoer Management) */
		writel(LCD_BUSSEL_INIT,   LCDCMmioV + LCD_BUSSEL);
#ifdef CONFIG_EMXX_LCD_FRAMECACHE
	}
#endif /* CONFIG_EMXX_LCD_FRAMECACHE */

	writel(LCD_COEF_Y0_INIT, LCDCMmioV + LCD_COEF_Y0);
	writel(LCD_COEF_Y1_INIT, LCDCMmioV + LCD_COEF_Y1);
	writel(LCD_COEF_Y2_INIT, LCDCMmioV + LCD_COEF_Y2);
	writel(LCD_COEF_Y3_INIT, LCDCMmioV + LCD_COEF_Y3);
	writel(LCD_COEF_U0_INIT, LCDCMmioV + LCD_COEF_U0);
	writel(LCD_COEF_U1_INIT, LCDCMmioV + LCD_COEF_U1);
	writel(LCD_COEF_U2_INIT, LCDCMmioV + LCD_COEF_U2);
	writel(LCD_COEF_U3_INIT, LCDCMmioV + LCD_COEF_U3);
	writel(LCD_COEF_V0_INIT, LCDCMmioV + LCD_COEF_V0);
	writel(LCD_COEF_V1_INIT, LCDCMmioV + LCD_COEF_V1);
	writel(LCD_COEF_V2_INIT, LCDCMmioV + LCD_COEF_V2);
	writel(LCD_COEF_V3_INIT, LCDCMmioV + LCD_COEF_V3);
	writel(LCD_BYTELANE_INIT, LCDCMmioV + LCD_BYTELANE);

	init_is_first = 0;
}


/******************************************************************************
* MODULE   : lcd_controller_hw_init_lcdsize
* FUNCTION : LCD(H/W) size initialize
* RETURN   : none
* NOTE     : none
******************************************************************************/
static inline void lcd_controller_hw_init_lcdsize(void)
{
	unsigned int harea, hpulse, hfrontp, hbackp, varea, vpulse, vfrontp, vbackp;
	unsigned int voff_odd, voff_even;
	lcdm_input_timing_t input_timing;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	lcdm_param_get_timing(&input_timing);
	harea	= input_timing.harea;
	hpulse	= input_timing.hpulse;
	hfrontp	= input_timing.hfrontp;
	hbackp	= input_timing.hbackp;
	varea	= input_timing.varea;
	vpulse	= input_timing.vpulse;
	vfrontp	= input_timing.vfrontp;
	vbackp	= input_timing.vbackp;
	voff_odd  = input_timing.voff_odd;
	voff_even = input_timing.voff_even;

	/* Horizontal Synchronizing Signal Total Width  */
	writel(harea + hfrontp + hbackp, LCDCMmioV + LCD_HTOTAL);    // 640 + 96 + 122 = 858
	/* Horizontal Display Area Width                */
	writel(harea,				  LCDCMmioV + LCD_HAREA);        // 640
	/* Horizontal Synchronizing Signal Edge Point 1 */
	writel(hfrontp,				  LCDCMmioV + LCD_HEDGE1);       // 96
	/* Horizontal Synchronizing Signal Edge Point 2 */
	writel(hfrontp + hpulse,		  LCDCMmioV + LCD_HEDGE2);   // 96 + 3 = 99
	/* Vertical Synchronizing Signal Total Width    */
	switch (lcdc_output_mode) {
	default:
	case EMXX_FB_OUTPUT_MODE_LCD:
		writel(varea + vfrontp + vbackp, LCDCMmioV + LCD_VTOTAL);   // 480 + 7 + 38 = 525
		
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
		if ((system_rev & EMXX_REV_MASK) != EMXX_REV_ES1) {
#endif
			writel(LCD_VOFFSET_EN_BIT | LCD_VTOTAL_SEL_BIT,	LCDCMmioV + LCD_VSYNC_CONT);
			writel((varea + vfrontp + vbackp),		LCDCMmioV + LCD_VAREA_EVEN);
			writel(voff_odd,  LCDCMmioV + LCD_VOFFSET_ODD);
			writel(voff_even, LCDCMmioV + LCD_VOFFSET_EVEN);
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
		}
#endif
//		varea *= 2;	/* 2 times for the output to interlace (apparent) */	/* ★Progressive */
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_720P:
		writel(varea + vfrontp + vpulse + vbackp,
		 LCDCMmioV + LCD_VTOTAL);
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
		if ((system_rev & EMXX_REV_MASK) != EMXX_REV_ES1) {
#endif
			writel(LCD_VOFFSET_EN_BIT, LCDCMmioV + LCD_VSYNC_CONT);
			writel(hfrontp,		   LCDCMmioV + LCD_VOFFSET_ODD);
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
		}
#endif
		break;
	case EMXX_FB_OUTPUT_MODE_HDMI_1080I:
		writel(varea / 2 + vfrontp + vpulse + vbackp,
		 LCDCMmioV + LCD_VTOTAL);
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
		if ((system_rev & EMXX_REV_MASK) != EMXX_REV_ES1) {
#endif
			writel((LCD_VOFFSET_EN_BIT | LCD_VTOTAL_SEL_BIT |
			 LCD_VEDGE_SEL_BIT),	 LCDCMmioV + LCD_VSYNC_CONT);
			writel(hfrontp,		 LCDCMmioV + LCD_VOFFSET_ODD);
			writel((harea + hfrontp + hpulse + hbackp) / 2 +
			 hfrontp,		 LCDCMmioV + LCD_VOFFSET_EVEN);
			writel(varea / 2 + vfrontp + vpulse + vbackp + 1,
						 LCDCMmioV + LCD_VAREA_EVEN);
			writel(vfrontp,		 LCDCMmioV + LCD_VEDGE1_EVEN);
			writel(vfrontp + vpulse, LCDCMmioV + LCD_VEDGE2_EVEN);
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
		}
#endif
		break;
	}
	/* Vertical Display Area Width                  */
	writel(varea,				  LCDCMmioV + LCD_VAREA);
	/* Vertical Synchronizing Signal Edge Point 1   */
	writel(vfrontp,				  LCDCMmioV + LCD_VEDGE1);
	/* Vertical Synchronizing Signal Edge Point 2   */
	writel(vfrontp + vpulse,		  LCDCMmioV + LCD_VEDGE2);
#ifdef CONFIG_EMXX_LCD_FRAMECACHE
	/* Horizontal OFFSET Size                       */
	writel(harea * BITS_PER_PIXEL / 8, LCDCMmioV + LCD_HOFFSET);
#endif /* CONFIG_EMXX_LCD_FRAMECACHE */
}


/* ------------------ LCD module initialize function ----------------------- */
/*****************************************************************************
* MODULE   : lcd_module_hw_unreset
* FUNCTION :
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_module_hw_unreset(void)
{
#if 0
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
#ifdef CONFIG_MACH_EMEV
	if (lcdc_output_mode == EMXX_FB_OUTPUT_MODE_LCD) {
		gpio_direction_output(GPIO_LCD_RST, 0x1);
		mdelay(1);
	}
#endif
#endif
	return;
}

/*****************************************************************************
* MODULE   : lcd_module_hw_reset
* FUNCTION :
* RETURN   : none
* NOTE     : none
******************************************************************************/
void lcd_module_hw_reset(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
#ifdef CONFIG_MACH_EMEV
	if (lcdc_output_mode == EMXX_FB_OUTPUT_MODE_LCD)
		gpio_direction_output(GPIO_LCD_RST, 0x0);
#endif
}

/*******************************************************************************
 * @brief	GPIO使用リソースを獲得する
 *
 * @oaram	なし
 *
 * @return	なし
 *******************************************************************************/
static void lcd_module_hw_request_gpio(void)
{
#if 0
	gpio_request(LCDM_GIO_VFON, "LCD VFON");
	gpio_request(LCDM_GIO_DOWN, "LCD DOWN");

	gpio_direction_input(LCDM_GIO_VFON);
	gpio_direction_output(LCDM_GIO_DOWN, LCDM_GIODATA_DOWN_PWROFF);
#endif
	return;
}

/*******************************************************************************
 * @brief	GPIO使用リソースを解放する
 *
 * @oaram	なし
 *
 * @return	なし
 *******************************************************************************/
static void lcd_module_hw_free_gpio(void)
{
#if 0
	gpio_free(LCDM_GIO_VFON);
	gpio_free(LCDM_GIO_DOWN);
#endif
	return;
}


/*******************************************************************************
 * @brief	SubLCD電源ON処理
 *
 * @oaram	なし
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
static int lcd_module_hw_power_on(void)
{
#if	1
	int result = 0, wk_power = 0, after_power = 0, i = 0;
	lcdm_param_module_t param_module =
	{
		.devinfo  = LCDM_PARAM_DEVINFO_0,
		.moduleid = LCDM_PARAM_MODULEID_VGA
	};

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	result = 0;

	wk_power = lcdm_status_get_power();
	after_power = wk_power;

	if ((lcdc_output_mode == EMXX_FB_OUTPUT_MODE_LCD) && (LCDM_PARAM_POWER_OFF == wk_power)) {
		for (i = 0 ; i < PMWLCD_PON_SEQ_RETRY_MAX ; i++) {
			/* lcd module power on */
			result = lcd_module_hw_power_on_pmwlcd();

			if (result == 0) {
				/* start black back display mode */
				lcd_hw_start_black(param_module.moduleid);

				/* set module id */
				lcdm_param_set_module(&param_module);

				/* start refresh */
				lcdm_start_polling();

				/* set power status */
				lcdm_status_set_power(LCDM_PARAM_POWER_ON);
				after_power = LCDM_PARAM_POWER_ON;

				mdelay(PMWLCD_LCDOUT_WAIT_MSEC);

				/* lcd module disp on */
				lcd_module_hw_disp_on();
				break;
			}

			printk_err("LCD Module power on failed! - retry (%d/%d)\n", i+1, PMWLCD_PON_SEQ_RETRY_MAX);
			mdelay(PMWLCD_PON_SEQ_RETRY_WAIT_MSEC);
		}
	}

	printk_dbg((_DEBUG_LCDHW & 0x02), "power=%d->%d, result=%d\n", wk_power, after_power, result);

	return result;
#else
	const int error_retry_max = 3;		//!< エラーリトライ回数
	const int wait_sleep_msec = 200;	//!< エラーリトライ時に少し待つ時間(msec)
	
	int result = 0, wk_power = 0, after_power = 0, i = 0;
	unsigned long status = 0, bussel = 0;
	lcdm_param_module_t	param_module;
	lcdm_param_userfunc_t	param_userfunc;
	lcdm_param_devfunc_t	param_devfunc;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	
	result = 0;
	
	wk_power = lcdm_status_get_power();
	after_power = wk_power;
	if ((lcdc_output_mode == EMXX_FB_OUTPUT_MODE_LCD) && (LCDM_PARAM_POWER_OFF == wk_power)) {
		for (i=0; i<error_retry_max; i++) {
			// SubLCD電源ON制御(DOWN=L)
			result = lcd_module_hw_power_on_pmwlcd();
			if (0 == result) {
				// 現在の表示状態を保持
				status = lcd_hw_chk_status();
				bussel = lcd_hw_chk_bussel();
				
				// 黒画固定出力開始
//				lcd_hw_start_black(LCDM_PARAM_MODULEID_QVGA);
				lcd_hw_start_black(LCDM_PARAM_MODULEID_VGA);
				
				do {
					// Module-ID取得
					result = lcd_module_hw_detect_module(&param_module);
					if (0 > result) {
						break;
					}
					
					param_module.moduleid = 2;  //強制的に2(640×480)を返すように変更
					
					// ユーザ調整機能更新
					lcdm_param_get_userfunc(&param_userfunc);
					result = lcd_module_hw_set_userfunc(&param_userfunc);
					if (0 > result) {
						break;
					}
					
					// Device別制御機能設定
					lcdm_param_get_devfunc(&param_devfunc);
					result = lcd_module_hw_set_devfunc(&param_devfunc, param_module.devinfo);
					if (0 > result) {
						break;
					}
					
				}while(0);
				
				// 表示状態を元に戻す
				if (!(status & LCD_STATUS_ON)) {
					lcd_hw_stop();
				}
				if (bussel != LCD_BUSSEL_BLACK) {
					writel(bussel, LCDCMmioV + LCD_BUSSEL);
				}
				
				if (0 == result) {
					// 決定値の保存
					lcdm_param_set_module(&param_module);
					lcdm_param_set_userfunc(&param_userfunc);
					lcdm_param_set_devfunc(&param_devfunc);
					
					// 静電気対策シーケンス起動
					lcdm_start_polling();
					
					// 電源ON状態設定
					lcdm_status_set_power(LCDM_PARAM_POWER_ON);
					after_power = LCDM_PARAM_POWER_ON;
					
					// 正常終了
					break;
				} else {
					// SubLCD電源OFF制御(DOWN=H)
					lcd_module_hw_power_off_pmwlcd();
				}
			}
			// エラーチェック
			if (0 > result) {
				printk_err("LCD Module power on failed! - retry (%d/%d)\n", 
									i+1, error_retry_max);
				mdelay(wait_sleep_msec);
			}
		}
	}

	printk_dbg((_DEBUG_LCDHW & 0x02), 
		"power=%d->%d, result=%d\n", wk_power, after_power, result);
	return result;
#endif
}

/*******************************************************************************
 * @brief	SubLCD電源ON内部処理(DOWN=L制御)
 *
 * @oaram	なし
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
static int lcd_module_hw_power_on_pmwlcd(void)
{
#if 1
	int i, result = -EIO;
	int vfon;

	// lcd module power on
	gpio_set_value(LCDM_GIO_DOWN, LCDM_GIODATA_DOWN_PWRON);

	for (i = 0 ; i < PMWLCD_PON_RETRY_MAX ; i++) {
		vfon = gpio_get_value(LCDM_GIO_VFON);
		printk_dbg((_DEBUG_LCDHW & 0x80), "vfon = %d, retry = %d\n", vfon, i);

		if (vfon == LCDM_GIODATA_VFON_PWRON) {
			result = 0;
			mdelay(PMWLCD_PON_WAIT_MSEC);
			break;
		}

		mdelay(PMWLCD_PON_RETRY_WAIT_MSEC);
	}

	s_set_page_1st = 1;
	for (i = 0; i < LCD_RESET_SIZE; i++) {
		result = lcd_hw_spi_register_set(lcd_reset[i].reg, lcd_reset[i].data);
		if (result != 0) {
			printk_err("error: result=%d, reg=0x%02X, data=0x%02X\n", result, lcd_reset[i].reg, lcd_reset[i].data);
			return result;
		}
	}
	mdelay(PMWLCD_SW_RESX_WAIT_MSEC);

	for (i = 0; i < LCD_SET_SIZE; i++) {
		result = lcd_hw_spi_register_set(lcdset_val[i].reg, lcdset_val[i].data);
		if (result != 0) {
			printk_err("error: result=%d, reg=0x%02X, data=0x%02X\n", result, lcdset_val[i].reg, lcdset_val[i].data);
			return result;
		}
	}

	return 0;
#else
	const int wait_retry_max = 10;		//!< 電源ON待ちリトライ回数
	const int wait_sleep_msec = 10;		//!< リトライ時に少し待つ時間(msec)
	const int vfon_sleep_msec = 200;	//!< VFON後に少し待つ時間(msec)
	
	int vfon, i, result;
	// SubLCD電源ON(DOWN=L)
	gpio_set_value(LCDM_GIO_DOWN, LCDM_GIODATA_DOWN_PWRON);
	
	// VFON監視
#ifdef DEBUG_PMWLCD_DUMMY
	mdelay(wait_sleep_msec * wait_retry_max);
	i = 0;
	vfon = 0;
	result = 0;
#else
	result = -EIO;
	for (i=0; i<wait_retry_max; i++) {
		vfon = gpio_get_value(LCDM_GIO_VFON);
		printk_dbg((_DEBUG_LCDHW & 0x80), 
			"vfon = %d, retry = %d\n", vfon, i);
		if (LCDM_GIODATA_VFON_PWRON == vfon) {
			// 電源ON状態
			result = 0;
			mdelay(vfon_sleep_msec);
			break;
		} else {
			// 少し待つ
			mdelay(wait_sleep_msec);
		}
	}
#endif
	return result;
#endif
}

/*******************************************************************************
 * @brief	SubLCD電源OFF処理
 *
 * @oaram	なし
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
static int lcd_module_hw_power_off(void)
{
	int wk_power = 0;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	wk_power = lcdm_status_get_power();
	if ((lcdc_output_mode == EMXX_FB_OUTPUT_MODE_LCD) && (LCDM_PARAM_POWER_ON == wk_power)) {
		// 静電気対策シーケンス削除
		lcdm_stop_polling();
		
		// SubLCD電源OFF制御(DOWN⇒H)
		lcd_module_hw_power_off_pmwlcd();
		
		// 電源OFF状態設定
		lcdm_status_set_power(LCDM_PARAM_POWER_OFF);
	}

	printk_dbg((_DEBUG_LCDHW & 0x02), "power=%d, result=%d\n", wk_power, 0);
	return 0;
}

/*******************************************************************************
 * @brief	SubLCD電源OFF内部処理(DOWN=H制御)
 *
 * @oaram	なし
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_module_hw_power_off_pmwlcd(void)
{
	// SubLCD電源OFF(DOWN=H)
	gpio_set_value(LCDM_GIO_DOWN, LCDM_GIODATA_DOWN_PWROFF);
#if 0
	// PWM制御を停止する
	emxx_pwm_stop(EMXX_PWM_CH0);
#endif
	return 0;
}


/*******************************************************************************
 * @brief	blank用SubLCD電源OFF->ONシーケンス処理
 *		※change_output()を元に作成
 *
 * @oaram	なし
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_module_hw_blank_power_on(void)
{
	int result = 0;

	if (EMXX_FB_OUTPUT_MODE_LCD == lcdc_output_mode) {
		lcd_module_hw_unreset();
		result = lcd_module_hw_power_on();
		if (0 == result) {
			lcd_hw_update_size();
		}
	}

	return result;
}


/*******************************************************************************
 * @brief	blank用SubLCD電源ON->OFFシーケンス処理
 *		※change_output()を元に作成
 *
 * @oaram	なし
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_module_hw_blank_power_off(void)
{
	int result = 0;

	if (EMXX_FB_OUTPUT_MODE_LCD == lcdc_output_mode) {
		result = lcd_module_hw_power_off();
		if (0 == result) {
			lcd_module_hw_reset();
		}
	}

	return result;
}


/*****************************************************************************
* MODULE   : lcd_module_hw_standby
* FUNCTION :
* RETURN   : none
* NOTE     : none
******************************************************************************/
int lcd_module_hw_standby(void)
{
	int result = 0;
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	/* nop */

	return result;
}

/*****************************************************************************
* MODULE   : lcd_module_hw_wakeup
* FUNCTION :
* RETURN   : none
* NOTE     : none
******************************************************************************/
int lcd_module_hw_wakeup(void)
{
	int result = 0;
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	/* nop */

	return result;
}

/*****************************************************************************
* MODULE   : lcd_module_hw_disp_on
* FUNCTION :
* RETURN   : none
* NOTE     : none
******************************************************************************/
static int lcd_module_hw_disp_on(void)
{
	int result = 0;
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

//	printk_info("panel stb off\n");
	result = lcd_hw_spi_register_set(lcd_stb[1].reg, lcd_stb[1].data);

	if (result != 0) {
		printk_err("error: result=%d, reg=0x%02X, data=0x%02X\n", result, lcd_stb[1].reg, lcd_stb[1].data);
		return result;
	}

	mdelay(PMWLCD_SW_STB_WAIT_MSEC);

	return result;
}

/*******************************************************************************
 * @brief	LCDM-モジュールパラメタ検出
 *
 * @oaram[out]	*param	モジュールパラメタ格納先へのポインタ
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
static int lcd_module_hw_detect_module(lcdm_param_module_t *param)
{
#if 0
	const int error_retry_max = 10;		//!< SPI通信エラーやModule-IDが0x00/0xFFの際のリトライ回数
	const int check_retry_max = 3;		//!< Module-IDの多数決用リトライ回数
	const int wait_sleep_msec = 10;		//!< エラーリトライ時に少し待つ時間(msec)

	lcdm_spi_param_t spi_param;
	unsigned int id_counter[LCDM_PARAM_MODULEID_MAX];
	unsigned char related_devinfo[LCDM_PARAM_MODULEID_MAX];
	int result = 0, error_retry = 0, check_retry = 0, maxval = 0, counter = 0;
	int wk_devinfo = 0, wk_moduleid = 0;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	// 引数チェック
	if (!param) {
		printk_err("invalid argument. param=%p\n", param);
		return -EINVAL;
	}
	
	wk_devinfo = 0;
	wk_moduleid = 0;
	memset(id_counter, 0, sizeof(id_counter));
	memset(related_devinfo, 0, sizeof(related_devinfo));
	for (error_retry=0; error_retry<error_retry_max; error_retry++) {
		
		result = -EIO;
		
		for (check_retry=0; check_retry<check_retry_max; check_retry++) {
			
			// SPI通信(読み込み)
			result = lcd_module_hw_spi_read(LCDM_SPI_ADDR_MODULEID, &(spi_param.byteif));
			
			// SPI通信エラー発生
			// 時間を置いて最初からやり直す
			if (0 > result) {
				break;
			}
			// 取得した値が0x00/0xFFの場合、LCDMの準備が完了していない
			// 時間を置いて最初からやり直す
			if ((0x00 == spi_param.byteif) || (0xFF == spi_param.byteif)) {
				result = -EBUSY;
				break;
			}
			
			// Module-IDごとのカウンタ加算
			id_counter[spi_param.module.moduleid]++;
			// 関連するDevice-Infoを保存
			related_devinfo[spi_param.module.moduleid] = spi_param.module.devinfo;
		}
		
		// Module-ID多数決実行
		if (0 == result) {
			maxval = 0;
			for (counter=0; counter<LCDM_PARAM_MODULEID_MAX; counter++) {
				if (maxval < id_counter[counter]) {
					maxval = id_counter[counter];
					// Module-ID決定
					wk_moduleid = counter;
				}
			}
			// Device-Info決定
			wk_devinfo = related_devinfo[wk_moduleid];
			
			// 出力引数作成
			memset(param, 0, sizeof(*param));
			param->devinfo = wk_devinfo;
			param->moduleid = wk_moduleid;
			break;
		}
		
		// 少し待つ
		mdelay(wait_sleep_msec);
	}
	
	printk_dbg((_DEBUG_LCDHW & 0x02),
		"result=%d, param->devinfo=0x%02x, param->moduleid=0x%02x\n",
		result, param->devinfo, param->moduleid);
	return result;
#else
	return 0;
#endif
}

/*******************************************************************************
 * @brief	LCDM-ユーザ調整機能パラメタ設定
 *
 * @oaram[in]	param	ユーザ調整機能パラメタ格納先へのポインタ
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_module_hw_set_userfunc(lcdm_param_userfunc_t *param)
{
#if 0
	lcdm_spi_param_t spi_param;
	int result = 0;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	// 引数チェック
	if (!param) {
		printk_err("invalid argument. param=%p\n", param);
		return -EINVAL;
	}
	
	// 設定値作成
	memset(&spi_param, 0, sizeof(spi_param));
	spi_param.userfunc.on        = 1;
	spi_param.userfunc.framerate = param->framerate;
	spi_param.userfunc.flip_h    = param->flip_h;
	spi_param.userfunc.flip_v    = param->flip_v;
	
	// SPI通信(書き込み)
	result = lcd_module_hw_spi_write(LCDM_SPI_ADDR_USERFUNC, spi_param.byteif);
	
	printk_dbg((_DEBUG_LCDHW & 0x02),
		"result=%d, param=0x%02x\n", result, spi_param.byteif);
	return result;
#else
	return 0;
#endif
}

/*******************************************************************************
 * @brief	LCDM-ユーザ調整機能パラメタ取得
 *
 * @oaram[out]	param	ユーザ調整機能パラメタ格納先へのポインタ
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_module_hw_get_userfunc(lcdm_param_userfunc_t *param)
{
#if 0
	lcdm_spi_param_t spi_param;
	int result = 0;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	// 引数チェック
	if (!param) {
		printk_err("invalid argument. param=%p\n", param);
		return -EINVAL;
	}
	
	// SPI通信(読み込み)
	memset(&spi_param, 0, sizeof(spi_param));
	result = lcd_module_hw_spi_read(LCDM_SPI_ADDR_USERFUNC, &(spi_param.byteif));
	
	// 取得値作成
	param->framerate = spi_param.userfunc.framerate;
	param->flip_h    = spi_param.userfunc.flip_h;
	param->flip_v    = spi_param.userfunc.flip_v;
	
	printk_dbg((_DEBUG_LCDHW & 0x02),
		"result=%d, param=0x%02x\n", result, spi_param.byteif);
	return result;
#else
	return 0;
#endif
}

/*******************************************************************************
 * @brief	LCDM-Device別制御機能パラメタ設定
 *
 * @oaram[in]	*param	Device別制御機能パラメタ格納先へのポインタ
 * @oaram[in]	devinfo	Device-Info
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_module_hw_set_devfunc(lcdm_param_devfunc_t *param, unsigned int devinfo)
{
#if 0
	lcdm_spi_param_t spi_param;
	int result = 0;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	// 引数チェック
	if ((LCDM_PARAM_DEVINFO_0 != devinfo) && (!param)) {
		printk_err("invalid argument. param=%p, devinfo=%d\n", param, devinfo);
		return -EINVAL;
	}
	
	// 設定値作成
	memset(&spi_param, 0, sizeof(spi_param));
	switch (devinfo) {
		case LCDM_PARAM_DEVINFO_2:
		case LCDM_PARAM_DEVINFO_1:
			spi_param.devfunc1.sidebyside = param->sidebyside;
			spi_param.devfunc1.dimension  = param->dimension;
			break;
		case LCDM_PARAM_DEVINFO_0:
		default:
			/* nop */
			break;
	}
	
	// SPI通信(書き込み)
	result = lcd_module_hw_spi_write(LCDM_SPI_ADDR_DEVFUNC, spi_param.byteif);

	printk_dbg((_DEBUG_LCDHW & 0x02),
		"result=%d, param=0x%02x, devinfo=%d\n", result, spi_param.byteif, devinfo);
	return result;
#else
	return 0;
#endif
}

/*******************************************************************************
 * @brief	LCDM-Device別制御機能パラメタ取得
 *
 * @oaram[out]	param	Device別制御機能パラメタ格納先へのポインタ
 * @oaram[in]	devinfo	Device-Info
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
int lcd_module_hw_get_devfunc(lcdm_param_devfunc_t *param, unsigned int devinfo)
{
#if 0
	lcdm_spi_param_t spi_param;
	int result = 0;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");
	// 引数チェック
	if ((LCDM_PARAM_DEVINFO_0 != devinfo) && (!param)) {
		printk_err("invalid argument. param=%p, devinfo=%d\n", param, devinfo);
		return -EINVAL;
	}
	
	// SPI通信(読み込み)
	memset(&spi_param, 0, sizeof(spi_param));
	result = lcd_module_hw_spi_read(LCDM_SPI_ADDR_DEVFUNC, &(spi_param.byteif));
	
	// 取得値作成
	switch (devinfo) {
		case LCDM_PARAM_DEVINFO_2:
		case LCDM_PARAM_DEVINFO_1:
			param->sidebyside = spi_param.devfunc1.sidebyside;
			param->dimension  = spi_param.devfunc1.dimension;
			break;
		case LCDM_PARAM_DEVINFO_0:
		default:
			/* nop */
			break;
	}

	printk_dbg((_DEBUG_LCDHW & 0x02),
		"result=%d, param=0x%02x, devinfo=%d\n", result, spi_param.byteif, devinfo);
	return result;
#else
	return 0;
#endif
}

/* ------------------ spi control function --------------------------------- */
#ifdef DEBUG_PMWLCD_DUMMY
static unsigned char test_spi_param_moduleid = ((0<<4) | (1<<0));
static unsigned char test_spi_param_userfunc = (0x80);
static unsigned char test_spi_param_devfunc  = (0x00);
#endif
/*******************************************************************************
 * @brief	LCD用SPI読み込み関数
 *
 * @oaram[in]	addr	LCDM提供のSPIアドレス
 * @oaram[out]	*data	読み込みデータ格納先
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
static int lcd_module_hw_spi_read(unsigned char addr, unsigned char *data)
{
#if 0
#ifdef DEBUG_PMWLCD_DUMMY
	int result = 0;
	
	mutex_lock(&s_lcd_spi_mtx);
	if (LCDM_SPI_ADDR_MODULEID == addr) {
		*data = test_spi_param_moduleid;
	} else if (LCDM_SPI_ADDR_USERFUNC == addr) {
		*data = test_spi_param_userfunc;
	} else if (LCDM_SPI_ADDR_DEVFUNC == addr) {
		*data = test_spi_param_devfunc;
	} else {
		result = -1;
	}
	mutex_unlock(&s_lcd_spi_mtx);
	
	printk_dbg((_DEBUG_LCDHW & 0x02), 
		"<SPI DUMMY> result=%d: emma <- spi (%02x:%02x)\n", 
		result, addr, *data);
	return result;
#else
	const int retry_count = 3;

	int		count, retry, retval;
	unsigned char	r_data[LCDM_SPI_TRANSIZE], w_data[LCDM_SPI_TRANSIZE];
	unsigned char	rw_dir[LCDM_SPI_TRANSIZE];

	for (retry=0; retry < retry_count; retry++) {
		// 送信データ作成
		w_data[LCDM_SPI_INDEX_CMD]  = LCDM_SPI_CMD_READ;
		w_data[LCDM_SPI_INDEX_ADDR] = addr;
		w_data[LCDM_SPI_INDEX_LOW1] = 0;
		w_data[LCDM_SPI_INDEX_DATA] = 0;
		w_data[LCDM_SPI_INDEX_LOW2] = 0;
		
		// 受信データクリア
		memset(r_data, 0, sizeof(r_data));
		
		// 送受信方向設定
		rw_dir[LCDM_SPI_INDEX_CMD]  = LCDM_SPI_DIR_WRITE;
		rw_dir[LCDM_SPI_INDEX_ADDR] = LCDM_SPI_DIR_WRITE;
		rw_dir[LCDM_SPI_INDEX_LOW1] = LCDM_SPI_DIR_WRITE;
		rw_dir[LCDM_SPI_INDEX_DATA] = LCDM_SPI_DIR_READ;
		rw_dir[LCDM_SPI_INDEX_LOW2] = LCDM_SPI_DIR_WRITE;
		
		// データ送受信
		count = lcd_module_hw_spi_xfer(w_data, r_data, rw_dir, LCDM_SPI_TRANSIZE);
		
		printk_dbg((_DEBUG_LCDHW & 0x80), 
			"Tx[]={%02x,%02x,%02x,%02x,%02x}, "
			"Rx[]={%02x,%02x,%02x,%02x,%02x}\n",
			w_data[0], w_data[1], w_data[2], w_data[3], w_data[4],
			r_data[0], r_data[1], r_data[2], r_data[3], r_data[4]);
		printk_dbg((_DEBUG_LCDHW & 0x02), 
			"count=%d: emma <- spi (%02x:%02x)\n", 
			count, addr, r_data[LCDM_SPI_INDEX_DATA]);
		
		// 結果判定
		if (LCDM_SPI_TRANSIZE == count) {
			// 戻り値作成(先頭から4バイト目)
			*data = r_data[LCDM_SPI_INDEX_DATA];
			break;
		} else if (0 <= count) {
			// 送受信数が一致しない
			// 戻り値 -1 にして再実施
			printk_dbg((_DEBUG_LCDHW & 0x80), 
				"mismatch count=%d, read data=%02x, retry=%d\n", 
				count, r_data[LCDM_SPI_INDEX_DATA], retry);
			count = -1;
		} else {
			// SPI通信でエラー検出
			printk_dbg((_DEBUG_LCDHW & 0x80), 
				"read result=%d, retry=%d\n", count, retry);
		}
	}
	// 戻り値作成
	if (LCDM_SPI_TRANSIZE == count) {
		/* Clear SPI Error */
		lcdm_event_set_value(LCDM_EVENT_SPIERR, LCDM_OFF);
		retval = 0;
	} else {
		/* Set SPI Error */
		lcdm_event_set_value(LCDM_EVENT_SPIERR, LCDM_ON);
		retval = -1;
	}
	return retval;
#endif
#else
	return -1;
#endif
}

/*******************************************************************************
 * @brief	LCD用SPI書き込み関数
 *
 * @oaram[in]	addr	LCDM提供のSPIアドレス
 * @oaram[in]	data	書き込みデータ
 *
 * @retval	0	成功
 * @retval	0以外	失敗
 *******************************************************************************/
static int lcd_module_hw_spi_write(unsigned char addr, unsigned char data)
{
#ifdef DEBUG_PMWLCD_DUMMY
	int result = 0;
	
	mutex_lock(&s_lcd_spi_mtx);
	if (LCDM_SPI_ADDR_MODULEID == addr) {
		test_spi_param_moduleid = data;
	} else if (LCDM_SPI_ADDR_USERFUNC == addr) {
		test_spi_param_userfunc = data;
	} else if (LCDM_SPI_ADDR_DEVFUNC == addr) {
		test_spi_param_devfunc = data;
	} else {
		result = -1;
	}
	mutex_unlock(&s_lcd_spi_mtx);
	
	printk_dbg((_DEBUG_LCDHW & 0x02), 
		"<SPI DUMMY> result=%d: emma <- spi (%02x:%02x)\n",
		result, addr, data);
	return result;
#else
	const int retry_count = 1;

	int		count, retry, retval;
	unsigned char	r_data[LCDM_SPI_TRANSIZE], w_data[LCDM_SPI_TRANSIZE];
	unsigned char	rw_dir[LCDM_SPI_TRANSIZE];

	for (retry=0; retry < retry_count; retry++) {
		// 送信データ作成
#if 0
		w_data[LCDM_SPI_INDEX_CMD]  = LCDM_SPI_CMD_WRITE;
		w_data[LCDM_SPI_INDEX_ADDR] = addr;
		w_data[LCDM_SPI_INDEX_LOW1] = 0;
		w_data[LCDM_SPI_INDEX_DATA] = data;
		w_data[LCDM_SPI_INDEX_LOW2] = 0;
#else
		w_data[LCDM_SPI_INDEX_DATA] = data;
		w_data[LCDM_SPI_INDEX_ADDR] = addr;
#endif
		
		// 受信データクリア
		memset(r_data, 0, sizeof(r_data));
		
		// 送受信方向設定
#if 0
		rw_dir[LCDM_SPI_INDEX_CMD]  = LCDM_SPI_DIR_WRITE;
		rw_dir[LCDM_SPI_INDEX_ADDR] = LCDM_SPI_DIR_WRITE;
		rw_dir[LCDM_SPI_INDEX_LOW1] = LCDM_SPI_DIR_WRITE;
		rw_dir[LCDM_SPI_INDEX_DATA] = LCDM_SPI_DIR_WRITE;
		rw_dir[LCDM_SPI_INDEX_LOW2] = LCDM_SPI_DIR_WRITE;
#else
		rw_dir[LCDM_SPI_INDEX_DATA] = LCDM_SPI_DIR_WRITE;
		rw_dir[LCDM_SPI_INDEX_ADDR] = LCDM_SPI_DIR_WRITE;
#endif
		
		// データ送受信
		count = lcd_module_hw_spi_xfer(w_data, r_data, rw_dir, LCDM_SPI_TRANSIZE);
		
		printk_dbg((_DEBUG_LCDHW & 0x02), 
			"count=%d: emma -> spi (%02x:%02x)\n",
			count, addr, w_data[LCDM_SPI_INDEX_DATA]);
		
		// 結果判定
		if (LCDM_SPI_TRANSIZE == count) {
			break;
		} else if (0 <= count) {
			// 送受信数が一致しない
			// 戻り値 -1 にして再実施
			printk_dbg((_DEBUG_LCDHW & 0x80), 
				"mismatch count=%d, write data=%02x, retry=%d\n", 
				count, w_data[LCDM_SPI_INDEX_DATA], retry);
			count = -1;
		} else {
			// SPI通信でエラー検出
			printk_dbg((_DEBUG_LCDHW & 0x80), 
				"write result=%d, retry=%d\n", count, retry);
		}
	}
	// 戻り値作成
	if (LCDM_SPI_TRANSIZE == count) {
		/* Clear SPI Error */
		lcdm_event_set_value(LCDM_EVENT_SPIERR, LCDM_OFF);
		retval = 0;
	} else {
		/* Set SPI Error */
		lcdm_event_set_value(LCDM_EVENT_SPIERR, LCDM_ON);
		retval = count;
	}
	return retval;
#endif
}

/*******************************************************************************
 * @brief	LCD用SPI読み込み関数
 *
 * @oaram[in]	wbuf[]	書き込みデータ格納先
 * @oaram[out]	rbuf[]	読み込みデータ格納先
 * @oaram[in]	dirs[]	転送方向
 * @oaram[in]	num	配列個数
 *
 * @retval	成功：読み書きバイト数
 * @retval	失敗：0未満
 *******************************************************************************/
static int lcd_module_hw_spi_xfer(unsigned char *wbuf, unsigned char *rbuf, unsigned char *dirs, unsigned int num)
{
	struct spi_config_t spi_conf;
	int result;
	char *perr;

	// for debug
	if (lcdm_debug_get_spi_force_error()) return 0;

	// 送受信設定
	spi_conf.dev    = SPI_DEV_SP2;
	spi_conf.nbw    = SPI_NB_16BIT;
	spi_conf.nbr    = SPI_NB_16BIT;
	spi_conf.cs_sel = SPI_CS_SEL_CS0;
	spi_conf.m_s    = SPI_M_S_MASTER;
	spi_conf.dma    = SPI_DMA_OFF;
	spi_conf.pol    = SPI_CSW_8CLK | SPI_CK_DLY_OFF | SPI_CK_POL_NEG | SPI_CS_POL_NEG;
	spi_conf.sclk   = SPI_SCLK_1500KHZ;
	spi_conf.mode   = SPI_CPHA_NORMAL;
	spi_conf.tiecs  = SPI_TIECS_NORMAL;

	// --- 送受信開始 ---
	mutex_lock(&s_lcd_spi_mtx);

	// データ送受信(2byte毎)
//	printk_info("spi_addr=%02x, spi_data=%02x\n", wbuf[1], wbuf[0]);
	result = spi2_write(&spi_conf, &wbuf[0], 0, 2, SPI_BLOCK);

	// 転送成功？
	if (result != 2) {
		chk_errno(result, &perr);
		printk_err("error: result=%d(%s), wbuf[1]=0x%02X, wbuf[0]=0x%02X\n", result, perr, wbuf[1], wbuf[0]);
	}

	// --- 送受信終了 ---
	mutex_unlock(&s_lcd_spi_mtx);

	return result;
}


/* ------------------ IMC initialize function ------------------------------ */
/*****************************************************************************
* MODULE   : imc_hw_init
* FUNCTION : IMC(H/W) initialized
* RETURN   : 0     : success
*            other : fail
* NOTE     : none
******************************************************************************/
static int imc_hw_init(void)
{
	unsigned long sync, format;
	int iRet;

	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	memset(&imc_info, 0, sizeof(struct emxx_imc_info));
	imc_info.device  = DEV_LCD;
	imc_info.timeout = 0;
	if (emxx_request_imc(IMC_CH0, &imc_info)) {
		printk_err("could not acquire IMC channel\n");
		return -EBUSY;
	}

	if (!imc_param) {
		imc_param = kmalloc(sizeof(struct emxx_imc_param), GFP_KERNEL);
		if (!imc_param) {
			printk_err("could not allocate memory "
				"for \"IMC info\"\n");
			return -ENOMEM;
		}
		memset(imc_param, 0, sizeof(struct emxx_imc_param));

		imc_preset  = &imc_param->imc_preset;
		imc_vsync   = &imc_param->imc_vsync;
		imc_reserve = &imc_param->imc_reserve;

		imc_vsync->cpubufsel    =
		 &imc_param->param_vsync.imc_cpubufsel;
		imc_vsync->wb           =
		 &imc_param->param_vsync.param_wb;
		imc_vsync->mirror       =
		 &imc_param->param_vsync.imc_mirror;
		imc_vsync->alphasel     =
		 &imc_param->param_vsync.param_alphasel;
		imc_vsync->l0_scanmode  =
		 &imc_param->param_vsync.imc_l0_scanmode;
		imc_vsync->l1a_scanmode =
		 &imc_param->param_vsync.imc_l1a_scanmode;
		imc_vsync->l1b_scanmode =
		 &imc_param->param_vsync.imc_l1b_scanmode;
		imc_vsync->l1c_scanmode =
		 &imc_param->param_vsync.imc_l1c_scanmode;
		imc_vsync->l2a_scanmode =
		 &imc_param->param_vsync.imc_l2a_scanmode;
		imc_vsync->l2b_scanmode =
		 &imc_param->param_vsync.imc_l2b_scanmode;
		imc_vsync->bg_scanmode  =
		 &imc_param->param_vsync.imc_bg_scanmode;

		/* set callback function */
		imc_param->callback_refresh = lcd_callback_imc_refresh;
		imc_param->callback_wb      = lcd_callback_imc_wb;
		printk_dbg((_DEBUG_LCDHW & 0x04), "kmalloc()\n");
	}

	/**********************
	 * set_callback
	 **********************/
	emxx_imc_set_callback(imc_info.id, imc_param->callback_refresh,
	 imc_param->callback_wb);
	printk_dbg((_DEBUG_LCDHW & 0x04), "set_callback()\n");

	/**********************
	 * set_preset
	 **********************/
	sync   = IMC_START_MODE_LCD_SYNC;	/* VSYNC syncro mode */
	format = IMC_FORMAT_RGB888;

#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
	if ((system_rev & EMXX_REV_MASK) != EMXX_REV_ES1)
#endif
		imc_param->imc_control  = (format | sync);
#if defined(CONFIG_MACH_EMEV) || defined(CONFIG_MACH_EVSY)
	else
		imc_param->imc_control  = (format | sync | IMC_CLKCNT_ALL);
#endif
	imc_preset->imc_control = &imc_param->imc_control;
	imc_param->imc_datareq  = IMC_DATAREQ_INIT;
	imc_preset->imc_datareq = &imc_param->imc_datareq;
	imc_preset->gamma       =
		imc_hw_init_preset_gamma(&imc_param->param_gamma);

#if 0
	imc_preset->yuv         =
		imc_hw_init_preset_yuv(&imc_param->param_yuv);
#else
	imc_preset->yuv         = 0;
#endif

	imc_preset->burst       =
		imc_hw_init_preset_burst(&imc_param->param_burst);

	iRet = emxx_imc_set_preset(imc_info.id, imc_preset);
	if (iRet)
		return -1;

	printk_dbg((_DEBUG_LCDHW & 0x04), "set_preset()\n");

	/**********************
	 * set_update_vsync
	 **********************/
	ImcNxtVsync_Param.imc_cpubufsel = IMC_CPUBUFSEL_INIT;
	ImcNxtVsync_Param.imc_mirror    = uiInverseFlag_tmp = IMC_MIRROR_INIT;
	ImcNxtVsync_Param.imc_l0_scanmode  = IMC_L0_SCANMODE_INIT;
	ImcNxtVsync_Param.imc_l1a_scanmode = IMC_L1A_SCANMODE_INIT;
	ImcNxtVsync_Param.imc_l1b_scanmode = IMC_L1B_SCANMODE_INIT;
	ImcNxtVsync_Param.imc_l1c_scanmode = IMC_L1C_SCANMODE_INIT;
	ImcNxtVsync_Param.imc_l2a_scanmode = IMC_L2A_SCANMODE_INIT;
	ImcNxtVsync_Param.imc_l2b_scanmode = IMC_L2B_SCANMODE_INIT;
	ImcNxtVsync_Param.imc_bg_scanmode  = IMC_BG_SCANMODE_INIT;

	ImcNxtVsync.cpubufsel    = &ImcNxtVsync_Param.imc_cpubufsel;
	ImcNxtVsync.wb           =
	 imc_hw_init_vsync_wb(&ImcNxtVsync_Param.param_wb);
	ImcNxtVsync.mirror       = &ImcNxtVsync_Param.imc_mirror;
	ImcNxtVsync.alphasel     =
	 imc_hw_init_vsync_alphasel(&ImcNxtVsync_Param.param_alphasel);
	ImcNxtVsync.l0_scanmode  = &ImcNxtVsync_Param.imc_l0_scanmode;
	ImcNxtVsync.l1a_scanmode = &ImcNxtVsync_Param.imc_l1a_scanmode;
	ImcNxtVsync.l1b_scanmode = &ImcNxtVsync_Param.imc_l1b_scanmode;
	ImcNxtVsync.l1c_scanmode = &ImcNxtVsync_Param.imc_l1c_scanmode;
	ImcNxtVsync.l2a_scanmode = &ImcNxtVsync_Param.imc_l2a_scanmode;
	ImcNxtVsync.l2b_scanmode = &ImcNxtVsync_Param.imc_l2b_scanmode;
	ImcNxtVsync.bg_scanmode  = &ImcNxtVsync_Param.imc_bg_scanmode;

	iRet = imc_hw_set_update_vsync(&ImcNxtVsync);
	if (iRet)
		return -1;

	printk_dbg((_DEBUG_LCDHW & 0x04), "update_vsync()\n");

	/**********************
	 * set_update_reserve
	 **********************/
	imc_reserve->l0  = imc_hw_init_reserve_l0(&imc_param->param_l0);
	imc_reserve->l1a = imc_hw_init_reserve_l1a(&imc_param->param_l1a);
	imc_reserve->l1b = imc_hw_init_reserve_l1b(&imc_param->param_l1b);
	imc_reserve->l1c = imc_hw_init_reserve_l1c(&imc_param->param_l1c);
	imc_reserve->l2a = imc_hw_init_reserve_l2a(&imc_param->param_l2a);
	imc_reserve->l2b = imc_hw_init_reserve_l2b(&imc_param->param_l2b);
	imc_reserve->bg  = imc_hw_init_reserve_bg(&imc_param->param_bg);

	iRet = emxx_imc_set_update_reserve(imc_info.id, imc_reserve,
	 imc_param->callback_refresh);
	if (iRet)
		return -1;

	printk_dbg((_DEBUG_LCDHW & 0x04), "update_reserve()\n");

	return 0;
}


#if defined(CONFIG_PM) || defined(CONFIG_DPM) || defined(CONFIG_EMXX_LCDHW_PMWLCD)
/******************************************************************************
* MODULE   : imc_hw_restore_reg
* FUNCTION : restore IMC(H/W) register
* RETURN   : 0     : success
*            other : fail
* NOTE     : none
******************************************************************************/
int imc_hw_restore_reg(void)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!imc_param) {
		printk_err("not allocate memory for \"IMC info\"\n");
		return -ENOMEM;
	}

	/**********************
	 * set_preset
	 **********************/
	if (emxx_imc_set_preset(imc_info.id, imc_preset)) {
		printk_err("set_preset() failed!\n");
		return -1;
	}
	printk_dbg((_DEBUG_LCDHW & 0x04), "set_preset()\n");

	/**********************
	 * set_update_vsync
	 **********************/
	if (imc_hw_set_update_vsync(&ImcNxtVsync)) {
		printk_err("set_update_vsync() failed!\n");
		return -1;
	}
	printk_dbg((_DEBUG_LCDHW & 0x04), "set_update_vsync()\n");

	IMC_reset_flg = 0;
	return 0;
}
#endif /* CONFIG_PM || CONFIG_DPM */


/*****************************************************************************
* MODULE   : imc_hw_init_preset_gamma
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_preset_gamma(struct imc_gamma_param *param_gamma)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_gamma)
		return NULL;
	memset(param_gamma, 0, sizeof(struct imc_gamma_param));

	param_gamma->en   = IMC_GAMMA_EN_INIT;
	param_gamma->adr  = IMC_GAMMA_ADR_INIT;
	param_gamma->data = NULL;

	return param_gamma;
}


/*****************************************************************************
* MODULE   : imc_hw_init_preset_yuv
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_preset_yuv(struct imc_yuv_param *param_yuv)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_yuv)
		return NULL;
	memset(param_yuv, 0, sizeof(struct imc_yuv_param));

	param_yuv->ygain   = IMC_YGAINOFFSET_INIT;
	param_yuv->ugain   = IMC_UGAINOFFSET_INIT;
	param_yuv->vgain   = IMC_VGAINOFFSET_INIT;
	param_yuv->yuv2rgb = IMC_YUV2RGB_INIT;
	if ((param_yuv->yuv2rgb & IMC_TRANSMODE_BIT) == IMC_TRANSMODE_CUSTOM1 ||
	    (param_yuv->yuv2rgb & IMC_TRANSMODE_BIT) == IMC_TRANSMODE_CUSTOM2) {
		param_yuv->coef_r[0] = IMC_COEF_R0_INIT;
		param_yuv->coef_r[1] = IMC_COEF_R1_INIT;
		param_yuv->coef_r[2] = IMC_COEF_R2_INIT;
		param_yuv->coef_r[3] = IMC_COEF_R3_INIT;
		param_yuv->coef_g[0] = IMC_COEF_G0_INIT;
		param_yuv->coef_g[1] = IMC_COEF_G1_INIT;
		param_yuv->coef_g[2] = IMC_COEF_G2_INIT;
		param_yuv->coef_g[3] = IMC_COEF_G3_INIT;
		param_yuv->coef_b[0] = IMC_COEF_B0_INIT;
		param_yuv->coef_b[1] = IMC_COEF_B1_INIT;
		param_yuv->coef_b[2] = IMC_COEF_B2_INIT;
		param_yuv->coef_b[3] = IMC_COEF_B3_INIT;
	}

	return param_yuv;
}


/*****************************************************************************
* MODULE   : imc_hw_init_preset_burst
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_preset_burst(struct imc_burst_param *param_burst)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_burst)
		return NULL;
	memset(param_burst, 0, sizeof(struct imc_burst_param));

	param_burst->burst_en  = IMC_BURST_EN_INIT;
	param_burst->threshold = IMC_THRESHOLD_INIT;

	return param_burst;
}


/*****************************************************************************
* MODULE   : imc_hw_init_vsync_wb
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_vsync_wb(struct imc_wb_param *param_wb)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_wb)
		return NULL;
	memset(param_wb, 0, sizeof(struct imc_wb_param));

	param_wb->areaadr_p = LCD_AREAADR_ODD_INIT;
	param_wb->areaadr_q = LCD_AREAADR_EVEN_INIT;
	param_wb->hoffset   = FRONT_WIDTH_LCD * BITS_PER_PIXEL / 8;
	param_wb->format    = IMC_WB_FORMAT_RGB888;
	param_wb->size      = (FRONT_WIDTH_LCD << IMC_WB_HSIZE_SFT) |
			      (FRONT_HEIGHT_LCD << IMC_WB_VSIZE_SFT);
	param_wb->bufsel    = IMC_WB_BUFSEL_INIT;
	param_wb->mposition = IMC_Lx_MPOSX_MIN | IMC_Lx_MPOSY_MIN;
	param_wb->msize     = IMC_Lx_MSIZEX_MAX | IMC_Lx_MSIZEY_MAX;
	param_wb->color     = IMC_BACKCOLOR_INIT;
	param_wb->bytelane  = IMC_WB_BYTELANE_INIT;
	param_wb->scanmode  = IMC_WB_SCANMODE_INIT;

	return param_wb;
}


/*****************************************************************************
* MODULE   : imc_hw_init_vsync_alphasel
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_vsync_alphasel(
 struct imc_alphasel_param *param_alphasel)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_alphasel)
		return NULL;
	memset(param_alphasel, 0, sizeof(struct imc_alphasel_param));

	param_alphasel->alphasel0 = IMC_ALPHASEL0_INIT;
	param_alphasel->alphasel1 = IMC_ALPHASEL1_INIT;

	return param_alphasel;
}


/*****************************************************************************
* MODULE   : imc_hw_init_reserve_l0
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_reserve_l0(struct l01_param *param_l0)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_l0)
		return NULL;
	memset(param_l0, 0, sizeof(struct l01_param));

	param_l0->control    = IMC_L0_CONTROL_INIT;
	param_l0->format     = IMC_L0_FORMAT_INIT;
	param_l0->bufsel     = IMC_L0_BUFSEL_INIT;
	param_l0->bytelane   = IMC_L0_BYTELANE_INIT;
	param_l0->keyenable  = IMC_L0_KEYENABLE_INIT;
	param_l0->keycolor   = IMC_L0_KEYCOLOR_INIT;
	param_l0->alpha      = IMC_L0_ALPHA_INIT;
	param_l0->resize     = IMC_L0_RESIZE_INIT;
	param_l0->mirror     = IMC_L0_MIRROR_INIT;
	param_l0->offset     = IMC_L0_OFFSET_INIT;
	param_l0->frameadr_p = IMC_L0_FRAMEADR_P_INIT;
	param_l0->frameadr_q = IMC_L0_FRAMEADR_Q_INIT;
	param_l0->position   = IMC_L0_POSITION_INIT;
	param_l0->size       = IMC_L0_SIZE_INIT;
	param_l0->mposition  = IMC_Lx_MPOSX_MIN | IMC_Lx_MPOSY_MIN;
	param_l0->msize      = IMC_Lx_MSIZEX_MAX | IMC_Lx_MSIZEY_MAX;

	return param_l0;
}


/*****************************************************************************
* MODULE   : imc_hw_init_reserve_l1a
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_reserve_l1a(struct l01_param *param_l1a)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_l1a)
		return NULL;
	memset(param_l1a, 0, sizeof(struct l01_param));

	param_l1a->format     = IMC_L01x_FORMAT_RGB565;
	param_l1a->offset     = FRONT_WIDTH_V_LCD * BYTES_PER_PIXEL;

	param_l1a->control    = IMC_L1A_CONTROL_INIT;
	param_l1a->bufsel     = IMC_L1A_BUFSEL_INIT;
	param_l1a->bytelane   = IMC_L1A_BYTELANE_INIT;
	param_l1a->keyenable  = IMC_L1A_KEYENABLE_INIT;
	param_l1a->keycolor   = IMC_L1A_KEYCOLOR_INIT;
	param_l1a->alpha      = IMC_L1A_ALPHA_INIT;
	param_l1a->resize     = IMC_L1A_RESIZE_INIT;
	param_l1a->mirror     = IMC_L1A_MIRROR_INIT;
	param_l1a->frameadr_p = IMC_L1A_FRAMEADR_P_INIT;
	param_l1a->frameadr_q = IMC_L1A_FRAMEADR_Q_INIT;
	param_l1a->position   = IMC_L1A_POSITION_INIT;
	param_l1a->size       = IMC_L1A_SIZE_INIT;
	param_l1a->mposition  = IMC_L1A_MPOSITION_INIT;
	param_l1a->msize      = IMC_Lx_MSIZEX_MAX | IMC_Lx_MSIZEY_MAX;

	return param_l1a;
}


/*****************************************************************************
* MODULE   : imc_hw_init_reserve_l1b
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_reserve_l1b(struct l01_param *param_l1b)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_l1b)
		return NULL;
	memset(param_l1b, 0, sizeof(struct l01_param));

	param_l1b->control    = IMC_L1B_CONTROL_INIT;
	param_l1b->format     = IMC_L1B_FORMAT_INIT;
	param_l1b->bufsel     = IMC_L1B_BUFSEL_INIT;
	param_l1b->bytelane   = IMC_L1B_BYTELANE_INIT;
	param_l1b->keyenable  = IMC_L1B_KEYENABLE_INIT;
	param_l1b->keycolor   = IMC_L1B_KEYCOLOR_INIT;
	param_l1b->alpha      = IMC_L1B_ALPHA_INIT;
	param_l1b->resize     = IMC_L1B_RESIZE_INIT;
	param_l1b->mirror     = IMC_L1B_MIRROR_INIT;
	param_l1b->offset     = IMC_L1B_OFFSET_INIT;
	param_l1b->frameadr_p = IMC_L1B_FRAMEADR_P_INIT;
	param_l1b->frameadr_q = IMC_L1B_FRAMEADR_Q_INIT;
	param_l1b->position   = IMC_L1B_POSITION_INIT;
	param_l1b->size       = IMC_L1B_SIZE_INIT;
	param_l1b->mposition  = IMC_L1B_MPOSITION_INIT;
	param_l1b->msize      = IMC_Lx_MSIZEX_MAX | IMC_Lx_MSIZEY_MAX;

	return param_l1b;
}


/*****************************************************************************
* MODULE   : imc_hw_init_reserve_l1c
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_reserve_l1c(struct l01_param *param_l1c)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_l1c)
		return NULL;
	memset(param_l1c, 0, sizeof(struct l01_param));

	param_l1c->control    = IMC_L1C_CONTROL_INIT;
	param_l1c->format     = IMC_L1C_FORMAT_INIT;
	param_l1c->bufsel     = IMC_L1C_BUFSEL_INIT;
	param_l1c->bytelane   = IMC_L1C_BYTELANE_INIT;
	param_l1c->keyenable  = IMC_L1C_KEYENABLE_INIT;
	param_l1c->keycolor   = IMC_L1C_KEYCOLOR_INIT;
	param_l1c->alpha      = IMC_L1C_ALPHA_INIT;
	param_l1c->resize     = IMC_L1C_RESIZE_INIT;
	param_l1c->mirror     = IMC_L1C_MIRROR_INIT;
	param_l1c->offset     = IMC_L1C_OFFSET_INIT;
	param_l1c->frameadr_p = IMC_L1C_FRAMEADR_P_INIT;
	param_l1c->frameadr_q = IMC_L1C_FRAMEADR_Q_INIT;
	param_l1c->position   = IMC_L1C_POSITION_INIT;
	param_l1c->size       = IMC_L1C_SIZE_INIT;
	param_l1c->mposition  = IMC_L1C_MPOSITION_INIT;
	param_l1c->msize      = IMC_Lx_MSIZEX_MAX | IMC_Lx_MSIZEY_MAX;

	return param_l1c;
}


/*****************************************************************************
* MODULE   : imc_hw_init_reserve_l2a
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_reserve_l2a(struct l2_param *param_l2a)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_l2a)
		return NULL;
	memset(param_l2a, 0, sizeof(struct l2_param));

	param_l2a->control     = IMC_L2A_CONTROL_INIT;
	param_l2a->format      = IMC_L2A_FORMAT_INIT;
	param_l2a->bufsel      = IMC_L2A_BUFSEL_INIT;
	param_l2a->bytelane    = IMC_L2A_BYTELANE_INIT;
	param_l2a->resize      = IMC_L2A_RESIZE_INIT;
	param_l2a->mirror      = IMC_L2A_MIRROR_INIT;
	param_l2a->offset      = IMC_L2A_OFFSET_INIT;
	param_l2a->frameadr_yp = IMC_L2A_FRAMEADR_YP_INIT;
	param_l2a->frameadr_up = IMC_L2A_FRAMEADR_UP_INIT;
	param_l2a->frameadr_vp = IMC_L2A_FRAMEADR_VP_INIT;
	param_l2a->frameadr_yq = IMC_L2A_FRAMEADR_YQ_INIT;
	param_l2a->frameadr_uq = IMC_L2A_FRAMEADR_UQ_INIT;
	param_l2a->frameadr_vq = IMC_L2A_FRAMEADR_VQ_INIT;
	param_l2a->position    = IMC_L2A_POSITION_INIT;
	param_l2a->size        = IMC_L2A_SIZE_INIT;
	param_l2a->mposition   = IMC_Lx_MPOSX_MIN | IMC_Lx_MPOSY_MIN;
	param_l2a->msize       = IMC_Lx_MSIZEX_MAX | IMC_Lx_MSIZEY_MAX;

	return param_l2a;
}


/*****************************************************************************
* MODULE   : imc_hw_init_reserve_l2b
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_reserve_l2b(struct l2_param *param_l2b)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_l2b)
		return NULL;
	memset(param_l2b, 0, sizeof(struct l2_param));

	param_l2b->control     = IMC_L2B_CONTROL_INIT;
	param_l2b->format      = IMC_L2B_FORMAT_INIT;
	param_l2b->bufsel      = IMC_L2B_BUFSEL_INIT;
	param_l2b->bytelane    = IMC_L2B_BYTELANE_INIT;
	param_l2b->resize      = IMC_L2B_RESIZE_INIT;
	param_l2b->mirror      = IMC_L2B_MIRROR_INIT;
	param_l2b->offset      = IMC_L2B_OFFSET_INIT;
	param_l2b->frameadr_yp = IMC_L2B_FRAMEADR_YP_INIT;
	param_l2b->frameadr_up = IMC_L2B_FRAMEADR_UP_INIT;
	param_l2b->frameadr_vp = IMC_L2B_FRAMEADR_VP_INIT;
	param_l2b->frameadr_yq = IMC_L2B_FRAMEADR_YQ_INIT;
	param_l2b->frameadr_uq = IMC_L2B_FRAMEADR_UQ_INIT;
	param_l2b->frameadr_vq = IMC_L2B_FRAMEADR_VQ_INIT;
	param_l2b->position    = IMC_L2B_POSITION_INIT;
	param_l2b->size        = IMC_L2B_SIZE_INIT;
	param_l2b->mposition   = IMC_Lx_MPOSX_MIN | IMC_Lx_MPOSY_MIN;
	param_l2b->msize       = IMC_Lx_MSIZEX_MAX | IMC_Lx_MSIZEY_MAX;

	return param_l2b;
}


/*****************************************************************************
* MODULE   : imc_hw_init_reserve_bg
* FUNCTION :
* RETURN   : char *
* NOTE     : none
******************************************************************************/
static void *imc_hw_init_reserve_bg(struct bg_param *param_bg)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "\n");

	if (!param_bg)
		return NULL;
	memset(param_bg, 0, sizeof(struct bg_param));

	param_bg->format     = IMC_BG_FORMAT_BACKCOLOR;
	param_bg->bufsel     = IMC_BG_BUFSEL_INIT;
	param_bg->bytelane   = IMC_BG_BYTELANE_INIT;
	param_bg->resize     = IMC_BG_RESIZE_INIT;
	param_bg->mirror     = IMC_BG_MIRROR_INIT;
	param_bg->offset     = IMC_BG_OFFSET_INIT;
	param_bg->frameadr_p = IMC_BG_FRAMEADR_P_INIT;
	param_bg->frameadr_q = IMC_BG_FRAMEADR_Q_INIT;
	param_bg->mposition  = IMC_Lx_MPOSX_MIN | IMC_Lx_MPOSY_MIN;
	param_bg->msize      = IMC_Lx_MSIZEX_MAX | IMC_Lx_MSIZEY_MAX;

	return param_bg;
}


/*****************************************************************************
* MODULE   : imc_hw_set_update_vsync
* FUNCTION :
* RETURN   :  0: success
*          : -1: failed
* NOTE     : none
******************************************************************************/
int imc_hw_set_update_vsync(struct emxx_imc_update_vsync *vsync)
{
	printk_dbg((_DEBUG_LCDHW & 0x01), "in\n");

	if (emxx_imc_set_update_vsync(imc_info.id, vsync)) {
		printk_dbg((_DEBUG_LCDHW & 0x04),
		 "emxx_imc_set_update_vsync() failed\n");
		return -1;
	}

	printk_dbg((_DEBUG_LCDHW & 0x04),
	 "emxx_imc_set_update_vsync() success\n");

	*imc_vsync->cpubufsel    = *vsync->cpubufsel;
	*imc_vsync->mirror       = *vsync->mirror;
	*imc_vsync->l0_scanmode  = *vsync->l0_scanmode;
	*imc_vsync->l1a_scanmode = *vsync->l1a_scanmode;
	*imc_vsync->l1b_scanmode = *vsync->l1b_scanmode;
	*imc_vsync->l1c_scanmode = *vsync->l1c_scanmode;
	*imc_vsync->l2a_scanmode = *vsync->l2a_scanmode;
	*imc_vsync->l2b_scanmode = *vsync->l2b_scanmode;
	*imc_vsync->bg_scanmode  = *vsync->bg_scanmode;
	memcpy(imc_vsync->wb, vsync->wb, sizeof(struct imc_wb_param));
	memcpy(imc_vsync->alphasel, vsync->alphasel,
	 sizeof(struct imc_alphasel_param));

	printk_dbg((_DEBUG_LCDHW & 0x02), "out\n");
	return 0;
}


/*****************************************************************************
* MODULE   : imc_hw_set_update_reserve
* FUNCTION :
* RETURN   :  0: success
*          : -1: failed
* NOTE     : none
******************************************************************************/
int imc_hw_set_update_reserve(int type, int mixdsp, int update)
{
	struct l01_param tmp_fb_layer;
	int iRet;
	printk_dbg((_DEBUG_LCDHW & 0x01), "in\n");

	/**********************
	 * set_update_reserve
	 **********************/
	if (type == SET_LAYER_2D) {
		memcpy(&tmp_fb_layer, &fb_layer, sizeof(struct l01_param));
		if (mixdsp != MIX_DSP_ON)
			tmp_fb_layer.keyenable = IMC_Lx_KEYEN_DISABLE;

		/* set 2D(DispBuffer) layer */
		printk_dbg((_DEBUG_LCDHW & 0x04), "   set2D\n");
		imc_reserve->l1a = &tmp_fb_layer;
	} else if (type == SET_LAYER_V4L2) {
		/* set v4l2 layer */
		printk_dbg((_DEBUG_LCDHW & 0x04), "   setV4L2\n");
		imc_reserve->l1a = &fb_layer;
		imc_reserve->l2b = &v4l2_layer;
	} else if (type == CLR_LAYER_V4L2) {
		memcpy(&tmp_fb_layer, &fb_layer, sizeof(struct l01_param));
		if (mixdsp != MIX_DSP_ON)
			tmp_fb_layer.keyenable = IMC_Lx_KEYEN_DISABLE;

		/* clr v4l2 layer */
		printk_dbg((_DEBUG_LCDHW & 0x04), "   clrV4L2\n");
		imc_reserve->l1a = &tmp_fb_layer;
		imc_reserve->l2b =
			imc_hw_init_reserve_l2b(&imc_param->param_l2b);
	} else {
		printk_dbg((_DEBUG_LCDHW & 0x04), "   set----\n");
		return -1;
	}

	if (update ==  UPDATE_ON) {
		iRet = emxx_imc_set_update_reserve(imc_info.id, imc_reserve,
		 imc_param->callback_refresh);
		if (iRet)
			return -1;
		if (lcd_field == FIELD_NONE) {
			printk_dbg((_DEBUG_LCDHW & 0x10), "Set REFRESH\n");
			emxx_imc_set_refresh(imc_info.id);
		} else {
			if (v4l2_field == V4L2_TOP_BOTTOM) {
				if (lcd_field == FIELD_EVEN) {
					printk_dbg((_DEBUG_LCDHW & 0x10),
					 "Set REFRESH\n");
					emxx_imc_set_refresh(imc_info.id);
				} else {
					printk_dbg((_DEBUG_LCDHW & 0x10),
					 "Reserve REFRESH\n");
					refresh_reserved = 1;
				}
			} else { /* v4l2_field == V4L2_BOTTOM_TOP */
				if (lcd_field == FIELD_ODD) {
					printk_dbg((_DEBUG_LCDHW & 0x10),
					 "Set REFRESH\n");
					emxx_imc_set_refresh(imc_info.id);
				} else {
					printk_dbg((_DEBUG_LCDHW & 0x10),
					 "Reserve REFRESH\n");
					refresh_reserved = 1;
				}
			}
		}
	}
	printk_dbg((_DEBUG_LCDHW & 0x02), "out\n");

	return 0;
}


