/*
 * File Name       : drivers/video/emxx/emxx_mod_pmwlcd.h
 * Function        : PMWLCD Driver (Module Control)
 * Release Version : Ver 1.17
 * Release Date    : 2012.11.14
 *
 * Copyright (C) 2012 Sony Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */


#ifndef _EMXX_MOD_PMWLCD_H_
#define _EMXX_MOD_PMWLCD_H_

/**
 * PMWLCD用パラメータ定義
 */
#define LCDM_PARAM_DEVINFO_0		0	/*!<   LCD, 2D    */
#define LCDM_PARAM_DEVINFO_1		1	/*!<   LCD, 2D/3D */
#define LCDM_PARAM_DEVINFO_2		2	/*!<  OLED, 2D    */

#define LCDM_PARAM_MODULEID_DUMMY0	0	/*!< reserved              */
#define LCDM_PARAM_MODULEID_QVGA	1	/*!<  320H x 240V  (QVGA)  */
#define LCDM_PARAM_MODULEID_VGA		2	/*!<  640H x 480V  (VGA)   */
#define LCDM_PARAM_MODULEID_FWVGA	3	/*!<  852H x 480V  (FWVGA) */
#define LCDM_PARAM_MODULEID_QHG		4	/*!<  960H x 540V  (qHG))  */
#define LCDM_PARAM_MODULEID_HDTV	5	/*!< 1280H x 720V  (HDTV)  */
#define LCDM_PARAM_MODULEID_FHD		6	/*!< 1920H x 1080V (FHD)   */

#define LCDM_PARAM_FRAMERATE_60HZ	0	/*!< 60Hz */
#define LCDM_PARAM_FRAMERATE_50HZ	1	/*!< 50Hz */

#define LCDM_PARAM_NORMAL		0	/*!< 正転 */
#define LCDM_PARAM_REVERSE		1	/*!< 反転 */

#define LCDM_PARAM_OFF			0	/*!< OFF */
#define LCDM_PARAM_ON			1	/*!< ON  */

#define LCDM_PARAM_2D			0	/*!< 2D */
#define LCDM_PARAM_3D			1	/*!< 3D */

typedef struct lcdm_param_module_t {
	unsigned int devinfo;
	unsigned int moduleid;
}lcdm_param_module_t;

typedef struct lcdm_param_userfunc_t {
	unsigned int framerate;
	unsigned int flip_h;
	unsigned int flip_v;
}lcdm_param_userfunc_t;

typedef struct lcdm_param_devfunc_t {
	unsigned int sidebyside;
	unsigned int dimension;
}lcdm_param_devfunc_t;

enum {
	LCDM_PARAM_BRIGHTNESS_VERY_LOW = 0,
	LCDM_PARAM_BRIGHTNESS_LOW      = 1,
	LCDM_PARAM_BRIGHTNESS_MIDDLE   = 2,
	LCDM_PARAM_BRIGHTNESS_HIGH     = 3,
	LCDM_PARAM_BRIGHTNESS_NUM,

	LCDM_PARAM_BRIGHTNESS_MIN      = LCDM_PARAM_BRIGHTNESS_VERY_LOW,
	LCDM_PARAM_BRIGHTNESS_MAX      = LCDM_PARAM_BRIGHTNESS_HIGH,
};

/**
 * 電源状態
 */
#define LCDM_PARAM_POWER_OFF		0
#define LCDM_PARAM_POWER_ON		1

/* 入力タイミング */
typedef struct lcdm_input_timing_t {
	unsigned int harea;
	unsigned int hpulse;
	unsigned int hfrontp;
	unsigned int hbackp;
	unsigned int varea;
	unsigned int vpulse;
	unsigned int vfrontp;
	unsigned int vbackp;
	unsigned int voff_odd;
	unsigned int voff_even;
}lcdm_input_timing_t;

/**
 * 通知イベント
 */
#define LCDM_EVENT_UNDERRUN	0x00000001
#define LCDM_EVENT_INITERR	0x00000002
#define LCDM_EVENT_RESTART	0x00000004
#define LCDM_EVENT_SPIERR	0x00000008

/**
 * 通知イベント操作用
 */
#define LCDM_OFF	0
#define LCDM_ON		1


/********************************************************
 *  Variables                                           *
 *******************************************************/


/********************************************************
 *  Prototype declarations of function                  *
 *******************************************************/
/* ------------------ PMWLCD初期化終了化関数 --------------------- */
extern int init_mod_pmwlcd(void);
extern int exit_mod_pmwlcd(void);

/* ------------------ LCDモジュール監視関数 ----------------------- */
extern void lcdm_start_polling(void);
extern void lcdm_stop_polling(void);

/* ------------------ LCDモジュールパラメータ操作関数 ------------- */
extern void lcdm_param_get_timing_fix(lcdm_input_timing_t *input_timing);
extern void lcdm_param_get_timing(lcdm_input_timing_t *input_timing);
extern void lcdm_param_get_module(lcdm_param_module_t *param);
extern void lcdm_param_set_module(lcdm_param_module_t *param);
extern void lcdm_param_get_userfunc(lcdm_param_userfunc_t *param);
extern void lcdm_param_set_userfunc(lcdm_param_userfunc_t *param);
extern void lcdm_param_get_devfunc(lcdm_param_devfunc_t *param);
extern void lcdm_param_set_devfunc(lcdm_param_devfunc_t *param);
extern void lcdm_param_get_brightness(unsigned int *param);
extern void lcdm_param_set_brightness(unsigned int *param);
extern unsigned int lcdm_status_get_power(void);
extern void         lcdm_status_set_power(unsigned int status);
extern void lcdm_event_set_value(unsigned int event, unsigned int mask);
extern bool lcdm_debug_get_spi_force_error(void);

#endif /* _EMXX_MOD_PMWLCD_H_ */
