/*
 * fs/proc/freemem.c
 *
 * Copyright 2010 Sony Corporation.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation; version 2 of the License.
 *
 * THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 * WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 * NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 * USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write  to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <linux/mman.h>
#include <linux/proc_fs.h>
#include <linux/swap.h>
#include <linux/seq_file.h>
#include <linux/vmalloc.h>

extern struct seq_operations freemem_op;
static int freemem_open(struct inode *inode, struct file *file)
{
	return seq_open(file, &freemem_op);
}
static struct file_operations proc_freemem_operations = {
	.open           = freemem_open,
	.read           = seq_read,
	.llseek         = seq_lseek,
	.release        = seq_release,
};

void __init proc_freemem_init(void)
{
	struct proc_dir_entry *entry;
	entry = create_proc_entry("freemem", S_IWUSR|S_IRUGO, NULL);
	if (entry)
		entry->proc_fops = &proc_freemem_operations;
}
module_init(proc_freemem_init);
