/*
 * em_export.h - Exception Monitor exported functions
 *
 * Copyright 2010  Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef __EM_EXPORT_H__
#define __EM_EXPORT_H__

struct pt_regs;
typedef void (*em_callback_t)(struct pt_regs *regs, void *arg);

extern void *em_register_usermode_callback(em_callback_t fun, void *arg);
extern void em_unregister_usermode_callback(void *handle);

extern void *em_register_atomic_callback(em_callback_t fun, void *arg);
extern void em_unregister_atomic_callback(void *handle);

extern void em_reboot(int force);
extern void em_cond_reboot(void);

#endif
