/*
 * include/linux/udif/atomic.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_ATOMIC_H__
#define __UDIF_ATOMIC_H__

#include <asm/atomic.h>

typedef atomic_t UDIF_ATOMIC;

#define UDIF_ATOMIC_INIT(i)	ATOMIC_INIT(i)
#define udif_atomic_set(v,i)	atomic_set(v,i)
#define udif_atomic_read(v)	atomic_read(v)
#define udif_atomic_inc(v)	atomic_inc(v)
#define udif_atomic_dec(v)	atomic_dec(v)
#define udif_atomic_dec_and_test(v)	atomic_dec_and_test(v)

#endif /* __UDIF_ATOMIC_H__ */
