/*
 * include/linux/udif/boottime.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_BOOT_TIME_H__
#define __UDIF_BOOT_TIME_H__

#include <linux/snsc_boot_time.h>
#include <linux/kernel.h>

#define MAX_COMMENT 64

#define UDIF_TAGID_BEGIN	0
#define UDIF_TAGID_END		1

static inline void udif_timetag(unsigned short sid, unsigned short tagid, const char *tag)
{
	char buf[MAX_COMMENT];

	scnprintf(buf, sizeof(buf),
		  "%04X %s %s", sid, tagid == UDIF_TAGID_BEGIN ? "B" : "E", tag);

	BOOT_TIME_ADD1(buf);
}

#endif /* __UDIF_BOOT_TIME_H__ */
