/*
 * include/linux/udif/cache.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_CACHE_H__
#define __UDIF_CACHE_H__

#include <linux/dma-mapping.h>
#include <linux/udif/types.h>
#include <linux/udif/macros.h>
#include <asm/dma-mapping.h>

typedef enum {
	UDIF_CACHE_BIDRECTIONAL	= DMA_BIDIRECTIONAL,
	UDIF_CACHE_FLUSH	= DMA_TO_DEVICE,
	UDIF_CACHE_INVALIDATE	= DMA_FROM_DEVICE,
	UDIF_CACHE_NONE		= DMA_NONE,
} UDIF_CACHE_FLAGS;

static inline void udif_cache_ctrl(UDIF_VA va, UDIF_SIZE size, UDIF_CACHE_FLAGS dir)
{
	if (unlikely(!va || !size)) {
		UDIF_PERR("invalid param: addr:0x%p, size:0x%08x\n", va, size);
		return;
	}

	dma_sync_single_for_device(NULL, virt_to_phys(va), size, dir);
}

#define udif_cache_ctrl_r(a,s,f) udif_cache_ctrl(a,s,f)

#endif /* __UDIF_CACHE_H__ */
