/*
 * include/linux/udif/dmac.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_DMAC_H__
#define __UDIF_DMAC_H__

#include <linux/udif/irq.h>

#define UDIF_DMAC_NORQID (-1UL)

typedef struct UDIF_DMAC {
	const UDIF_CH	ch;
	const UDIF_U32	rqid;
	UDIF_INTRPT intr;
} UDIF_DMAC;

typedef struct __UDIF_DMAC {
	const UDIF_UINT	num;
	UDIF_DMAC	*dmac;
} __UDIF_DMAC;

#define __udif_dmac_num(d)			((d)->num)
#define __udif_dmac_ch(d,i)			((d)->dmac[i].ch)
#define __udif_dmac_rqid(d,i)			((d)->dmac[i].rqid)
#define __udif_dmac_irq(d,i)			udif_intr_irq(&(d)->dmac[i].intr)
#define __udif_dmac_flags(d,i)			udif_intr_flags(&(d)->dmac[i].intr)

#define __udif_dmac_request_irq(d,i,hndl,data)	__udif_request_irq(&(d)->dmac[i].intr,hndl,data)
#define __udif_dmac_free_irq(d,i)		__udif_free_irq(&(d)->dmac[i].intr)

#define __udif_dmastop(d,i)		dma_stop((d)->dmac[i].ch)
#define __udif_dmastart(d,i,p,c)	dma_start((d)->dmac[i].ch,p,c)
#define __udif_dmaclear(d,i)		dma_clear((d)->dmac[i].ch)
#define __udif_dmainttc_status(d,i)	dma_inttc_status((d)->dmac[i].ch)

#endif /* __UDIF_DMAC_H__ */
