/*
 * include/linux/udif/file.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_FILE_H__
#define __UDIF_FILE_H__

#include <linux/ioctl.h>
#include <linux/udif/types.h>

#define udif_file_data(x)	(*(x)->data)
#define udif_file_major(x)	((x) ? MAJOR((x)->devno): 0)
#define udif_file_minor(x)	((x) ? MINOR((x)->devno): 0)
#define udif_file_bdev(x)	((x) ? (x)->bdev: 0)

#define UDIF_MKDEV(m, n)	MKDEV(m, n)

typedef struct UDIF_FILE {
	UDIF_DEVNO	devno;
	UDIF_VP		*data;
} UDIF_FILE;

typedef struct UDIF_IOCTL {
	UDIF_UINT	cmd;
	UDIF_ULONG	arg;
	UDIF_UINT	disk_change;
} UDIF_IOCTL;

typedef	UDIF_ERR (*UDIF_FILE_CB)(UDIF_FILE *);
typedef	UDIF_ERR (*UDIF_IOCTL_CB)(UDIF_FILE *, UDIF_IOCTL *);

#endif /* __UDIF_FILE_H__ */
