/*
 * include/linux/udif/io.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_IO_H__
#define __UDIF_IO_H__

#include <linux/udif/string.h>
#include <asm/io.h>
#include <mach/hardware.h>

#define UDIF_IO_ADDRESS(x) ((void __iomem __force *)IO_ADDRESS(x))

#define UDIF_IO_FLAGS_NONCACHED	0x0000
#define UDIF_IO_FLAGS_CACHED	0x0001
#define UDIF_IO_FLAGS_SHARED	0x0002

typedef struct UDIF_IOMEM {
	UDIF_U8		name[8];
	UDIF_PA		phys;
	UDIF_SIZE	size;
	UDIF_VA		virt;
	UDIF_U32	flags;
} UDIF_IOMEM;

#define udif_iomem_virt(x) ((x)?(x)->virt:0)
#define udif_iomem_phys(x) ((x)?(x)->phys:0)
#define udif_iomem_size(x) ((x)?(x)->size:0)
#define udif_iomem_flags(x) ((x)?(x)->flags:(-1UL))

#define UDIF_IOMEM_INIT(n,p,s,f) \
{ \
	.name	= n, \
	.phys	= p, \
	.size	= s, \
	.virt	= UDIF_IO_ADDRESS(p), \
	.flags	= f, \
}
#define UDIF_DECLARE_IOMEM(name,n,p,s,f) \
	UDIF_IOMEM name = UDIF_IOMEM_INIT(n,p,s,f)

UDIF_VA  udif_ioremap(UDIF_IOMEM *);
UDIF_ERR udif_iounmap(UDIF_IOMEM *);

#define udif_ioread8(a)		readb(a)
#define udif_ioread16(a)	readw(a)
#define udif_ioread32(a)	readl(a)

#define udif_iowrite8(v,a)	writeb(v,a)
#define udif_iowrite16(v,a)	writew(v,a)
#define udif_iowrite32(v,a)	writel(v,a)

static inline void udif_iomem_init(UDIF_IOMEM *io, const UDIF_U8 *name, UDIF_PA phys,
				   UDIF_SIZE size, UDIF_U32 flags)
{
	__strncpy(io->name, name, sizeof(io->name));
	io->phys = phys;
	io->size = size;
	io->virt = UDIF_IO_ADDRESS(phys);
	io->flags = flags;
}

#endif /* __UDIF_IO_H__ */
