/*
 * include/linux/udif/irq.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_IRQ_H__
#define __UDIF_IRQ_H__

typedef struct UDIF_INTR {
	UDIF_IRQ	irq;
	UDIF_VP		data;
} UDIF_INTR;

typedef	UDIF_ERR (*UDIF_INT_CB)(UDIF_INTR *);

typedef struct UDIF_INTRPT {
	UDIF_U8		name[16];
	UDIF_IRQ	irq;
	UDIF_U32	flags;
	UDIF_INT_CB	hndl;
	UDIF_VP		data;
} UDIF_INTRPT;

UDIF_ERR __udif_request_irq(UDIF_INTRPT *, UDIF_INT_CB, UDIF_VP);
UDIF_ERR __udif_free_irq(UDIF_INTRPT *);

#define udif_intr_irq(x)	((x)?(x)->irq:0)
#define udif_intr_flags(x)	((x)?(x)->flags:(-1UL))
#define udif_intr_data(x)	((x)?(x)->data:0)

#define __udif_clearirq(x)	gic_clearirq((x)->irq)
#define __udif_maskirq(x,e)	gic_maskirq((x)->irq,e)
#define __udif_pollirq(x)	gic_pollirq((x)->irq)

#endif /* __UDIF_IRQ_H__ */
