/*
 * include/linux/udif/mmap.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_MMAP_H__
#define __UDIF_MMAP_H__

#include <linux/mm.h>

#define UDIF_VM_IO		VM_IO
#define UDIF_VM_PFNMAP		VM_PFNMAP
#define UDIF_VM_RESERVED	VM_RESERVED

typedef struct vm_area_struct UDIF_VMAREA;

#define udif_remap_pfn_range(vma, start, pfn, sz, prot) \
	remap_pfn_range(vma, start, pfn, sz, (prot) | L_PTE_DIRTY)

#define udif_pgprot_noncached	pgprot_noncached

#endif /* __UDIF_MMAP_H__ */
