/*
 * include/linux/udif/mutex.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_MUTEX_H__
#define __UDIF_MUTEX_H__

#include <linux/mutex.h>
#include <linux/udif/types.h>
#include <linux/udif/macros.h>

typedef struct UDIF_MUTEX {
	struct mutex	mtx;
} UDIF_MUTEX;

#define UDIF_MUTEX_INIT(name) { .mtx = __MUTEX_INITIALIZER(name.mtx) }
#define UDIF_DECLARE_MUTEX(name) \
	UDIF_MUTEX name = UDIF_MUTEX_INIT(name)

#define udif_mutex_init(m)	UDIF_PARM_CHK_FN(m, mutex_init, &(m)->mtx)
#define udif_mutex_lock(m)	UDIF_PARM_CHK_FN(m, mutex_lock, &(m)->mtx)
#define udif_mutex_unlock(m)	UDIF_PARM_CHK_FN(m, mutex_unlock, &(m)->mtx)

#endif /* __UDIF_MUTEX_H__ */
