/*
 * include/linux/udif/poll.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_POLL_H__
#define __UDIF_POLL_H__

#include <linux/poll.h>

#define UDIF_POLLIN	POLLIN
#define UDIF_POLLPRI	POLLPRI
#define UDIF_POLLOUT	POLLOUT
#define UDIF_POLLERR	POLLERR
#define UDIF_POLLHUP	POLLHUP
#define UDIF_POLLNVAL	POLLNVAL

#define UDIF_POLLRDNORM	POLLRDNORM
#define UDIF_POLLWRNORM	POLLWRNORM

typedef poll_table UDIF_POLL;

#define udif_poll_wait(f,wq,poll) \
({ \
	poll_wait(container_of((f)->data, struct file, private_data), wq, poll); \
})

#endif /* __UDIF_POLL_H__ */
