/*
 * include/linux/udif/spinlock.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_SPINLOCK_H__
#define __UDIF_SPINLOCK_H__

#include <linux/spinlock.h>
#include <linux/udif/macros.h>
#include <linux/udif/types.h>

typedef struct UDIF_SPINLOCK {
	spinlock_t lock;
} UDIF_SPINLOCK;

#define UDIF_SPINLOCK_INIT { .lock = SPIN_LOCK_UNLOCKED, }
#define UDIF_DECLARE_SPINLOCK(name) \
	UDIF_SPINLOCK name = UDIF_SPINLOCK_INIT

typedef struct UDIF_RAW_SPINLOCK {
	raw_spinlock_t lock;
} UDIF_RAW_SPINLOCK;

#define UDIF_DECLARE_RAW_SPINLOCK(name) \
	UDIF_RAW_SPINLOCK name = { .lock = RAW_SPIN_LOCK_UNLOCKED(name), }

#define udif_spin_lock_init(l)		UDIF_PARM_CHK_FN(l, spin_lock_init, &(l)->lock)
#define udif_spin_lock(l)		UDIF_PARM_CHK_FN(l, spin_lock, &(l)->lock)
#define udif_spin_unlock(l)		UDIF_PARM_CHK_FN(l, spin_unlock, &(l)->lock)
#define udif_spin_lock_irqsave(l,f)	UDIF_PARM_CHK_FN(l, spin_lock_irqsave, &(l)->lock, f)
#define udif_spin_unlock_irqrestore(l,f) UDIF_PARM_CHK_FN(l, spin_unlock_irqrestore, &(l)->lock, f)
#define udif_local_irq_save(f)		local_irq_save(f)
#define udif_local_irq_restore(f)	local_irq_restore(f)

#endif /* __UDIF_SPINLOCK_H__ */
