/*
 * include/linux/udif/string.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_string_H__
#define __UDIF_string_H__

#include <asm/string.h>

static inline void __strncpy(char *dst, const char *src, size_t len)
{
	memcpy(dst, src, len);
	dst[len - 1] = 0;
}

#endif /* __UDIF_STRING_H__ */
