/*
 * include/linux/udif/tasklet.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_TASKLET_H__
#define __UDIF_TASKLET_H__

#include <linux/interrupt.h>
#include <linux/udif/macros.h>
#include <linux/udif/types.h>

typedef struct UDIF_TASKLET {
	struct tasklet_struct tsk;
} UDIF_TASKLET;

typedef	void (*UDIF_TASKLET_CB)(UDIF_ULONG);

#define UDIF_TASKLET_INIT(f,d) { .tsk = { NULL,0,ATOMIC_INIT(0),f,d }, }
#define UDIF_DECLARE_TASKLET(name,f,d) \
	UDIF_TASKLET name = UDIF_TASKLET_INIT(f,d)

#define udif_tasklet_init(t,f,d)	UDIF_PARM_CHK_FN(t, tasklet_init, &(t)->tsk, f, d)
#define udif_tasklet_schedule(t)	UDIF_PARM_CHK_FN(t, tasklet_schedule, &(t)->tsk)

#endif /* __UDIF_TASKLET_H__ */
