/*
 * include/linux/udif/wait.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_WAIT_H__
#define __UDIF_WAIT_H__

#include <linux/sched.h>
#include <linux/wait.h>
#include <linux/udif/types.h>
#include <linux/udif/macros.h>

/* simple wait */
typedef struct UDIF_WAIT {
	struct simple_wait wait;
} UDIF_WAIT;

#define UDIF_WAIT_INIT { .wait = SIMPLE_WAIT_INIT, }
#define UDIF_DECLARE_WAIT(name) \
	UDIF_WAIT name = UDIF_WAIT_INIT

#define udif_wait_init(w)	UDIF_PARM_CHK_FN(w, init_simple_wait, &(w)->wait)
#define udif_wake_up(w)		UDIF_PARM_CHK_FN(w, wake_up_task, &(w)->wait)
#define udif_wait_event(w, c)	task_wait_event(&(w)->wait, c)
#define udif_wait_event_timeout(w, c, tmo) \
({ \
	task_wait_event_timeout(&(w)->wait, c, (tmo) * HZ) ? UDIF_ERR_TIMEOUT : \
	UDIF_ERR_OK; \
})

/* wait queue head for poll */
typedef wait_queue_head_t UDIF_WAIT_QUEUE_HEAD;

#define UDIF_WAIT_QUEUE_INIT(name)	__WAIT_QUEUE_HEAD_INITIALIZER(name)
#define UDIF_DECLARE_WAIT_QUEUE(name)	DECLARE_WAIT_QUEUE_HEAD(name)

#define udif_wait_queue_init(wq)			init_waitqueue_head(wq)
#define udif_wait_queue_wake_up(wq)			wake_up(wq)
#define udif_wait_queue_wake_up_interruptible(wq)	wake_up_interruptible(wq)
#define udif_wait_queue_wake_up_all(wq)			wake_up_all(wq)
#define udif_wait_queue_event(wq, c)			wait_event(wq, c)
#define udif_wait_queue_event_timeout(wq, c, tmo) \
({ \
	wait_event_timeout(wq, c, (tmo) * HZ) ? UDIF_ERR_OK : \
	UDIF_ERR_TIMEOUT; \
})

#endif /* __UDIF_WAIT_H__ */
