/*
 * include/linux/udif/workqueue.h
 *
 *
 * Copyright 2010 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __UDIF_WORKQUEUE_H__
#define __UDIF_WORKQUEUE_H__

#include <linux/workqueue.h>

typedef struct work_struct UDIF_WORK;
typedef	void (*UDIF_WORK_CB)(UDIF_WORK *);

#define UDIF_DECLARE_WORK(name,func)	DECLARE_WORK(name,func)
#define udif_init_work(w,func)		INIT_WORK(w,func)
#define udif_schedule_work(w)		schedule_work(w)

#endif /* __UDIF_WORKQUEUE_H__ */
