#ifndef _TRACE_EXT4_H
#define _TRACE_EXT4_H

#include <linux/tracepoint.h>

struct ext4_free_data;
struct ext4_prealloc_space;
struct ext4_allocation_context;
struct ext4_allocation_request;

DECLARE_TRACE(ext4_free_inode,
	TP_PROTO(struct inode *inode),
		TP_ARGS(inode));

DECLARE_TRACE(ext4_request_inode,
	TP_PROTO(struct inode *dir, int mode),
		TP_ARGS(dir, mode));

DECLARE_TRACE(ext4_allocate_inode,
	TP_PROTO(struct inode *inode, struct inode *dir, int mode),
		TP_ARGS(inode, dir, mode));

DECLARE_TRACE(ext4_write_begin,
	TP_PROTO(struct inode *inode, loff_t pos, unsigned int len,
			unsigned int flags),
		TP_ARGS(inode, pos, len, flags));

DECLARE_TRACE(ext4_ordered_write_end,
	TP_PROTO(struct inode *inode, loff_t pos, unsigned int len,
			unsigned int copied),
		TP_ARGS(inode, pos, len, copied));

DECLARE_TRACE(ext4_writeback_write_end,
	TP_PROTO(struct inode *inode, loff_t pos, unsigned int len,
			unsigned int copied),
		TP_ARGS(inode, pos, len, copied));

DECLARE_TRACE(ext4_journalled_write_end,
	TP_PROTO(struct inode *inode, loff_t pos, unsigned int len,
			unsigned int copied),
		TP_ARGS(inode, pos, len, copied));

DECLARE_TRACE(ext4_da_writepage,
	TP_PROTO(struct inode *inode, struct page *page),
		TP_ARGS(inode, page));

DECLARE_TRACE(ext4_da_writepages,
	TP_PROTO(struct inode *inode, struct writeback_control *wbc),
		TP_ARGS(inode, wbc));

DECLARE_TRACE(ext4_da_writepages_result,
	TP_PROTO(struct inode *inode, struct writeback_control *wbc,
			int ret, int pages_written),
		TP_ARGS(inode, wbc, ret, pages_written));

DECLARE_TRACE(ext4_da_write_begin,
	TP_PROTO(struct inode *inode, loff_t pos, unsigned int len,
			unsigned int flags),
		TP_ARGS(inode, pos, len, flags));

DECLARE_TRACE(ext4_da_write_end,
	TP_PROTO(struct inode *inode, loff_t pos, unsigned int len,
			unsigned int copied),
		TP_ARGS(inode, pos, len, copied));

DECLARE_TRACE(ext4_normal_writepage,
	TP_PROTO(struct inode *inode, struct page *page),
		TP_ARGS(inode, page));

DECLARE_TRACE(ext4_journalled_writepage,
	TP_PROTO(struct inode *inode, struct page *page),
		TP_ARGS(inode, page));

DECLARE_TRACE(ext4_discard_blocks,
	TP_PROTO(struct super_block *sb, unsigned long long blk,
			struct ext4_free_data *entry),
		TP_ARGS(sb, blk, entry));

DECLARE_TRACE(ext4_mb_new_inode_pa,
	TP_PROTO(struct ext4_allocation_context *ac,
			struct ext4_prealloc_space *pa),
		TP_ARGS(ac, pa));

DECLARE_TRACE(ext4_mb_new_group_pa,
	TP_PROTO(struct ext4_allocation_context *ac,
			struct ext4_prealloc_space *pa),
		TP_ARGS(ac, pa));

DECLARE_TRACE(ext4_mb_release_inode_pa,
	TP_PROTO(struct ext4_allocation_context *ac,
			struct ext4_prealloc_space *pa,
			unsigned long long block, unsigned int count),
		TP_ARGS(ac, pa, block, count));

DECLARE_TRACE(ext4_mb_release_group_pa,
	TP_PROTO(struct ext4_allocation_context *ac,
			struct ext4_prealloc_space *pa),
		TP_ARGS(ac, pa));

DECLARE_TRACE(ext4_discard_preallocations,
	TP_PROTO(struct inode *inode),
		TP_ARGS(inode));

DECLARE_TRACE(ext4_mb_discard_preallocations,
	TP_PROTO(struct super_block *sb, int needed),
		TP_ARGS(sb, needed));

DECLARE_TRACE(ext4_request_blocks,
	TP_PROTO(struct ext4_allocation_request *ar),
		TP_ARGS(ar));

DECLARE_TRACE(ext4_allocate_blocks,
	TP_PROTO(struct ext4_allocation_request *ar, unsigned long long block),
		TP_ARGS(ar, block));

DECLARE_TRACE(ext4_free_blocks,
	TP_PROTO(struct inode *inode, unsigned long block, unsigned long count,
			int metadata),
		TP_ARGS(inode, block, count, metadata));

DECLARE_TRACE(ext4_sync_file,
	TP_PROTO(struct file *file, struct dentry *dentry, int datasync),
		TP_ARGS(file, dentry, datasync));

DECLARE_TRACE(ext4_sync_fs,
	TP_PROTO(struct super_block *sb, int wait),
		TP_ARGS(sb, wait));

#endif
