#ifndef _TRACE_IRQ_H
#define _TRACE_IRQ_H

#include <linux/interrupt.h>
#include <linux/tracepoint.h>

#include <trace/irq_event_types.h>

DECLARE_TRACE(irq_entry,
	TP_PROTO(unsigned int id, struct pt_regs *regs),
	TP_ARGS(id, regs));
DECLARE_TRACE(irq_exit,
	TP_PROTO(irqreturn_t retval),
	TP_ARGS(retval));
DECLARE_TRACE(irq_softirq_entry,
	TP_PROTO(struct softirq_action *h, struct softirq_action *softirq_vec),
	TP_ARGS(h, softirq_vec));
DECLARE_TRACE(irq_softirq_exit,
	TP_PROTO(struct softirq_action *h, struct softirq_action *softirq_vec),
	TP_ARGS(h, softirq_vec));
DECLARE_TRACE(irq_softirq_raise,
	TP_PROTO(unsigned int nr),
	TP_ARGS(nr));
DECLARE_TRACE(irq_tasklet_entry,
	TP_PROTO(struct tasklet_struct *t),
	TP_ARGS(t));
DECLARE_TRACE(irq_tasklet_exit,
	TP_PROTO(struct tasklet_struct *t),
	TP_ARGS(t));

#endif
