/*
 *  /proc/debug_sched_clock to read sched_clock() return value.
 *
 *  Copyright 2003-2007 Sony Corporation.
 *
 *  This program is free software; you can redistribute	 it and/or modify it
 *  under  the terms of	 the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the	 License.
 *
 *  THIS  SOFTWARE  IS PROVIDED	  ``AS	IS'' AND   ANY	EXPRESS OR IMPLIED
 *  WARRANTIES,	  INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO	EVENT  SHALL   THE AUTHOR  BE	 LIABLE FOR ANY	  DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED	  TO, PROCUREMENT OF  SUBSTITUTE GOODS	OR SERVICES; LOSS OF
 *  USE, DATA,	OR PROFITS; OR	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN	 CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/proc_fs.h>
#include <linux/delay.h>

extern unsigned long long sched_clock(void);

static int proc_read(char *page, char **start,
			     off_t off, int count,
			     int *eof, void *data)
{
	int len;
	unsigned long flag;
	unsigned long long val;
	local_irq_save(flag);

	/* make sure we have enough chance to test
	 * sched_clock() in irq disabled context
	 */
	mdelay(200);
	val = sched_clock();
	local_irq_restore(flag);

	len = snprintf(page, PAGE_SIZE, "%lld\n", val);
	return len;
}

static int proc_write(struct file *file, const char *buffer,
			       unsigned long count, void *data)
{
	return count;
}

static struct proc_dir_entry *p_entry = NULL;

static int __init mod_init(void)
{
	if ((p_entry = create_proc_entry("debug_sched_clock", 0600, NULL))
	    == NULL) {
		printk("cannot create proc entry\n");
		return 1;
	}
	p_entry->read_proc  = &proc_read;
	p_entry->write_proc  = &proc_write;

	return 0;
}

static void __exit mod_exit(void)
{
	remove_proc_entry("debug_sched_clock", NULL);
}

module_init(mod_init);
module_exit(mod_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Sony Corporation");
MODULE_DESCRIPTION("output sched_clock() retval from /proc");
