/*@@ Test Name     : ppgstat-page-buddy-001.c
 *@brief
 * Function Tested : Test the "Pages Buddy" information in /proc/ppgstat
 *                   entry of the PPGSTAT feature.
 *                   This program will perform allcating the memory using the kernel function
 *                   kmalloc()and freeing the memory when module is removed.
 *
 *@pre
 * Test Technique  : Functional
 * Compilation     : make
 *                   ppgstat-page-buddy-001.ko
 *@criteria
 * In the ppgstat viewer output for ppgstat-page-buddy-log1 the BuddyPages
 * bit will be cleared.
 *
 *
 *
 *@note
 *
 */
#include <linux/module.h>  /* Needed by all modules */


char *value = NULL;

int ppgstat_page_buddy_init(void)
{
	int alloc_size=1*1024*1024; /* allocating 1 MB Memory*/

	printk("%s %d, Module is inserted \n", __FILE__, __LINE__);
	value = kmalloc(alloc_size, GFP_KERNEL);
	if (!value)
	{
		printk("Error in allocating the Memory\n");
		return ENOMEM;
	}
	return 0;
}

void ppgstat_page_buddy_exit(void)
{
	printk("%s %d, Module removed ...\n", __FILE__, __LINE__);
	kfree(value);
}

module_init(ppgstat_page_buddy_init);
module_exit(ppgstat_page_buddy_exit);

MODULE_DESCRIPTION("RMM ppgstat test module");
MODULE_LICENSE("GPL");
