#!/bin/sh
#
# scripts/cutdown.sh
#
# Slim down source tree
#
# Copyright 2007,2008 Sony Corporation
#
#  This program is free software; you can redistribute  it and/or modify it
#  under  the terms of  the GNU General  Public License as published by the
#  Free Software Foundation;  version 2 of the  License.
#
#  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
#  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
#  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
#  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
#  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
#  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
#  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  You should have received a copy of the  GNU General Public License along
#  with this program; if not, write  to the Free Software Foundation, Inc.,
#  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
#

# Delete tree except Kbuild, Kconfig and Makefile.
function cutdown
{
    if [ ! -e $1 ]; then
	return;
    fi
    find $1 -type f -and ! \( -name "Kbuild" -o -name "Kconfig*" -o -name "Makefile*" \) -exec rm -f {} \;
    if [ ! -e $1 ]; then
	return;
    fi
    find $1 -type d -exec rmdir --ignore-fail-on-non-empty {} \; -depth
}

(cd Documentation && \
    for i in B* DMA* H* IPMI* [J-L]* [N-Q]* README.* [S-Z]* a[a-q]* aux* blackfin cciss* cdrom co* cpq* cr* dcd* dell* device-mapper digi* drivers dvb ecrypt* eisa* fb floppy* fujitsu g* ha* hw_random* hw* i2o i386 ia64 ide* infini* is* j* key* ldm* led* logo* m68k mca* md* mips mox* par* powerpc riscom* rocket* s390 scsi serial* sgi* sh sony* sparc specialix* stallion* svga* sx* telephony tinkipad* tipar* uml video* voyager* [w-z]*; \
    do
        cutdown $i; \
    done)
(cd Documentation/filesystems && \
    for i in [0-9]* a[a-t]* b* cifs* coda* [g-h]* [j-o]* spu* sysv* ufs*; \
    do
        cutdown $i; \
    done)

(cd include && rm -rf acpi asm-alpha asm-arm26 asm-avr32 asm-[b-f]* asm-[h-z]* media)

(cd arch && rm -rf alpha arm26 avr32 [b-t]* [v-z]*) #exclude um/
(cd arch && \
    for i in s390 um; \
    do \
        cutdown $i; \
    done)

(cd drivers && \
    for i in acorn acpi atm auxdisplay dio edac eisa fc4 firewire firmware hwmon ieee1394 infiniband isdn kvm macintosh mca md media message mfd nubus parisc parport pnp ps3 rapidio s390 sbus sh sn tc telephony w1 zorro; \
    do \
        cutdown $i; \
    done)

(cd drivers/char && \
    for i in agp ami* applicom* cyclades* dec* drm ds* epca* hv* hw_random ip2 ipmi moxa* mspec* mwave mx* pcmcia rio riscom* rocket* ser* snsc.* snsc_event.* sonypi* specialix* stallion* synclink* sx* tpm toshiba* watchdog; \
    do \
        cutdown $i; \
    done)

(cd drivers/gpu && \
    for i in *; \
    do \
        cutdown $i; \
    done)

(cd drivers/net && \
    for i in 3c* ace* appletalk arcnet atari* atl* benet bnx* can chelsio de* dgrs* e1000* ehea enic fs_enet hamradio hp* ibm* igb irda ix* mac* mlx4 myri* netxen ni* pasemi* pcmcia qla* sis* sk* spider* starfire* tlan* sun* tg* tokenring tulip typhoon* ucc* via*; \
    do \
        cutdown $i; \
    done)

(cd drivers/pcmcia && \
    for i in * \;
    do \
        cutdown $i; \
    done)

(cd drivers/scsi && \
    for i in [0-9]* [A-J]* [N-Z]* [a-b]* d* esp* g* ibm* in* j* libsas lpfc [m-q]* seagate.c sgi* sim* sni* sun* sym53* [t-z]*; \
    do \
        cutdown $i; \
    done)

(cd drivers/serial && \
    for i in cpm_uart cris* dz* icom* ioc* ip* jsm* m32* mcf* mpsc* x* of* pmac* pnx* \;
    do \
        cutdown $i; \
    done)

(cd drivers/staging && \
    for i in * \;
    do \
        cutdown $i; \
    done)

(cd drivers/video && \
    for i in aty geode i810 intelfb kyro matrox nvidia riva savage sis via; \
    do \
        cutdown $i; \
    done)

(cd firmware && \
    for i in *; \
    do \
    	if [ $i != e100 ]; then \
        cutdown $i; \
	fi; \
    done)

(cd fs && \
    for i in 9p adfs affs afs befs bfs btrfs cifs coda efs freevxfs gfs2 hfs hfsplus hostfs hpfs hppfs jbd jbd2 jfs minix ncpfs ntfs ocfs2 openpromfs qnx4 reiserfs smbfs ubifs ufs xfs; \
    do \
        cutdown $i; \
    done)

(cd fs/nls && \
    for i in nls_cp9*; \
    do \
        cutdown $i; \
    done)

(cd sound && \
    for i in aoa drivers i2c isa mips parisc pci pcmcia ppc soc sparc synth; \
    do \
        cutdown $i; \
    done)
(cd sound/oss && \
    for i in ac97* ad* aedp* au1550* bt* cs* emu* es* i810* msnd* nec* nm* opl* pas* pss* sb* sh* sscape* swarm* trident* trix* via* vwsnd* waveartist*
    do \
        cutdown $i; \
    done)

rm -f setup-ebony setup-pc setup-tx49
