#!/bin/bash
############################################################################
# ssboot-verify.sh
#
# This script calculates the page count and section count from ssboot
# log files captured before and after snapshot boot image.
# Also checks the difference in page count for each sectiion
#
# Refer the below doc for how to capture ssboot debug logs
# ncvs:gp/kernel/PSGCAMS/internaldoc/howto/SnapshotBoot/howto-verify-ssboot-mem-image_en.txt
#
# Usage: sh ssboot-verify.sh <log-file-before-ssboot> <log-file-after-ssboot>
#
# Copyright 2016 Sony Corporation
#
############################################################################

file1=$1
file2=$2
tmp=0

# Check for cmdline arguments, It should be two file names
if [ $# -ne 2 ]; then
	echo "Incorrect number of command line arguments"
	echo "help: $0 <log-file-before-ssboot> <log-file-after-ssboot>"
	exit 1
fi

# Before ssboot boot image
# Check for page statistics and count pages for each category
kernel_pages1=`awk /'Kernel     :'/ $file1 | awk '{print $4}'`
kernel_ro_pages1=`awk /'Kernel R\/O :'/ $file1 | awk '{print $5}'`
module_ro_pages1=`awk /'Module R\/O :'/ $file1 | awk '{print $5}'`
user_pages1=`awk /'User       :'/ $file1 | awk '{print $4}'`
anon_pages1=`awk /'Anon       :'/ $file1 | awk '{print $4}'`
cache_pages1=`awk /'Cache      :'/ $file1 | awk '{print $4}'`
swapcache_pages1=`awk /'Swapcache  :'/ $file1 | awk '{print $4}'`
reserved_pages1=`awk /'Reserved   :'/ $file1 | awk '{print $4}'`
other_pages1=`awk /'Other      :'/ $file1 | awk '{print $4}'`
zero_pages1=(`awk /'Zero       :'/ $file1 | awk '{print $4}'`)

# Count critical, normal and total pages
critical_pages1=`awk /'Critical   :'/ $file1 | awk '{print $4}'`
normal_pages1=`awk /'Normal     :'/ $file1 | awk '{print $4}'`
total_pages1=`awk /'Total      :'/ $file1 | awk '{print $4}'`

# Count ssboot allocated pages and page bitmaps
alloc_page_bitmaps=`awk /'allocate page bitmaps'/ $file1 | awk '{print $5}' | sed -e 's/(//' -e 's/)//' -e 's/KB//'`
alloc_ssboot_pages=`awk /'allocate pages for copy'/ $file1  | awk '{print $6}' | sed  's/(//'`

#After ssboot image
# Check for page statistics and count pages for each category
kernel_pages2=`awk /'Kernel     :'/ $file2 | awk '{print $4}'`
kernel_ro_pages2=`awk /'Kernel R\/O :'/ $file2 | awk '{print $5}'`
module_ro_pages2=`awk /'Module R\/O :'/ $file2 | awk '{print $5}'`
user_pages2=`awk /'User       :'/ $file2 | awk '{print $4}'`
anon_pages2=`awk /'Anon       :'/ $file2 | awk '{print $4}'`
cache_pages2=`awk /'Cache      :'/ $file2 | awk '{print $4}'`
swapcache_pages2=`awk /'Swapcache  :'/ $file2 | awk '{print $4}'`
reserved_pages2=`awk /'Reserved   :'/ $file2 | awk '{print $4}'`
other_pages2=`awk /'Other      :'/ $file2 | awk '{print $4}'`
zero_pages2=(`awk /'Zero       :'/ $file2 | awk '{print $4}'`)

# Count critical, normal and total pages
critical_pages2=`awk /'Critical   :'/ $file2 | awk '{print $4}'`
normal_pages2=`awk /'Normal     :'/ $file2 | awk '{print $4}'`
total_pages2=`awk /'Total      :'/ $file2 | awk '{print $4}'`

# Count ssboot freed pages and page bitmaps
free_page_bitmaps=`awk /'free page bitmaps'/ $file2 | awk '{print $5}' | sed -e 's/(//' -e 's/)//' -e 's/KB//'`
free_ssboot_pages=`awk /'free copied critical pages'/ $file2  | awk '{print $6}' | sed  's/(//'`

# Verifiy page count
#Check for kernel page differences
if [ $kernel_pages1 != $kernel_pages2 ]; then
	if [ $kernel_pages1 -gt $kernel_pages2 ]; then
		echo "Difference in kernel pages is $(($kernel_pages1-$kernel_pages2)) pages"
		let tmp++
	else
		echo "Difference in kernel pages is $(($kernel_pages2-$kernel_pages1)) pages"
		let tmp++
	fi
fi
#Check for kernel RO page differences
if [ $kernel_ro_pages1 != $kernel_ro_pages2 ]; then
	if [ $kernel_ro_pages1 -gt $kernel_ro_pages2 ]; then
		echo "Difference in kernel RO pages is $(($kernel_ro_pages1-$kernel_ro_pages2)) pages"
		let tmp++
	else
		echo "Difference in kernel RO pages is $(($kernel_ro_pages2-$kernel_ro_pages1)) pages"
		let tmp++
	fi
fi
#Check for module RO page differences
if [ $module_ro_pages1 != $module_ro_pages2 ]; then
	if [ $module_ro_pages1 -gt $module_ro_pages2 ]; then
		echo "Difference in module RO pages is $(($module_ro_pages1-$module_ro_pages2)) pages"
		let tmp++
	else
		echo "Difference in module RO pages is $(($module_ro_pages2-$module_ro_pages1)) pages"
		let tmp++
	fi
fi
#Check for user page differences
if [ $user_pages1 != $user_pages2 ]; then
	if [ $user_pages1 -gt $user_pages2 ]; then
		echo "Difference in user pages is $(($user_pages1-$user_pages2)) pages"
		let tmp++
	else
		echo "Difference in user pages is $(($user_pages2-$user_pages1)) pages"
		let tmp++
	fi
fi
#Check for anon page differences
if [ $anon_pages1 != $anon_pages2 ]; then
	if [ $anon_pages1 -gt $anon_pages2 ]; then
		echo "Difference in anon pages is $(($anon_pages1-$anon_pages2)) pages"
		let tmp++
	else
		echo "Difference in anon pages is $(($anon_pages2-$anon_pages1)) pages"
		let tmp++
	fi
fi
#Check for cache page differences
if [ $cache_pages1 != $cache_pages2 ]; then
	if [ $cache_pages1 -gt $cache_pages2 ]; then
		echo "Difference in cache pages is $(($cache_pages1-$cache_pages2)) pages"
		let tmp++
	else
		echo "Difference in cache pages is $(($cache_pages2-$cache_pages1)) pages"
		let tmp++
	fi
fi
#Check for swapcache page differences
if [ $swapcache_pages1 != $swapcache_pages2 ]; then
	if [ $swapcache_pages1 -gt $swapcache_pages2 ]; then
		echo "Difference in swapcache pages is $(($swapcache_pages1-$swapcache_pages2)) pages"
		let tmp++
	else
		echo "Difference in swapcache pages is $(($swapcache_pages2-$swapcache_pages1)) pages"
		let tmp++
	fi
fi
#Check for reserved page differences
if [ $reserved_pages1 != $reserved_pages2 ]; then
	if [ $reserved_pages1 -gt $reserved_pages2 ]; then
		echo "Difference in reserved pages is $(($reserved_pages1-$reserved_pages2)) pages"
		let tmp++
	else
		echo "Difference in reserevd pages is $(($reserved_pages2-$reserved_pages1)) pages"
		let tmp++
	fi
fi
#Check for other page differences
if [ $other_pages1 != $other_pages2 ]; then
	if [ $other_pages1 -gt $other_pages2 ]; then
		echo "Difference in other pages is $(($other_pages1-$other_pages2)) pages"
		let tmp++
	else
		echo "Difference in other pages is $(($other_pages2-$other_pages1)) pages"
		let tmp++
	fi
fi
#Check for zero page differences
if [ $zero_pages1 != $zero_pages2 ]; then
	if [ $zero_pages1 -gt $zero_pages2 ]; then
		echo "Difference in zero pages is $(($zero_pages1-$zero_pages2)) pages"
		let tmp++
	else
		echo "Difference in zero pages is $(($zero_pages2-$zero_pages1)) pages"
		let tmp++
	fi
fi
#Check for critial page differences
if [ $critical_pages1 != $critical_pages2 ]; then
	if [ $critical_pages1 -gt $critical_pages2 ]; then
		echo "Difference in critical pages is $(($critical_pages1-$critical_pages2)) pages"
		let tmp++
	else
		echo "Difference in critical pages is $(($critical_pages2-$critical_pages1)) pages"
		let tmp++
	fi
fi
#Check for normal page differences
if [ $normal_pages1 != $normal_pages2 ]; then
	if [ $normal_pages1 -gt $normal_pages2 ]; then
		echo "Difference in normal pages is $(($normal_pages1-$normal_pages2)) pages"
		let tmp++
	else
		echo "Difference in normal pages is $(($normal_pages2-$normal_pages1)) pages"
		let tmp++
	fi
fi
#Check for total page count differences
if [ $total_pages1 != $total_pages2 ]; then
	if [ $total_pages1 -gt $total_pages2 ]; then
		echo "Difference in total pages count is $(($total_pages1-$total_pages2)) pages"
		let tmp++
	else
		echo "Difference in total page count is $(($total_pages2-$total_pages1)) pages"
		let tmp++
	fi
fi

#Check for page bitmap size differences
if [ $alloc_page_bitmaps != $free_page_bitmaps ]; then
	if [ $alloc_page_bitmaps -gt $free_page_bitmaps ]; then
		echo "Difference in page bitmap size is $(($alloc_page_bitmaps-$free_page_bitmaps)) KB"
		let tmp++
	else
		echo "Difference in page bitmap size is $(($free_page_bitmaps-$alloc_page_bitmaps)) KB"
		let tmp++
	fi
fi

#Check for differences in ssboot pages allocated and freed pages
if [ $alloc_ssboot_pages != $free_ssboot_pages ]; then
	if [ $alloc_ssboot_pages -gt $free_ssboot_pages ]; then
		echo "Difference in ssboot page count is $(($alloc_ssboot_pages-$free_ssboot_pages)) pages"
		let tmp++
	else
		echo "Difference in ssboot page count is $(($free_ssboot_pages-$alloc_ssboot_pages)) pages"
		let tmp++
	fi
fi

if [ $tmp -eq 0 ]; then
	echo "No differences observed for page count"
	echo "Test is OK"
fi

