/*
 * Xilinx VPSS Scaler
 *
 * Copyright (C) 2017 Xilinx, Inc.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/delay.h>
#include <linux/device.h>
#include <linux/gpio/consumer.h>
#include <linux/module.h>
#include <linux/of.h>
#include <linux/platform_device.h>

#include <media/v4l2-async.h>
#include <media/v4l2-subdev.h>
#include "xilinx-vip.h"

#define XSCALER_MIN_WIDTH		(64)
#define XSCALER_MAX_WIDTH		(8192)
#define XSCALER_MIN_HEIGHT		(64)
#define XSCALER_MAX_HEIGHT		(4320)
#define XSCALER_DEF_MAX_WIDTH		(3840)
#define XSCALER_DEF_MAX_HEIGHT		(2160)
#define XSCALER_MAX_PHASES		(64)

/* Modify to defaults incase it is not configured from application */
#define XSCALER_DEF_IN_HEIGHT		(720)
#define XSCALER_DEF_IN_WIDTH		(1280)
#define XSCALER_DEF_OUT_HEIGHT		(1080)
#define XSCALER_DEF_OUT_WIDTH		(1920)

#define XSCALER_HSF			(0x0100)
#define XSCALER_VSF			(0x0104)
#define XSCALER_SF_SHIFT		(20)
#define XSCALER_SF_MASK			(0xffffff)
#define XSCALER_SOURCE_SIZE		(0x0108)
#define XSCALER_SIZE_HORZ_SHIFT		(0)
#define XSCALER_SIZE_VERT_SHIFT		(16)
#define XSCALER_SIZE_MASK		(0xfff)
#define XSCALER_HAPERTURE		(0x010c)
#define XSCALER_VAPERTURE		(0x0110)
#define XSCALER_APERTURE_START_SHIFT	(0)
#define XSCALER_APERTURE_END_SHIFT	(16)
#define XSCALER_OUTPUT_SIZE		(0x0114)
#define XSCALER_COEF_DATA_IN		(0x0134)
#define XSCALER_BITSHIFT_16		(16)

/* Video subsytems block offset */
#define S_AXIS_RESET_OFF	(0x00010000)
#define V_HSCALER_OFF		(0x00000000)
#define V_VSCALER_OFF		(0x00020000)

/* HW Reset Network GPIO Channel */
#define XGPIO_CH_RESET_SEL		(1)
#define XGPIO_RESET_MASK_VIDEO_IN	BIT(0)
#define XGPIO_RESET_MASK_IP_AXIS	BIT(1)
#define XGPIO_RESET_MASK_IP_AXIMM	BIT(0)
#define XGPIO_RESET_MASK_ALL_BLOCKS	(XGPIO_RESET_MASK_VIDEO_IN  | \
						XGPIO_RESET_MASK_IP_AXIS)
#define XGPIO_DATA_OFFSET		(0x0)
#define XGPIO_TRI_OFFSET		(0x4)
#define XGPIO_DATA2_OFFSET		(0x8)
#define XGPIO_TRI2_OFFSET		(0xc)

#define XGPIO_GIE_OFFSET		(0x11c)
#define XGPIO_ISR_OFFSET		(0x120)
#define XGPIO_IER_OFFSET		(0x128)
#define XGPIO_CHAN_OFFSET		(8)
#define STEP_PRECISION			(65536)

/* Video IP Formats */
enum xscaler_vid_reg_fmts {
	XVIDC_CSF_RGB = 0,
	XVIDC_CSF_YCRCB_444,
	XVIDC_CSF_YCRCB_422,
	XVIDC_CSF_YCRCB_420,
};

/* Video IP PPC */
#define XSCALER_PPC_1			(1)
#define XSCALER_PPC_2			(2)

#define XV_HSCALER_MAX_H_TAPS           (12)
#define XV_HSCALER_MAX_H_PHASES         (64)
#define XV_HSCALER_MAX_LINE_WIDTH       (3840)
#define XV_VSCALER_MAX_V_TAPS           (12)
#define XV_VSCALER_MAX_V_PHASES         (64)

#define XV_HSCALER_TAPS_2		(2)
#define XV_HSCALER_TAPS_4		(4)
#define XV_HSCALER_TAPS_6		(6)
#define XV_HSCALER_TAPS_8		(8)
#define XV_HSCALER_TAPS_10		(10)
#define XV_HSCALER_TAPS_12		(12)
#define XV_VSCALER_TAPS_2		(2)
#define XV_VSCALER_TAPS_4		(4)
#define XV_VSCALER_TAPS_6		(6)
#define XV_VSCALER_TAPS_8		(8)
#define XV_VSCALER_TAPS_10		(10)
#define XV_VSCALER_TAPS_12		(12)

/* Mask definitions for Low and high 16 bits in a 32 bit number */
#define XHSC_MASK_LOW_16BITS		GENMASK(15, 0)
#define XHSC_MASK_HIGH_16BITS		GENMASK(31, 16)
#define XHSC_MASK_LOW_32BITS		GENMASK(31, 0)
#define XHSC_STEP_PRECISION_SHIFT	(16)
#define XHSC_HPHASE_SHIFT_BY_6		(6)
#define XHSC_HPHASE_MULTIPLIER		(9)

/* Mask definitions for Low and high 16 bits in a 32 bit number */
#define XVSC_MASK_LOW_16BITS            GENMASK(15, 0)
#define XVSC_MASK_HIGH_16BITS           GENMASK(31, 16)

/* XSCALER POWER MACROS */
#define XSCALER_RESET_ASSERT	(0x1)
#define XSCALER_RESET_DEASSERT	(0x0)

/* Scaler AP Control Registers */
#define XSCALER_START		BIT(0)
#define XSCALER_AUTO_RESTART	BIT(7)
#define XSCALER_STREAM_ON	(XSCALER_START | XSCALER_AUTO_RESTART)

/* H-scaler registers */
#define XV_HSCALER_CTRL_ADDR_AP_CTRL				(0x0000)
#define XV_HSCALER_CTRL_ADDR_GIE				(0x0004)
#define XV_HSCALER_CTRL_ADDR_IER				(0x0008)
#define XV_HSCALER_CTRL_ADDR_ISR				(0x000c)
#define XV_HSCALER_CTRL_ADDR_HWREG_HEIGHT_DATA			(0x0010)
#define XV_HSCALER_CTRL_ADDR_HWREG_WIDTHIN_DATA			(0x0018)
#define XV_HSCALER_CTRL_ADDR_HWREG_WIDTHOUT_DATA		(0x0020)
#define XV_HSCALER_CTRL_ADDR_HWREG_COLORMODE_DATA		(0x0028)
#define XV_HSCALER_CTRL_ADDR_HWREG_PIXELRATE_DATA		(0x0030)
#define XV_HSCALER_CTRL_ADDR_HWREG_COLORMODEOUT_DATA		(0X0038)
#define XV_HSCALER_CTRL_ADDR_HWREG_HFLTCOEFF_BASE		(0x0800)
#define XV_HSCALER_CTRL_ADDR_HWREG_HFLTCOEFF_HIGH		(0x0bff)

/* H-scaler coefficients for 6, 8, 10 and 12 tap filters */
static const u16
xhsc_coeff_taps6[XV_HSCALER_MAX_H_PHASES][XV_HSCALER_TAPS_6] = {
	{  -132,   236,  3824,   236,  -132,    64, },
	{  -116,   184,  3816,   292,  -144,    64, },
	{  -100,   132,  3812,   348,  -160,    64, },
	{   -88,    84,  3808,   404,  -176,    64, },
	{   -72,    36,  3796,   464,  -192,    64, },
	{   -60,    -8,  3780,   524,  -208,    68, },
	{   -48,   -52,  3768,   588,  -228,    68, },
	{   -32,   -96,  3748,   652,  -244,    68, },
	{   -20,  -136,  3724,   716,  -260,    72, },
	{    -8,  -172,  3696,   784,  -276,    72, },
	{     0,  -208,  3676,   848,  -292,    72, },
	{    12,  -244,  3640,   920,  -308,    76, },
	{    20,  -276,  3612,   988,  -324,    76, },
	{    32,  -304,  3568,  1060,  -340,    80, },
	{    40,  -332,  3532,  1132,  -356,    80, },
	{    48,  -360,  3492,  1204,  -372,    84, },
	{    56,  -384,  3448,  1276,  -388,    88, },
	{    64,  -408,  3404,  1352,  -404,    88, },
	{    72,  -428,  3348,  1428,  -416,    92, },
	{    76,  -448,  3308,  1500,  -432,    92, },
	{    84,  -464,  3248,  1576,  -444,    96, },
	{    88,  -480,  3200,  1652,  -460,    96, },
	{    92,  -492,  3140,  1728,  -472,   100, },
	{    96,  -504,  3080,  1804,  -484,   104, },
	{   100,  -516,  3020,  1880,  -492,   104, },
	{   104,  -524,  2956,  1960,  -504,   104, },
	{   104,  -532,  2892,  2036,  -512,   108, },
	{   108,  -540,  2832,  2108,  -520,   108, },
	{   108,  -544,  2764,  2184,  -528,   112, },
	{   112,  -544,  2688,  2260,  -532,   112, },
	{   112,  -548,  2624,  2336,  -540,   112, },
	{   112,  -548,  2556,  2408,  -544,   112, },
	{   112,  -544,  2480,  2480,  -544,   112, },
	{   112,  -544,  2408,  2556,  -548,   112, },
	{   112,  -540,  2336,  2624,  -548,   112, },
	{   112,  -532,  2260,  2688,  -544,   112, },
	{   112,  -528,  2184,  2764,  -544,   108, },
	{   108,  -520,  2108,  2832,  -540,   108, },
	{   108,  -512,  2036,  2892,  -532,   104, },
	{   104,  -504,  1960,  2956,  -524,   104, },
	{   104,  -492,  1880,  3020,  -516,   100, },
	{   104,  -484,  1804,  3080,  -504,    96, },
	{   100,  -472,  1728,  3140,  -492,    92, },
	{    96,  -460,  1652,  3200,  -480,    88, },
	{    96,  -444,  1576,  3248,  -464,    84, },
	{    92,  -432,  1500,  3308,  -448,    76, },
	{    92,  -416,  1428,  3348,  -428,    72, },
	{    88,  -404,  1352,  3404,  -408,    64, },
	{    88,  -388,  1276,  3448,  -384,    56, },
	{    84,  -372,  1204,  3492,  -360,    48, },
	{    80,  -356,  1132,  3532,  -332,    40, },
	{    80,  -340,  1060,  3568,  -304,    32, },
	{    76,  -324,   988,  3612,  -276,    20, },
	{    76,  -308,   920,  3640,  -244,    12, },
	{    72,  -292,   848,  3676,  -208,     0, },
	{    72,  -276,   784,  3696,  -172,    -8, },
	{    72,  -260,   716,  3724,  -136,   -20, },
	{    68,  -244,   652,  3748,   -96,   -32, },
	{    68,  -228,   588,  3768,   -52,   -48, },
	{    68,  -208,   524,  3780,    -8,   -60, },
	{    64,  -192,   464,  3796,    36,   -72, },
	{    64,  -176,   404,  3808,    84,   -88, },
	{    64,  -160,   348,  3812,   132,  -100, },
	{    64,  -144,   292,  3816,   184,  -116, }
};

static const u16
xhsc_coeff_taps8[XV_HSCALER_MAX_H_PHASES][XV_HSCALER_TAPS_8] = {
	{-5, 309, 1023, 1445, 1034, 317, -3, -24, },
	{-6, 300, 1011, 1445, 1045, 326, -1, -24, },
	{-7, 291, 1000, 1444, 1056, 336, 0, -24, },
	{-9, 282, 988, 1444, 1067, 345, 2, -24, },
	{-10, 274, 977, 1443, 1078, 354, 4, -24, },
	{-11, 266, 965, 1441, 1089, 364, 6, -24, },
	{-12, 258, 953, 1440, 1100, 373, 8, -24, },
	{-13, 250, 942, 1438, 1110, 383, 10, -24, },
	{-14, 242, 930, 1437, 1121, 393, 12, -24, },
	{-15, 234, 918, 1434, 1131, 403, 14, -24, },
	{-16, 226, 906, 1432, 1142, 413, 17, -24, },
	{-17, 219, 894, 1430, 1152, 423, 19, -24, },
	{-17, 211, 882, 1427, 1162, 433, 22, -24, },
	{-18, 204, 870, 1424, 1172, 443, 24, -24, },
	{-19, 197, 858, 1420, 1182, 454, 27, -24, },
	{-19, 190, 846, 1417, 1191, 464, 30, -24, },
	{-20, 183, 834, 1413, 1201, 475, 33, -24, },
	{-20, 176, 822, 1409, 1210, 486, 36, -24, },
	{-21, 170, 810, 1405, 1220, 497, 39, -24, },
	{-21, 163, 798, 1401, 1229, 507, 42, -24, },
	{-22, 157, 786, 1396, 1238, 518, 46, -24, },
	{-22, 151, 774, 1392, 1247, 529, 49, -24, },
	{-22, 144, 762, 1387, 1255, 540, 53, -24, },
	{-23, 139, 750, 1382, 1264, 552, 57, -24, },
	{-23, 133, 738, 1376, 1272, 563, 60, -24, },
	{-23, 127, 726, 1371, 1280, 574, 64, -24, },
	{-23, 121, 714, 1365, 1288, 586, 69, -24, },
	{-23, 116, 703, 1359, 1296, 597, 73, -24, },
	{-24, 111, 691, 1353, 1304, 609, 77, -24, },
	{-24, 105, 679, 1346, 1312, 620, 81, -24, },
	{-24, 100, 667, 1340, 1319, 632, 86, -24, },
	{-24, 96, 655, 1333, 1326, 644, 91, -24, },
	{-24, 91, 644, 1326, 1333, 655, 96, -24, },
	{-24, 86, 632, 1319, 1340, 667, 100, -24, },
	{-24, 81, 620, 1312, 1346, 679, 105, -24, },
	{-24, 77, 609, 1304, 1353, 691, 111, -24, },
	{-24, 73, 597, 1296, 1359, 703, 116, -23, },
	{-24, 69, 586, 1288, 1365, 714, 121, -23, },
	{-24, 64, 574, 1280, 1371, 726, 127, -23, },
	{-24, 60, 563, 1272, 1376, 738, 133, -23, },
	{-24, 57, 552, 1264, 1382, 750, 139, -23, },
	{-24, 53, 540, 1255, 1387, 762, 144, -22, },
	{-24, 49, 529, 1247, 1392, 774, 151, -22, },
	{-24, 46, 518, 1238, 1396, 786, 157, -22, },
	{-24, 42, 507, 1229, 1401, 798, 163, -21, },
	{-24, 39, 497, 1220, 1405, 810, 170, -21, },
	{-24, 36, 486, 1210, 1409, 822, 176, -20, },
	{-24, 33, 475, 1201, 1413, 834, 183, -20, },
	{-24, 30, 464, 1191, 1417, 846, 190, -19, },
	{-24, 27, 454, 1182, 1420, 858, 197, -19, },
	{-24, 24, 443, 1172, 1424, 870, 204, -18, },
	{-24, 22, 433, 1162, 1427, 882, 211, -17, },
	{-24, 19, 423, 1152, 1430, 894, 219, -17, },
	{-24, 17, 413, 1142, 1432, 906, 226, -16, },
	{-24, 14, 403, 1131, 1434, 918, 234, -15, },
	{-24, 12, 393, 1121, 1437, 930, 242, -14, },
	{-24, 10, 383, 1110, 1438, 942, 250, -13, },
	{-24, 8, 373, 1100, 1440, 953, 258, -12, },
	{-24, 6, 364, 1089, 1441, 965, 266, -11, },
	{-24, 4, 354, 1078, 1443, 977, 274, -10, },
	{-24, 2, 345, 1067, 1444, 988, 282, -9, },
	{-24, 0, 336, 1056, 1444, 1000, 291, -7, },
	{-24, -1, 326, 1045, 1445, 1011, 300, -6, },
	{-24, -3, 317, 1034, 1445, 1023, 309, -5, },
};

static const u16
xhsc_coeff_taps10[XV_HSCALER_MAX_H_PHASES][XV_HSCALER_TAPS_10] = {
	{59, 224, 507, 790, 911, 793, 512, 227, 61, 13, },
	{58, 220, 502, 786, 911, 797, 516, 231, 62, 13, },
	{56, 216, 497, 783, 911, 800, 521, 235, 64, 13, },
	{55, 213, 492, 779, 910, 804, 526, 238, 65, 13, },
	{54, 209, 487, 775, 910, 807, 531, 242, 67, 14, },
	{52, 206, 482, 772, 910, 810, 536, 246, 69, 14, },
	{51, 202, 477, 768, 909, 813, 541, 250, 70, 14, },
	{50, 199, 473, 764, 909, 817, 545, 254, 72, 14, },
	{48, 195, 468, 760, 908, 820, 550, 258, 74, 15, },
	{47, 192, 463, 756, 908, 823, 555, 262, 76, 15, },
	{46, 188, 458, 752, 907, 826, 560, 266, 78, 15, },
	{45, 185, 453, 748, 906, 829, 565, 270, 79, 16, },
	{44, 182, 448, 744, 906, 832, 569, 274, 81, 16, },
	{42, 179, 444, 740, 905, 835, 574, 278, 83, 16, },
	{41, 175, 439, 736, 904, 837, 579, 282, 85, 17, },
	{40, 172, 434, 732, 903, 840, 584, 286, 87, 17, },
	{39, 169, 429, 728, 902, 843, 589, 290, 89, 18, },
	{38, 166, 425, 724, 901, 846, 593, 294, 91, 18, },
	{37, 163, 420, 720, 900, 848, 598, 298, 93, 18, },
	{36, 160, 415, 716, 899, 851, 603, 302, 95, 19, },
	{35, 157, 410, 711, 897, 854, 608, 307, 98, 19, },
	{34, 154, 406, 707, 896, 856, 612, 311, 100, 20, },
	{33, 151, 401, 703, 895, 859, 617, 315, 102, 20, },
	{33, 148, 396, 698, 893, 861, 622, 320, 104, 21, },
	{32, 145, 392, 694, 892, 863, 626, 324, 107, 21, },
	{31, 142, 387, 690, 890, 866, 631, 328, 109, 22, },
	{30, 140, 382, 685, 889, 868, 636, 333, 111, 23, },
	{29, 137, 378, 681, 887, 870, 640, 337, 114, 23, },
	{28, 134, 373, 677, 886, 872, 645, 342, 116, 24, },
	{28, 131, 369, 672, 884, 874, 649, 346, 119, 24, },
	{27, 129, 364, 668, 882, 876, 654, 350, 121, 25, },
	{26, 126, 359, 663, 880, 878, 659, 355, 124, 26, },
	{26, 124, 355, 659, 878, 880, 663, 359, 126, 26, },
	{25, 121, 350, 654, 876, 882, 668, 364, 129, 27, },
	{24, 119, 346, 649, 874, 884, 672, 369, 131, 28, },
	{24, 116, 342, 645, 872, 886, 677, 373, 134, 28, },
	{23, 114, 337, 640, 870, 887, 681, 378, 137, 29, },
	{23, 111, 333, 636, 868, 889, 685, 382, 140, 30, },
	{22, 109, 328, 631, 866, 890, 690, 387, 142, 31, },
	{21, 107, 324, 626, 863, 892, 694, 392, 145, 32, },
	{21, 104, 320, 622, 861, 893, 698, 396, 148, 33, },
	{20, 102, 315, 617, 859, 895, 703, 401, 151, 33, },
	{20, 100, 311, 612, 856, 896, 707, 406, 154, 34, },
	{19, 98, 307, 608, 854, 897, 711, 410, 157, 35, },
	{19, 95, 302, 603, 851, 899, 716, 415, 160, 36, },
	{18, 93, 298, 598, 848, 900, 720, 420, 163, 37, },
	{18, 91, 294, 593, 846, 901, 724, 425, 166, 38, },
	{18, 89, 290, 589, 843, 902, 728, 429, 169, 39, },
	{17, 87, 286, 584, 840, 903, 732, 434, 172, 40, },
	{17, 85, 282, 579, 837, 904, 736, 439, 175, 41, },
	{16, 83, 278, 574, 835, 905, 740, 444, 179, 42, },
	{16, 81, 274, 569, 832, 906, 744, 448, 182, 44, },
	{16, 79, 270, 565, 829, 906, 748, 453, 185, 45, },
	{15, 78, 266, 560, 826, 907, 752, 458, 188, 46, },
	{15, 76, 262, 555, 823, 908, 756, 463, 192, 47, },
	{15, 74, 258, 550, 820, 908, 760, 468, 195, 48, },
	{14, 72, 254, 545, 817, 909, 764, 473, 199, 50, },
	{14, 70, 250, 541, 813, 909, 768, 477, 202, 51, },
	{14, 69, 246, 536, 810, 910, 772, 482, 206, 52, },
	{14, 67, 242, 531, 807, 910, 775, 487, 209, 54, },
	{13, 65, 238, 526, 804, 910, 779, 492, 213, 55, },
	{13, 64, 235, 521, 800, 911, 783, 497, 216, 56, },
	{13, 62, 231, 516, 797, 911, 786, 502, 220, 58, },
	{13, 61, 227, 512, 793, 911, 790, 507, 224, 59, },
};

static const u16
xhsc_coeff_taps12[XV_HSCALER_MAX_H_PHASES][XV_HSCALER_TAPS_12] = {
	{48, 143, 307, 504, 667, 730, 669, 507, 310, 145, 49, 18, },
	{47, 141, 304, 501, 665, 730, 670, 510, 313, 147, 50, 18, },
	{46, 138, 301, 498, 663, 730, 672, 513, 316, 149, 51, 18, },
	{45, 136, 298, 495, 661, 730, 674, 516, 319, 151, 52, 18, },
	{44, 134, 295, 492, 659, 730, 676, 519, 322, 153, 53, 18, },
	{44, 132, 292, 489, 657, 730, 677, 522, 325, 155, 54, 18, },
	{43, 130, 289, 486, 655, 729, 679, 525, 328, 157, 55, 19, },
	{42, 129, 287, 483, 653, 729, 681, 528, 331, 160, 56, 19, },
	{41, 127, 284, 480, 651, 729, 683, 531, 334, 162, 57, 19, },
	{40, 125, 281, 477, 648, 729, 684, 534, 337, 164, 58, 19, },
	{40, 123, 278, 474, 646, 728, 686, 537, 340, 166, 59, 20, },
	{39, 121, 275, 471, 644, 728, 687, 539, 343, 169, 60, 20, },
	{38, 119, 272, 468, 642, 727, 689, 542, 346, 171, 61, 20, },
	{37, 117, 269, 465, 640, 727, 690, 545, 349, 173, 62, 20, },
	{37, 115, 266, 461, 638, 727, 692, 548, 353, 175, 63, 21, },
	{36, 114, 264, 458, 635, 726, 693, 551, 356, 178, 65, 21, },
	{35, 112, 261, 455, 633, 726, 695, 554, 359, 180, 66, 21, },
	{35, 110, 258, 452, 631, 725, 696, 556, 362, 183, 67, 21, },
	{34, 108, 255, 449, 628, 724, 698, 559, 365, 185, 68, 22, },
	{33, 107, 252, 446, 626, 724, 699, 562, 368, 187, 69, 22, },
	{33, 105, 250, 443, 624, 723, 700, 565, 371, 190, 71, 22, },
	{32, 103, 247, 440, 621, 723, 702, 567, 374, 192, 72, 23, },
	{32, 101, 244, 437, 619, 722, 703, 570, 377, 195, 73, 23, },
	{31, 100, 241, 433, 617, 721, 704, 573, 380, 197, 75, 23, },
	{31, 98, 239, 430, 614, 720, 705, 576, 383, 200, 76, 24, },
	{30, 97, 236, 427, 612, 720, 707, 578, 387, 202, 77, 24, },
	{29, 95, 233, 424, 609, 719, 708, 581, 390, 205, 79, 24, },
	{29, 93, 231, 421, 607, 718, 709, 584, 393, 207, 80, 25, },
	{28, 92, 228, 418, 604, 717, 710, 586, 396, 210, 81, 25, },
	{28, 90, 225, 415, 602, 716, 711, 589, 399, 212, 83, 26, },
	{27, 89, 223, 412, 599, 715, 712, 591, 402, 215, 84, 26, },
	{27, 87, 220, 408, 597, 714, 713, 594, 405, 217, 86, 27, },
	{27, 86, 217, 405, 594, 713, 714, 597, 408, 220, 87, 27, },
	{26, 84, 215, 402, 591, 712, 715, 599, 412, 223, 89, 27, },
	{26, 83, 212, 399, 589, 711, 716, 602, 415, 225, 90, 28, },
	{25, 81, 210, 396, 586, 710, 717, 604, 418, 228, 92, 28, },
	{25, 80, 207, 393, 584, 709, 718, 607, 421, 231, 93, 29, },
	{24, 79, 205, 390, 581, 708, 719, 609, 424, 233, 95, 29, },
	{24, 77, 202, 387, 578, 707, 720, 612, 427, 236, 97, 30, },
	{24, 76, 200, 383, 576, 705, 720, 614, 430, 239, 98, 31, },
	{23, 75, 197, 380, 573, 704, 721, 617, 433, 241, 100, 31, },
	{23, 73, 195, 377, 570, 703, 722, 619, 437, 244, 101, 32, },
	{23, 72, 192, 374, 567, 702, 723, 621, 440, 247, 103, 32, },
	{22, 71, 190, 371, 565, 700, 723, 624, 443, 250, 105, 33, },
	{22, 69, 187, 368, 562, 699, 724, 626, 446, 252, 107, 33, },
	{22, 68, 185, 365, 559, 698, 724, 628, 449, 255, 108, 34, },
	{21, 67, 183, 362, 556, 696, 725, 631, 452, 258, 110, 35, },
	{21, 66, 180, 359, 554, 695, 726, 633, 455, 261, 112, 35, },
	{21, 65, 178, 356, 551, 693, 726, 635, 458, 264, 114, 36, },
	{21, 63, 175, 353, 548, 692, 727, 638, 461, 266, 115, 37, },
	{20, 62, 173, 349, 545, 690, 727, 640, 465, 269, 117, 37, },
	{20, 61, 171, 346, 542, 689, 727, 642, 468, 272, 119, 38, },
	{20, 60, 169, 343, 539, 687, 728, 644, 471, 275, 121, 39, },
	{20, 59, 166, 340, 537, 686, 728, 646, 474, 278, 123, 40, },
	{19, 58, 164, 337, 534, 684, 729, 648, 477, 281, 125, 40, },
	{19, 57, 162, 334, 531, 683, 729, 651, 480, 284, 127, 41, },
	{19, 56, 160, 331, 528, 681, 729, 653, 483, 287, 129, 42, },
	{19, 55, 157, 328, 525, 679, 729, 655, 486, 289, 130, 43, },
	{18, 54, 155, 325, 522, 677, 730, 657, 489, 292, 132, 44, },
	{18, 53, 153, 322, 519, 676, 730, 659, 492, 295, 134, 44, },
	{18, 52, 151, 319, 516, 674, 730, 661, 495, 298, 136, 45, },
	{18, 51, 149, 316, 513, 672, 730, 663, 498, 301, 138, 46, },
	{18, 50, 147, 313, 510, 670, 730, 665, 501, 304, 141, 47, },
	{18, 49, 145, 310, 507, 669, 730, 667, 504, 307, 143, 48, },
};

#define XV_HSCALER_CTRL_WIDTH_HWREG_HFLTCOEFF			(16)
#define XV_HSCALER_CTRL_DEPTH_HWREG_HFLTCOEFF			(384)
#define XV_HSCALER_CTRL_ADDR_HWREG_PHASESH_V_BASE		(0x2000)
#define XV_HSCALER_CTRL_ADDR_HWREG_PHASESH_V_HIGH		(0x3fff)
#define XV_HSCALER_CTRL_WIDTH_HWREG_PHASESH_V			(18)
#define XV_HSCALER_CTRL_DEPTH_HWREG_PHASESH_V			(1920)

/* H-scaler masks */
#define XV_HSCALER_PHASESH_V_OUTPUT_WR_EN			BIT(8)

/* V-scaler registers */
#define XV_VSCALER_CTRL_ADDR_AP_CTRL			(0x000)
#define XV_VSCALER_CTRL_ADDR_GIE			(0x004)
#define XV_VSCALER_CTRL_ADDR_IER			(0x008)
#define XV_VSCALER_CTRL_ADDR_ISR			(0x00c)
#define XV_VSCALER_CTRL_ADDR_HWREG_HEIGHTIN_DATA	(0x010)
#define XV_VSCALER_CTRL_ADDR_HWREG_WIDTH_DATA		(0x018)
#define XV_VSCALER_CTRL_ADDR_HWREG_HEIGHTOUT_DATA	(0x020)
#define XV_VSCALER_CTRL_ADDR_HWREG_LINERATE_DATA	(0x028)
#define XV_VSCALER_CTRL_ADDR_HWREG_COLORMODE_DATA	(0x030)
#define XV_VSCALER_CTRL_ADDR_HWREG_VFLTCOEFF_BASE	(0x800)
#define XV_VSCALER_CTRL_ADDR_HWREG_VFLTCOEFF_HIGH	(0xbff)

/* V-scaler coefficients for 6, 8, 10 and 12 tap filters */
static const u16
xvsc_coeff_taps6[XV_VSCALER_MAX_V_PHASES][XV_VSCALER_TAPS_6] = {
	{-132, 236, 3824, 236, -132, 64, },
	{-116, 184, 3816, 292, -144, 64, },
	{-100, 132, 3812, 348, -160, 64, },
	{-88, 84, 3808, 404, -176, 64, },
	{-72, 36, 3796, 464, -192, 64, },
	{-60, -8, 3780, 524, -208, 68, },
	{-48, -52, 3768, 588, -228, 68, },
	{-32, -96, 3748, 652, -244, 68, },
	{-20, -136, 3724, 716, -260, 72, },
	{-8,  -172, 3696, 784, -276, 72, },
	{0, -208, 3676,  848, -292, 72, },
	{12, -244, 3640, 920, -308, 76, },
	{20, -276, 3612, 988, -324, 76, },
	{32, -304, 3568, 1060, -340, 80, },
	{40, -332, 3532, 1132, -356, 80, },
	{48, -360, 3492, 1204, -372, 84, },
	{56, -384, 3448, 1276, -388, 88, },
	{64, -408, 3404, 1352, -404, 88, },
	{72, -428, 3348, 1428, -416, 92, },
	{76, -448, 3308, 1500, -432, 92, },
	{84, -464, 3248, 1576, -444, 96, },
	{88, -480, 3200, 1652, -460, 96, },
	{92, -492, 3140, 1728, -472, 100, },
	{96, -504, 3080, 1804, -484, 104, },
	{100, -516, 3020, 1880, -492, 104, },
	{104, -524, 2956, 1960, -504, 104, },
	{104, -532, 2892, 2036, -512, 108, },
	{108, -540, 2832, 2108, -520, 108, },
	{108, -544, 2764, 2184, -528, 112, },
	{112, -544, 2688, 2260, -532, 112, },
	{112, -548, 2624, 2336, -540, 112, },
	{112, -548, 2556, 2408, -544, 112, },
	{112, -544, 2480, 2480, -544, 112, },
	{112, -544, 2408, 2556, -548, 112, },
	{112, -540, 2336, 2624, -548, 112, },
	{112, -532, 2260, 2688, -544, 112, },
	{112, -528, 2184, 2764, -544, 108, },
	{108, -520, 2108, 2832, -540, 108, },
	{108, -512, 2036, 2892, -532, 104, },
	{104, -504, 1960, 2956, -524, 104, },
	{104, -492, 1880, 3020, -516, 100, },
	{104, -484, 1804, 3080, -504, 96, },
	{100, -472, 1728, 3140, -492, 92, },
	{ 96, -460, 1652, 3200, -480, 88, },
	{ 96, -444, 1576, 3248, -464, 84, },
	{ 92, -432, 1500, 3308, -448, 76, },
	{ 92, -416, 1428, 3348, -428, 72, },
	{ 88, -404, 1352, 3404, -408, 64, },
	{ 88, -388, 1276, 3448, -384, 56, },
	{ 84, -372, 1204, 3492, -360, 48, },
	{ 80, -356, 1132, 3532, -332, 40, },
	{ 80, -340, 1060, 3568, -304, 32, },
	{ 76, -324, 988, 3612, -276, 20, },
	{ 76, -308, 920, 3640, -244, 12, },
	{ 72, -292, 848, 3676, -208, 0, },
	{ 72, -276, 784, 3696, -172, -8, },
	{ 72, -260, 716, 3724, -136, -20, },
	{ 68, -244, 652, 3748, -96, -32, },
	{ 68, -228, 588, 3768, -52, -48, },
	{ 68, -208, 524, 3780, -8, -60, },
	{ 64, -192, 464, 3796, 36, -72, },
	{ 64, -176, 404, 3808, 84, -88, },
	{ 64, -160, 348, 3812,  132, -100, },
	{ 64, -144, 292, 3816,  184, -116, }
};

static const u16
xvsc_coeff_taps8[XV_VSCALER_MAX_V_PHASES][XV_VSCALER_TAPS_8] = {
	{-5, 309, 1023, 1445, 1034, 317, -3, -24, },
	{-6, 300, 1011, 1445, 1045, 326, -1, -24, },
	{-7, 291, 1000, 1444, 1056, 336, 0, -24, },
	{-9, 282, 988, 1444, 1067, 345, 2, -24, },
	{-10, 274, 977, 1443, 1078, 354, 4, -24, },
	{-11, 266, 965, 1441, 1089, 364, 6, -24, },
	{-12, 258, 953, 1440, 1100, 373, 8, -24, },
	{-13, 250, 942, 1438, 1110, 383, 10, -24, },
	{-14, 242, 930, 1437, 1121, 393, 12, -24, },
	{-15, 234, 918, 1434, 1131, 403, 14, -24, },
	{-16, 226, 906, 1432, 1142, 413, 17, -24, },
	{-17, 219, 894, 1430, 1152, 423, 19, -24, },
	{-17, 211, 882, 1427, 1162, 433, 22, -24, },
	{-18, 204, 870, 1424, 1172, 443, 24, -24, },
	{-19, 197, 858, 1420, 1182, 454, 27, -24, },
	{-19, 190, 846, 1417, 1191, 464, 30, -24, },
	{-20, 183, 834, 1413, 1201, 475, 33, -24, },
	{-20, 176, 822, 1409, 1210, 486, 36, -24, },
	{-21, 170, 810, 1405, 1220, 497, 39, -24, },
	{-21, 163, 798, 1401, 1229, 507, 42, -24, },
	{-22, 157, 786, 1396, 1238, 518, 46, -24, },
	{-22, 151, 774, 1392, 1247, 529, 49, -24, },
	{-22, 144, 762, 1387, 1255, 540, 53, -24, },
	{-23, 139, 750, 1382, 1264, 552, 57, -24, },
	{-23, 133, 738, 1376, 1272, 563, 60, -24, },
	{-23, 127, 726, 1371, 1280, 574, 64, -24, },
	{-23, 121, 714, 1365, 1288, 586, 69, -24, },
	{-23, 116, 703, 1359, 1296, 597, 73, -24, },
	{-24, 111, 691, 1353, 1304, 609, 77, -24, },
	{-24, 105, 679, 1346, 1312, 620, 81, -24, },
	{-24, 100, 667, 1340, 1319, 632, 86, -24, },
	{-24, 96, 655, 1333, 1326, 644, 91, -24, },
	{-24, 91, 644, 1326, 1333, 655, 96, -24, },
	{-24, 86, 632, 1319, 1340, 667, 100, -24, },
	{-24, 81, 620, 1312, 1346, 679, 105, -24, },
	{-24, 77, 609, 1304, 1353, 691, 111, -24, },
	{-24, 73, 597, 1296, 1359, 703, 116, -23, },
	{-24, 69, 586, 1288, 1365, 714, 121, -23, },
	{-24, 64, 574, 1280, 1371, 726, 127, -23, },
	{-24, 60, 563, 1272, 1376, 738, 133, -23, },
	{-24, 57, 552, 1264, 1382, 750, 139, -23, },
	{-24, 53, 540, 1255, 1387, 762, 144, -22, },
	{-24, 49, 529, 1247, 1392, 774, 151, -22, },
	{-24, 46, 518, 1238, 1396, 786, 157, -22, },
	{-24, 42, 507, 1229, 1401, 798, 163, -21, },
	{-24, 39, 497, 1220, 1405, 810, 170, -21, },
	{-24, 36, 486, 1210, 1409, 822, 176, -20, },
	{-24, 33, 475, 1201, 1413, 834, 183, -20, },
	{-24, 30, 464, 1191, 1417, 846, 190, -19, },
	{-24, 27, 454, 1182, 1420, 858, 197, -19, },
	{-24, 24, 443, 1172, 1424, 870, 204, -18, },
	{-24, 22, 433, 1162, 1427, 882, 211, -17, },
	{-24, 19, 423, 1152, 1430, 894, 219, -17, },
	{-24, 17, 413, 1142, 1432, 906, 226, -16, },
	{-24, 14, 403, 1131, 1434, 918, 234, -15, },
	{-24, 12, 393, 1121, 1437, 930, 242, -14, },
	{-24, 10, 383, 1110, 1438, 942, 250, -13, },
	{-24, 8, 373, 1100, 1440, 953, 258, -12, },
	{-24, 6, 364, 1089, 1441, 965, 266, -11, },
	{-24, 4, 354, 1078, 1443, 977, 274, -10, },
	{-24, 2, 345, 1067, 1444, 988, 282, -9, },
	{-24, 0, 336, 1056, 1444, 1000, 291, -7, },
	{-24, -1, 326, 1045, 1445, 1011, 300, -6, },
	{-24, -3, 317, 1034, 1445, 1023, 309, -5, },
};

static const u16
xvsc_coeff_taps10[XV_VSCALER_MAX_V_PHASES][XV_VSCALER_TAPS_10] = {
	{59, 224, 507, 790, 911, 793, 512, 227, 61, 13, },
	{58, 220, 502, 786, 911, 797, 516, 231, 62, 13, },
	{56, 216, 497, 783, 911, 800, 521, 235, 64, 13, },
	{55, 213, 492, 779, 910, 804, 526, 238, 65, 13, },
	{54, 209, 487, 775, 910, 807, 531, 242, 67, 14, },
	{52, 206, 482, 772, 910, 810, 536, 246, 69, 14, },
	{51, 202, 477, 768, 909, 813, 541, 250, 70, 14, },
	{50, 199, 473, 764, 909, 817, 545, 254, 72, 14, },
	{48, 195, 468, 760, 908, 820, 550, 258, 74, 15, },
	{47, 192, 463, 756, 908, 823, 555, 262, 76, 15, },
	{46, 188, 458, 752, 907, 826, 560, 266, 78, 15, },
	{45, 185, 453, 748, 906, 829, 565, 270, 79, 16, },
	{44, 182, 448, 744, 906, 832, 569, 274, 81, 16, },
	{42, 179, 444, 740, 905, 835, 574, 278, 83, 16, },
	{41, 175, 439, 736, 904, 837, 579, 282, 85, 17, },
	{40, 172, 434, 732, 903, 840, 584, 286, 87, 17, },
	{39, 169, 429, 728, 902, 843, 589, 290, 89, 18, },
	{38, 166, 425, 724, 901, 846, 593, 294, 91, 18, },
	{37, 163, 420, 720, 900, 848, 598, 298, 93, 18, },
	{36, 160, 415, 716, 899, 851, 603, 302, 95, 19, },
	{35, 157, 410, 711, 897, 854, 608, 307, 98, 19, },
	{34, 154, 406, 707, 896, 856, 612, 311, 100, 20, },
	{33, 151, 401, 703, 895, 859, 617, 315, 102, 20, },
	{33, 148, 396, 698, 893, 861, 622, 320, 104, 21, },
	{32, 145, 392, 694, 892, 863, 626, 324, 107, 21, },
	{31, 142, 387, 690, 890, 866, 631, 328, 109, 22, },
	{30, 140, 382, 685, 889, 868, 636, 333, 111, 23, },
	{29, 137, 378, 681, 887, 870, 640, 337, 114, 23, },
	{28, 134, 373, 677, 886, 872, 645, 342, 116, 24, },
	{28, 131, 369, 672, 884, 874, 649, 346, 119, 24, },
	{27, 129, 364, 668, 882, 876, 654, 350, 121, 25, },
	{26, 126, 359, 663, 880, 878, 659, 355, 124, 26, },
	{26, 124, 355, 659, 878, 880, 663, 359, 126, 26, },
	{25, 121, 350, 654, 876, 882, 668, 364, 129, 27, },
	{24, 119, 346, 649, 874, 884, 672, 369, 131, 28, },
	{24, 116, 342, 645, 872, 886, 677, 373, 134, 28, },
	{23, 114, 337, 640, 870, 887, 681, 378, 137, 29, },
	{23, 111, 333, 636, 868, 889, 685, 382, 140, 30, },
	{22, 109, 328, 631, 866, 890, 690, 387, 142, 31, },
	{21, 107, 324, 626, 863, 892, 694, 392, 145, 32, },
	{21, 104, 320, 622, 861, 893, 698, 396, 148, 33, },
	{20, 102, 315, 617, 859, 895, 703, 401, 151, 33, },
	{20, 100, 311, 612, 856, 896, 707, 406, 154, 34, },
	{19, 98, 307, 608, 854, 897, 711, 410, 157, 35, },
	{19, 95, 302, 603, 851, 899, 716, 415, 160, 36, },
	{18, 93, 298, 598, 848, 900, 720, 420, 163, 37, },
	{18, 91, 294, 593, 846, 901, 724, 425, 166, 38, },
	{18, 89, 290, 589, 843, 902, 728, 429, 169, 39, },
	{17, 87, 286, 584, 840, 903, 732, 434, 172, 40, },
	{17, 85, 282, 579, 837, 904, 736, 439, 175, 41, },
	{16, 83, 278, 574, 835, 905, 740, 444, 179, 42, },
	{16, 81, 274, 569, 832, 906, 744, 448, 182, 44, },
	{16, 79, 270, 565, 829, 906, 748, 453, 185, 45, },
	{15, 78, 266, 560, 826, 907, 752, 458, 188, 46, },
	{15, 76, 262, 555, 823, 908, 756, 463, 192, 47, },
	{15, 74, 258, 550, 820, 908, 760, 468, 195, 48, },
	{14, 72, 254, 545, 817, 909, 764, 473, 199, 50, },
	{14, 70, 250, 541, 813, 909, 768, 477, 202, 51, },
	{14, 69, 246, 536, 810, 910, 772, 482, 206, 52, },
	{14, 67, 242, 531, 807, 910, 775, 487, 209, 54, },
	{13, 65, 238, 526, 804, 910, 779, 492, 213, 55, },
	{13, 64, 235, 521, 800, 911, 783, 497, 216, 56, },
	{13, 62, 231, 516, 797, 911, 786, 502, 220, 58, },
	{13, 61, 227, 512, 793, 911, 790, 507, 224, 59, },
};

static const u16
xvsc_coeff_taps12[XV_VSCALER_MAX_V_PHASES][XV_VSCALER_TAPS_12] = {
	{48, 143, 307, 504, 667, 730, 669, 507, 310, 145, 49, 18, },
	{47, 141, 304, 501, 665, 730, 670, 510, 313, 147, 50, 18, },
	{46, 138, 301, 498, 663, 730, 672, 513, 316, 149, 51, 18, },
	{45, 136, 298, 495, 661, 730, 674, 516, 319, 151, 52, 18, },
	{44, 134, 295, 492, 659, 730, 676, 519, 322, 153, 53, 18, },
	{44, 132, 292, 489, 657, 730, 677, 522, 325, 155, 54, 18, },
	{43, 130, 289, 486, 655, 729, 679, 525, 328, 157, 55, 19, },
	{42, 129, 287, 483, 653, 729, 681, 528, 331, 160, 56, 19, },
	{41, 127, 284, 480, 651, 729, 683, 531, 334, 162, 57, 19, },
	{40, 125, 281, 477, 648, 729, 684, 534, 337, 164, 58, 19, },
	{40, 123, 278, 474, 646, 728, 686, 537, 340, 166, 59, 20, },
	{39, 121, 275, 471, 644, 728, 687, 539, 343, 169, 60, 20, },
	{38, 119, 272, 468, 642, 727, 689, 542, 346, 171, 61, 20, },
	{37, 117, 269, 465, 640, 727, 690, 545, 349, 173, 62, 20, },
	{37, 115, 266, 461, 638, 727, 692, 548, 353, 175, 63, 21, },
	{36, 114, 264, 458, 635, 726, 693, 551, 356, 178, 65, 21, },
	{35, 112, 261, 455, 633, 726, 695, 554, 359, 180, 66, 21, },
	{35, 110, 258, 452, 631, 725, 696, 556, 362, 183, 67, 21, },
	{34, 108, 255, 449, 628, 724, 698, 559, 365, 185, 68, 22, },
	{33, 107, 252, 446, 626, 724, 699, 562, 368, 187, 69, 22, },
	{33, 105, 250, 443, 624, 723, 700, 565, 371, 190, 71, 22, },
	{32, 103, 247, 440, 621, 723, 702, 567, 374, 192, 72, 23, },
	{32, 101, 244, 437, 619, 722, 703, 570, 377, 195, 73, 23, },
	{31, 100, 241, 433, 617, 721, 704, 573, 380, 197, 75, 23, },
	{31, 98, 239, 430, 614, 720, 705, 576, 383, 200, 76, 24, },
	{30, 97, 236, 427, 612, 720, 707, 578, 387, 202, 77, 24, },
	{29, 95, 233, 424, 609, 719, 708, 581, 390, 205, 79, 24, },
	{29, 93, 231, 421, 607, 718, 709, 584, 393, 207, 80, 25, },
	{28, 92, 228, 418, 604, 717, 710, 586, 396, 210, 81, 25, },
	{28, 90, 225, 415, 602, 716, 711, 589, 399, 212, 83, 26, },
	{27, 89, 223, 412, 599, 715, 712, 591, 402, 215, 84, 26, },
	{27, 87, 220, 408, 597, 714, 713, 594, 405, 217, 86, 27, },
	{27, 86, 217, 405, 594, 713, 714, 597, 408, 220, 87, 27, },
	{26, 84, 215, 402, 591, 712, 715, 599, 412, 223, 89, 27, },
	{26, 83, 212, 399, 589, 711, 716, 602, 415, 225, 90, 28, },
	{25, 81, 210, 396, 586, 710, 717, 604, 418, 228, 92, 28, },
	{25, 80, 207, 393, 584, 709, 718, 607, 421, 231, 93, 29, },
	{24, 79, 205, 390, 581, 708, 719, 609, 424, 233, 95, 29, },
	{24, 77, 202, 387, 578, 707, 720, 612, 427, 236, 97, 30, },
	{24, 76, 200, 383, 576, 705, 720, 614, 430, 239, 98, 31, },
	{23, 75, 197, 380, 573, 704, 721, 617, 433, 241, 100, 31, },
	{23, 73, 195, 377, 570, 703, 722, 619, 437, 244, 101, 32, },
	{23, 72, 192, 374, 567, 702, 723, 621, 440, 247, 103, 32, },
	{22, 71, 190, 371, 565, 700, 723, 624, 443, 250, 105, 33, },
	{22, 69, 187, 368, 562, 699, 724, 626, 446, 252, 107, 33, },
	{22, 68, 185, 365, 559, 698, 724, 628, 449, 255, 108, 34, },
	{21, 67, 183, 362, 556, 696, 725, 631, 452, 258, 110, 35, },
	{21, 66, 180, 359, 554, 695, 726, 633, 455, 261, 112, 35, },
	{21, 65, 178, 356, 551, 693, 726, 635, 458, 264, 114, 36, },
	{21, 63, 175, 353, 548, 692, 727, 638, 461, 266, 115, 37, },
	{20, 62, 173, 349, 545, 690, 727, 640, 465, 269, 117, 37, },
	{20, 61, 171, 346, 542, 689, 727, 642, 468, 272, 119, 38, },
	{20, 60, 169, 343, 539, 687, 728, 644, 471, 275, 121, 39, },
	{20, 59, 166, 340, 537, 686, 728, 646, 474, 278, 123, 40, },
	{19, 58, 164, 337, 534, 684, 729, 648, 477, 281, 125, 40, },
	{19, 57, 162, 334, 531, 683, 729, 651, 480, 284, 127, 41, },
	{19, 56, 160, 331, 528, 681, 729, 653, 483, 287, 129, 42, },
	{19, 55, 157, 328, 525, 679, 729, 655, 486, 289, 130, 43, },
	{18, 54, 155, 325, 522, 677, 730, 657, 489, 292, 132, 44, },
	{18, 53, 153, 322, 519, 676, 730, 659, 492, 295, 134, 44, },
	{18, 52, 151, 319, 516, 674, 730, 661, 495, 298, 136, 45, },
	{18, 51, 149, 316, 513, 672, 730, 663, 498, 301, 138, 46, },
	{18, 50, 147, 313, 510, 670, 730, 665, 501, 304, 141, 47, },
	{18, 49, 145, 310, 507, 669, 730, 667, 504, 307, 143, 48, },
};

#define XV_VSCALER_CTRL_WIDTH_HWREG_VFLTCOEFF		(16)
#define XV_VSCALER_CTRL_DEPTH_HWREG_VFLTCOEFF		(384)

/**
 * struct xscaler_device - Xilinx Scaler device structure
 * @xvip: Xilinx Video IP device
 * @pads: Scaler sub-device media pads
 * @formats: V4L2 media bus formats at the sink and source pads
 * @default_formats: default V4L2 media bus formats
 * @vip_formats: Xilinx Video IP format retrieved from the DT
 * @num_hori_taps: number of horizontal taps
 * @num_vert_taps: number of vertical taps
 * @max_num_phases: maximum number of phases
 * @pix_per_clk: Pixels per Clock cycle the IP operates upon
 * @max_pixels: The maximum number of pixels that the H-scaler examines
 * @max_lines: The maximum number of lines that the V-scaler examines
 * @H_phases: The phases needed to program the H-scaler for different taps
 * @hscaler_coeff: The complete array of H-scaler coefficients
 * @vscaler_coeff: The complete array of V-scaler coefficients
 * @is_polyphase: Track if scaling algorithm is polyphase or not
 * @rst_gpio: GPIO reset line to bring VPSS Scaler out of reset
 */
struct xscaler_device {
	struct xvip_device xvip;

	struct media_pad pads[2];
	struct v4l2_mbus_framefmt formats[2];
	struct v4l2_mbus_framefmt default_formats[2];
	const struct xvip_video_format *vip_formats[2];

	u32 num_hori_taps;
	u32 num_vert_taps;
	u32 max_num_phases;
	u32 pix_per_clk;
	u32 max_pixels;
	u32 max_lines;
	u32 H_phases[XV_HSCALER_MAX_LINE_WIDTH];
	short hscaler_coeff[XV_HSCALER_MAX_H_PHASES][XV_HSCALER_MAX_H_TAPS];
	short vscaler_coeff[XV_VSCALER_MAX_V_PHASES][XV_VSCALER_MAX_V_TAPS];
	bool is_polyphase;

	struct gpio_desc *rst_gpio;
};

static inline struct xscaler_device *to_scaler(struct v4l2_subdev *subdev)
{
	return container_of(subdev, struct xscaler_device, xvip.subdev);
}

static void
xv_hscaler_calculate_phases(struct xscaler_device *xscaler,
			    u32 width_in, u32 width_out, u32 pixel_rate)
{
	unsigned int loop_width;
	unsigned int x, s;
	int offset = 0;
	int xwrite_pos = 0;
	bool output_write_en;
	bool get_new_pix;
	u64 phaseH;
	u32 array_idx = 0;
	int nr_rds;
	int nr_rds_clck;
	unsigned int nphases = xscaler->max_num_phases;
	unsigned int nppc = xscaler->pix_per_clk;
	unsigned int shift = XHSC_STEP_PRECISION_SHIFT - ilog2(nphases);

	loop_width = max_t(u32, width_in, width_out);
	loop_width = ALIGN(loop_width + nppc - 1, nppc);

	for (x = 0; x < loop_width; x++) {
		nr_rds_clck = 0;
		for (s = 0; s < nppc; s++) {
			phaseH = (offset >> shift) & (nphases - 1);
			get_new_pix = false;
			output_write_en = false;
			if ((offset >> XHSC_STEP_PRECISION_SHIFT) != 0) {
				/* read a new input sample */
				get_new_pix = true;
				offset -= (1 << XHSC_STEP_PRECISION_SHIFT);
				array_idx++;
			}

			if (((offset >> XHSC_STEP_PRECISION_SHIFT) == 0) &&
			    (xwrite_pos < width_out)) {
				/* produce a new output sample */
				offset += pixel_rate;
				output_write_en = true;
				xwrite_pos++;
			}

			/* Needs updates for 4 PPC */
			xscaler->H_phases[x] |= (phaseH <<
						(s * XHSC_HPHASE_MULTIPLIER));
			xscaler->H_phases[x] |= (array_idx <<
						(XHSC_HPHASE_SHIFT_BY_6 +
						(s * XHSC_HPHASE_MULTIPLIER)));
			if (output_write_en) {
				xscaler->H_phases[x] |=
				(XV_HSCALER_PHASESH_V_OUTPUT_WR_EN <<
				(s * XHSC_HPHASE_MULTIPLIER));
			}

			if (get_new_pix)
				nr_rds_clck++;
		}
		if (array_idx >= nppc)
			array_idx &= (nppc - 1);

		nr_rds += nr_rds_clck;
		if (nr_rds >= nppc)
			nr_rds -= nppc;
	}
}

static void
xv_hscaler_load_ext_coeff(struct xscaler_device *xscaler,
			  const short *coeff, u32 ntaps)
{
	unsigned int i, j, pad, offset;
	u32 nphases = xscaler->max_num_phases;

	/* Determine if coefficient needs padding (effective vs. max taps) */
	pad = XV_HSCALER_MAX_H_TAPS - ntaps;
	offset = pad >> 1;
	dev_dbg(xscaler->xvip.dev,
		"%s : Pad = %d Offset = %d Nphases = %d ntaps = %d",
			__func__, pad, offset, nphases, ntaps);

	/* Load coefficients into scaler coefficient table */
	for (i = 0; i < nphases; i++) {
		for (j = 0; j < ntaps; ++j)
			xscaler->hscaler_coeff[i][j + offset] =
						coeff[i * ntaps + j];
	}

	if (pad) { /* effective taps < max_taps */
		for (i = 0; i < nphases; i++) {
			/* pad left */
			for (j = 0; j < offset; j++)
				xscaler->hscaler_coeff[i][j] = 0;
			/* pad right */
			j = ntaps + offset;
			for (; j < XV_HSCALER_MAX_H_TAPS; j++)
				xscaler->hscaler_coeff[i][j] = 0;
		}
	}
}

/**
 * xv_hscaler_coeff_select - Selection of H-Scaler coefficients of operation
 * @xscaler: VPSS Scaler device information
 * @width_in: Width of input video
 * @width_out: Width of desired output video
 *
 * There are instances when a N-tap filter might operate in an M-tap
 * configuration where N > M.
 *
 * For example :
 * Depending on the ratio of scaling (while downscaling), a 12-tap
 * filter may operate with 10 tap coefficients and zero-pads the remaining
 * coefficients.
 *
 * While upscaling the driver will program 6-tap filter coefficients
 * in any N-tap configurations (for N >= 6).
 *
 * This selection is adopted by the as it gives optimal
 * video output determined by repeated testing of the IP
 *
 * Return: Will return 0 if successful. Returns -EINVAL on an unsupported
 * H-scaler number of taps.
 */
static int
xv_hscaler_select_coeff(struct xscaler_device *xscaler,
			u32 width_in, u32 width_out)
{
	const short *coeff;
	u16 hscale_ratio;
	u32 ntaps = xscaler->num_hori_taps;

	/*
	 * Scale Down Mode will use dynamic filter selection logic
	 * Scale Up Mode (including 1:1) will always use 6 tap filter
	 */
	if (width_out < width_in) {
		hscale_ratio = ((width_in * 10) / width_out);

		switch (xscaler->num_hori_taps) {
		case XV_HSCALER_TAPS_6:
			coeff = &xhsc_coeff_taps6[0][0];
			ntaps = XV_HSCALER_TAPS_6;
		break;
		case XV_HSCALER_TAPS_8:
			if (hscale_ratio > 15) {
				coeff = &xhsc_coeff_taps8[0][0];
				ntaps = XV_HSCALER_TAPS_8;
			} else {
				coeff = &xhsc_coeff_taps6[0][0];
				ntaps = XV_HSCALER_TAPS_6;
			}
		break;
		case XV_HSCALER_TAPS_10:
			if (hscale_ratio > 25) {
				coeff = &xhsc_coeff_taps10[0][0];
				ntaps = XV_HSCALER_TAPS_10;
			} else if (hscale_ratio > 15) {
				coeff = &xhsc_coeff_taps8[0][0];
				ntaps = XV_HSCALER_TAPS_8;
			} else {
				coeff = &xhsc_coeff_taps6[0][0];
				ntaps = XV_HSCALER_TAPS_6;
			}
		break;
		case XV_HSCALER_TAPS_12:
			if (hscale_ratio > 35) {
				coeff = &xhsc_coeff_taps12[0][0];
				ntaps = XV_HSCALER_TAPS_12;
			} else if (hscale_ratio > 25) {
				coeff = &xhsc_coeff_taps10[0][0];
				ntaps = XV_HSCALER_TAPS_10;
			} else if (hscale_ratio > 15) {
				coeff = &xhsc_coeff_taps8[0][0];
				ntaps = XV_HSCALER_TAPS_8;
			} else {
				coeff = &xhsc_coeff_taps6[0][0];
				ntaps = XV_HSCALER_TAPS_6;
			}
		break;
		default:
			dev_err(xscaler->xvip.dev,
				"Unsupported H-scaler number of taps = %d",
				xscaler->num_hori_taps);
			return -EINVAL;
		}
	} else {
		dev_dbg(xscaler->xvip.dev, "H-scaler : scale up 6 tap");
		coeff = &xhsc_coeff_taps6[0][0];
		ntaps = XV_HSCALER_TAPS_6;
	}
	xv_hscaler_load_ext_coeff(xscaler, coeff, ntaps);
	return 0;
}

static void xv_hscaler_set_coeff(struct xscaler_device *xscaler)
{
	int val, i, j, offset, rd_indx;
	u32 ntaps = xscaler->num_hori_taps;
	u32 nphases = xscaler->max_num_phases;
	u32 base_addr;

	offset = (XV_HSCALER_MAX_H_TAPS - ntaps) / 2;
	base_addr = V_HSCALER_OFF + XV_HSCALER_CTRL_ADDR_HWREG_HFLTCOEFF_BASE;
	for (i = 0; i < nphases; i++) {
		for (j = 0; j < ntaps / 2; j++) {
			rd_indx = j * 2 + offset;
			val = (xscaler->hscaler_coeff[i][rd_indx + 1] <<
			       XSCALER_BITSHIFT_16) |
			       (xscaler->hscaler_coeff[i][rd_indx] &
			       XHSC_MASK_LOW_16BITS);
			 xvip_write(&xscaler->xvip, base_addr +
				    ((i * ntaps / 2 + j) * 4), val);
		}
	}
}

static void
xv_vscaler_load_ext_coeff(struct xscaler_device *xscaler,
			  const short *coeff, u32 ntaps)
{
	int i, j, pad, offset;
	u32 nphases = xscaler->max_num_phases;

	/* Determine if coefficient needs padding (effective vs. max taps) */
	pad = XV_VSCALER_MAX_V_TAPS - ntaps;
	offset = pad ? (pad >> 1) : 0;

	dev_dbg(xscaler->xvip.dev,
		"%s : Pad = %d Offset = %d Nphases = %d ntaps = %d",
			__func__, pad, offset, nphases, ntaps);

	/* Load User defined coefficients into scaler coefficient table */
	for (i = 0; i < nphases; i++) {
		for (j = 0; j < ntaps; ++j)
			xscaler->vscaler_coeff[i][j + offset] =
						coeff[i * ntaps + j];
	}

	if (pad) { /* effective taps < max_taps */
		for (i = 0; i < nphases; i++) {
			/* pad left */
			for (j = 0; j < offset; j++)
				xscaler->vscaler_coeff[i][j] = 0;
			/* pad right */
			j = ntaps + offset;
			for (; j < XV_VSCALER_MAX_V_TAPS; j++)
				xscaler->vscaler_coeff[i][j] = 0;
		}
	}
}

static void xv_vscaler_set_coeff(struct xscaler_device *xscaler)
{
	u32 nphases = xscaler->max_num_phases;
	u32 ntaps   = xscaler->num_vert_taps;
	int val, i, j, offset, rd_indx;
	u32 base_addr;

	offset = (XV_VSCALER_MAX_V_TAPS - ntaps) / 2;
	base_addr = V_VSCALER_OFF + XV_VSCALER_CTRL_ADDR_HWREG_VFLTCOEFF_BASE;

	for (i = 0; i < nphases; i++) {
		for (j = 0; j < ntaps / 2; j++) {
			rd_indx = j * 2 + offset;
			val = (xscaler->vscaler_coeff[i][rd_indx + 1] <<
			       XSCALER_BITSHIFT_16) |
			       (xscaler->vscaler_coeff[i][rd_indx] &
			       XVSC_MASK_LOW_16BITS);
			xvip_write(&xscaler->xvip,
				   base_addr + ((i * ntaps / 2 + j) * 4), val);
		}
	}
}

/**
 * xv_vscaler_coeff_select - Selection of V-Scaler coefficients of operation
 * @xscaler: VPSS Scaler device information
 * @height_in: Height of input video
 * @height_out: Height of desired output video
 *
 * There are instances when a N-tap filter might operate in an M-tap
 * configuration where N > M.
 *
 * For example :
 * Depending on the ratio of scaling (while downscaling), a 10-tap
 * filter may operate with 6 tap coefficients and zero-pads the remaining
 * coefficients.
 *
 * While upscaling the driver will program 6-tap filter coefficients
 * in any N-tap configurations (for N >= 6).
 *
 * This selection is adopted by the as it gives optimal
 * video output determined by repeated testing of the IP
 *
 * Return: Will return 0 if successful. Returns -EINVAL on an unsupported
 * V-scaler number of taps.
 */
static int
xv_vscaler_select_coeff(struct xscaler_device *xscaler,
			u32 height_in, u32 height_out)
{
	const short *coeff;
	u16 vscale_ratio;
	u32 ntaps = xscaler->num_vert_taps;

	/*
	 * Scale Down Mode will use dynamic filter selection logic
	 * Scale Up Mode (including 1:1) will always use 6 tap filter
	 */

	if (height_out < height_in) {
		vscale_ratio = ((height_in * 10) / height_out);

		switch (xscaler->num_vert_taps) {
		case XV_VSCALER_TAPS_6:
			coeff = &xvsc_coeff_taps6[0][0];
			ntaps = XV_VSCALER_TAPS_6;
			break;
		case XV_VSCALER_TAPS_8:
			if (vscale_ratio > 15) {
				coeff = &xvsc_coeff_taps8[0][0];
				ntaps = XV_VSCALER_TAPS_8;
			} else {
				coeff = &xvsc_coeff_taps6[0][0];
				ntaps = XV_VSCALER_TAPS_6;
			}
			break;
		case XV_VSCALER_TAPS_10:
			if (vscale_ratio > 25) {
				coeff = &xvsc_coeff_taps10[0][0];
				ntaps = XV_VSCALER_TAPS_10;
			} else if (vscale_ratio > 15) {
				coeff = &xvsc_coeff_taps8[0][0];
				ntaps = XV_VSCALER_TAPS_8;
			} else {
				coeff = &xvsc_coeff_taps6[0][0];
				ntaps = XV_VSCALER_TAPS_6;
			}
			break;
		case XV_VSCALER_TAPS_12:
			if (vscale_ratio > 35) {
				coeff = &xvsc_coeff_taps12[0][0];
				ntaps = XV_VSCALER_TAPS_12;
			} else if (vscale_ratio > 25) {
				coeff = &xvsc_coeff_taps10[0][0];
				ntaps = XV_VSCALER_TAPS_10;
			} else if (vscale_ratio > 15) {
				coeff = &xvsc_coeff_taps8[0][0];
				ntaps = XV_VSCALER_TAPS_8;
			} else {
				coeff = &xvsc_coeff_taps6[0][0];
				ntaps = XV_VSCALER_TAPS_6;
			}
			break;
		default:
			dev_err(xscaler->xvip.dev,
				"Unsupported V-scaler number of taps = %d",
				xscaler->num_vert_taps);
			return -EINVAL;
		}
	} else {
		dev_dbg(xscaler->xvip.dev, "V-scaler : scale up 6 tap");
		coeff = &xvsc_coeff_taps6[0][0];
		ntaps = XV_VSCALER_TAPS_6;
	}

	xv_vscaler_load_ext_coeff(xscaler, coeff, ntaps);
	return 0;
}

/*
 * V4L2 Subdevice Video Operations
 */

static inline void
xv_procss_disable_block(struct xvip_device *xvip, u32 channel, u32 ip_block)
{
	xvip_clr(xvip, ((channel - 1) * XGPIO_CHAN_OFFSET) +
		 XGPIO_DATA_OFFSET + S_AXIS_RESET_OFF,
		 ip_block);
}

static inline void
xv_procss_enable_block(struct xvip_device *xvip, u32 channel, u32 ip_block)
{
	xvip_set(xvip, ((channel - 1) * XGPIO_CHAN_OFFSET) +
		 XGPIO_DATA_OFFSET + S_AXIS_RESET_OFF,
		 ip_block);
}

static void xscaler_reset(struct xscaler_device *xscaler)
{
	xv_procss_disable_block(&xscaler->xvip, XGPIO_CH_RESET_SEL,
				XGPIO_RESET_MASK_ALL_BLOCKS);
	xv_procss_enable_block(&xscaler->xvip, XGPIO_CH_RESET_SEL,
			       XGPIO_RESET_MASK_IP_AXIS);
}

static int
xv_vscaler_setup_video_fmt(struct xscaler_device *xscaler, u32 code_in)
{
	u32 video_in;

	switch (code_in) {
	case MEDIA_BUS_FMT_VYYUYY8_1X24:
		dev_dbg(xscaler->xvip.dev,
			"Vscaler Input Media Format YUV 420");
		video_in = XVIDC_CSF_YCRCB_420;
		break;
	case MEDIA_BUS_FMT_UYVY8_1X16:
		dev_dbg(xscaler->xvip.dev,
			"Vscaler Input Media Format YUV 422");
		video_in = XVIDC_CSF_YCRCB_422;
		break;
	case MEDIA_BUS_FMT_VUY8_1X24:
		dev_dbg(xscaler->xvip.dev,
			"Vscaler Input Media Format YUV 444");
		video_in = XVIDC_CSF_YCRCB_444;
		break;
	case MEDIA_BUS_FMT_RBG888_1X24:
		dev_dbg(xscaler->xvip.dev,
			"Vscaler Input Media Format RGB");
		video_in = XVIDC_CSF_RGB;
		break;
	default:
		dev_err(xscaler->xvip.dev,
			"Vscaler Unsupported Input Media Format 0x%x",
			code_in);
		return -EINVAL;
	}
	xvip_write(&xscaler->xvip, V_VSCALER_OFF +
		   XV_VSCALER_CTRL_ADDR_HWREG_COLORMODE_DATA,
		   video_in);
	/*
	 * Vscaler will upscale to YUV 422 before
	 * Hscaler starts operation
	 */
	if (video_in == XVIDC_CSF_YCRCB_420)
		return XVIDC_CSF_YCRCB_422;
	return video_in;
}

static int xv_hscaler_setup_video_fmt(struct xscaler_device *xscaler,
				      u32 code_out, u32 vsc_out)
{
	u32 video_out;

	switch (vsc_out) {
	case XVIDC_CSF_YCRCB_422:
		dev_dbg(xscaler->xvip.dev,
			"Hscaler Input Media Format is YUV 422");
		break;
	case XVIDC_CSF_YCRCB_444:
		dev_dbg(xscaler->xvip.dev,
			"Hscaler Input Media Format is YUV 444");
		break;
	case XVIDC_CSF_RGB:
		dev_dbg(xscaler->xvip.dev,
			"Hscaler Input Media Format is RGB");
		break;
	default:
		dev_err(xscaler->xvip.dev,
			"Hscaler got unsupported format from Vscaler");
		return -EINVAL;
	}

	xvip_write(&xscaler->xvip, V_HSCALER_OFF +
		XV_HSCALER_CTRL_ADDR_HWREG_COLORMODE_DATA,
		vsc_out);

	switch (code_out) {
	case MEDIA_BUS_FMT_VYYUYY8_1X24:
		dev_dbg(xscaler->xvip.dev,
			"Hscaler Output Media Format YUV 420\n");
		video_out = XVIDC_CSF_YCRCB_420;
		break;
	case MEDIA_BUS_FMT_UYVY8_1X16:
		dev_dbg(xscaler->xvip.dev,
			"Hscaler Output Media Format YUV 422\n");
		video_out = XVIDC_CSF_YCRCB_422;
		break;
	case MEDIA_BUS_FMT_VUY8_1X24:
		dev_dbg(xscaler->xvip.dev,
			"Hscaler Output Media Format YUV 444\n");
		video_out = XVIDC_CSF_YCRCB_444;
		break;
	case MEDIA_BUS_FMT_RBG888_1X24:
		dev_dbg(xscaler->xvip.dev,
			"Hscaler Output Media Format RGB\n");
		video_out = XVIDC_CSF_RGB;
		break;
	default:
		dev_err(xscaler->xvip.dev,
			"Hscaler Unsupported Output Media Format 0x%x",
			code_out);
		return -EINVAL;
	}
	xvip_write(&xscaler->xvip, V_HSCALER_OFF +
		   XV_HSCALER_CTRL_ADDR_HWREG_COLORMODEOUT_DATA,
		   video_out);
	return 0;
}

static void
xv_hscaler_set_phases(struct xscaler_device *xscaler)
{
	u32 loop_width;
	u32 index, val;
	u32 offset, i, lsb, msb;

	loop_width = xscaler->max_pixels / xscaler->pix_per_clk;
	offset = V_HSCALER_OFF + XV_HSCALER_CTRL_ADDR_HWREG_PHASESH_V_BASE;

	switch (xscaler->pix_per_clk) {
	case XSCALER_PPC_1:
		/*
		 * phaseH is 64 bits but only lower 16 bits of each entry
		 * is valid .Form a 32 bit word with 16bit LSB from 2
		 * consecutive entries. Need 1 32b write to get 2 entries
		 * into IP registers (i is array loc and index is
		 * address offset)
		 */
		index = 0;
		for (i = 0; i < loop_width; i += 2) {
			lsb = xscaler->H_phases[i] & XHSC_MASK_LOW_16BITS;
			msb = xscaler->H_phases[i + 1] & XHSC_MASK_LOW_16BITS;
			val = (msb << 16 | lsb);
			xvip_write(&xscaler->xvip, offset + (index * 4), val);
			++index;
		}
		dev_dbg(xscaler->xvip.dev,
			"%s : Operating in 1 PPC design", __func__);
		return;
	case XSCALER_PPC_2:
		/*
		 * PhaseH is 64bits but only lower 32b of each entry is valid
		 * Need 1 32b write to get each entry into IP registers
		 */
		for (i = 0; i < loop_width; i++) {
			val = (xscaler->H_phases[i] &
					XHSC_MASK_LOW_32BITS);
			xvip_write(&xscaler->xvip, offset + (i * 4), val);
		}
		dev_dbg(xscaler->xvip.dev,
			"%s : Operating in 2 PPC design", __func__);
		return;
	}
}

static int xscaler_s_stream(struct v4l2_subdev *subdev, int enable)
{
	struct xscaler_device *xscaler = to_scaler(subdev);
	u32 width_in, width_out;
	u32 height_in, height_out;
	u32 code_in, code_out;
	u32 pixel_rate;
	u32 line_rate;
	int ret;

	if (!enable) {
		dev_dbg(xscaler->xvip.dev, "%s: Stream Off", __func__);
		/* Reset the Global IP Reset through PS GPIO */
		gpiod_set_value_cansleep(xscaler->rst_gpio,
					 XSCALER_RESET_ASSERT);
		gpiod_set_value_cansleep(xscaler->rst_gpio,
					 XSCALER_RESET_DEASSERT);
		xscaler_reset(xscaler);
		memset(xscaler->H_phases, 0, sizeof(xscaler->H_phases));
		return 0;
	}

	dev_dbg(xscaler->xvip.dev, "%s: Stream On", __func__);

	/* Extract Sink Pad Information */
	width_in = xscaler->formats[XVIP_PAD_SINK].width;
	height_in = xscaler->formats[XVIP_PAD_SINK].height;
	code_in = xscaler->formats[XVIP_PAD_SINK].code;

	/* Extract Source Pad Information */
	width_out = xscaler->formats[XVIP_PAD_SOURCE].width;
	height_out = xscaler->formats[XVIP_PAD_SOURCE].height;
	code_out = xscaler->formats[XVIP_PAD_SOURCE].code;

	/*
	 * V Scaler is before H Scaler
	 * V-Scaler_setup
	 */
	line_rate = (height_in * STEP_PRECISION) / height_out;

	if (xscaler->is_polyphase) {
		ret = xv_vscaler_select_coeff(xscaler, height_in, height_out);
		if (ret < 0)
			return ret;
		xv_vscaler_set_coeff(xscaler);
	}

	xvip_write(&xscaler->xvip, V_VSCALER_OFF +
		   XV_VSCALER_CTRL_ADDR_HWREG_HEIGHTIN_DATA, height_in);
	xvip_write(&xscaler->xvip, V_VSCALER_OFF +
		   XV_VSCALER_CTRL_ADDR_HWREG_WIDTH_DATA, width_in);
	xvip_write(&xscaler->xvip, V_VSCALER_OFF +
		   XV_VSCALER_CTRL_ADDR_HWREG_HEIGHTOUT_DATA, height_out);
	xvip_write(&xscaler->xvip, V_VSCALER_OFF +
		   XV_VSCALER_CTRL_ADDR_HWREG_LINERATE_DATA, line_rate);
	ret = xv_vscaler_setup_video_fmt(xscaler, code_in);
	if (ret < 0)
		return ret;

	/* H-Scaler_setup */
	pixel_rate = (width_in * STEP_PRECISION) / width_out;

	xvip_write(&xscaler->xvip, V_HSCALER_OFF +
		   XV_HSCALER_CTRL_ADDR_HWREG_HEIGHT_DATA, height_out);
	xvip_write(&xscaler->xvip, V_HSCALER_OFF +
		   XV_HSCALER_CTRL_ADDR_HWREG_WIDTHIN_DATA, width_in);
	xvip_write(&xscaler->xvip, V_HSCALER_OFF +
		   XV_HSCALER_CTRL_ADDR_HWREG_WIDTHOUT_DATA, width_out);
	xvip_write(&xscaler->xvip, V_HSCALER_OFF +
		   XV_HSCALER_CTRL_ADDR_HWREG_PIXELRATE_DATA, pixel_rate);
	ret = xv_hscaler_setup_video_fmt(xscaler, code_out, ret);
	if (ret < 0)
		return ret;

	if (xscaler->is_polyphase) {
		ret = xv_hscaler_select_coeff(xscaler, width_in, width_out);
		if (ret < 0)
			return ret;
		xv_hscaler_set_coeff(xscaler);
	}

	xv_hscaler_calculate_phases(xscaler, width_in, width_out, pixel_rate);
	xv_hscaler_set_phases(xscaler);

	/* Start Scaler sub-cores */
	xvip_write(&xscaler->xvip, V_HSCALER_OFF +
		   XV_HSCALER_CTRL_ADDR_AP_CTRL, XSCALER_STREAM_ON);
	xvip_write(&xscaler->xvip, V_VSCALER_OFF +
		   XV_VSCALER_CTRL_ADDR_AP_CTRL, XSCALER_STREAM_ON);
	xv_procss_enable_block(&xscaler->xvip, XGPIO_CH_RESET_SEL,
			       XGPIO_RESET_MASK_VIDEO_IN);
	return 0;
}

/*
 * V4L2 Subdevice Pad Operations
 */

static int xscaler_enum_frame_size(struct v4l2_subdev *subdev,
				   struct v4l2_subdev_pad_config *cfg,
				   struct v4l2_subdev_frame_size_enum *fse)
{
	struct v4l2_mbus_framefmt *format;
	struct xscaler_device *xscaler = to_scaler(subdev);

	format = v4l2_subdev_get_try_format(subdev, cfg, fse->pad);
	if (fse->index || fse->code != format->code)
		return -EINVAL;

	fse->min_width = XSCALER_MIN_WIDTH;
	fse->max_width = xscaler->max_pixels;
	fse->min_height = XSCALER_MIN_HEIGHT;
	fse->max_height = xscaler->max_lines;

	return 0;
}

static struct v4l2_mbus_framefmt *
__xscaler_get_pad_format(struct xscaler_device *xscaler,
			 struct v4l2_subdev_pad_config *cfg,
			 unsigned int pad, u32 which)
{
	switch (which) {
	case V4L2_SUBDEV_FORMAT_TRY:
		return v4l2_subdev_get_try_format(&xscaler->xvip.subdev, cfg,
						  pad);
	case V4L2_SUBDEV_FORMAT_ACTIVE:
		return &xscaler->formats[pad];
	default:
		return NULL;
	}
}

static int xscaler_get_format(struct v4l2_subdev *subdev,
			      struct v4l2_subdev_pad_config *cfg,
			      struct v4l2_subdev_format *fmt)
{
	struct xscaler_device *xscaler = to_scaler(subdev);

	fmt->format = *__xscaler_get_pad_format(xscaler, cfg, fmt->pad,
						fmt->which);

	return 0;
}

static int xscaler_set_format(struct v4l2_subdev *subdev,
			      struct v4l2_subdev_pad_config *cfg,
			      struct v4l2_subdev_format *fmt)
{
	struct xscaler_device *xscaler = to_scaler(subdev);
	struct v4l2_mbus_framefmt *format;

	format = __xscaler_get_pad_format(xscaler, cfg, fmt->pad, fmt->which);
	*format = fmt->format;

	format->width = clamp_t(unsigned int, fmt->format.width,
				XSCALER_MIN_WIDTH, xscaler->max_pixels);
	format->height = clamp_t(unsigned int, fmt->format.height,
				 XSCALER_MIN_HEIGHT, xscaler->max_lines);
	fmt->format = *format;
	return 0;
}

/*
 * V4L2 Subdevice Operations
 */

static int
xscaler_open(struct v4l2_subdev *subdev, struct v4l2_subdev_fh *fh)
{
	struct xscaler_device *xscaler = to_scaler(subdev);
	struct v4l2_mbus_framefmt *format;

	/* Initialize with default formats */
	format = v4l2_subdev_get_try_format(subdev, fh->pad, XVIP_PAD_SINK);
	*format = xscaler->default_formats[XVIP_PAD_SINK];

	format = v4l2_subdev_get_try_format(subdev, fh->pad, XVIP_PAD_SOURCE);
	*format = xscaler->default_formats[XVIP_PAD_SOURCE];

	return 0;
}

static int
xscaler_close(struct v4l2_subdev *subdev, struct v4l2_subdev_fh *fh)
{
	return 0;
}

static struct v4l2_subdev_video_ops xscaler_video_ops = {
	.s_stream = xscaler_s_stream,
};

static struct v4l2_subdev_pad_ops xscaler_pad_ops = {
	.enum_mbus_code		= xvip_enum_mbus_code,
	.enum_frame_size	= xscaler_enum_frame_size,
	.get_fmt		= xscaler_get_format,
	.set_fmt		= xscaler_set_format,
};

static struct v4l2_subdev_ops xscaler_ops = {
	.video  = &xscaler_video_ops,
	.pad    = &xscaler_pad_ops,
};

static const struct v4l2_subdev_internal_ops xscaler_internal_ops = {
	.open	= xscaler_open,
	.close	= xscaler_close,
};

/*
 * Media Operations
 */

static const struct media_entity_operations xscaler_media_ops = {
	.link_validate = v4l2_subdev_link_validate,
};

/*
 * Platform Device Driver
 */

static int xscaler_parse_of(struct xscaler_device *xscaler)
{
	struct device *dev = xscaler->xvip.dev;
	struct device_node *node = xscaler->xvip.dev->of_node;
	const struct xvip_video_format *vip_format;
	struct device_node *ports;
	struct device_node *port;
	int ret;
	u32 port_id, dt_ppc;

	ret = of_property_read_u32(node, "xlnx,max-height",
				   &xscaler->max_lines);
	if (ret < 0) {
		xscaler->max_lines = XSCALER_DEF_MAX_HEIGHT;
	} else if (xscaler->max_lines > XSCALER_MAX_HEIGHT ||
		   xscaler->max_lines < XSCALER_MIN_HEIGHT) {
		dev_err(dev, "Invalid height in dt");
		return -EINVAL;
	}

	ret = of_property_read_u32(node, "xlnx,max-width",
				   &xscaler->max_pixels);
	if (ret < 0) {
		xscaler->max_pixels = XSCALER_DEF_MAX_WIDTH;
	} else if (xscaler->max_pixels > XSCALER_MAX_WIDTH ||
		   xscaler->max_pixels < XSCALER_MIN_WIDTH) {
		dev_err(dev, "Invalid width in dt");
		return -EINVAL;
	}

	ports = of_get_child_by_name(node, "ports");
	if (!ports)
		ports = node;

	/* Get the format description for each pad */
	for_each_child_of_node(ports, port) {
		if (port->name && (of_node_cmp(port->name, "port") == 0)) {
			vip_format = xvip_of_get_format(port);
			if (IS_ERR(vip_format)) {
				dev_err(dev, "invalid format in DT");
				return PTR_ERR(vip_format);
			}

			ret = of_property_read_u32(port, "reg", &port_id);
			if (ret < 0) {
				dev_err(dev, "No reg in DT");
				return ret;
			}

			if (port_id != 0 && port_id != 1) {
				dev_err(dev, "Invalid reg in DT");
				return -EINVAL;
			}
			xscaler->vip_formats[port_id] = vip_format;
		}
	}

	ret = of_property_read_u32(node, "xlnx,num-hori-taps",
				   &xscaler->num_hori_taps);
	if (ret < 0)
		return ret;

	switch (xscaler->num_hori_taps) {
	case XV_HSCALER_TAPS_2:
	case XV_HSCALER_TAPS_4:
		xscaler->is_polyphase = false;
		break;
	case XV_HSCALER_TAPS_6:
	case XV_HSCALER_TAPS_8:
	case XV_HSCALER_TAPS_10:
	case XV_HSCALER_TAPS_12:
		xscaler->is_polyphase = true;
		break;
	default:
		dev_err(dev, "Unsupported num-hori-taps %d",
			xscaler->num_hori_taps);
		return -EINVAL;
	}

	ret = of_property_read_u32(node, "xlnx,num-vert-taps",
				   &xscaler->num_vert_taps);
	if (ret < 0)
		return ret;

	/*
	 * For Bilinear and Bicubic case
	 * number of vertical and horizontal taps must match
	 */
	switch (xscaler->num_vert_taps) {
	case XV_HSCALER_TAPS_2:
	case XV_VSCALER_TAPS_4:
		if (xscaler->num_vert_taps != xscaler->num_hori_taps) {
			dev_err(dev,
				"H-scaler taps %d mismatches V-scaler taps %d",
				 xscaler->num_hori_taps,
				 xscaler->num_vert_taps);
			return -EINVAL;
		}
		break;
	case XV_VSCALER_TAPS_6:
	case XV_VSCALER_TAPS_8:
	case XV_VSCALER_TAPS_10:
	case XV_VSCALER_TAPS_12:
		xscaler->is_polyphase = true;
		break;
	default:
		dev_err(dev, "Unsupported num-vert-taps %d",
			xscaler->num_vert_taps);
		return -EINVAL;
	}

	ret = of_property_read_u32(node, "xlnx,pix-per-clk", &dt_ppc);
	if (ret < 0)
		return ret;

	/* Driver only supports 1 PPC and 2 PPC */
	if (dt_ppc != XSCALER_PPC_1 && dt_ppc != XSCALER_PPC_2) {
		dev_err(xscaler->xvip.dev,
			"Unsupported xlnx,pix-per-clk(%d) value in DT", dt_ppc);
		return -EINVAL;
	}
	xscaler->pix_per_clk = dt_ppc;

	/* Reset GPIO */
	xscaler->rst_gpio = devm_gpiod_get(dev, "reset", GPIOD_OUT_HIGH);
	if (IS_ERR(xscaler->rst_gpio)) {
		if (PTR_ERR(xscaler->rst_gpio) != -EPROBE_DEFER)
			dev_err(dev, "Reset GPIO not setup in DT");
		return PTR_ERR(xscaler->rst_gpio);
	}

	return 0;
}

static int xscaler_probe(struct platform_device *pdev)
{
	struct xscaler_device *xscaler;
	struct v4l2_subdev *subdev;
	struct v4l2_mbus_framefmt *default_format;
	int ret;

	xscaler = devm_kzalloc(&pdev->dev, sizeof(*xscaler), GFP_KERNEL);
	if (!xscaler)
		return -ENOMEM;

	xscaler->xvip.dev = &pdev->dev;

	ret = xscaler_parse_of(xscaler);
	if (ret < 0)
		return ret;

	/* Initialize coefficient parameters */
	xscaler->max_num_phases = XSCALER_MAX_PHASES;

	ret = xvip_init_resources(&xscaler->xvip);
	if (ret < 0)
		return ret;

	/* Reset the Global IP Reset through a PS GPIO */
	gpiod_set_value_cansleep(xscaler->rst_gpio, XSCALER_RESET_DEASSERT);
	/* Reset internal GPIO within the IP */
	xscaler_reset(xscaler);

	/* Initialize V4L2 subdevice and media entity */
	subdev = &xscaler->xvip.subdev;
	v4l2_subdev_init(subdev, &xscaler_ops);
	subdev->dev = &pdev->dev;
	subdev->internal_ops = &xscaler_internal_ops;
	strlcpy(subdev->name, dev_name(&pdev->dev), sizeof(subdev->name));
	v4l2_set_subdevdata(subdev, xscaler);
	subdev->flags |= V4L2_SUBDEV_FL_HAS_DEVNODE;

	/* Initialize default and active formats */
	default_format = &xscaler->default_formats[XVIP_PAD_SINK];
	default_format->code = xscaler->vip_formats[XVIP_PAD_SINK]->code;
	default_format->field = V4L2_FIELD_NONE;
	default_format->colorspace = V4L2_COLORSPACE_SRGB;
	default_format->width = XSCALER_DEF_IN_WIDTH;
	default_format->height = XSCALER_DEF_IN_HEIGHT;
	xscaler->formats[XVIP_PAD_SINK] = *default_format;

	default_format = &xscaler->default_formats[XVIP_PAD_SOURCE];
	*default_format = xscaler->default_formats[XVIP_PAD_SINK];
	default_format->code = xscaler->vip_formats[XVIP_PAD_SOURCE]->code;
	default_format->width = XSCALER_DEF_OUT_WIDTH;
	default_format->height = XSCALER_DEF_OUT_HEIGHT;
	xscaler->formats[XVIP_PAD_SOURCE] = *default_format;

	xscaler->pads[XVIP_PAD_SINK].flags = MEDIA_PAD_FL_SINK;
	xscaler->pads[XVIP_PAD_SOURCE].flags = MEDIA_PAD_FL_SOURCE;
	subdev->entity.ops = &xscaler_media_ops;

	ret = media_entity_pads_init(&subdev->entity, 2, xscaler->pads);
	if (ret < 0)
		goto error;

	platform_set_drvdata(pdev, xscaler);

	ret = v4l2_async_register_subdev(subdev);
	if (ret < 0) {
		dev_err(&pdev->dev, "failed to register subdev");
		goto error;
	}
	dev_info(xscaler->xvip.dev, "Num Hori Taps %d",
		 xscaler->num_hori_taps);
	dev_info(xscaler->xvip.dev, "Num Vert Taps %d",
		 xscaler->num_vert_taps);
	dev_info(&pdev->dev, "VPSS Scaler Probe Successful");
	return 0;

error:
	media_entity_cleanup(&subdev->entity);
	xvip_cleanup_resources(&xscaler->xvip);
	return ret;
}

static int xscaler_remove(struct platform_device *pdev)
{
	struct xscaler_device *xscaler = platform_get_drvdata(pdev);
	struct v4l2_subdev *subdev = &xscaler->xvip.subdev;

	v4l2_async_unregister_subdev(subdev);
	media_entity_cleanup(&subdev->entity);
	xvip_cleanup_resources(&xscaler->xvip);

	return 0;
}

static const struct of_device_id xscaler_of_id_table[] = {
	{ .compatible = "xlnx,v-vpss-scaler" },
	{ /* end of table */ }
};
MODULE_DEVICE_TABLE(of, xscaler_of_id_table);

static struct platform_driver xscaler_driver = {
	.driver			= {
		.name		= "xilinx-vpss-scaler",
		.of_match_table	= xscaler_of_id_table,
	},
	.probe			= xscaler_probe,
	.remove			= xscaler_remove,
};

module_platform_driver(xscaler_driver);
MODULE_DESCRIPTION("Xilinx Scaler VPSS Driver");
MODULE_LICENSE("GPL v2");
