/*
 * (C) Copyright 2000-2006
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef	__VERSION_H__
#define	__VERSION_H__

#include <timestamp.h>

#ifndef DO_DEPS_ONLY
#include "generated/version_autogenerated.h"
#endif

#ifdef __CONFIG_ZYNQMP_ENC185_H
// banjo
// Need to be updated for releasing u-boot
#define SW_VER_MAJ  	( 0x00 )        // Major Version
#define SW_VER_MIN  	( 0x00 )        // Minor Version
#define SW_VER_USR  	( 0x01 )        // User Code 
#define SW_VER_INDEX    ( 0x00 )        // Index

#define SW_VER_YEAR_H   ( 0x20 )        // Year (High)
#define SW_VER_YEAR_L   ( 0x20 )        // Year (Low)
#define SW_VER_MONTH    ( 0x06 )        // Month
#define SW_VER_DAY  	( 0x15 )        // Day

#define SW_VER_HOUR 	( 0x15 )        // Hour
#define SW_VER_MINUTE   ( 0x00 )        // Minute

#define SW_SDK_YEAR 	( 0x2018 )      // SDK Year
#define SW_SDK_VER  	( 0x3 )         // SDK Version

#define SW_SDK_YEAR_H   ( 0x20 )        // SDK Year High
#define SW_SDK_YEAR_L   ( 0x18 )        // SDK Year Low

/* OCM address used for Version info */
#define VERSION_INFO_Q_OCM_ADDR     0xFFFFFFA0  /* pmufw */
#define VERSION_INFO_Q_OCM_SIZE     0x10
#define VERSION_INFO_ATF_ADDR       0xFFFFEFF0  /* ATF */

#define SW_PMUFW_VER_INFO_ADDRESS   0x7FFFF070  /* pmufw */
#define SW_ATF_VER_INFO_ADDRESS     0x7FFFF080  /* atf */
#define SW_UBOOT_VER_INFO_ADDRESS   0x7FFFF090  /* u-boot */

typedef struct _VersionInfo
{
	uint8_t mMajorVer;
	uint8_t mMinorVer;
	uint8_t mUserCode;
	uint8_t mIndex;
	uint8_t mYearH;
	uint8_t mYearL;
	uint8_t mMonth;
	uint8_t mDay;
	uint8_t mHour;
	uint8_t mMinute;
	uint8_t mReserved[ 6 ];
} VersionInfo;
// banjo
#endif

#define U_BOOT_VERSION_STRING U_BOOT_VERSION " (" U_BOOT_DATE " - " \
	U_BOOT_TIME " " U_BOOT_TZ ")" CONFIG_IDENT_STRING

#ifndef __ASSEMBLY__
extern const char version_string[];
#endif	/* __ASSEMBLY__ */
#endif	/* __VERSION_H__ */
