#ifndef __DWPCIE_DEBUGFS_H
#define __DWPCIE_DEBUGFS_H

#include "pcie-designware.h"

#define MAX_STR_LEN           20
#define REG32BYTES            0x04
#define PCIE_HDR_SIZE         16
#define PCI_EXP_CAP_SIZE      13
#define SIDE_BAND_REG32_SIZE  164
#define SIDE_BAND_DUMP_START  0x100
#define iATU_DUMP_SIZE        7
#define iATU_REGION_MAX       8
#define iATU_BASE             (0x03UL<<20)
#define iATU_REGION(x)        ((x&0xff)<<9)
#define iATU_INBOUND(x)       ((x&0x1UL)<<8)
#define dump_iatu_register_set(n,i)			\
{					\
    .name = "Region Control 1    :",	\
    .offset = iATU_BASE + iATU_REGION(n) + iATU_INBOUND(i) + PCIE_ATU_UNR_REGION_CTRL1,	\
},					\
{					\
    .name = "Region Control 2    :",	\
    .offset = iATU_BASE + iATU_REGION(n) + iATU_INBOUND(i) + PCIE_ATU_UNR_REGION_CTRL2,	\
},					\
{					\
    .name = "Lower Base Address  :",	\
    .offset = iATU_BASE+iATU_REGION(n) + iATU_INBOUND(i) + PCIE_ATU_UNR_LOWER_BASE,	\
},					\
{					\
    .name = "Uppper Base Address :",	\
    .offset = iATU_BASE+iATU_REGION(n) + iATU_INBOUND(i) + PCIE_ATU_UNR_UPPER_BASE,	\
},					\
{					\
    .name = "Limit Address       :",	\
    .offset = iATU_BASE+iATU_REGION(n) + iATU_INBOUND(i) + PCIE_ATU_UNR_LIMIT,	\
},					\
{					\
    .name = "Lower Target Address:",	\
    .offset = iATU_BASE+iATU_REGION(n) + iATU_INBOUND(i) + PCIE_ATU_UNR_LOWER_TARGET,	\
},					\
{					\
    .name = "Upper Target Address:",	\
    .offset = iATU_BASE+iATU_REGION(n) + iATU_INBOUND(i) + PCIE_ATU_UNR_UPPER_TARGET,	\
}

#endif /* __DWPCIE_DEBUGFS_H */
