/*
 * drivers/udif/mach-cxd900xx/gic.c
 *
 *
 * Copyright 2018 Sony Corporation
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <linux/module.h>
#include <linux/io.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <mach/gic_export.h>

#define GIC_DIST_CONFIG_EDGE  0x2

void __init gic_config_edge(unsigned int irq)
{
	u32 offset, shift, tmp;

	offset = GIC_CONFIG_OFFSET(irq);
	shift  = GIC_CONFIG_DATA_SHIFT(irq);
	/* RMW */
	tmp = readl_relaxed(VA_GIC_DIST+GIC_DIST_CONFIG + offset);
	tmp |= GIC_DIST_CONFIG_EDGE << shift;
	writel_relaxed(tmp, VA_GIC_DIST+GIC_DIST_CONFIG + offset);
}

void __init gic_target_cpu(unsigned int irq, unsigned int cpumask)
{
	writeb_relaxed(cpumask, VA_GIC_DIST + GIC_DIST_TARGET + irq);
}

#ifdef CONFIG_AUTO_IRQ_AFFINITY
int irq_select_affinity(unsigned int irq)
{
	struct irq_desc *desc;
	struct irq_data *irqd;
	u32 map, cpu;
	extern void irq_set_thread_affinity(struct irq_desc *desc);

	if (!irq_can_set_affinity(irq))
		return 0;
	desc = irq_to_desc(irq);
	irqd = irq_desc_get_irq_data(desc);
	irq = irqd_to_hwirq(irqd);
	map = readb_relaxed(GIC_IRQ_TARGET(irq));
	cpu = ffs(map);
	if (cpu > 0) {
		cpu--;
		cpumask_copy(desc->irq_common_data.affinity, cpumask_of(cpu));
		irq_set_thread_affinity(desc);
	}
	return 0;
}
#endif /* CONFIG_AUTO_IRQ_AFFINITY */

#ifdef CONFIG_AUTO_IRQ_TRIGGER
unsigned int irq_get_trigger(struct irq_desc *desc)
{
	struct irq_chip *chip;
	struct irq_data *irqd;
	unsigned int irq;
	u32 cfg;
	unsigned int trig;

	if (!desc)
		return 0;
	chip = irq_desc_get_chip(desc);
	if (!chip)
		return 0;
	irqd = irq_desc_get_irq_data(desc);
	irq = irqd_to_hwirq(irqd);
	cfg = readl_relaxed(VA_GIC_DIST+GIC_DIST_CONFIG+GIC_CONFIG_OFFSET(irq));
	cfg >>= GIC_CONFIG_DATA_SHIFT(irq);
	cfg &= GIC_CONFIG_DATA_MASK;
	trig = (cfg & GIC_CONFIG_EDGE) ? IRQF_TRIGGER_RISING:IRQF_TRIGGER_HIGH;
	return trig;
}
#endif /* CONFIG_AUTO_IRQ_TRIGGER */
