/*
 * mach-cxd900xx/include/mach/pm_macro.S
 *
 * DDR power down macro
 *
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <mach/platform.h>
#include <mach/bootram.h>
#include <mach/regs-ddrc.h>
#include <mach/regs-clk.h>
#include <mach/regs-srst.h>

#define PM_MEMORY_DEBUG

	.macro	pm_memory
	/* DDR_A */
	ldr	x0, =CXD900XX_DDRC(0)
	ldr	x1, =CXD900XX_DDRPHY(0)
	ldr	w2, cxd90057_ddr_ctrl
	bl	ddr_ctrl
	/* DDR_B */
	ldr	x0, =CXD900XX_DDRC(1)
	ldr	x1, =CXD900XX_DDRPHY(1)
	ldr	w2, cxd90057_ddr_ctrl
	bl	ddr_ctrl
	/* DDR_C */
	ldr	x0, =CXD900XX_DDRC(2)
	ldr	x1, =CXD900XX_DDRPHY(2)
	ldr	w2, cxd90057_ddr_ctrl
	bl	ddr_ctrl
	/* DDR_D */
	ldr	x0, =CXD900XX_DDRC(3)
	ldr	x1, =CXD900XX_DDRPHY(3)
	ldr	w2, cxd90057_ddr_ctrl
	bl	ddr_ctrl

	/* wait 4us */
	mov	x0, #4
	bl	__udelay
	/* reset DDR */
	ldr	x0, =CXD900XX_RESET(SRST_MEM)
	mov	w1, #SRST_DDR_ALL
	str	w1, [x0, #SRST_SET] /* assert RESET */
	/* wait 2us */
	mov	x0, #2
	bl	__udelay
	/* clock off */
	ldr	x0, =CXD900XX_CLKEN(CLKEN_RAM)
	mov	w1, #CLKEN_DDR_ALL
	str	w1, [x0, #CLK_CLR] /* stop CLK */
	/* wait 2us */
	mov	x0, #2
	bl	__udelay
	.endm

	.macro	pm_functions
ddr_ctrl:
	/* input: x0=DDRC address
	*	  x1=PHY address
	* 	  w2=command
	*  output: none.
	*  destruct: w2
	*/
	stp	x29, x30, [sp, #-16]!

	/* Self Refresh */
	ldr	w2, =LPCMD_SREF_CMD
	bl	issue_lp_cmd
#ifdef PM_MEMORY_DEBUG
	ldr	w2, cxd90057_sus_end_msg
	cmp	w2, #0
	beq	1f
	stp	x0, x1, [sp, #-16]!	// push x0,x1
	ldrb	w1, [x0, #LPSTATE_CS0]
	mov	w0, w1
	bl	__printhex2
	mov	w0, #'\n'
	bl	__printch
	ldr	x0, [sp]		// restore x0
	ldrb	w1, [x0, #LPSTATE_CS1]
	mov	w0, w1
	bl	__printhex2
	mov	w0, #'\n'
	bl	__printch
	ldp	x0, x1, [sp], #16	// pop x0,x1
1:
#endif /* PM_MEMORY_DEBUG */
	/* set r_sre_io_n to 0 */
	ldr	w2, [x1, #PHYREG50]
	and	w2, w2, #~R_SRE_IO_N
	str	w2, [x1, #PHYREG50]

	ldp	x29, x30, [sp], #16
	ret

issue_lp_cmd:
	/* Issue lp_cmd and wait for completion
	*  input: x0=DDRC address
	*	  x1=PHY address
	*	  w2=lp_cmd
	*  output: none
	*  destruct: w3
	*/
	/* disable lp_auto_entry */
	strb	wzr, [x0, #LP_AUTO_ENTRY_EN]
	/* wait for idle */
1:
	ldrb	w3, [x0, #LPSTATE_CS0]
	and	w3, w3, #LPSTATE_MASK
	cmp	w3, #LPSTATE_IDLE
	bne	1b
1:
	ldrb	w3, [x0, #LPSTATE_CS1]
	and	w3, w3, #LPSTATE_MASK
	cmp	w3, #LPSTATE_IDLE
	bne	1b

	/* clear int_status */
	mov	w3, #INTSTAT_LPCMD_DONE
	str	w3, [x0, #INTACK_REG]

	/* issue lp_cmd */
	ldr	w3, [x0, #LPCMD_REG]
	and	w3, w3, #~LPCMD_MASK
	orr	w3, w3, w2
	str	w3, [x0, #LPCMD_REG]

	/* wait for completion */
1:
	ldr	w3, [x0, #INTSTAT_REG]
	tst	w3, #INTSTAT_LPCMD_DONE
	beq	1b
	ret

	ldp	x29, x30, [sp], #16
	ret

	.endm
