/*
 * Copyright 2011 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if defined ( __USBG_SEN_FIFO__ )
#else
#define __USBG_SEN_FIFO__

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/moduleparam.h>
#include <linux/wait.h>
#include <linux/sched.h>

#include <asm/memory.h>
#include <linux/dma-mapping.h>
#include <linux/udif/mutex.h>

struct sen_xfer_fifo {
    UDIF_MUTEX  lock;
    unsigned char* top;
    unsigned char* bottom;
    unsigned char* rp;
    unsigned char* wp;
};

/* fifo は必ず設定されることを期待する。NULLチェックしない */
void sen_fifo_lock( struct sen_xfer_fifo* fifo);
void sen_fifo_unlock( struct sen_xfer_fifo* fifo);
int sen_fifo_setup( struct sen_xfer_fifo*, unsigned char* buf, unsigned int size );
int sen_fifo_data_size ( struct sen_xfer_fifo* );
int sen_fifo_free_size ( struct sen_xfer_fifo* );
int sen_fifo_buf_size  ( struct sen_xfer_fifo* );
void* sen_fifo_buf_top ( struct sen_xfer_fifo* );

/* FIFOに入っているサイズが要求より小さい場合、FIFOに入っているデータだけ返す。*/
int sen_fifo_read( struct sen_xfer_fifo*, void* buf, unsigned int size );
int sen_fifo_read_to_user( struct sen_xfer_fifo*, void* buf, unsigned int size );

/* FIFOの空き容量が要求より少ない場合、空き容量分だけ書き込ませる */
int sen_fifo_write( struct sen_xfer_fifo*, void* buf, unsigned int size );

/* DMAでFIFOをFillしたあとにwpを進めるため */
void sen_fifo_skip_wp( struct sen_xfer_fifo*, unsigned int );

void sen_fifo_reset( struct sen_xfer_fifo* );

void sen_fifo_show_status( struct sen_xfer_fifo* fifo );


#ifdef  SEN_FIFO_DEBUG_INF
#define SEN_FIFO_DEBUG(fmt, args...) { printk("usbg_sen_fifo(%d): [I]" fmt, __LINE__, ##args); }
#else
#define SEN_FIFO_DEBUG(fmt, args...) { }
#endif

#define SEN_FIFO_ERR(fmt, args...) { printk("usbg_sen_fifo(%d): [E]" fmt, __LINE__, ##args); }

#endif /* __USBG_SEN_FIFO__ */
