/*
 * usbg_storage_cmd_extern.h
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2008,2009 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Gadget Command Header (extern) >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __USBG_STORAGE_CMD_EXTERN_H__   /* ť󥯥롼ɥ顼ɻ */
#define __USBG_STORAGE_CMD_EXTERN_H__
/*

 󥯥롼ɥե                                                 
*/
#include "usbg_storage_drvcnt.h"
#include "usbg_storage_cmd.h"

/*

                                                              
*/
/*

                                                                
*/
/*

 ؿ                                                         
*/
/* ޥɽ ------------------------------------------------------------*/
extern GSTORAGE__Status storage_cmd_cmdPacket( GSTORAGE_DRV__CmdContext * );
/* ޥɽ( continue ) ------------------------------------------------*/
extern GSTORAGE__Status storage_cmd_cmdContinue( GSTORAGE_DRV__CmdContext * );
/* ޥɽ( MS ) ------------------------------------------------------*/
extern GSTORAGE__Status execPacketCmd_ms( GSTORAGE_DRV__CmdContext * );
/* ޥɽ( HDD ) -----------------------------------------------------*/
extern GSTORAGE__Status execPacketCmd_hdd( GSTORAGE_DRV__CmdContext * );
/* ޥɽ( DVD ) -----------------------------------------------------*/
extern GSTORAGE__Status execPacketCmd_dvd            ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status atapi_dvd_std                ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status atapi_dvd_cmn                ( GSTORAGE_DRV__CmdContext *,
                                                       unsigned char *, unsigned int );
extern GSTORAGE__Status atapi_dvd_read_write         ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status atapi_dvd_read_write_continue( GSTORAGE_DRV__CmdContext * );
extern void             atapi_dvd_set_write_protect  ( int, struct file *         );
extern void             atapi_dvd_synchronize_cache  ( struct file *              );
extern void             atapi_dvd_reset              ( struct file *              );
extern void             atapi_dvd_set_dma            ( struct file *              );
/* INQUIRY -----------------------------------------------------------------*/
extern GSTORAGE__Status inquiry_std( GSTORAGE_DRV__CmdContext * );
/* MODE SENSE --------------------------------------------------------------*/
extern GSTORAGE__Status modeSense6_ms ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status modeSense10_ms ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status modeSense6_ata( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status modeSense10_ata( GSTORAGE_DRV__CmdContext * );
/* PREVENT ALLOW -----------------------------------------------------------*/
extern GSTORAGE__Status preventAllow_std         ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status preventAllow_mediaLockOn ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status preventAllow_mediaLockOff( GSTORAGE_DRV__CmdContext * );
/* READ --------------------------------------------------------------------*/
extern GSTORAGE__Status read_std         ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status read_std_continue( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status readMedia        ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status preRead_std      ( void *                     );
/* READ CAPACITY -----------------------------------------------------------*/
extern GSTORAGE__Status readCapa_std( GSTORAGE_DRV__CmdContext * );
/* READ FORMAT CAPACITY ----------------------------------------------------*/
extern GSTORAGE__Status readFormatCapa_ms( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status readFormatCapa_std( GSTORAGE_DRV__CmdContext * );
/* REQUEST SENSE -----------------------------------------------------------*/
extern GSTORAGE__Status requestSense_std( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status requestSense_dvd( GSTORAGE_DRV__CmdContext * );


/* START STOP --------------------------------------------------------------*/
extern GSTORAGE__Status startStop_std( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status startStop_ms ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status startStop_ata( GSTORAGE_DRV__CmdContext * );
/* SYNCHRONIZE CACHE -------------------------------------------------------*/
extern GSTORAGE__Status synchronize_cache_std( GSTORAGE_DRV__CmdContext * );
/* TEST UNIT READY ---------------------------------------------------------*/
extern GSTORAGE__Status testUnit_std( GSTORAGE_DRV__CmdContext * );
/* VERIFY ------------------------------------------------------------------*/
extern GSTORAGE__Status verify_std( GSTORAGE_DRV__CmdContext * );
/* WRITE -------------------------------------------------------------------*/
extern GSTORAGE__Status write_std         ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status write_std_continue( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status writeMedia        ( GSTORAGE_DRV__CmdContext * );
/* EXTCMD -------------------------------------------------------------------*/
extern GSTORAGE__Status extCmd_std               ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status extCmd_ata               ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status extCmd_exec              ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status extCmd_write_std_continue( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status extCmd_writeMedia        ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status extCmd_read_std_continue ( GSTORAGE_DRV__CmdContext * );
extern GSTORAGE__Status extCmd_readMedia         ( GSTORAGE_DRV__CmdContext * );
extern int extcmd_cancel                         ( GSTORAGE_DRV__DeviceContext *);
/* ¾Υޥɽ	----------------------------------------------------*/
extern GSTORAGE__Status unknownCmd_std( GSTORAGE_DRV__CmdContext * );

/* ž ------------------------------------------------------*/
extern unsigned int getTransLength( unsigned int, unsigned int, unsigned int );
/* ǥ̥顼 --------------------------------------------------*/
extern void         setMediaCommonError( GSTORAGE_DRV__CmdContext *, unsigned int );
/* ǥ UNKNOWN  -------------------------------------------------*/
extern void         setDriveNotReady( GSTORAGE_DRV__CmdContext *, unsigned int);
/* Drive Reset  ------------------------------------------------------*/
extern void         setDriveReset( GSTORAGE_DRV__CmdContext *, unsigned int );
/* ǥ ------------------------------------------------------*/
extern void         setMediaChanged( GSTORAGE_DRV__CmdContext *, unsigned int );
/* ǥ Eject  ---------------------------------------------------*/
extern void         setMediaEjected( GSTORAGE_DRV__CmdContext *, unsigned int );
/* SENSE ǡ ----------------------------------------------------*/
extern void         setSense( GSTORAGE_DRV__SenseCode *, unsigned int );
extern void         setSenseDvd( unsigned char *, unsigned int );
/* SENSE ǡ ----------------------------------------------------*/
extern unsigned int getSense( GSTORAGE_DRV__SenseCode *  );
/* Read --------------------------------------------------------------------*/
extern unsigned int storage_read_cmn( GSTORAGE_DRV__UnitContext *,
                                      struct file *, unsigned char *,
                                      unsigned int, signed long long );
extern unsigned int storage_read( struct file *, unsigned char *,
                                  unsigned int, signed long long );
extern unsigned int storage_read_cdev( struct file *, unsigned char *,
                                  unsigned int, signed long long );
/* Write -------------------------------------------------------------------*/
extern unsigned int storage_write_cmn( GSTORAGE_DRV__UnitContext *,
                                       struct file *, unsigned char *,
                                       unsigned int, signed long long );
extern unsigned int storage_write( struct file *, unsigned char *,
                                   unsigned int, signed long long );
extern unsigned int storage_write_cdev( struct file *, unsigned char *,
                                   unsigned int, signed long long );
/* ޥɽ( standbyImmediate ) ----------------------------------------*/
extern void storage_ata_standbyImmediate( struct file * );
extern int  standbyImmediate_ata_cmn    ( GSTORAGE_DRV__UnitContext *, struct file * );
extern int  standbyImmediate_ata        ( struct file * );
extern void storage_ata_idleImmediate   ( struct file * );
extern int  idleImmediate_ata_cmn       ( GSTORAGE_DRV__UnitContext *, struct file * );
extern int  idleImmediate_ata           ( struct file * );
extern void storage_ata_flushCache      ( struct file * );
extern int  flushCache_ata_cmn          ( GSTORAGE_DRV__UnitContext *, struct file * );
extern int  flushCache_ata              ( struct file * );
/* ĥޥɥå ------------------------------------------------*/
GSTORAGE__Status checkExtCommand( GSTORAGE_DRV__CmdContext *pCmdCtx );
/* ǥХåѴؿ ----------------------------------------------------------*/
extern void printDevCtx( void );
extern void printCmdCtx( GSTORAGE_DRV__CmdContext *pCmdCtx );
extern void printMediaInfo( GSTORAGE_DRV__UnitContext *pUnitCtx );

#endif  /*__USBG_STORAGE_CMD_EXTERN_H__*/

