#ifndef _LINUX_TTY_FLIP_H
#define _LINUX_TTY_FLIP_H

#ifdef CONFIG_SNSC_VUART
#include <linux/snsc_vuart.h>
#endif

extern int tty_buffer_set_limit(struct tty_port *port, int limit);
extern int tty_buffer_space_avail(struct tty_port *port);
extern int tty_buffer_request_room(struct tty_port *port, size_t size);
extern int tty_insert_flip_string_flags(struct tty_port *port,
		const unsigned char *chars, const char *flags, size_t size);
extern int tty_insert_flip_string_fixed_flag(struct tty_port *port,
		const unsigned char *chars, char flag, size_t size);
extern int tty_prepare_flip_string(struct tty_port *port,
		unsigned char **chars, size_t size);
extern void tty_flip_buffer_push(struct tty_port *port);
void tty_schedule_flip(struct tty_port *port);
int __tty_insert_flip_char(struct tty_port *port, unsigned char ch, char flag);

static inline int tty_insert_flip_char(struct tty_port *port,
					unsigned char ch, char flag)
{
	struct tty_buffer *tb = port->buf.tail;
	int change;
#ifdef CONFIG_SNSC_VUART
	struct tty_struct *tty = port->itty;
	static int header_avail, vuart_data_size;
	static char vuart_header[SNSC_VUART_HEADER_SIZE];

	if (!tty->buddy || !tty->buddy->count)
		goto normal_data;

	if (vuart_data_size) {
		/* Process VUART data */
		tty = tty->buddy;
		tb = tty->port->buf.tail;
		vuart_data_size--;
		goto normal_data;
	} else {
		/* Parse VUART header */
		if (ch == SNSC_VUART_HEADER_FLAG || header_avail > 1)
			vuart_header[header_avail++] = ch;
		else
			goto roll_back;

		/* vuart_header[4]: [0]=[1]=0xff, size=[2]<<8|[3] */
		if (header_avail == SNSC_VUART_HEADER_SIZE) {
			vuart_data_size = (vuart_header[2] << 8);
			vuart_data_size |= (vuart_header[3] & 0xff);
			header_avail = 0;
			if (!vuart_data_size)
				goto roll_back;
		}
		return 1;
	}

roll_back:
	if (header_avail) {
		unsigned int idx;
		unsigned char ch;
		for (idx = 0; idx < header_avail; idx++) {
			ch = vuart_header[idx];

			if (tb && tb->used < tb->size) {
				*flag_buf_ptr(tb, tb->used) = flag;
				*char_buf_ptr(tb, tb->used++) = ch;
			} else {
				tty_insert_flip_string_flags(tty->port,
					&ch, &flag, 1);
			}
		}
		header_avail = 0;
	}

normal_data:
#endif /* CONFIG_SNSC_VUART */
	change = (tb->flags & TTYB_NORMAL) && (flag != TTY_NORMAL);
	if (!change && tb->used < tb->size) {
		if (~tb->flags & TTYB_NORMAL)
			*flag_buf_ptr(tb, tb->used) = flag;
		*char_buf_ptr(tb, tb->used++) = ch;
		return 1;
	}

#ifdef CONFIG_SNSC_VUART
	return tty_insert_flip_string_flags(tty->port, &ch, &flag, 1);
#else
	return __tty_insert_flip_char(port, ch, flag);
#endif /* CONFIG_SNSC_VUART */
}

static inline int tty_insert_flip_string(struct tty_port *port,
		const unsigned char *chars, size_t size)
{
	return tty_insert_flip_string_fixed_flag(port, chars, TTY_NORMAL, size);
}

extern void tty_buffer_lock_exclusive(struct tty_port *port);
extern void tty_buffer_unlock_exclusive(struct tty_port *port);

#endif /* _LINUX_TTY_FLIP_H */
