/*
 * include/linux/usb/f_usb/usb_otg_extcon.h
 *
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined(__USB_OTG_EXTCON_H__)
#define __USB_OTG_EXTCON_H__

#include <linux/platform_device.h>

#ifdef CONFIG_USB_FUSB_OTG_EXTCON
#define FUSB_DRD_HOST       true
#define FUSB_DRD_GADGET     false

int fusb_otg_set_drd_state(bool host_state);
int fusb_otg_get_drd_state(bool *state);
void fusb_otg_flip_drd_state(void);
int fusb_otg_set_tpc_setting(bool orientation, bool ss_operation);
int fusb_otg_set_orientation(bool orientation);
int fusb_otg_set_ss_operation(bool ss_operation);
int fusb_otg_get_orientation(bool *state);
int fusb_otg_get_ss_operation(bool *state);
void fusb_otg_flip_orientation(void);
void fusb_otg_flip_ss_operation(void);
int fusb_otg_is_orientation_enabled(void);
int fusb_otg_is_ss_operation_enabled(void);
int fusb_otg_extcon_setup(struct platform_device *pdev);
int fusb_otg_extcon_teardown(struct platform_device *pdev);

/* currently nothing to do
#ifdef CONFIG_PM_SLEEP
int fusb_otg_extcon_suspend(struct device *dev);
int fusb_otg_extcon_resume(struct device *dev);
#endif*/
#else
static inline int fusb_otg_set_drd_state(bool host_state) { return 0; }
static inline int fusb_otg_get_drd_state(bool *state) { *state = false; return 0; }
static inline void fusb_otg_flip_drd_state(void) { ; }
static inline int fusb_otg_set_tpc_setting(bool orientation, bool ss_operation) { return 0; }
static inline int fusb_otg_set_orientation(bool orientation) { return 0; }
static inline int fusb_otg_set_ss_operation(bool ss_operation) { return 0; }
static inline int fusb_otg_get_orientation(bool *state) { *state = false; return 0; }
static inline int fusb_otg_get_ss_operation(bool *state) { *state = false; return 0; }
static inline void fusb_otg_flip_orientation(void) { ; }
static inline void fusb_otg_flip_ss_operation(void) { ; }
static inline int fusb_otg_is_orientation_enabled(void) { return 0; }
static inline int fusb_otg_is_ss_operation_enabled(void) { return 0; }
static inline int fusb_otg_extcon_setup(struct platform_device *pdev) { return 0; }
static inline int fusb_otg_extcon_teardown(struct platform_device *pdev) { return 0; }

/* currently nothing to do
#ifdef CONFIG_PM_SLEEP
int fusb_otg_extcon_suspend(struct device *dev) { return 0; }
int fusb_otg_extcon_resume(struct device *dev) { return 0; }
#endif*/
#endif  /* CONFIG_USB_FUSB_OTG_EXTCON */

#endif  /* __USB_OTG_EXTCON_H__ */
