/*
 * mach-cxd900xx/boot.S
 *
 *
 * Copyright 2018,2019 Sony Corporation
 *
 * This code is based on arch/arm64/kernel/head.S.
 */
/*
 * Low-level CPU initialisation
 * Based on arch/arm/kernel/head.S
 *
 * Copyright (C) 1994-2002 Russell King
 * Copyright (C) 2003-2012 ARM Ltd.
 * Authors:	Catalin Marinas <catalin.marinas@arm.com>
 *		Will Deacon <will.deacon@arm.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/linkage.h>
#include <linux/init.h>
#include <asm/assembler.h>
#include <asm/cputype.h>
#if !defined(CONFIG_EJ_SIMPLE_LOADER)
# include <mach/bootram.h>
#endif /* !CONFIG_EJ_SIMPLE_LOADER */

	.pushsection ".idmap.text", "ax"
ENTRY(cxd900xx_init)
	mrs	x10, CurrentEL
	cmp	x10, CurrentEL_EL3
	b.ne	1f
	/* turn MMU off and disable D-Cache */
	mrs	x10, sctlr_el1
	bic	x10, x10, #SCTLR_ELx_M
	bic	x10, x10, #SCTLR_ELx_C
	msr	sctlr_el1, x10
	mrs	x10, sctlr_el3
	bic	x10, x10, #SCTLR_ELx_M
	bic	x10, x10, #SCTLR_ELx_C
	msr	sctlr_el3, x10
	isb
	tlbi	alle3
	dsb	nsh
1:
#ifdef CONFIG_ARCH_CXD900XX_FPGA
	/* memzero 0xe000..0xffff for dummy SCU */
	mov	x5, #0x0000e000
	mov	x6, #0x00010000
1:
	str	xzr, [x5],#8
	cmp	x5, x6
	bne	1b
#endif /* CONFIG_ARCH_CXD900XX_FPGA */
	ret
ENDPROC(cxd900xx_init)

#if !defined(CONFIG_EJ_SIMPLE_LOADER)
	.align	3
	.type	__secondary_vector, %object
__secondary_vector:
	.quad	.
	.quad	ej_secondary_entry
#endif /* !CONFIG_EJ_SIMPLE_LOADER */

ENTRY(cxd900xx_smp_init)
#if !defined(CONFIG_EJ_SIMPLE_LOADER)
	/* boot secondary CPUs */
	adr	x0, __secondary_vector
	ldp	x5, x6, [x0]
	sub	x0, x0, x5
	add	x6, x6, x0
	ldr	x5, =CXD900XX_BOOTRAM_WORK
	str	w6, [x5, #CXD900XX_BOOTRAM_VEC+0x04] /* CPU#1 */
	str	w6, [x5, #CXD900XX_BOOTRAM_VEC+0x08] /* CPU#2 */
	str	w6, [x5, #CXD900XX_BOOTRAM_VEC+0x0c] /* CPU#3 */
	strb	wzr, [x5, #CXD900XX_BOOTRAM_FLAG+1]  /* CPU#1 */
	strb	wzr, [x5, #CXD900XX_BOOTRAM_FLAG+2]  /* CPU#2 */
	strb	wzr, [x5, #CXD900XX_BOOTRAM_FLAG+3]  /* CPU#3 */
	dsb	sy
	sev
#endif /* !CONFIG_EJ_SIMPLE_LOADER */
	ret
ENDPROC(cxd900xx_smp_init)

ENTRY(cxd900xx_secondary_init)
#if !defined(CONFIG_EJ_SIMPLE_LOADER)
	/* clear boot flag */
	ldr	x5, =CXD900XX_BOOTRAM_WORK+CXD900XX_BOOTRAM_FLAG
	mrs	x0, mpidr_el1
	ands	x0, x0, #MPIDR_LEVEL_MASK	// CPU#
	mov	w1, #0xff
	strb	w1, [x5, x0]

# if !defined(CONFIG_ARCH_CXD900XX_FPGA)
	/* address conversion */
	orr	lr, lr, #0x400000000 // bit[35..32]
# endif /* !CONFIG_ARCH_CXD900XX_FPGA */
#endif /* !CONFIG_EJ_SIMPLE_LOADER */
	ret
ENDPROC(cxd900xx_secondary_init)
	.ltorg
	.popsection
