/*
 * Copyright 2005,2006,2011 Sony Corporation
 * Copyright 2018, 2019 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <asm/uaccess.h>
#include <asm/errno.h>

#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 21)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif

#include <linux/device.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 29)
#include <linux/usb/gadget.h>
#else
#include <linux/usb_gadget.h>
#endif

#include <linux/byteorder/generic.h>

#ifdef CONFIG_OSAL_UDIF
#include <linux/fs.h>
#else
#include <asm/arch/sonymisc.h>
#endif

#include <linux/usb/gcore/usb_event.h>
#include <linux/usb/gcore/usb_gadgetcore.h>

#include <linux/usb/specific_gadget/usbg_cmn.h>

/*  */
/* ⥸塼							*/
/*  */
#ifdef CONFIG_OSAL_UDIF
int usbg_cmn_reg( struct usbg_cdev* p_this_dev )
{
    UDIF_ERR err;
    int res = 0;
    UDIF_DEVNODE *node = p_this_dev->node;
    
    udif_cdev_init(&p_this_dev->cdev, node, p_this_dev->fops, NULL);
    err = udif_cdev_register(&p_this_dev->cdev);
    res = (int)err;
    if(UDIF_ERR_OK != err){
        return res;
    }
    
    return res;
}
#else
int usbg_cmn_reg( struct sonymisc_device* p_this_dev )
{
    return sonymisc_register( p_this_dev );
}
#endif
EXPORT_SYMBOL(usbg_cmn_reg);

/*  */
/* ⥸塼륢							*/
/*  */
#ifdef CONFIG_OSAL_UDIF
void usbg_cmn_dereg( struct usbg_cdev* p_this_dev )
{
    udif_cdev_unregister(&p_this_dev->cdev);
}
#else
void usbg_cmn_dereg( struct sonymisc_device* p_this_dev )
{
    sonymisc_deregister( p_this_dev );
}
#endif
EXPORT_SYMBOL(usbg_cmn_dereg);

/*  */
/* 󥹥							*/
/*  */
int usbg_cmn_new(struct inode *inode, struct file *fd)
{
    int err = 0;
    struct func_data* p_this;
    
    /* 󥹥󥹤	*/
    p_this = kmalloc( sizeof(struct func_data), GFP_ATOMIC );
    if ( p_this == NULL ) {
        err = -ENOBUFS;
        goto SUB_RET;
    }
    memset(p_this, 0x00, sizeof(struct func_data));
    fd->private_data = p_this;
    
SUB_RET:
    return err;
}
EXPORT_SYMBOL(usbg_cmn_new);

/*  */
/* 󥹥󥹺							*/
/*  */
void usbg_cmn_delete( struct func_data* p_this )
{
    /* 󥹥󥹤	*/
    if( p_this ){
        kfree( p_this );
        p_this=NULL;
    }
}
EXPORT_SYMBOL(usbg_cmn_delete);
/*  */
/* probe infoԡ							*/
/*  */
int usbg_cmn_copy_probe_info( struct func_data* p_this,
                                     struct probe_info *p_info )
{
    int err = -ENOSYS;
    
    /* Svcΰ򥤥󥹥󥹤γƥФ˥ԡ			*/
    if( copy_from_user( &(p_this->info), p_info, sizeof(struct probe_info) ) ){
        err = -ENOBUFS;
        goto SUB_RET;
    }
    
    /* 󥿡եơ֥					*/
    p_this->info.tbl_interface
        = (struct func_info_interface*)
            kmalloc( sizeof(struct func_info_interface)
                      * p_this->info.uc_func_info_interface_num,
                      GFP_ATOMIC );
    if( p_this->info.tbl_interface == NULL ){
        err = -ENOBUFS;
        goto SUB_RET;
    }
    
    if( copy_from_user( p_this->info.tbl_interface,
                        p_info->tbl_interface ,
                        sizeof(struct func_info_interface)
                        * p_this->info.uc_func_info_interface_num ) ){
        usbg_cmn_clear_probe_info( p_this );
        err = -ENOBUFS;
        goto SUB_RET;
    }
    
    /* ̥ǡΥԡ						*/
    if( p_info->vp_user != NULL ){
        p_this->info.vp_user = kmalloc( p_this->info.ul_user_size,
                                        GFP_ATOMIC );
        if( p_this->info.vp_user == NULL ){
            usbg_cmn_clear_probe_info( p_this );
            err = -ENOBUFS;
            goto SUB_RET;
        }
        if( copy_from_user( p_this->info.vp_user,
                            p_info->vp_user,
                            p_info->ul_user_size ) ){
            kfree(p_this->info.tbl_interface);
            p_this->info.tbl_interface=NULL;
            err = -ENOBUFS;
            goto SUB_RET;
        }
    } else {
        p_this->info.vp_user = NULL;
        p_this->info.ul_user_size = 0;
    }
    
    err = 0;
SUB_RET:
    return err;
}
EXPORT_SYMBOL(usbg_cmn_copy_probe_info);

/*  */
/* IOCTL : remove							*/
/*  */
void usbg_cmn_clear_probe_info( struct func_data* p_this )
{
    /* ioctl_probe()kmallocΤkfree	*/
    if( p_this->info.vp_user ){
        kfree( p_this->info.vp_user );
        p_this->info.vp_user=NULL;
    }
    if( p_this->info.tbl_interface ){
        kfree( p_this->info.tbl_interface );
        p_this->info.tbl_interface=NULL;
    }
}
EXPORT_SYMBOL(usbg_cmn_clear_probe_info);

/*  */
/* Endpoint list							*/
/*  */
int usbg_cmn_make_ep_list( struct func_data* p_this,
                                  unsigned char alt,
                                  struct usb_gadget_ep_list list )
{
    int err = 0;
    int i;

    /* altֹ桤EP¸	*/
    p_this->c_alternate = alt;
    p_this->uc_ep_num = list.num_ep;
    
    /* EP listѤΰ						*/
    p_this->ptbl_ep = kmalloc(
        sizeof(struct usb_ep*)*list.num_ep, GFP_ATOMIC );
    if(p_this->ptbl_ep == NULL){
        err = -ENOBUFS;
        goto SUB_RET;
    }
    
    i = 0;
    while( i<list.num_ep ){
        /* EndpointΥԡ						*/
        p_this->ptbl_ep[i] = list.ep[i];
        i++;
    }
    
SUB_RET :
    return err;
    /* </framework>	*/
}
EXPORT_SYMBOL(usbg_cmn_make_ep_list);

/*  */
/* Endpoint list							*/
/*  */
void usbg_cmn_clear_ep_list( struct func_data* p_this )
{
    if(p_this->ptbl_ep){
        kfree(p_this->ptbl_ep);
        p_this->ptbl_ep=NULL;
    }
}
EXPORT_SYMBOL(usbg_cmn_clear_ep_list);
