/*
 * usbg_bdio.h
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << Block-direct I/O (header) >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __BDIO_H_INCLUDED__
#define __BDIO_H_INCLUDED__

#define BDIO_BLOCK_SIZE		512
#define BDIO_MAX_SIZE		(512*1024)

// Block-direct I/O functions
int  bdio_init(void);
void bdio_fin(void);
int  bdio_read(struct file *fp, u8 *buf, int size, loff_t off);
int  bdio_write(struct file *fp, u8 *buf, int size, loff_t off);
int  bdio_ioctl(struct file *fp, unsigned cmd, unsigned long arg);


#endif // __BDIO_H_INCLUDED__
