/*
 * drivers/usb/f_usb/udif_usb_otg_gpioint.c
 *
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/udif/types.h>
#include <linux/udif/io.h>
#include <mach/platform.h>

#include "udif_usb_otg_gpioint.h"

static volatile void __iomem *gint_base = NULL;

#define GPIOINT_CH   (19)

// GPIO INTR REGISTER
#define GPIO_INTINV             0x00U
#define GPIO_INTINV_SET         0x04U
#define GPIO_INTINV_CLR         0x08U
/* NotUsed                      0x0CU */
#define GPIO_INTS               0x10U
#define GPIO_INTS_SET           0x14U
#define GPIO_INTS_CLR           0x18U
/* NotUsed                      0x1CU */
#define GPIO_INTTHE             0x20U
#define GPIO_INTTHE_SET         0x24U
#define GPIO_INTTHE_CLR         0x28U
/* NotUsed                      0x2CU */
#define GPIO_INTTLE             0x30U
#define GPIO_INTTLE_SET         0x34U
#define GPIO_INTTLE_CLR         0x38U
/* NotUsed                      0x3CU */

#define GPIO_REG_INTINV          (gint_base + GPIO_INTINV)
#define GPIO_REG_INTINV_SET      (gint_base + GPIO_INTINV_SET)
#define GPIO_REG_INTINV_CLR      (gint_base + GPIO_INTINV_CLR)
#define GPIO_REG_INTS            (gint_base + GPIO_INTS)
#define GPIO_REG_INTS_SET        (gint_base + GPIO_INTS_SET)
#define GPIO_REG_INTS_CLR        (gint_base + GPIO_INTS_CLR)
#define GPIO_REG_INTTHE          (gint_base + GPIO_INTTHE)
#define GPIO_REG_INTTHE_SET      (gint_base + GPIO_INTTHE_SET)
#define GPIO_REG_INTTHE_CLR      (gint_base + GPIO_INTTHE_CLR)
#define GPIO_REG_INTTLE          (gint_base + GPIO_INTTLE)
#define GPIO_REG_INTTLE_SET      (gint_base + GPIO_INTTLE_SET)
#define GPIO_REG_INTTLE_CLR      (gint_base + GPIO_INTTLE_CLR)

#define GPIO_REG_INTINV_THROUGH   0U
#define GPIO_REG_INTINV_INVERT    1U
#define GPIO_REG_INTS_EDGE        0U
#define GPIO_REG_INTS_LEVEL       1U
#define GPIO_REG_INTTHE_DIS       0U
#define GPIO_REG_INTTHE_ENB       1U
#define GPIO_REG_INTTLE_DIS       0U
#define GPIO_REG_INTTLE_ENB       1U


void fusb_set_gpio_base(void)
{
	gint_base = VA_GPIO(GPIOINT_CH);
	printk(KERN_INFO "%s gpioint=%p\n", __FUNCTION__, gint_base);
}

int fusb_setup_gpioint(unsigned int bit)
{
	UDIF_U32 bitmask = 1 << bit;

	if (!gint_base) return -EAGAIN;

	/*TODO: choose proper polarity. currently it is positive.
	udif_iowrite32( bitmask, GPIO_REG_INTINV_SET );*/
	udif_iowrite32( bitmask, GPIO_REG_INTINV_CLR );

	// both edge
	udif_iowrite32( bitmask, GPIO_REG_INTS_CLR );
	udif_iowrite32( bitmask, GPIO_REG_INTTHE_SET );
	udif_iowrite32( bitmask, GPIO_REG_INTTLE_SET );
	return 0;
}
