/**
 *	@file	usbg_still_conf.h
 *	@brief	USB SICD(Still Image Capture Device class) - conf
 *	
 *		Copyright 2005,2006,2008 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
#ifndef __USBG_STILL_CONF_H__
#define __USBG_STILL_CONF_H__


#include <linux/usb/specific_gadget/usb_node_info.h>

/*
 *	@brief	Still Image Class function's information
 */
#define MY_VER		"02.00.000"
#define MY_NAME		"usbg_stillimage"
#define MY_DESC		"USB Still Image Class function driver"
#define MY_MINOR	USB_MINOR_STILL_CORE
#define MY_NODE		USB_NODE_STILL_CORE

#define SICD_TX_DMA					///< enable TX DMA
#define SICD_RX_DMA					///< enable TX DMA

#define SICD_SEMAPHORE
//#define SICD_SPINLOCK
//#define SICD_CLEAR_HALT_AT_DEVICE_RESET

#define SICD_DEBUG_ERR					///< enable ERR printk
//#define SICD_DEBUG_INF				///< enable INF printk
//#define SICD_DEBUG_FNC				///< enable FNC printk
//#define SICD_DEBUG_API				///< enable API printk
//#define SICD_DEBUG_DMP				///< enable DMP printk
//#define SICD_DEBUG_DMP_HEADER_ONLY	///< dump only SICD header

#endif // __USBG_STILL_CONF_H__
