/*
 * em_export.h - Exception Monitor exported functions
 *
 * Copyright 2010  Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */

#ifndef __EM_EXPORT_H__
#define __EM_EXPORT_H__

struct pt_regs;
typedef void (*em_callback_t)(struct pt_regs *regs, void *arg);

extern void *em_register_usermode_callback(em_callback_t fun, void *arg);
extern void em_unregister_usermode_callback(void *handle);

extern void *em_register_atomic_callback(em_callback_t fun, void *arg);
extern void em_unregister_atomic_callback(void *handle);

extern void em_dump_write(const char *format, ...);
extern void em_reboot(int force);
extern void (*em_hook)(struct pt_regs *regs, unsigned int errcode);
extern int  (*em_console_enable)(char *options);
extern int  (*em_console_enable_triggered)(void);
extern void em_cond_reboot(void);
extern int em_reboot_flag;
extern int em_use_console;

#endif
