/*
 * Copyright 2005,2006 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __UAPI_USBG_SEN_H__
#define __UAPI_USBG_SEN_H__

/*#include <linux/types.h>*/
#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 21)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif

#ifdef __KERNEL__
#endif

/* cmd */
typedef enum {
	USBG_SEN_CMD_0	= 0,
	USBG_SEN_CMD_1,
	USBG_SEN_CMD_NR,
	USBG_SEN_CMD_NONE = -1,
} usbg_sen_cmd_id;

/* transfer mode bit	*/
#define USBG_SEN_XFERMODE_DMA	0x00000001
#define USBG_SEN_XFERMODE_PHYS	0x00000002

struct usbg_sen_cmd {
	struct usb_ctrlrequest setup;
	/*	void* vp;	*/
};

struct usbg_sen_probe_info {
	struct usbg_sen_cmd cmd[USBG_SEN_CMD_NR];
};

struct usbg_se_data {
	/* for user	*/
	unsigned char* cp;
	int32_t count;
	uint32_t mode;
};

struct usbg_te_conf {
	int32_t buf_sz;
};

enum USBG_KEVENT_ID_STD {
	USBG_KEVENT_ID_SE_SEND	= 0,
	USBG_KEVENT_ID_SE_RECEIVE,
	USBG_KEVENT_ID_SE_NBROF,
};

struct usbg_kevent_arg_se_send {
	unsigned char* cp;
	int32_t count;
};

struct usbg_kevent_arg_se_receive {
	unsigned char* cp;
	int32_t count;
};

#define USBG_IOC_SE_SEND	_IOW( USB_IOC_SE, 0, struct usbg_se_data )
#define USBG_IOC_SE_RECEIVE	_IOR( USB_IOC_SE, 1, struct usbg_se_data )
#define USBG_IOC_SE_SETBUF	_IOW( USB_IOC_SE, 2, struct usbg_se_data )
#define USBG_IOC_SE_NBROF	3

#ifndef MY_NAME
#define MY_NAME "usbg_sen"
#endif

#endif
