/*
 * Copyright (c) 2015 Elliptic Technologies Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <elpspacc.h>
static int show_ch_status_while_int;

static inline uint32_t _spacc_get_stat_cnt (spacc_device * spacc)
{
	uint32_t fifo;

	fifo = SPACC_FIFO_STAT_STAT_CNT_GET (pdu_io_read32 (spacc->regmap + SPACC_REG_FIFO_STAT));
	return fifo;
}

int spacc_pop_packets_ex (spacc_device * spacc, int *num_popped, unsigned long *lock_flag)
{
	int ret = CRYPTO_INPROGRESS;
	// spacc_ctx *ctx = NULL;
	spacc_job *job = NULL;
	uint32_t cmdstat, swid, ch=0xdeadbeef;
	int jobs;
	int got_swid  = 0;

	*num_popped = 0;

	while ((jobs = _spacc_get_stat_cnt(spacc))) {
		if(show_ch_status_while_int)
			pr_info ("%s: has jobs(%d)\n", __func__,jobs);
		while (jobs-- > 0) {
			/* write the pop register to get the next job */
			pdu_io_write32 (spacc->regmap + SPACC_REG_STAT_POP, 1);
			cmdstat = pdu_io_read32 (spacc->regmap + SPACC_REG_STATUS);

			swid = SPACC_STATUS_SW_ID_GET(cmdstat);
			if(spacc->ch_mode && !got_swid)
				ch = swid;

			if((!got_swid && spacc->ch_mode) || !spacc->ch_mode)
			{

				if (spacc->job_lookup[swid] == SPACC_JOB_IDX_UNUSED) {
					ELPHW_PRINT ("Invalid sw id (%d) popped off the stack", swid);
					ret = CRYPTO_FAILED;
					goto ERR;
				}

				/* find the associated job with popped swid */
				job = job_lookup_by_swid (spacc, swid);
				if (NULL == job) {
					ret = CRYPTO_FAILED;
					ELPHW_PRINT ("Failed to find job for ID %d\n", swid);
					goto ERR;
				}
				else {
					if(show_ch_status_while_int)
						if(spacc->ch_mode)
							pr_info ("%s: channel (id:%d) is in processing\n", __func__,spacc->job_lookup[swid]);
				}

				/* mark job as done */
				job->job_done = 1;
				if(!spacc->ch_mode)
					spacc->job_lookup[swid] = SPACC_JOB_IDX_UNUSED;
				else
					got_swid =1;
			}

			switch (SPACC_GET_STATUS_RET_CODE (cmdstat)) {
			case SPACC_ICVFAIL:
				ret = CRYPTO_AUTHENTICATION_FAILED;
				break;
			case SPACC_MEMERR:
				ret = CRYPTO_MEMORY_ERROR;
				break;
			case SPACC_BLOCKERR:
				ret = CRYPTO_INVALID_BLOCK_ALIGNMENT;
				break;
			case SPACC_SECERR:
				ret = CRYPTO_FAILED;
				break;

			case SPACC_OK:
				ret = CRYPTO_OK;
				break;
			}
			if(show_ch_status_while_int)
				if(spacc->ch_mode)
					pr_info ("%s: ch ID(%d), swid(%d): ret = %d\n", __func__,ch,swid,ret);


			job->job_err |= ret;



		}

	}
	/*
	 * We're done touching the SPAcc hw, so release the lock across the
	 * job callback.  It must be reacquired before continuing to the next
	 * iteration.
	 */

	if(job)
		if (job->cb) {
			PDU_UNLOCK(&spacc->lock, *lock_flag);
			job->cb(spacc, job->cbdata);
			PDU_LOCK(&spacc->lock, *lock_flag);
		}

	(*num_popped)++;
	//if (!*num_popped) { ELPHW_PRINT("ERROR: Failed to pop a single job\n"); }
ERR:
	spacc_process_jb(spacc);

	if (spacc->op_mode == SPACC_OP_MODE_WD) {
		spacc_set_wd_count(spacc, spacc->config.wd_timer); // reset the WD timer to the original value
	}

	if (*num_popped && spacc->spacc_notify_jobs != NULL) {
		spacc->spacc_notify_jobs(spacc);
	}

	return ret;
}

int spacc_pop_packets (spacc_device * spacc, int *num_popped)
{
	unsigned long lock_flag;
	int err;
	PDU_LOCK(&spacc->lock, lock_flag);
	err = spacc_pop_packets_ex(spacc, num_popped, &lock_flag);
	PDU_UNLOCK(&spacc->lock, lock_flag);
	return err;
}


/* test if done */
int spacc_packet_dequeue (spacc_device * spacc, int job_idx)
{
	int ret = CRYPTO_OK;
	spacc_job *job = &spacc->job[job_idx];
	unsigned long lock_flag;

	PDU_LOCK(&spacc->lock, lock_flag);

	if (job == NULL || (job == NULL && !(job_idx == SPACC_JOB_IDX_UNUSED))) {
		ret = CRYPTO_FAILED;
	} else {
		if (job->job_done) {
			job->job_done  = 0;
			ret = job->job_err;
		} else {
			ret = CRYPTO_INPROGRESS;
		}
	}

	PDU_UNLOCK(&spacc->lock, lock_flag);
	return ret;
}

module_param(show_ch_status_while_int, int, 0600);
MODULE_PARM_DESC(show_ch_status_while_int, "debug channel status when irq is arrived");
