// ------------------------------------------------------------------------
//
//                (C) COPYRIGHT 2011 - 2015 SYNOPSYS, INC.
//                          ALL RIGHTS RESERVED
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  version 2 as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, see <https://gnu.org/licenses/>.
//
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <elpspaccusr.h>

int spacc_dev_open(struct elp_spacc_usr *io,
                   int cipher_mode, int hash_mode, int encrypt, int icvmode, int icv_len, int aad_copy,
                   unsigned char *ckey, int ckeylen, unsigned char *civ, int civlen,
                   unsigned char *hkey, int hkeylen, unsigned char *hiv, int hivlen)
{

   io->io.cipher_mode = cipher_mode;
   io->io.hash_mode   = hash_mode;
   io->io.aad_copy    = aad_copy;
   io->io.icv_mode    = icvmode;
   io->io.icv_len     = icv_len;
   io->io.encrypt     = encrypt;

   io->io.ckeylen     = ckeylen;
   io->io.civlen      = civlen;
   io->io.hkeylen     = hkeylen;
   io->io.hivlen      = hivlen;

   if (ckeylen > sizeof(io->io.ckey) ||
       civlen  > sizeof(io->io.civ)  ||
       hkeylen > sizeof(io->io.hkey) ||
       hivlen  > sizeof(io->io.hiv)) {
      printf("Error in keylen check, ckeylen=%d civlen=%d hkeylen=%d hivlen=%d\n",
             ckeylen,
             civlen,
             hkeylen,
             hivlen);
      return -1;
   }

   if (!io->io.icv_len) {
      switch (cipher_mode) {
         case CRYPTO_MODE_AES_CCM:
         case CRYPTO_MODE_AES_GCM: io->io.icv_len = 16; break;
	 default:
					       break;
      }
      if (!io->io.icv_len) {
         switch (hash_mode) {
            case CRYPTO_MODE_SSLMAC_SHA1:
            case CRYPTO_MODE_HASH_SHA1:
            case CRYPTO_MODE_HMAC_SHA1:        io->io.icv_len =  20; break;
            case CRYPTO_MODE_SSLMAC_MD5:
            case CRYPTO_MODE_HASH_MD5:
            case CRYPTO_MODE_HMAC_MD5:         io->io.icv_len =  16; break;
            case CRYPTO_MODE_HASH_SHA224:
            case CRYPTO_MODE_HMAC_SHA224:      io->io.icv_len =  28; break;
            case CRYPTO_MODE_HASH_SHA256:
            case CRYPTO_MODE_HMAC_SHA256:      io->io.icv_len =  32; break;
            case CRYPTO_MODE_HASH_SHA384:
            case CRYPTO_MODE_HMAC_SHA384:      io->io.icv_len =  48; break;
            case CRYPTO_MODE_HASH_SHA512:
            case CRYPTO_MODE_HMAC_SHA512:      io->io.icv_len =  64; break;
            case CRYPTO_MODE_HASH_SHA512_224:
            case CRYPTO_MODE_HMAC_SHA512_224:  io->io.icv_len =  28; break;
            case CRYPTO_MODE_HASH_SHA512_256:
            case CRYPTO_MODE_HMAC_SHA512_256:  io->io.icv_len =  32; break;
            case CRYPTO_MODE_MAC_XCBC:
            case CRYPTO_MODE_MAC_CMAC:
            case CRYPTO_MODE_MAC_KASUMI_F9:    io->io.icv_len =  16; break;
            case CRYPTO_MODE_HASH_CRC32:
            case CRYPTO_MODE_MAC_SNOW3G_UIA2:
            case CRYPTO_MODE_MAC_ZUC_UIA3:     io->io.icv_len =  4; break;
            case CRYPTO_MODE_NULL:             io->io.icv_len =  0; break;
	    default:
					       break;
         }
      }
   }

   // AES-F8 mode has a SALTKEY prepended to the base key so we double
   // the key size internally, note we pass the original ckeylen to the ioctl
   if (cipher_mode == CRYPTO_MODE_AES_F8) {
      ckeylen <<= 1;
   }

   memcpy(io->io.ckey, ckey, ckeylen);
   memcpy(io->io.civ,  civ,  civlen);
   memcpy(io->io.hkey, hkey, hkeylen);
   memcpy(io->io.hiv,  hiv,  hivlen);

   io->fd = open("/dev/spaccusr", O_RDWR);
   if (io->fd < 0) {
      printf("Error opening /dev/spaccusr, errno %d\n", errno);
      return -1;
   }

   if (ioctl(io->fd, ELP_SPACC_USR_INIT, &io->io) < 0) {
      printf("ioctl error, errno %d\n", errno);
      close(io->fd);
      return -1;
   }

   return 0;
}


int spacc_dev_process_packets(struct elp_spacc_usr *io)
{
   int err;

   err = ioctl(io->fd, ELP_SPACC_USR_PROCESS, &io->io);

   if (err >= 0) {
      return err;
   } else {
      return -1;
   }
}

int spacc_dev_process_cancel(struct elp_spacc_usr *io)
{
   int err;

   err = ioctl(io->fd, ELP_SPACC_USR_CANCEL, &io->io);

   if (err >= 0) {
      return err;
   } else {
      return -1;
   }
}

int spacc_dev_close(struct elp_spacc_usr *io)
{
   close(io->fd);
   memset(io, 0, sizeof *io);
   return 0;
}

