/*
 * mach-cxd900xx/include/mach/pm.h
 *
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __MACH_CXD900XX_PM_H
#define __MACH_CXD900XX_PM_H

#include <mach/pm_export.h>

/* mode of cxd90057_suspend_finisher() */
#define PM_ENTER_NORMAL   0
#define PM_ENTER_ERROR    1

#ifndef __ASSEMBLY__
extern void cxd90057_set_pasr(void);
extern void cxd90057_suspend(void), cxd90057_suspend2(void);
extern void cxd90057_resume(void);
extern void cxd90057_early_resume(void);
#ifdef CONFIG_SNSC_SSBOOT
extern void cxd90057_resume_profile(void);
extern void cxd90057_resume_optimize(void);
extern void cxd90057_resume_ssboot_pre(void);
extern void cxd90057_resume_ssboot(void);
#endif /* CONFIG_SNSC_SSBOOT */
#endif /* !__ASSEMBLY__ */
#endif /* __MACH_CXD900XX_PM_H */
